/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.compat;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.esri.ST_Area;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsBinary;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsGeoJson;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsJson;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsShape;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsText;
import org.apache.hadoop.hive.ql.udf.esri.ST_Bin;
import org.apache.hadoop.hive.ql.udf.esri.ST_BinEnvelope;
import org.apache.hadoop.hive.ql.udf.esri.ST_Boundary;
import org.apache.hadoop.hive.ql.udf.esri.ST_Buffer;
import org.apache.hadoop.hive.ql.udf.esri.ST_Centroid;
import org.apache.hadoop.hive.ql.udf.esri.ST_Contains;
import org.apache.hadoop.hive.ql.udf.esri.ST_ConvexHull;
import org.apache.hadoop.hive.ql.udf.esri.ST_CoordDim;
import org.apache.hadoop.hive.ql.udf.esri.ST_Crosses;
import org.apache.hadoop.hive.ql.udf.esri.ST_Difference;
import org.apache.hadoop.hive.ql.udf.esri.ST_Dimension;
import org.apache.hadoop.hive.ql.udf.esri.ST_Disjoint;
import org.apache.hadoop.hive.ql.udf.esri.ST_Distance;
import org.apache.hadoop.hive.ql.udf.esri.ST_EndPoint;
import org.apache.hadoop.hive.ql.udf.esri.ST_EnvIntersects;
import org.apache.hadoop.hive.ql.udf.esri.ST_Envelope;
import org.apache.hadoop.hive.ql.udf.esri.ST_Equals;
import org.apache.hadoop.hive.ql.udf.esri.ST_ExteriorRing;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeodesicLengthWGS84;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomCollection;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomFromGeoJson;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomFromJson;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomFromShape;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomFromText;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryN;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryType;
import org.apache.hadoop.hive.ql.udf.esri.ST_InteriorRingN;
import org.apache.hadoop.hive.ql.udf.esri.ST_Intersection;
import org.apache.hadoop.hive.ql.udf.esri.ST_Intersects;
import org.apache.hadoop.hive.ql.udf.esri.ST_Is3D;
import org.apache.hadoop.hive.ql.udf.esri.ST_IsClosed;
import org.apache.hadoop.hive.ql.udf.esri.ST_IsEmpty;
import org.apache.hadoop.hive.ql.udf.esri.ST_IsMeasured;
import org.apache.hadoop.hive.ql.udf.esri.ST_IsRing;
import org.apache.hadoop.hive.ql.udf.esri.ST_IsSimple;
import org.apache.hadoop.hive.ql.udf.esri.ST_Length;
import org.apache.hadoop.hive.ql.udf.esri.ST_LineFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_LineString;
import org.apache.hadoop.hive.ql.udf.esri.ST_M;
import org.apache.hadoop.hive.ql.udf.esri.ST_MLineFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_MPointFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_MPolyFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_MaxM;
import org.apache.hadoop.hive.ql.udf.esri.ST_MaxX;
import org.apache.hadoop.hive.ql.udf.esri.ST_MaxY;
import org.apache.hadoop.hive.ql.udf.esri.ST_MaxZ;
import org.apache.hadoop.hive.ql.udf.esri.ST_MinM;
import org.apache.hadoop.hive.ql.udf.esri.ST_MinX;
import org.apache.hadoop.hive.ql.udf.esri.ST_MinY;
import org.apache.hadoop.hive.ql.udf.esri.ST_MinZ;
import org.apache.hadoop.hive.ql.udf.esri.ST_MultiLineString;
import org.apache.hadoop.hive.ql.udf.esri.ST_MultiPoint;
import org.apache.hadoop.hive.ql.udf.esri.ST_MultiPolygon;
import org.apache.hadoop.hive.ql.udf.esri.ST_NumGeometries;
import org.apache.hadoop.hive.ql.udf.esri.ST_NumInteriorRing;
import org.apache.hadoop.hive.ql.udf.esri.ST_NumPoints;
import org.apache.hadoop.hive.ql.udf.esri.ST_Overlaps;
import org.apache.hadoop.hive.ql.udf.esri.ST_Point;
import org.apache.hadoop.hive.ql.udf.esri.ST_PointFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_PointN;
import org.apache.hadoop.hive.ql.udf.esri.ST_PointZ;
import org.apache.hadoop.hive.ql.udf.esri.ST_PolyFromWKB;
import org.apache.hadoop.hive.ql.udf.esri.ST_Polygon;
import org.apache.hadoop.hive.ql.udf.esri.ST_Relate;
import org.apache.hadoop.hive.ql.udf.esri.ST_SRID;
import org.apache.hadoop.hive.ql.udf.esri.ST_SetSRID;
import org.apache.hadoop.hive.ql.udf.esri.ST_StartPoint;
import org.apache.hadoop.hive.ql.udf.esri.ST_SymmetricDiff;
import org.apache.hadoop.hive.ql.udf.esri.ST_Touches;
import org.apache.hadoop.hive.ql.udf.esri.ST_Union;
import org.apache.hadoop.hive.ql.udf.esri.ST_Within;
import org.apache.hadoop.hive.ql.udf.esri.ST_X;
import org.apache.hadoop.hive.ql.udf.esri.ST_Y;
import org.apache.hadoop.hive.ql.udf.esri.ST_Z;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.builtins.ST_ConvexHull_Wrapper;
import org.apache.impala.builtins.ST_LineString_Wrapper;
import org.apache.impala.builtins.ST_MultiPoint_Wrapper;
import org.apache.impala.builtins.ST_Polygon_Wrapper;
import org.apache.impala.builtins.ST_Union_Wrapper;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.hive.executor.BinaryToBinaryHiveLegacyFunctionExtractor;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveLegacyJavaFunction;
import org.apache.impala.thrift.TFunctionBinaryType;

public class HiveEsriGeospatialBuiltins {
    public static void initBuiltins(Db db) {
        HiveEsriGeospatialBuiltins.addLegacyUDFs(db);
        HiveEsriGeospatialBuiltins.addGenericUDFs(db);
        HiveEsriGeospatialBuiltins.addVarargsUDFs(db);
    }

    private static void addLegacyUDFs(Db db) {
        List<UDF> legacyUDFs = Arrays.asList(new ST_Area(), new ST_AsBinary(), new ST_AsGeoJson(), new ST_AsJson(), new ST_AsShape(), new ST_AsText(), new ST_Boundary(), new ST_Buffer(), new ST_Centroid(), new ST_CoordDim(), new ST_Difference(), new ST_Dimension(), new ST_Distance(), new ST_EndPoint(), new ST_Envelope(), new ST_EnvIntersects(), new ST_ExteriorRing(), new ST_GeodesicLengthWGS84(), new ST_GeomCollection(), new ST_GeometryN(), new ST_GeometryType(), new ST_GeomFromShape(), new ST_GeomFromText(), new ST_GeomFromWKB(), new ST_InteriorRingN(), new ST_Intersection(), new ST_Is3D(), new ST_IsClosed(), new ST_IsEmpty(), new ST_IsMeasured(), new ST_IsRing(), new ST_IsSimple(), new ST_Length(), new ST_LineFromWKB(), new ST_M(), new ST_MaxM(), new ST_MaxX(), new ST_MaxY(), new ST_MaxZ(), new ST_MinM(), new ST_MinX(), new ST_MinY(), new ST_MinZ(), new ST_MLineFromWKB(), new ST_MPointFromWKB(), new ST_MPolyFromWKB(), new ST_NumGeometries(), new ST_NumInteriorRing(), new ST_NumPoints(), new ST_Point(), new ST_PointFromWKB(), new ST_PointN(), new ST_PointZ(), new ST_PolyFromWKB(), new ST_Relate(), new ST_SRID(), new ST_StartPoint(), new ST_SymmetricDiff(), new ST_X(), new ST_Y(), new ST_Z(), new ST_SetSRID());
        for (UDF udf : legacyUDFs) {
            for (Function function : HiveEsriGeospatialBuiltins.extractFromLegacyHiveBuiltin(udf, db.getName())) {
                db.addBuiltin(function);
            }
        }
    }

    private static void addGenericUDFs(Db db) {
        ArrayList<ScalarFunction> genericUDFs = new ArrayList<ScalarFunction>();
        ImmutableList stBinArguments = ImmutableList.of((Object)ImmutableSet.of((Object)Type.DOUBLE, (Object)Type.BIGINT), (Object)ImmutableSet.of((Object)Type.STRING, (Object)Type.BINARY));
        ImmutableList stBinEnvelopeArguments = ImmutableList.of((Object)ImmutableSet.of((Object)Type.DOUBLE, (Object)Type.BIGINT), (Object)ImmutableSet.of((Object)Type.STRING, (Object)Type.BINARY, (Object)Type.BIGINT));
        genericUDFs.addAll(HiveEsriGeospatialBuiltins.createMappedGenericUDFs((List<Set<Type>>)stBinArguments, Type.BIGINT, ST_Bin.class));
        genericUDFs.addAll(HiveEsriGeospatialBuiltins.createMappedGenericUDFs((List<Set<Type>>)stBinEnvelopeArguments, Type.BINARY, ST_BinEnvelope.class));
        genericUDFs.add(HiveEsriGeospatialBuiltins.createScalarFunction(ST_GeomFromGeoJson.class, Type.BINARY, new Type[]{Type.STRING}));
        genericUDFs.add(HiveEsriGeospatialBuiltins.createScalarFunction(ST_GeomFromJson.class, Type.BINARY, new Type[]{Type.STRING}));
        genericUDFs.add(HiveEsriGeospatialBuiltins.createScalarFunction(ST_MultiPolygon.class, Type.BINARY, new Type[]{Type.STRING}));
        genericUDFs.add(HiveEsriGeospatialBuiltins.createScalarFunction(ST_MultiLineString.class, Type.BINARY, new Type[]{Type.STRING}));
        HiveEsriGeospatialBuiltins.createRelationalGenericUDFs(genericUDFs);
        for (ScalarFunction function : genericUDFs) {
            db.addBuiltin(function);
        }
    }

    private static void createRelationalGenericUDFs(List<ScalarFunction> genericUDFs) {
        List<GenericUDF> relationalUDFs = Arrays.asList(new ST_Contains(), new ST_Crosses(), new ST_Disjoint(), new ST_Equals(), new ST_Intersects(), new ST_Overlaps(), new ST_Touches(), new ST_Within());
        ImmutableList relationalUDFArguments = ImmutableList.of((Object)ImmutableSet.of((Object)Type.STRING, (Object)Type.BINARY), (Object)ImmutableSet.of((Object)Type.STRING, (Object)Type.BINARY));
        for (GenericUDF relationalUDF : relationalUDFs) {
            genericUDFs.addAll(HiveEsriGeospatialBuiltins.createMappedGenericUDFs((List<Set<Type>>)relationalUDFArguments, Type.BOOLEAN, relationalUDF.getClass()));
        }
    }

    private static void addVarargsUDFs(Db db) {
        ArrayList<ScalarFunction> varargsUDFs = new ArrayList<ScalarFunction>();
        varargsUDFs.addAll(HiveEsriGeospatialBuiltins.extractFunctions(ST_Union_Wrapper.class, ST_Union.class, db.getName()));
        varargsUDFs.addAll(HiveEsriGeospatialBuiltins.extractFunctions(ST_Polygon_Wrapper.class, ST_Polygon.class, db.getName()));
        varargsUDFs.addAll(HiveEsriGeospatialBuiltins.extractFunctions(ST_LineString_Wrapper.class, ST_LineString.class, db.getName()));
        varargsUDFs.addAll(HiveEsriGeospatialBuiltins.extractFunctions(ST_MultiPoint_Wrapper.class, ST_MultiPoint.class, db.getName()));
        varargsUDFs.addAll(HiveEsriGeospatialBuiltins.extractFunctions(ST_ConvexHull_Wrapper.class, ST_ConvexHull.class, db.getName()));
        for (ScalarFunction function : varargsUDFs) {
            db.addBuiltin(function);
        }
    }

    private static List<ScalarFunction> extractFromLegacyHiveBuiltin(UDF udf, String dbName) {
        return HiveEsriGeospatialBuiltins.extractFunctions(udf.getClass(), udf.getClass(), dbName);
    }

    private static List<ScalarFunction> extractFunctions(Class<?> udfClass, Class<?> signatureClass, String dbName) {
        String fnName = signatureClass.getSimpleName().toLowerCase();
        String symbolName = udfClass.getName();
        org.apache.hadoop.hive.metastore.api.Function hiveFunction = HiveJavaFunction.createHiveFunction(fnName, dbName, symbolName, null);
        try {
            return new HiveLegacyJavaFunction(udfClass, hiveFunction, null, null).extract(new BinaryToBinaryHiveLegacyFunctionExtractor());
        }
        catch (CatalogException ex) {
            Preconditions.checkState((boolean)false, (Object)ex.getMessage());
            return Collections.emptyList();
        }
    }

    private static ScalarFunction createScalarFunction(Class<?> udf, String name, Type returnType, Type[] arguments) {
        ScalarFunction function = new ScalarFunction(new FunctionName("_impala_builtins", name), arguments, returnType, false);
        function.setSymbolName(udf.getName());
        function.setUserVisible(true);
        function.setHasVarArgs(false);
        function.setBinaryType(TFunctionBinaryType.JAVA);
        function.setIsPersistent(true);
        return function;
    }

    private static ScalarFunction createScalarFunction(Class<?> udf, Type returnType, Type[] arguments) {
        return HiveEsriGeospatialBuiltins.createScalarFunction(udf, udf.getSimpleName().toLowerCase(), returnType, arguments);
    }

    private static List<ScalarFunction> createMappedGenericUDFs(List<Set<Type>> listOfArgumentOptions, Type returnType, Class<?> genericUDF) {
        return Sets.cartesianProduct(listOfArgumentOptions).stream().map(types -> {
            Type[] arguments = types.toArray(new Type[0]);
            return HiveEsriGeospatialBuiltins.createScalarFunction(genericUDF, returnType, arguments);
        }).collect(Collectors.toList());
    }
}

