/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.impala.util.Visitor;

public abstract class TreeNode<NodeType extends TreeNode<NodeType>> {
    protected List<NodeType> children_ = new ArrayList<NodeType>();

    public NodeType getChild(int i) {
        return (NodeType)(this.hasChild(i) ? (TreeNode)this.children_.get(i) : null);
    }

    public void addChild(NodeType n) {
        this.children_.add(n);
    }

    public void removeChild(NodeType n) {
        this.children_.remove(n);
    }

    public void clearChildren() {
        this.children_.clear();
    }

    public void addChildren(List<? extends NodeType> l) {
        this.children_.addAll(l);
    }

    public boolean hasChild(int i) {
        return this.children_.size() > i;
    }

    public void setChild(int index, NodeType n) {
        this.children_.set(index, n);
    }

    public List<NodeType> getChildren() {
        return this.children_;
    }

    public int getChildCount() {
        return this.children_.size();
    }

    public <C extends TreeNode<NodeType>> List<C> getNodesPreOrder() {
        ArrayList result = new ArrayList();
        this.getNodesPreOrderAux(result);
        return result;
    }

    protected <C extends TreeNode<NodeType>> void getNodesPreOrderAux(List<C> result) {
        result.add(this);
        for (TreeNode child : this.children_) {
            child.getNodesPreOrderAux(result);
        }
    }

    public <C extends TreeNode<NodeType>> List<C> getNodesPostOrder() {
        ArrayList result = new ArrayList();
        this.getNodesPostOrderAux(result);
        return result;
    }

    protected <C extends TreeNode<NodeType>> void getNodesPostOrderAux(List<C> result) {
        for (TreeNode child : this.children_) {
            child.getNodesPostOrderAux(result);
        }
        result.add(this);
    }

    public int numNodes() {
        int numNodes = 1;
        for (TreeNode child : this.children_) {
            numNodes += child.numNodes();
        }
        return numNodes;
    }

    protected boolean shouldCollectRecursively() {
        return true;
    }

    public <C extends TreeNode<NodeType>, D extends C> void collect(Predicate<? super C> predicate, Collection<D> matches) {
        if (predicate.apply((Object)this) && !matches.contains(this)) {
            matches.add(this);
            return;
        }
        if (this.shouldCollectRecursively()) {
            for (TreeNode child : this.children_) {
                child.collect(predicate, matches);
            }
        }
    }

    public <C extends TreeNode<NodeType>, D extends C> void collect(Class<D> cl, Collection<D> matches) {
        if (cl.isAssignableFrom(this.getClass())) {
            matches.add(this);
            return;
        }
        for (TreeNode child : this.children_) {
            child.collect(cl, matches);
        }
    }

    public <C extends TreeNode<NodeType>, D extends C> void collectAll(Predicate<? super C> predicate, Collection<D> matches) {
        if (predicate.apply((Object)this)) {
            matches.add(this);
        }
        for (TreeNode child : this.children_) {
            child.collectAll(predicate, matches);
        }
    }

    public static <C extends TreeNode<C>, D extends C> void collect(Collection<C> nodeList, Predicate<? super C> predicate, Collection<D> matches) {
        for (TreeNode node : nodeList) {
            node.collect(predicate, matches);
        }
    }

    public static <C extends TreeNode<C>, D extends C> void collect(Collection<C> nodeList, Class<D> cl, Collection<D> matches) {
        for (TreeNode node : nodeList) {
            node.collect(cl, matches);
        }
    }

    public <C extends TreeNode<NodeType>> boolean contains(Predicate<? super C> predicate) {
        if (predicate.apply((Object)this)) {
            return true;
        }
        for (TreeNode child : this.children_) {
            if (!child.contains((NodeType)predicate)) continue;
            return true;
        }
        return false;
    }

    public <C extends TreeNode<NodeType>> boolean contains(Class<C> cl) {
        if (cl.isAssignableFrom(this.getClass())) {
            return true;
        }
        for (TreeNode child : this.children_) {
            if (!child.contains((NodeType)cl)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(NodeType node) {
        if (this == node) {
            return true;
        }
        for (TreeNode child : this.children_) {
            if (!child.contains(node)) continue;
            return true;
        }
        return false;
    }

    public static <C extends TreeNode<C>, D extends C> boolean contains(Collection<C> nodeList, Predicate<? super C> predicate) {
        for (TreeNode node : nodeList) {
            if (!node.contains((Object)predicate)) continue;
            return true;
        }
        return false;
    }

    public static <C extends TreeNode<C>> boolean contains(List<C> nodeList, Class<? extends C> cl) {
        for (TreeNode node : nodeList) {
            if (!node.contains((Object)cl)) continue;
            return true;
        }
        return false;
    }

    public <C extends NodeType> C findFirstOf(Class<C> cl) {
        if (cl.isAssignableFrom(this.getClass())) {
            return (C)this;
        }
        for (TreeNode child : this.children_) {
            C result = child.findFirstOf(cl);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <C extends TreeNode<NodeType>> void accept(Visitor<C> visitor) {
        visitor.visit(this);
        for (TreeNode p : this.children_) {
            p.accept(visitor);
        }
    }

    public <C extends TreeNode<NodeType>> void postAccept(Visitor<C> visitor) {
        for (TreeNode p : this.children_) {
            p.postAccept(visitor);
        }
        visitor.visit(this);
    }
}

