/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.TupleCacheInfo;

public class ThriftSerializationCtx {
    private TupleCacheInfo tupleCacheInfo_;

    public ThriftSerializationCtx(TupleCacheInfo tupleCacheInfo) {
        this.tupleCacheInfo_ = tupleCacheInfo;
    }

    public ThriftSerializationCtx() {
        this.tupleCacheInfo_ = null;
    }

    public boolean isTupleCache() {
        return this.tupleCacheInfo_ != null;
    }

    public void registerTuple(TupleId id) {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.registerTuple(id);
        }
    }

    public void registerInputScanNode(HdfsScanNode hdfsScanNode) {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.registerInputScanNode(hdfsScanNode);
        }
    }

    public void setTupleCachingIneligible(TupleCacheInfo.IneligibilityReason reason) {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.setIneligible(reason);
        }
    }

    public TupleId translateTupleId(TupleId globalId) {
        if (this.isTupleCache()) {
            return this.tupleCacheInfo_.getLocalTupleId(globalId);
        }
        return globalId;
    }

    public SlotId translateSlotId(SlotId globalId) {
        if (this.isTupleCache()) {
            return this.tupleCacheInfo_.getLocalSlotId(globalId);
        }
        return globalId;
    }

    public void incorporateScans() {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.incorporateScans();
        }
    }

    public void setStreamingAggVariability() {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.setStreamingAggVariability();
        }
    }

    public void clearStreamingAggVariability() {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.clearStreamingAggVariability();
        }
    }
}

