/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.impala.catalog.SideloadTableStats;

public class RuntimeEnv {
    public static RuntimeEnv INSTANCE = new RuntimeEnv();
    private int numCores_;
    private boolean isTestEnv_;
    private Map<String, Map<String, SideloadTableStats>> sideloadStats_ = null;
    private Map<String, Map<String, Long>> tableScanRangeLimit_ = null;

    public RuntimeEnv() {
        this.reset();
    }

    public void reset() {
        this.numCores_ = Runtime.getRuntime().availableProcessors();
        this.isTestEnv_ = false;
    }

    public int getNumCores() {
        return this.numCores_;
    }

    public void setNumCores(int numCores) {
        this.numCores_ = numCores;
    }

    public void setTestEnv(boolean v) {
        this.isTestEnv_ = v;
    }

    public boolean isTestEnv() {
        return this.isTestEnv_;
    }

    public boolean hasTableScanRangeLimit() {
        return this.tableScanRangeLimit_ != null;
    }

    public void setSideloadStats(Map<String, Map<String, SideloadTableStats>> sideloadStats) {
        Preconditions.checkState((boolean)this.isTestEnv_);
        this.sideloadStats_ = sideloadStats;
    }

    public boolean hasSideloadStats(String db, String table) {
        return this.sideloadStats_ != null && this.sideloadStats_.containsKey(db) && this.sideloadStats_.get(db).containsKey(table);
    }

    public SideloadTableStats getSideloadStats(String db, String table) {
        if (!this.hasSideloadStats(db, table)) {
            return null;
        }
        return this.sideloadStats_.get(db).get(table);
    }

    public void dropSideloadStats() {
        this.sideloadStats_ = null;
    }

    public void addTableScanRangeLimit(String db, String table, long scanRangeLimit) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkArgument((!db.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!table.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((scanRangeLimit > 1L ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isTestEnv_);
        if (this.tableScanRangeLimit_ == null) {
            this.tableScanRangeLimit_ = new HashMap<String, Map<String, Long>>();
        }
        if (!this.tableScanRangeLimit_.containsKey(db)) {
            this.tableScanRangeLimit_.put(db, new HashMap());
        }
        this.tableScanRangeLimit_.get(db).put(table, scanRangeLimit);
    }

    public long getTableScanRangeLimit(String db, String table) {
        long scanRangeLimit = -1L;
        if (this.isTestEnv_ && this.tableScanRangeLimit_ != null && this.tableScanRangeLimit_.containsKey(db) && this.tableScanRangeLimit_.get(db).containsKey(table)) {
            scanRangeLimit = this.tableScanRangeLimit_.get(db).get(table);
        }
        return scanRangeLimit;
    }

    public void dropTableScanRangeLimit() {
        this.tableScanRangeLimit_ = null;
    }
}

