/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

public class Pair<F, S> {
    public F first;
    public S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair other = (Pair)o;
            return this.first.equals(other.first) && this.second.equals(other.second);
        }
        return false;
    }

    public int hashCode() {
        int hashFirst = this.first != null ? this.first.hashCode() : 0;
        int hashSecond = this.second != null ? this.second.hashCode() : 0;
        return (hashFirst + hashSecond) * hashSecond + hashFirst;
    }

    public static <F, S> Pair<F, S> create(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public String toString() {
        return String.format("<%s, %s>", this.first, this.second);
    }
}

