/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.TUniqueIdUtil;
import org.apache.kudu.client.KuduTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduTransactionManager {
    public static final Logger LOG = LoggerFactory.getLogger(KuduTransactionManager.class);
    private ConcurrentHashMap<TUniqueId, KuduTransaction> transactions_ = new ConcurrentHashMap();

    public void addTransaction(TUniqueId queryId, KuduTransaction txn) {
        Preconditions.checkNotNull((Object)queryId);
        Preconditions.checkNotNull((Object)txn);
        this.transactions_.put(queryId, txn);
    }

    public KuduTransaction deleteTransaction(TUniqueId queryId) {
        Preconditions.checkNotNull((Object)queryId);
        KuduTransaction txn = this.transactions_.remove(queryId);
        if (txn == null) {
            LOG.info("Kudu transaction with query-id {} was already removed from KuduTransactionManager object or never existed.", (Object)TUniqueIdUtil.PrintId(queryId));
        }
        return txn;
    }
}

