/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Joiner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TGetJMXJsonResponse;
import org.apache.impala.thrift.TGetJvmMemoryMetricsResponse;
import org.apache.impala.thrift.TGetJvmThreadsInfoRequest;
import org.apache.impala.thrift.TGetJvmThreadsInfoResponse;
import org.apache.impala.thrift.TJvmMemoryPool;
import org.apache.impala.thrift.TJvmThreadInfo;
import org.apache.impala.util.JMXJsonUtil;
import org.apache.impala.util.JvmPauseMonitor;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniUtil {
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private static final Logger LOG = LoggerFactory.getLogger(JniUtil.class);

    public static void initPauseMonitor(long deadlockCheckIntervalS) {
        JvmPauseMonitor.initPauseMonitor(deadlockCheckIntervalS);
    }

    public static String throwableToString(Throwable t) {
        StringWriter output = new StringWriter();
        output.write(String.format("%s: %s", t.getClass().getSimpleName(), t.getMessage()));
        Throwable cause = t;
        while ((cause = cause.getCause()) != null) {
            output.write(String.format("\nCAUSED BY: %s: %s", cause.getClass().getSimpleName(), cause.getMessage()));
        }
        return output.toString();
    }

    public static String throwableToStackTrace(Throwable t) {
        StringWriter output = new StringWriter();
        t.printStackTrace(new PrintWriter(output));
        return ((Object)output).toString();
    }

    public static <T extends TBase<?, ?>> byte[] serializeToThrift(T input) throws ImpalaException {
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize(input);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public static <T extends TBase<?, ?>, F extends TProtocolFactory> byte[] serializeToThrift(T input, F protocolFactory) throws ImpalaException {
        try {
            TSerializer serializer = new TSerializer(protocolFactory);
            return serializer.serialize(input);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public static <T extends TBase<?, ?>> void deserializeThrift(T result, byte[] thriftData) throws ImpalaException {
        JniUtil.deserializeThrift(protocolFactory_, result, thriftData);
    }

    public static <T extends TBase<?, ?>, F extends TProtocolFactory> void deserializeThrift(F protocolFactory, T result, byte[] thriftData) throws ImpalaException {
        try {
            TDeserializer deserializer = new TDeserializer(protocolFactory);
            deserializer.deserialize(result, thriftData);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    private static OperationLog logOperationInternal(String methodName, String shortDescription, boolean silentStartAndFinish) {
        OperationLog operationLog = new OperationLog(methodName, shortDescription, silentStartAndFinish);
        operationLog.logStart();
        return operationLog;
    }

    public static OperationLog logOperation(String methodName, String shortDescription) {
        return JniUtil.logOperationInternal(methodName, shortDescription, false);
    }

    public static OperationLog logOperationSilentStartAndFinish(String methodName, String shortDescription) {
        return JniUtil.logOperationInternal(methodName, shortDescription, true);
    }

    public static byte[] getJvmMemoryMetrics() throws ImpalaException {
        TGetJvmMemoryMetricsResponse jvmMetrics = new TGetJvmMemoryMetricsResponse();
        jvmMetrics.setMemory_pools(new ArrayList<TJvmMemoryPool>());
        TJvmMemoryPool totalUsage = new TJvmMemoryPool();
        totalUsage.setName("total");
        jvmMetrics.getMemory_pools().add(totalUsage);
        for (MemoryPoolMXBean memBean : ManagementFactory.getMemoryPoolMXBeans()) {
            TJvmMemoryPool usage = new TJvmMemoryPool();
            MemoryUsage beanUsage = memBean.getUsage();
            usage.setCommitted(beanUsage.getCommitted());
            usage.setInit(beanUsage.getInit());
            usage.setMax(beanUsage.getMax());
            usage.setUsed(beanUsage.getUsed());
            usage.setName(memBean.getName());
            totalUsage.committed += beanUsage.getCommitted();
            totalUsage.init += beanUsage.getInit();
            totalUsage.max += beanUsage.getMax();
            totalUsage.used += beanUsage.getUsed();
            MemoryUsage peakUsage = memBean.getPeakUsage();
            usage.setPeak_committed(peakUsage.getCommitted());
            usage.setPeak_init(peakUsage.getInit());
            usage.setPeak_max(peakUsage.getMax());
            usage.setPeak_used(peakUsage.getUsed());
            totalUsage.peak_committed += peakUsage.getCommitted();
            totalUsage.peak_init += peakUsage.getInit();
            totalUsage.peak_max += peakUsage.getMax();
            totalUsage.peak_used += peakUsage.getUsed();
            jvmMetrics.getMemory_pools().add(usage);
        }
        MemoryMXBean mBean = ManagementFactory.getMemoryMXBean();
        TJvmMemoryPool heap = new TJvmMemoryPool();
        MemoryUsage heapUsage = mBean.getHeapMemoryUsage();
        heap.setCommitted(heapUsage.getCommitted());
        heap.setInit(heapUsage.getInit());
        heap.setMax(heapUsage.getMax());
        heap.setUsed(heapUsage.getUsed());
        heap.setName("heap");
        heap.setPeak_committed(0L);
        heap.setPeak_init(0L);
        heap.setPeak_max(0L);
        heap.setPeak_used(0L);
        jvmMetrics.getMemory_pools().add(heap);
        TJvmMemoryPool nonHeap = new TJvmMemoryPool();
        MemoryUsage nonHeapUsage = mBean.getNonHeapMemoryUsage();
        nonHeap.setCommitted(nonHeapUsage.getCommitted());
        nonHeap.setInit(nonHeapUsage.getInit());
        nonHeap.setMax(nonHeapUsage.getMax());
        nonHeap.setUsed(nonHeapUsage.getUsed());
        nonHeap.setName("non-heap");
        nonHeap.setPeak_committed(0L);
        nonHeap.setPeak_init(0L);
        nonHeap.setPeak_max(0L);
        nonHeap.setPeak_used(0L);
        jvmMetrics.getMemory_pools().add(nonHeap);
        jvmMetrics.setGc_num_warn_threshold_exceeded(JvmPauseMonitor.INSTANCE.getNumGcWarnThresholdExceeded());
        jvmMetrics.setGc_num_info_threshold_exceeded(JvmPauseMonitor.INSTANCE.getNumGcInfoThresholdExceeded());
        jvmMetrics.setGc_total_extra_sleep_time_millis(JvmPauseMonitor.INSTANCE.getTotalGcExtraSleepTime());
        long gcCount = 0L;
        long gcTimeMillis = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTimeMillis += bean.getCollectionTime();
        }
        jvmMetrics.setGc_count(gcCount);
        jvmMetrics.setGc_time_millis(gcTimeMillis);
        return JniUtil.serializeToThrift(jvmMetrics, protocolFactory_);
    }

    public static byte[] getJvmThreadsInfo(byte[] argument) throws ImpalaException {
        TGetJvmThreadsInfoRequest request = new TGetJvmThreadsInfoRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, argument);
        TGetJvmThreadsInfoResponse response = new TGetJvmThreadsInfoResponse();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        response.setTotal_thread_count(threadBean.getThreadCount());
        response.setDaemon_thread_count(threadBean.getDaemonThreadCount());
        response.setPeak_thread_count(threadBean.getPeakThreadCount());
        if (request.get_complete_info) {
            for (ThreadInfo threadInfo : threadBean.dumpAllThreads(true, true)) {
                TJvmThreadInfo tThreadInfo = new TJvmThreadInfo();
                long id = threadInfo.getThreadId();
                StringBuffer customSummary = new StringBuffer();
                String regularSummary = threadInfo.toString();
                int firstNewlineIndex = regularSummary.indexOf("\n");
                customSummary.append(regularSummary.substring(0, firstNewlineIndex));
                customSummary.append("\n");
                for (StackTraceElement ste : threadInfo.getStackTrace()) {
                    customSummary.append("\tat " + ste.toString() + "\n");
                }
                tThreadInfo.setSummary(customSummary.toString());
                tThreadInfo.setCpu_time_in_ns(threadBean.getThreadCpuTime(id));
                tThreadInfo.setUser_time_in_ns(threadBean.getThreadUserTime(id));
                tThreadInfo.setBlocked_count(threadInfo.getBlockedCount());
                tThreadInfo.setBlocked_time_in_ms(threadInfo.getBlockedTime());
                tThreadInfo.setIs_in_native(threadInfo.isInNative());
                response.addToThreads(tThreadInfo);
            }
        }
        return JniUtil.serializeToThrift(response, protocolFactory_);
    }

    public static byte[] getJMXJson() throws ImpalaException {
        TGetJMXJsonResponse response = new TGetJMXJsonResponse(JMXJsonUtil.getJMXJson());
        return JniUtil.serializeToThrift(response, protocolFactory_);
    }

    public static String getJavaVersion() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        StringBuilder sb = new StringBuilder();
        sb.append("Java Input arguments:\n");
        sb.append(Joiner.on((String)" ").join(runtime.getInputArguments()));
        sb.append("\nJava System properties:\n");
        for (Map.Entry<String, String> entry : runtime.getSystemProperties().entrySet()) {
            sb.append(entry.getKey() + ":" + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public static List<String> decodeInjectedGroups(String flags, String username) {
        ArrayList<String> groups = new ArrayList<String>();
        if (flags == null || username == null) {
            return groups;
        }
        block0: for (String group : flags.split(";")) {
            String[] parts = group.split(":");
            if (parts.length != 2) {
                throw new IllegalStateException("group " + group + " is malformed in injected groups string '" + flags + "'");
            }
            String groupName = parts[0];
            for (String member : parts[1].split(",")) {
                if (!member.equals(username)) continue;
                groups.add(groupName);
                continue block0;
            }
        }
        return groups;
    }

    public static void setContextClassLoaderForThisThread(ClassLoader cl) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return;
        }
        Thread.currentThread().setContextClassLoader(cl);
    }

    public static class OperationLog {
        private final long startTime = System.currentTimeMillis();
        private final String methodName;
        private final String shortDescription;
        private final boolean silentStartAndFinish;

        public OperationLog(String methodName, String shortDescription, boolean silentStartAndFinish) {
            this.methodName = methodName;
            this.shortDescription = shortDescription;
            this.silentStartAndFinish = silentStartAndFinish;
        }

        public void logStart() {
            String startFormat = "{} request: {}";
            if (this.silentStartAndFinish) {
                LOG.trace("{} request: {}", (Object)this.methodName, (Object)this.shortDescription);
            } else {
                LOG.info("{} request: {}", (Object)this.methodName, (Object)this.shortDescription);
            }
        }

        public void logFinish() {
            String finishFormat = "Finished {} request: {}. Time spent: {}";
            long duration = this.getDurationFromStart();
            String durationString = PrintUtils.printTimeMs(duration);
            if (this.silentStartAndFinish) {
                LOG.trace("Finished {} request: {}. Time spent: {}", new Object[]{this.methodName, this.shortDescription, durationString});
            } else {
                LOG.info("Finished {} request: {}. Time spent: {}", new Object[]{this.methodName, this.shortDescription, durationString});
            }
        }

        public void logError() {
            long duration = this.getDurationFromStart();
            LOG.error("Error in {}. Time spent: {}", (Object)this.shortDescription, (Object)PrintUtils.printTimeMs(duration));
        }

        public void logResponse(long resultSize, TBase<?, ?> thriftReq) {
            boolean tooSlow;
            long duration = this.getDurationFromStart();
            boolean tooLarge = resultSize > BackendConfig.INSTANCE.getWarnCatalogResponseSize();
            boolean bl = tooSlow = duration > BackendConfig.INSTANCE.getWarnCatalogResponseDurationMs();
            if (tooLarge || tooSlow) {
                String header = tooLarge && tooSlow ? "Response too large and too slow" : (tooLarge ? "Response too large" : "Response too slow");
                String request = thriftReq == null ? "" : ", request: " + StringUtils.abbreviate((String)thriftReq.toString(), (int)1000);
                LOG.warn("{}: size={} ({}), duration={}ms ({}), method: {}{}", new Object[]{header, resultSize, PrintUtils.printBytes(resultSize), duration, PrintUtils.printTimeMs(duration), this.methodName, request});
            }
        }

        private long getDurationFromStart() {
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

