/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.paimon;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.paimon.FePaimonTable;
import org.apache.impala.catalog.paimon.ImpalaTypeUtils;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TDescribeHistoryParams;
import org.apache.impala.thrift.TGetTableHistoryResult;
import org.apache.impala.thrift.TGetTableHistoryResultItem;
import org.apache.impala.thrift.TPaimonCatalog;
import org.apache.impala.thrift.TPaimonTable;
import org.apache.impala.thrift.TPaimonTableKind;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TShowFilesParams;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.CatalogUtils;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.LocationKeyExtractor;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.table.source.RawFile;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.system.SystemTableLoader;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.HadoopUtils;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonUtil {
    static final Logger LOG = LoggerFactory.getLogger(PaimonUtil.class);
    public static final String PAIMON_STORAGE_HANDLER = "org.apache.paimon.hive.PaimonStorageHandler";
    public static final String STORAGE_HANDLER = "storage_handler";
    public static final String PAIMON_CATALOG = "paimon.catalog";
    public static final String HIVE_CATALOG = "hive";
    public static final String PAIMON_PROPERTY_PREFIX = "";
    public static final String PAIMON_HADOOP_CATALOG_LOCATION = "paimon.catalog_location";
    public static final String PAIMON_TABLE_LOCATION = "paimon_location";
    public static final String PAIMON_TABLE_IDENTIFIER = "paimon.table_identifier";
    private static final HiveConf hiveConf_ = new HiveConf();
    public static Catalog catalog_ = null;
    private static final String metastoreClientClass_ = "org.apache.hadoop.hive.metastore.HiveMetaStoreClient";

    public static boolean isPaimonTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        if (msTbl.getParameters() != null && PAIMON_STORAGE_HANDLER.equals(msTbl.getParameters().getOrDefault(STORAGE_HANDLER, PAIMON_PROPERTY_PREFIX))) {
            return true;
        }
        StorageDescriptor sd = msTbl.getSd();
        if (sd == null) {
            return false;
        }
        if (sd.getInputFormat() != null && sd.getInputFormat().equals(HdfsFileFormat.PAIMON.inputFormat())) {
            return true;
        }
        return sd.getSerdeInfo() != null && sd.getSerdeInfo().getSerializationLib() != null && sd.getSerdeInfo().getSerializationLib().equals(HdfsFileFormat.PAIMON.serializationLib());
    }

    public static ByteBuffer serialize(FePaimonTable paimonTable) throws IOException {
        return ByteBuffer.wrap(SerializationUtils.serialize((Serializable)paimonTable.getPaimonApiTable()));
    }

    public static org.apache.paimon.table.Table deserialize(ByteBuffer b) throws Exception {
        return (org.apache.paimon.table.Table)SerializationUtils.deserialize((byte[])b.array());
    }

    public static TPaimonTable getTPaimonTable(FePaimonTable paimonTable) throws IOException {
        TPaimonTable t_ = new TPaimonTable();
        t_.setKind(TPaimonTableKind.JNI);
        t_.setJni_tbl_obj(PaimonUtil.serialize(paimonTable));
        return t_;
    }

    public static List<FieldSchema> convertToHiveSchema(RowType schema) throws ImpalaRuntimeException {
        ArrayList<FieldSchema> ret = new ArrayList<FieldSchema>();
        for (DataField dataField : schema.getFields()) {
            ret.add(new FieldSchema(dataField.name().toLowerCase(), HiveTypeUtils.toTypeInfo((DataType)dataField.type()).getTypeName(), dataField.description()));
        }
        return ret;
    }

    public static List<Column> convertToImpalaSchema(RowType schema) throws ImpalaRuntimeException {
        ArrayList<Column> ret = new ArrayList<Column>();
        int pos = 0;
        for (DataField dataField : schema.getFields()) {
            Type colType = ImpalaTypeUtils.toImpalaType(dataField.type());
            ret.add(new Column(dataField.name().toLowerCase(), colType, pos++));
        }
        return ret;
    }

    public static Schema genPaimonSchema(List<TColumn> columns, List<String> partitionKeys, Map<String, String> options) {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        for (TColumn column : columns) {
            schemaBuilder.column(column.getColumnName().toLowerCase(), ImpalaTypeUtils.fromImpalaType(Type.fromThrift(column.getColumnType())));
        }
        if (!partitionKeys.isEmpty()) {
            schemaBuilder.partitionKeys(partitionKeys);
        }
        if (!options.isEmpty()) {
            schemaBuilder.options(options);
        }
        return schemaBuilder.build();
    }

    public static Catalog getPaimonCatalog(TPaimonCatalog catalog, boolean isExternal, String warehouse_location) throws ImpalaRuntimeException {
        switch (catalog) {
            case HADOOP_CATALOG: {
                org.postgresql.shaded.com.ongres.scram.common.util.Preconditions.checkNotNull((Object)warehouse_location, (String)"warehouse location should not be null");
                CatalogContext context = CatalogContext.create((Path)new Path(warehouse_location));
                return CatalogFactory.createCatalog((CatalogContext)context);
            }
            case HIVE_CATALOG: {
                try {
                    String location = isExternal ? hiveConf_.get(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL.varname) : hiveConf_.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
                    Path path = new Path(location);
                    Options catalogOptions = new Options();
                    catalogOptions.set(CatalogOptions.WAREHOUSE, (Object)location);
                    CatalogContext catalogContext = CatalogContext.create((Options)catalogOptions);
                    FileIO fileIO = FileIO.get((Path)path, (CatalogContext)catalogContext);
                    HiveCatalog externalWarehouseCatalog = new HiveCatalog(fileIO, hiveConf_, metastoreClientClass_, location);
                    return externalWarehouseCatalog;
                }
                catch (Exception ex) {
                    throw new ImpalaRuntimeException("failed to create hive catalog : ", ex);
                }
            }
        }
        throw new ImpalaRuntimeException("Unexpected catalog type: " + (Object)((Object)catalog));
    }

    public static Identifier getTableIdentifier(String dbName, String tableName) {
        return new Identifier(dbName, tableName);
    }

    public static Identifier getTableIdentifier(org.apache.hadoop.hive.metastore.api.Table msTable) {
        String name = (String)msTable.getParameters().get(PAIMON_TABLE_IDENTIFIER);
        if (name == null || name.isEmpty()) {
            return PaimonUtil.getTableIdentifier(msTable.getDbName().toLowerCase(), msTable.getTableName().toLowerCase());
        }
        if (!name.contains(".")) {
            return PaimonUtil.getTableIdentifier(msTable.getDbName(), name);
        }
        String[] names = name.split("\\.");
        return PaimonUtil.getTableIdentifier(names[0], names[1]);
    }

    public static Optional<ColumnStatisticsData> convertColStats(ColStats<?> colStats, DataField dataField) {
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        colStats.deserializeFieldsFromString(dataField.type());
        Set fieldFamilySet = dataField.type().getTypeRoot().getFamilies();
        if (fieldFamilySet.contains(DataTypeFamily.NUMERIC)) {
            if (fieldFamilySet.contains(DataTypeFamily.INTEGER_NUMERIC)) {
                LongColumnStatsData longColumnStatsData = new LongColumnStatsData();
                if (colStats.nullCount().isPresent()) {
                    longColumnStatsData.setNumNulls(colStats.nullCount().getAsLong());
                }
                if (dataField.type() instanceof BigIntType) {
                    if (colStats.min().isPresent()) {
                        longColumnStatsData.setLowValue(((Long)colStats.min().get()).longValue());
                    }
                    if (colStats.max().isPresent()) {
                        longColumnStatsData.setHighValue(((Long)colStats.max().get()).longValue());
                    }
                } else if (dataField.type() instanceof IntType) {
                    if (colStats.min().isPresent()) {
                        longColumnStatsData.setLowValue((long)((Integer)colStats.min().get()).intValue());
                    }
                    if (colStats.max().isPresent()) {
                        longColumnStatsData.setHighValue((long)((Integer)colStats.max().get()).intValue());
                    }
                } else if (dataField.type() instanceof SmallIntType) {
                    if (colStats.min().isPresent()) {
                        longColumnStatsData.setLowValue((long)((Short)colStats.min().get()).shortValue());
                    }
                    if (colStats.max().isPresent()) {
                        longColumnStatsData.setHighValue((long)((Short)colStats.max().get()).shortValue());
                    }
                } else if (dataField.type() instanceof TinyIntType) {
                    if (colStats.min().isPresent()) {
                        longColumnStatsData.setLowValue((long)((Byte)colStats.min().get()).byteValue());
                    }
                    if (colStats.max().isPresent()) {
                        longColumnStatsData.setHighValue((long)((Byte)colStats.max().get()).byteValue());
                    }
                } else {
                    LOG.warn(String.format("Column stats doesn't support data type %s", dataField.type().asSQLString()));
                    return Optional.empty();
                }
                if (colStats.distinctCount().isPresent()) {
                    longColumnStatsData.setNumDVs(colStats.distinctCount().getAsLong());
                }
                columnStatisticsData.setLongStats(longColumnStatsData);
                return Optional.of(columnStatisticsData);
            }
            if (fieldFamilySet.contains(DataTypeFamily.APPROXIMATE_NUMERIC)) {
                DoubleColumnStatsData doubleColumnStatsData = new DoubleColumnStatsData();
                if (colStats.nullCount().isPresent()) {
                    doubleColumnStatsData.setNumNulls(colStats.nullCount().getAsLong());
                }
                if (dataField.type() instanceof DoubleType) {
                    if (colStats.min().isPresent()) {
                        doubleColumnStatsData.setLowValue(((Double)colStats.min().get()).doubleValue());
                    }
                    if (colStats.max().isPresent()) {
                        doubleColumnStatsData.setHighValue(((Double)colStats.max().get()).doubleValue());
                    }
                } else if (dataField.type() instanceof FloatType) {
                    if (colStats.min().isPresent()) {
                        doubleColumnStatsData.setLowValue((double)((Float)colStats.min().get()).floatValue());
                    }
                    if (colStats.max().isPresent()) {
                        doubleColumnStatsData.setHighValue((double)((Float)colStats.max().get()).floatValue());
                    }
                } else {
                    LOG.warn(String.format("Column stats doesn't support data type %s", dataField.type().asSQLString()));
                    return Optional.empty();
                }
                if (colStats.distinctCount().isPresent()) {
                    doubleColumnStatsData.setNumDVs(colStats.distinctCount().getAsLong());
                }
                columnStatisticsData.setDoubleStats(doubleColumnStatsData);
                return Optional.of(columnStatisticsData);
            }
            LOG.warn(String.format("Column stats doesn't support data type %s", dataField.type().asSQLString()));
            return Optional.empty();
        }
        if (fieldFamilySet.contains(DataTypeFamily.CHARACTER_STRING)) {
            StringColumnStatsData stringColumnStatsData = new StringColumnStatsData();
            if (colStats.nullCount().isPresent()) {
                stringColumnStatsData.setNumNulls(colStats.nullCount().getAsLong());
            }
            if (colStats.avgLen().isPresent()) {
                stringColumnStatsData.setAvgColLen((double)colStats.avgLen().getAsLong());
            }
            if (colStats.maxLen().isPresent()) {
                stringColumnStatsData.setMaxColLen(colStats.maxLen().getAsLong());
            }
            columnStatisticsData.setStringStats(stringColumnStatsData);
            return Optional.of(columnStatisticsData);
        }
        if (fieldFamilySet.contains(DataTypeFamily.BINARY_STRING)) {
            BinaryColumnStatsData binaryColumnStatsData = new BinaryColumnStatsData();
            if (colStats.nullCount().isPresent()) {
                binaryColumnStatsData.setNumNulls(colStats.nullCount().getAsLong());
            }
            if (colStats.avgLen().isPresent()) {
                binaryColumnStatsData.setAvgColLen((double)colStats.avgLen().getAsLong());
            }
            if (colStats.maxLen().isPresent()) {
                binaryColumnStatsData.setMaxColLen(colStats.maxLen().getAsLong());
            }
            columnStatisticsData.setBinaryStats(binaryColumnStatsData);
            return Optional.of(columnStatisticsData);
        }
        if (dataField.type() instanceof BooleanType) {
            BooleanColumnStatsData booleanColumnStatsData = new BooleanColumnStatsData();
            if (colStats.nullCount().isPresent()) {
                booleanColumnStatsData.setNumNulls(colStats.nullCount().getAsLong());
            }
            columnStatisticsData.setBooleanStats(booleanColumnStatsData);
            return Optional.of(columnStatisticsData);
        }
        LOG.warn(String.format("Column stats doesn't support data type %s", dataField.type().asSQLString()));
        return Optional.empty();
    }

    public static FileStoreTable createFileStoreTable(org.apache.hadoop.hive.metastore.api.Table table) throws MetaException {
        Options options = HiveUtils.extractCatalogConfig((Configuration)FePaimonTable.jobConf);
        options.set(CoreOptions.PATH, (Object)LocationKeyExtractor.getPaimonLocation((Configuration)FePaimonTable.jobConf, (org.apache.hadoop.hive.metastore.api.Table)table));
        CatalogContext catalogContext = (Boolean)options.get(HadoopUtils.HADOOP_LOAD_DEFAULT_CONFIG) != false ? CatalogContext.create((Options)options, (Configuration)FePaimonTable.jobConf) : CatalogContext.create((Options)options);
        return FileStoreTableFactory.create((CatalogContext)catalogContext);
    }

    public static FileStoreTable createFileStoreTable(String tableLocation) throws MetaException {
        Options options = HiveUtils.extractCatalogConfig((Configuration)FePaimonTable.jobConf);
        options.set(CoreOptions.PATH, (Object)tableLocation);
        CatalogContext catalogContext = (Boolean)options.get(HadoopUtils.HADOOP_LOAD_DEFAULT_CONFIG) != false ? CatalogContext.create((Options)options, (Configuration)FePaimonTable.jobConf) : CatalogContext.create((Options)options);
        return FileStoreTableFactory.create((CatalogContext)catalogContext);
    }

    public static List<String> fieldNames(RowType rowType) {
        return rowType.getFields().stream().map(DataField::name).map(String::toLowerCase).collect(Collectors.toList());
    }

    public static boolean hasPrimaryKey(org.apache.paimon.table.Table table) {
        return !table.primaryKeys().isEmpty();
    }

    public static boolean hasPartition(org.apache.paimon.table.Table table) {
        return !table.partitionKeys().isEmpty();
    }

    public static List<InternalRow> lookupInTable(org.apache.paimon.table.Table table, List<Predicate> predicates) {
        return PaimonUtil.lookupInTable(table, predicates, 1000);
    }

    protected static List<InternalRow> lookupInTable(org.apache.paimon.table.Table table, List<Predicate> predicates, int maxcount) {
        ReadBuilder readBuilder = table.newReadBuilder().withFilter(predicates);
        List splits = readBuilder.newScan().plan().splits();
        TableRead read = readBuilder.newRead();
        ArrayList internalRows = Lists.newArrayList();
        try (RecordReader recordReader = read.createReader(splits);){
            RecordReader.RecordIterator recordIterator = recordReader.readBatch();
            InternalRow internalRow = null;
            while ((internalRow = (InternalRow)recordIterator.next()) != null) {
                internalRows.add(internalRow);
                if (internalRows.size() < maxcount) continue;
                break;
            }
        }
        catch (IOException ex) {
            LOG.warn("failed to read table", (Throwable)ex);
            return Lists.newArrayList();
        }
        return internalRows;
    }

    public static boolean canApplyPredicatePushDown(org.apache.paimon.table.Table table) {
        return table instanceof FileStoreTable;
    }

    public static TGetTableHistoryResult getPaimonTableHistory(FePaimonTable feTable, TDescribeHistoryParams params) throws DatabaseNotFoundException {
        try {
            int[] SNAPSHOT_TABLE_PROJECTION = new int[]{5, 0, 1};
            TGetTableHistoryResult historyResult = new TGetTableHistoryResult();
            FileStoreTable table = (FileStoreTable)feTable.getPaimonApiTable();
            org.apache.paimon.table.Table snapshotTable = SystemTableLoader.load((String)"snapshots", (FileStoreTable)table);
            PredicateBuilder predicateBuilder = new PredicateBuilder(snapshotTable.rowType());
            Optional<Object> predicataOpt = Optional.empty();
            if (params.isSetFrom_time()) {
                predicataOpt = Optional.of(predicateBuilder.greaterOrEqual(0, (Object)Timestamp.fromEpochMillis((long)params.getFrom_time())));
            } else if (params.isSetBetween_start_time() && params.isSetBetween_end_time()) {
                predicataOpt = Optional.of(PredicateBuilder.and((Predicate[])new Predicate[]{predicateBuilder.greaterOrEqual(0, (Object)Timestamp.fromEpochMillis((long)params.getBetween_start_time())), predicateBuilder.lessOrEqual(0, (Object)Timestamp.fromEpochMillis((long)params.getBetween_end_time()))}));
            }
            ReadBuilder readBuilder = snapshotTable.newReadBuilder().withProjection(SNAPSHOT_TABLE_PROJECTION);
            predicataOpt.ifPresent(arg_0 -> ((ReadBuilder)readBuilder).withFilter(arg_0));
            List splits = readBuilder.newScan().plan().splits();
            RecordReader internalRowRecordReader = readBuilder.newRead().createReader(splits);
            final ArrayList result = Lists.newArrayList();
            internalRowRecordReader.forEachRemaining((Consumer)new Consumer<InternalRow>(){

                @Override
                public void accept(InternalRow internalRow) {
                    TGetTableHistoryResultItem resultItem = new TGetTableHistoryResultItem();
                    long snapshotId = internalRow.getLong(1);
                    Timestamp timestamp = internalRow.getTimestamp(0, 9);
                    resultItem.setCreation_time(timestamp.getMillisecond());
                    resultItem.setSnapshot_id(snapshotId);
                    result.add(resultItem);
                }
            });
            historyResult.setResult(result);
            return historyResult;
        }
        catch (Exception ex) {
            throw new DatabaseNotFoundException("Failed to get snapshot: " + ex.getMessage());
        }
    }

    public static HdfsFileFormat getPaimonFileFormat(String format) {
        if ("PARQUET".equalsIgnoreCase(format) || format == null) {
            return HdfsFileFormat.PARQUET;
        }
        if ("ORC".equalsIgnoreCase(format)) {
            return HdfsFileFormat.ORC;
        }
        return null;
    }

    public static boolean isSynchronizedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        Preconditions.checkState((boolean)PaimonUtil.isPaimonTable(msTbl));
        return PaimonUtil.isManagedTable(msTbl) || Table.isExternalPurgeTable(msTbl);
    }

    public static boolean isManagedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return msTbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.toString());
    }

    public static String getPaimonCatalogLocation(MetaStoreClientPool.MetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTable) throws TException {
        TPaimonCatalog catalog = PaimonUtil.getTPaimonCatalog(msTable);
        if (catalog == TPaimonCatalog.HADOOP_CATALOG) {
            String location = (String)msTable.getParameters().get(PAIMON_HADOOP_CATALOG_LOCATION);
            Identifier table_identifier = PaimonUtil.getTableIdentifier(msTable);
            return AbstractCatalog.newTableLocation((String)location, (Identifier)table_identifier).toString();
        }
        return MetastoreShim.getPathForNewTable(msClient.getHiveClient().getDatabase(msTable.getDbName()), msTable);
    }

    public static String getPaimonCatalogLocation(org.apache.hadoop.hive.metastore.api.Table msTable) {
        return (String)msTable.getParameters().get(PAIMON_HADOOP_CATALOG_LOCATION);
    }

    public static TPaimonCatalog getTPaimonCatalog(org.apache.hadoop.hive.metastore.api.Table msTable) {
        return PaimonUtil.getTPaimonCatalog(msTable.getParameters());
    }

    public static TPaimonCatalog getTPaimonCatalog(Map<String, String> props) {
        return PaimonUtil.getTPaimonCatalog(props.get(PAIMON_CATALOG));
    }

    public static TPaimonCatalog getTPaimonCatalog(String catalog) {
        if ("hadoop".equalsIgnoreCase(catalog)) {
            return TPaimonCatalog.HADOOP_CATALOG;
        }
        if (HIVE_CATALOG.equalsIgnoreCase(catalog) || catalog == null) {
            return TPaimonCatalog.HIVE_CATALOG;
        }
        return TPaimonCatalog.HIVE_CATALOG;
    }

    public static List<String> extractColumnNames(String value) {
        return Arrays.stream(value.split(",")).map(String::toLowerCase).collect(Collectors.toList());
    }

    public static CatalogContext catalogContext(org.apache.hadoop.hive.metastore.api.Table table, String location) {
        Options options = HiveUtils.extractCatalogConfig((Configuration)hiveConf_);
        options.set(CoreOptions.PATH, (Object)location);
        table.getParameters().forEach((arg_0, arg_1) -> ((Options)options).set(arg_0, arg_1));
        return CatalogContext.create((Options)options, (Configuration)hiveConf_);
    }

    public static String partitionSpecToString(Map<String, String> spec) {
        List speclist = spec.keySet().stream().map(k -> String.join((CharSequence)"=", k, (CharSequence)spec.get(k))).collect(Collectors.toList());
        return String.join((CharSequence)"/", speclist);
    }

    public static TResultSet doGetTableStats(FePaimonTable table) {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        result.setSchema(resultSchema);
        result.setRows(new ArrayList<TResultRow>());
        resultSchema.addToColumns(new TColumn("Number Of Rows", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Number Of Bytes", Type.BIGINT.toThrift()));
        TTableStats stats = table.getTTableStats();
        TResultRowBuilder builder = new TResultRowBuilder();
        builder.add(stats.getNum_rows());
        builder.add(stats.getTotal_file_bytes());
        result.addToRows(builder.get());
        return result;
    }

    public static long localMillisToUTCMillis(long epochMillis) {
        ZoneId zone = ZoneId.systemDefault();
        ZoneOffset offset = zone.getRules().getOffset(Instant.now());
        return epochMillis + (long)offset.getTotalSeconds() * 1000L;
    }

    public static TResultSet doGetPartitionStats(FePaimonTable table) {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        result.setSchema(resultSchema);
        result.setRows(new ArrayList<TResultRow>());
        resultSchema.addToColumns(new TColumn("Partition", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Number Of Rows", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Number Of Files", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Number Of Bytes", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Last Creation Time", Type.BIGINT.toThrift()));
        List partitions = CatalogUtils.listPartitionsFromFileSystem((org.apache.paimon.table.Table)table.getPaimonApiTable());
        for (Partition partition : partitions) {
            TResultRowBuilder builder = new TResultRowBuilder();
            builder.add(PaimonUtil.partitionSpecToString(partition.spec()));
            builder.add(partition.recordCount());
            builder.add(partition.fileCount());
            builder.add(partition.fileSizeInBytes());
            builder.add(PaimonUtil.localMillisToUTCMillis(partition.lastFileCreationTime()));
            result.addToRows(builder.get());
        }
        return result;
    }

    public static int getFieldIndexByNameIgnoreCase(RowType rowType, String fieldName) {
        for (int i = 0; i < rowType.getFields().size(); ++i) {
            if (!((DataField)rowType.getFields().get(i)).name().equalsIgnoreCase(fieldName)) continue;
            return i;
        }
        return -1;
    }

    private static Optional<Predicate> extractPartitionFilter(org.apache.paimon.table.Table table, TShowFilesParams request) {
        Iterator<List<TPartitionKeyValue>> iter = request.getPartition_setIterator();
        PredicateBuilder predicateBuilder = new PredicateBuilder(table.rowType());
        List predicates = request.getPartition_set().parallelStream().map(l -> PredicateBuilder.and(l.stream().map(kv -> predicateBuilder.equal(PaimonUtil.getFieldIndexByNameIgnoreCase(table.rowType(), kv.getName()), (Object)kv.getValue())).collect(Collectors.toList()))).collect(Collectors.toList());
        if (!predicates.isEmpty()) {
            return Optional.of(PredicateBuilder.or(predicates));
        }
        return Optional.empty();
    }

    public static TResultSet doGetTableFiles(FePaimonTable paimon_table, TShowFilesParams request) {
        Optional<Predicate> predicate;
        org.apache.paimon.table.Table table = paimon_table.getPaimonApiTable();
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        result.setSchema(resultSchema);
        resultSchema.addToColumns(new TColumn("Path", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Size", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Partition", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("EC Policy", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Type", Type.STRING.toThrift()));
        ReadBuilder readBuilder = table.newReadBuilder();
        result.setRows(new ArrayList<TResultRow>());
        if (request.isSetPartition_set() && (predicate = PaimonUtil.extractPartitionFilter(table, request)).isPresent()) {
            readBuilder = readBuilder.withFilter(predicate.get());
        }
        TableScan.Plan plan = readBuilder.newScan().plan();
        Options options = Options.fromMap((Map)table.options());
        InternalRowPartitionComputer computer = new InternalRowPartitionComputer((String)options.get(CoreOptions.PARTITION_DEFAULT_NAME), table.rowType(), table.partitionKeys().toArray(new String[0]), ((Boolean)options.get(CoreOptions.PARTITION_GENERATE_LEGCY_NAME)).booleanValue());
        for (Split split : plan.splits()) {
            DeletionFile deletionFile;
            TResultRowBuilder builder;
            if (!(split instanceof DataSplit)) continue;
            DataSplit dataSplit = (DataSplit)split;
            Optional rawFiles = dataSplit.convertToRawFiles();
            if (rawFiles.isPresent()) {
                for (RawFile rawFile : (List)rawFiles.get()) {
                    builder = new TResultRowBuilder();
                    builder.add(rawFile.path());
                    builder.add(PrintUtils.printBytes(rawFile.fileSize()));
                    builder.add(PaimonUtil.partitionSpecToString(computer.generatePartValues((InternalRow)dataSplit.partition())));
                    builder.add(FileSystemUtil.getErasureCodingPolicy(new org.apache.hadoop.fs.Path(rawFile.path())));
                    builder.add("DATA");
                    result.addToRows(builder.get());
                }
            }
            if (!split.deletionFiles().isPresent()) continue;
            Iterator iterator = ((List)split.deletionFiles().get()).iterator();
            while (iterator.hasNext() && (deletionFile = (DeletionFile)iterator.next()) != null) {
                builder = new TResultRowBuilder();
                builder.add(deletionFile.path());
                builder.add(PrintUtils.printBytes(deletionFile.length()));
                builder.add(PaimonUtil.partitionSpecToString(computer.generatePartValues((InternalRow)dataSplit.partition())));
                builder.add(FileSystemUtil.getErasureCodingPolicy(new org.apache.hadoop.fs.Path(deletionFile.path())));
                builder.add("DELETE");
                result.addToRows(builder.get());
            }
        }
        return result;
    }
}

