/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.paimon;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.paimon.FePaimonTable;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TPaimonCatalog;
import org.apache.impala.thrift.TPaimonTable;
import org.apache.impala.thrift.TPaimonTableKind;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.types.DataField;

public class PaimonTable
extends Table
implements FePaimonTable {
    private static final Set<String> PAIMON_EXCLUDED_PROPERTIES = Sets.newHashSet();
    private org.apache.paimon.table.Table table_;

    public PaimonTable(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDescriptor = new TTableDescriptor(tableId, TTableType.PAIMON_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        try {
            tableDescriptor.setPaimonTable(PaimonUtil.getTPaimonTable(this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tableDescriptor;
    }

    @Override
    public TTable toThrift() {
        TTable tTable = super.toThrift();
        try {
            tTable.setPaimon_table(PaimonUtil.getTPaimonTable(this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tTable;
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        TPaimonTable tpaimon = thriftTable.getPaimon_table();
        try {
            Preconditions.checkArgument((tpaimon.getKind() == TPaimonTableKind.JNI ? 1 : 0) != 0);
            this.table_ = PaimonUtil.deserialize(ByteBuffer.wrap(tpaimon.getJni_tbl_obj()));
        }
        catch (Exception e) {
            throw new TableLoadingException("Failed to load paimon table from thrift data.", e);
        }
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    private void verifyTable(org.apache.hadoop.hive.metastore.api.Table msTbl) throws TableLoadingException {
        TPaimonCatalog catalog = PaimonUtil.getTPaimonCatalog(msTbl);
        if (catalog == TPaimonCatalog.HADOOP_CATALOG && !msTbl.getParameters().containsKey("paimon.catalog_location")) {
            throw new TableLoadingException(String.format("%s is required for paimon hadoop catalog table.", "paimon.catalog_location"));
        }
    }

    public void loadSchemaFromPaimon() throws TableLoadingException, ImpalaRuntimeException {
        this.loadSchema();
        this.addVirtualColumns();
    }

    private void loadSchema() throws TableLoadingException {
        this.clearColumns();
        try {
            List dataFields = this.getPaimonSchema().getFields();
            List partitionKeys = this.getPaimonApiTable().partitionKeys().stream().map(String::toLowerCase).collect(Collectors.toList());
            List<FieldSchema> hiveFields = PaimonUtil.convertToHiveSchema(this.getPaimonSchema());
            List<Column> impalaFields = PaimonUtil.convertToImpalaSchema(this.getPaimonSchema());
            ArrayList hivePartitionedFields = Lists.newArrayList();
            ArrayList hiveNonPartitionedFields = Lists.newArrayList();
            ArrayList impalaNonPartitionedFields = Lists.newArrayList();
            ArrayList impalaPartitionedFields = Lists.newArrayList();
            for (Iterator name : partitionKeys) {
                int colIndex = PaimonUtil.getFieldIndexByNameIgnoreCase(this.getPaimonSchema(), (String)((Object)name));
                Preconditions.checkArgument((colIndex >= 0 ? 1 : 0) != 0);
                hivePartitionedFields.add(hiveFields.get(colIndex));
                impalaPartitionedFields.add(impalaFields.get(colIndex));
            }
            for (int i = 0; i < dataFields.size(); ++i) {
                if (partitionKeys.contains(((DataField)dataFields.get(i)).name().toLowerCase())) continue;
                hiveNonPartitionedFields.add(hiveFields.get(i));
                impalaNonPartitionedFields.add(impalaFields.get(i));
            }
            if (!hivePartitionedFields.isEmpty()) {
                this.msTable_.setPartitionKeys((List)hivePartitionedFields);
            }
            this.msTable_.getSd().setCols((List)hiveNonPartitionedFields);
            int colPos = 0;
            for (Column col : impalaPartitionedFields) {
                col.setPosition(colPos++);
                this.addColumn(col);
            }
            for (Column col : impalaNonPartitionedFields) {
                col.setPosition(colPos++);
                this.addColumn(col);
            }
            this.numClusteringCols_ = impalaPartitionedFields.size();
            HashMap paimonProps = Maps.newHashMap((Map)this.getPaimonApiTable().options());
            for (String key : PAIMON_EXCLUDED_PROPERTIES) {
                paimonProps.remove(key);
            }
            for (String key : paimonProps.keySet()) {
                this.msTable_.getParameters().put(key, paimonProps.get(key));
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new TableLoadingException(e.getMessage(), e);
        }
    }

    private void addVirtualColumns() {
        this.addVirtualColumn(VirtualColumn.INPUT_FILE_NAME);
        this.addVirtualColumn(VirtualColumn.FILE_POSITION);
        this.addVirtualColumn(VirtualColumn.PARTITION_VALUE_SERIALIZED);
        this.addVirtualColumn(VirtualColumn.BUCKET_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        Timer.Context context = this.getMetrics().getTimer("load-duration").time();
        this.verifyTable(msTbl);
        try {
            this.msTable_ = msTbl;
            this.setTableStats(this.msTable_);
            Timer.Context ctxStorageLdTime = this.getMetrics().getTimer("load-duration.storage-metadata").time();
            try {
                this.table_ = PaimonUtil.createFileStoreTable(msTbl);
                catalogTimeline.markEvent("Loaded Paimon API table");
                this.loadSchemaFromPaimon();
                catalogTimeline.markEvent("Loaded schema from Paimon");
                this.applyPaimonTableStatsIfPresent();
                this.loadAllColumnStats(msClient, catalogTimeline);
                this.applyPaimonColumnStatsIfPresent();
                catalogTimeline.markEvent("Loaded stats from Paimon");
            }
            catch (Exception e) {
                throw new TableLoadingException("Error loading metadata for Paimon table " + msTbl.getTableName(), e);
            }
            finally {
                catalogTimeline.markEvent("Loaded all from Paimon");
                this.storageMetadataLoadTime_ = ctxStorageLdTime.stop();
            }
            this.refreshLastUsedTime();
        }
        finally {
            context.stop();
        }
    }

    @Override
    public org.apache.paimon.table.Table getPaimonApiTable() {
        return this.table_;
    }

    static {
        PAIMON_EXCLUDED_PROPERTIES.add(CoreOptions.PATH.key());
        PAIMON_EXCLUDED_PROPERTIES.add("owner");
    }
}

