/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.paimon;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.paimon.PaimonTable;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TCreateTableParams;
import org.apache.impala.thrift.TDropTableOrViewParams;
import org.apache.impala.util.EventSequence;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.types.DataField;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonCatalogOpExecutor {
    public static final Logger LOG = LoggerFactory.getLogger(PaimonCatalogOpExecutor.class);
    public static final String LOADED_PAIMON_TABLE = "Loaded paimon table";
    public static final String CREATED_PAIMON_TABLE = "Created table using Paimon Catalog ";

    public static String createTable(Identifier identifier, String location, TCreateTableParams params, org.apache.hadoop.hive.metastore.api.Table newTable) throws ImpalaRuntimeException {
        try {
            FileIO fileIO;
            ArrayList all_columns = Lists.newArrayList(params.getColumns());
            ArrayList partitionKeys = Lists.newArrayList();
            ArrayList primaryKeys = Lists.newArrayList();
            if (params.getPartition_columnsSize() > 0) {
                Preconditions.checkArgument((!params.getTable_properties().containsKey(CoreOptions.PARTITION.key()) ? 1 : 0) != 0);
                all_columns.addAll(params.getPartition_columns());
                partitionKeys.addAll(params.getPartition_columns().stream().map(c -> c.getColumnName().toLowerCase()).collect(Collectors.toList()));
                params.getTable_properties().remove(CoreOptions.PARTITION.key());
            }
            if (params.getTable_properties().containsKey(CoreOptions.PARTITION.key())) {
                Preconditions.checkArgument((params.getPartition_columnsSize() <= 0 ? 1 : 0) != 0);
                partitionKeys.clear();
                List newPartKeys = Arrays.stream(params.getTable_properties().get(CoreOptions.PARTITION.key()).split(",")).collect(Collectors.toList());
                partitionKeys.addAll(newPartKeys);
                params.getTable_properties().remove(CoreOptions.PARTITION.key());
            }
            if (params.getPrimary_key_column_namesSize() > 0) {
                primaryKeys.addAll(params.getPrimary_key_column_names());
                Preconditions.checkArgument((!params.getTable_properties().containsKey(CoreOptions.PRIMARY_KEY.key()) ? 1 : 0) != 0);
            }
            if (params.getTable_properties().containsKey(CoreOptions.PRIMARY_KEY.key())) {
                primaryKeys.clear();
                List exist = Arrays.stream(params.getTable_properties().get(CoreOptions.PRIMARY_KEY.key()).split(",")).collect(Collectors.toList());
                primaryKeys.addAll(exist);
            }
            params.getTable_properties().put(CoreOptions.PRIMARY_KEY.key(), StringUtils.join((Iterable)primaryKeys, (String)","));
            Path path = new Path(location);
            CatalogContext context = PaimonUtil.catalogContext(newTable, location);
            try {
                fileIO = FileIO.get((Path)path, (CatalogContext)context);
            }
            catch (IOException e) {
                throw new ImpalaRuntimeException("Failed to get file IO for paimon table", e);
            }
            SchemaManager schemaManager = new SchemaManager(fileIO, path);
            Optional tableSchema = schemaManager.latest();
            if (tableSchema.isPresent()) {
                throw new AlreadyExistsException("Can't create paimon table, since the table location is not clean.");
            }
            Schema schema = PaimonUtil.genPaimonSchema(all_columns, partitionKeys, params.getTable_properties());
            schemaManager.createTable(schema);
            LOG.info("Create paimon table successful.");
            return location;
        }
        catch (Exception ex) {
            throw new ImpalaRuntimeException("Failed to create paimon table", ex);
        }
    }

    public static void populateExternalTableSchemaFromPaimonTable(org.apache.hadoop.hive.metastore.api.Table msTbl, org.apache.paimon.table.Table tbl) throws TableLoadingException {
        try {
            ArrayList cols = Lists.newArrayList();
            ArrayList partCols = Lists.newArrayList();
            Set partSet = tbl.partitionKeys().stream().map(String::toLowerCase).collect(Collectors.toSet());
            List primaryKeys = tbl.primaryKeys().stream().map(String::toLowerCase).collect(Collectors.toList());
            List<FieldSchema> hiveFields = PaimonUtil.convertToHiveSchema(tbl.rowType());
            for (int i = 0; i < tbl.rowType().getFields().size(); ++i) {
                DataField dataField = (DataField)tbl.rowType().getFields().get(i);
                if (partSet.contains(dataField.name().toLowerCase())) {
                    partCols.add(hiveFields.get(i));
                    continue;
                }
                cols.add(hiveFields.get(i));
            }
            msTbl.getSd().setCols((List)cols);
            msTbl.setPartitionKeys((List)partCols);
            Map parameters = msTbl.getParameters();
            if (!primaryKeys.isEmpty()) {
                parameters.put(CoreOptions.PRIMARY_KEY.key(), StringUtils.join(primaryKeys, (String)","));
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new TableLoadingException("Error while infer schema from underlying paimon table", e);
        }
    }

    public static boolean dropTable(org.apache.hadoop.hive.metastore.api.Table msTbl, Table existingTbl, EventSequence catalogTimeline, TDropTableOrViewParams param) throws ImpalaRuntimeException {
        boolean isSynchronizedPaimonTable;
        if (msTbl == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(existingTbl instanceof PaimonTable));
        boolean bl = isSynchronizedPaimonTable = PaimonUtil.isSynchronizedTable(msTbl) || param.isPurge();
        if (isSynchronizedPaimonTable) {
            String location = msTbl.getSd().getLocation();
            Path path = new Path(location);
            CatalogContext context = PaimonUtil.catalogContext(msTbl, location);
            try {
                FileIO fileIO = FileIO.get((Path)path, (CatalogContext)context);
                if (fileIO.exists(path)) {
                    fileIO.deleteDirectoryQuietly(path);
                    fileIO.mkdirs(path);
                }
            }
            catch (IOException e) {
                LOG.warn("Delete directory '{}' fail for the paimon table.", (Object)path, (Object)e);
            }
            catalogTimeline.markEvent("Dropped table using Paimon");
        }
        return true;
    }
}

