/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.paimon;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class ImpalaTypeUtils {
    public static Type toImpalaType(DataType logicalType) {
        return (Type)logicalType.accept((DataTypeVisitor)PaimonToImpalaTypeVisitor.INSTANCE);
    }

    public static DataType fromImpalaType(Type Type2) {
        return ImpalaToPaimonTypeVisitor.visit(Type2);
    }

    public static boolean isSupportedPrimitiveType(PrimitiveType primitiveType) {
        Preconditions.checkNotNull((Object)((Object)primitiveType));
        switch (primitiveType) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case DATE: 
            case TIMESTAMP: 
            case BINARY: 
            case DATETIME: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportedColumnType(Type colType) {
        Preconditions.checkNotNull((Object)colType);
        return ImpalaTypeUtils.isSupportedPrimitiveType(colType.getPrimitiveType());
    }

    private static class ImpalaToPaimonTypeVisitor {
        private ImpalaToPaimonTypeVisitor() {
        }

        static DataType visit(Type type) {
            return ImpalaToPaimonTypeVisitor.visit(type, new ImpalaToPaimonTypeVisitor());
        }

        static DataType visit(Type type, ImpalaToPaimonTypeVisitor visitor) {
            if (type.isStructType()) {
                StructType structTypeInfo = (StructType)type;
                List<StructField> fields = structTypeInfo.getFields();
                RowType.Builder builder = RowType.builder();
                for (StructField field : fields) {
                    builder.field(field.getName(), ImpalaToPaimonTypeVisitor.visit(field.getType(), visitor));
                }
                return builder.build();
            }
            if (type.isMapType()) {
                MapType mapTypeInfo = (MapType)type;
                return DataTypes.MAP((DataType)ImpalaToPaimonTypeVisitor.visit(mapTypeInfo.getKeyType(), visitor), (DataType)ImpalaToPaimonTypeVisitor.visit(mapTypeInfo.getValueType(), visitor));
            }
            if (type.isArrayType()) {
                ArrayType listTypeInfo = (ArrayType)type;
                return DataTypes.ARRAY((DataType)ImpalaToPaimonTypeVisitor.visit(listTypeInfo.getItemType(), visitor));
            }
            return visitor.atomic(type);
        }

        public DataType atomic(Type atomic) {
            PrimitiveType primitiveType = atomic.getPrimitiveType();
            switch (primitiveType) {
                case BOOLEAN: {
                    return DataTypes.BOOLEAN();
                }
                case TINYINT: {
                    return DataTypes.TINYINT();
                }
                case SMALLINT: {
                    return DataTypes.SMALLINT();
                }
                case INT: {
                    return DataTypes.INT();
                }
                case BIGINT: {
                    return DataTypes.BIGINT();
                }
                case FLOAT: {
                    return DataTypes.FLOAT();
                }
                case DOUBLE: {
                    return DataTypes.DOUBLE();
                }
                case DECIMAL: {
                    ScalarType scalarType = (ScalarType)atomic;
                    return DataTypes.DECIMAL((int)scalarType.decimalPrecision(), (int)scalarType.decimalScale());
                }
                case CHAR: {
                    return DataTypes.CHAR((int)((ScalarType)atomic).getLength());
                }
                case VARCHAR: {
                    return DataTypes.VARCHAR((int)((ScalarType)atomic).getLength());
                }
                case STRING: {
                    return DataTypes.STRING();
                }
                case DATE: {
                    return DataTypes.DATE();
                }
                case TIMESTAMP: {
                    return DataTypes.TIMESTAMP();
                }
                case BINARY: {
                    return DataTypes.BINARY((int)Integer.MAX_VALUE);
                }
            }
            throw new UnsupportedOperationException("Not a supported type: " + atomic);
        }
    }

    private static class PaimonToImpalaTypeVisitor
    extends DataTypeDefaultVisitor<Type> {
        private static final PaimonToImpalaTypeVisitor INSTANCE = new PaimonToImpalaTypeVisitor();

        private PaimonToImpalaTypeVisitor() {
        }

        public Type visit(BooleanType booleanType) {
            return Type.BOOLEAN;
        }

        public Type visit(TinyIntType tinyIntType) {
            return Type.TINYINT;
        }

        public Type visit(SmallIntType smallIntType) {
            return Type.SMALLINT;
        }

        public Type visit(IntType intType) {
            return Type.INT;
        }

        public Type visit(BigIntType bigIntType) {
            return Type.BIGINT;
        }

        public Type visit(FloatType floatType) {
            return Type.FLOAT;
        }

        public Type visit(DoubleType doubleType) {
            return Type.DOUBLE;
        }

        public Type visit(DecimalType decimalType) {
            return ScalarType.createDecimalType(decimalType.getPrecision(), decimalType.getScale());
        }

        public Type visit(CharType charType) {
            if (charType.getLength() > 255) {
                return Type.STRING;
            }
            return ScalarType.createCharType(charType.getLength());
        }

        public Type visit(VarCharType varCharType) {
            if (varCharType.getLength() > 65535) {
                return Type.STRING;
            }
            return ScalarType.createVarcharType(varCharType.getLength());
        }

        public Type visit(BinaryType binaryType) {
            return Type.BINARY;
        }

        public Type visit(VarBinaryType varBinaryType) {
            return Type.BINARY;
        }

        public Type visit(DateType dateType) {
            return Type.DATE;
        }

        public Type visit(TimestampType timestampType) {
            return Type.TIMESTAMP;
        }

        public Type visit(LocalZonedTimestampType localZonedTimestampType) {
            return Type.TIMESTAMP;
        }

        public Type visit(org.apache.paimon.types.ArrayType arrayType) {
            DataType elementType = arrayType.getElementType();
            return new ArrayType((Type)elementType.accept((DataTypeVisitor)this));
        }

        public Type visit(org.apache.paimon.types.MapType mapType) {
            return new MapType((Type)mapType.getKeyType().accept((DataTypeVisitor)this), (Type)mapType.getValueType().accept((DataTypeVisitor)this));
        }

        public Type visit(RowType rowType) {
            List<StructField> structFields = rowType.getFields().stream().map(dataField -> new StructField(dataField.name().toLowerCase(), (Type)dataField.type().accept((DataTypeVisitor)this))).collect(Collectors.toList());
            return new StructType(structFields);
        }

        protected Type defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported type: " + dataType);
        }
    }
}

