/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.paimon;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.mapred.JobConf;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.paimon.FeShowFileStmtSupport;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TShowFilesParams;
import org.apache.impala.thrift.TShowStatsOp;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FePaimonTable
extends FeTable,
FeShowFileStmtSupport {
    public static final Logger LOG = LoggerFactory.getLogger(FePaimonTable.class);
    public static final JobConf jobConf = new JobConf();

    public Table getPaimonApiTable();

    default public boolean hasSnapshotMetaTable() {
        Table table = this.getPaimonApiTable();
        return table instanceof FileStoreTable;
    }

    default public RowType getPaimonSchema() {
        return this.getPaimonApiTable().rowType();
    }

    default public void applyPaimonTableStatsIfPresent() {
        Preconditions.checkState((this.getTTableStats() != null ? 1 : 0) != 0);
        Table table = this.getPaimonApiTable();
        Optional stats = table.statistics();
        if (!stats.isPresent()) {
            return;
        }
        if (this.getTTableStats().getNum_rows() < 0L) {
            this.getTTableStats().setNum_rows(((Statistics)stats.get()).mergedRecordCount().orElse(-1L));
        }
        this.getTTableStats().setTotal_file_bytes(((Statistics)stats.get()).mergedRecordSize().orElse(-1L));
    }

    default public void applyPaimonColumnStatsIfPresent() {
        Preconditions.checkState((this.getTTableStats() != null ? 1 : 0) != 0);
        Table table = this.getPaimonApiTable();
        Optional stats = table.statistics();
        if (!stats.isPresent()) {
            return;
        }
        Map colStatsMap = ((Statistics)stats.get()).colStats();
        for (String colName : colStatsMap.keySet()) {
            DataField dataField;
            Column col = this.getColumn(colName.toLowerCase());
            if (null == col) continue;
            if (!ColumnStats.isSupportedColType(col.getType())) {
                LOG.warn(String.format("Statistics for %s, column %s are not supported as column has type %s", this.getFullName(), col.getName(), col.getType()));
                continue;
            }
            ColStats colStats = (ColStats)colStatsMap.get(colName);
            Optional<ColumnStatisticsData> colStatsData = PaimonUtil.convertColStats(colStats, dataField = table.rowType().getField(colName));
            if (!colStatsData.isPresent() || col.updateStats(colStatsData.get())) continue;
            LOG.warn(String.format("Failed to load column stats for %s, column %s. Stats may be incompatible with column type %s. Consider regenerating statistics for %s.", this.getFullName(), col.getName(), col.getType(), this.getFullName()));
        }
    }

    default public TResultSet getTableStats(TShowStatsOp op) {
        if (TShowStatsOp.TABLE_STATS == op) {
            return PaimonUtil.doGetTableStats(this);
        }
        if (TShowStatsOp.PARTITIONS == op) {
            return PaimonUtil.doGetPartitionStats(this);
        }
        throw new UnsupportedOperationException("paimon table doesn't support Show Stats Op" + op.name());
    }

    @Override
    default public TResultSet doGetTableFiles(TShowFilesParams request) {
        return PaimonUtil.doGetTableFiles(this, request);
    }

    @Override
    default public HdfsFileFormat getTableFormat() {
        return HdfsFileFormat.PAIMON;
    }

    @Override
    default public boolean supportPartitionFilter() {
        return false;
    }
}

