/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.monitor.TableLoadingTimeHistogram;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.TopNCache;

public final class CatalogTableMetrics {
    public static final CatalogTableMetrics INSTANCE = new CatalogTableMetrics();
    private final TopNCache<TableMetric<Long>, Long> frequentlyAccessedTables_;
    private final TopNCache<TableMetric<Long>, Long> largestTables_;
    private final TopNCache<TableMetric<Long>, Long> highFileCountTables_;
    private final TopNCache<TableMetric<TableLoadingTimeHistogram>, Long> longMetadataLoadingTables_;

    private CatalogTableMetrics() {
        int num_tables_tracked = Integer.getInteger("org.apache.impala.catalog.CatalogUsageMonitor.NUM_TABLES_TRACKED", 25);
        int num_loading_time_tables_tracked = Integer.getInteger("org.apache.impala.catalog.CatalogUsageMonitor.NUM_LOADING_TIME_TABLES_TRACKED", 100);
        this.frequentlyAccessedTables_ = new TopNCache(Pair::getSecond, num_tables_tracked, true);
        this.largestTables_ = new TopNCache(Pair::getSecond, num_tables_tracked, false);
        this.highFileCountTables_ = new TopNCache(Pair::getSecond, num_tables_tracked, false);
        this.longMetadataLoadingTables_ = new TopNCache(metric -> ((TableLoadingTimeHistogram)metric.getSecond()).getQuantile(TableLoadingTimeHistogram.Quantile.P100), num_loading_time_tables_tracked, false);
    }

    public void updateFrequentlyAccessedTables(Table tbl) {
        TableMetric<Long> metric = TableMetric.of(tbl, tbl.getMetadataOpsCount());
        this.frequentlyAccessedTables_.putOrUpdate(metric);
    }

    public void updateLargestTables(Table tbl) {
        TableMetric<Long> metric = TableMetric.of(tbl, tbl.getEstimatedMetadataSize());
        this.largestTables_.putOrUpdate(metric);
    }

    public void updateHighFileCountTables(Table tbl) {
        TableMetric<Long> metric = TableMetric.of(tbl, tbl.getNumFiles());
        this.highFileCountTables_.putOrUpdate(metric);
    }

    public void updateLongMetadataLoadingTables(Table tbl) {
        TableLoadingTimeHistogram histogram = new TableLoadingTimeHistogram();
        histogram.setQuantile(TableLoadingTimeHistogram.Quantile.P50, tbl.getMedianTableLoadingTime());
        histogram.setQuantile(TableLoadingTimeHistogram.Quantile.P75, tbl.get75TableLoadingTime());
        histogram.setQuantile(TableLoadingTimeHistogram.Quantile.P95, tbl.get95TableLoadingTime());
        histogram.setQuantile(TableLoadingTimeHistogram.Quantile.P99, tbl.get99TableLoadingTime());
        histogram.setQuantile(TableLoadingTimeHistogram.Quantile.P100, tbl.getMaxTableLoadingTime());
        histogram.setCount(tbl.getTableLoadingCounts());
        TableMetric<TableLoadingTimeHistogram> metric = TableMetric.of(tbl, histogram);
        this.longMetadataLoadingTables_.putOrUpdate(metric);
    }

    public void removeTable(Table tbl) {
        TableMetric<?> metric = TableMetric.emptyOf(tbl);
        this.frequentlyAccessedTables_.remove(metric);
        this.largestTables_.remove(metric);
        this.highFileCountTables_.remove(metric);
        this.longMetadataLoadingTables_.remove(metric);
    }

    @VisibleForTesting
    synchronized void removeAllTables() {
        this.frequentlyAccessedTables_.removeAll();
        this.largestTables_.removeAll();
        this.highFileCountTables_.removeAll();
        this.longMetadataLoadingTables_.removeAll();
    }

    public List<? extends Pair<TTableName, Long>> getFrequentlyAccessedTables() {
        return this.frequentlyAccessedTables_.listEntries();
    }

    public List<? extends Pair<TTableName, Long>> getLargestTables() {
        return this.largestTables_.listEntries();
    }

    public List<? extends Pair<TTableName, Long>> getHighFileCountTables() {
        return this.highFileCountTables_.listEntries();
    }

    public List<? extends Pair<TTableName, TableLoadingTimeHistogram>> getLongMetadataLoadingTables() {
        return this.longMetadataLoadingTables_.listEntries();
    }

    static class TableMetric<T>
    extends Pair<TTableName, T> {
        TableMetric(TTableName tableName, T value) {
            super(tableName, value);
        }

        static <T> TableMetric<T> of(Table tbl, T value) {
            TTableName tTableName = tbl.getTableName().toThrift();
            return new TableMetric<T>(tTableName, value);
        }

        static TableMetric<?> emptyOf(Table tbl) {
            return TableMetric.of(tbl, null);
        }

        @Override
        public int hashCode() {
            return ((TTableName)this.first).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TableMetric)) {
                return false;
            }
            return ((TTableName)this.first).equals((TTableName)((TableMetric)obj).first);
        }
    }
}

