/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.HashMap;
import java.util.Optional;
import org.apache.impala.catalog.monitor.CatalogOperationCounter;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TTableName;

public class CatalogResetMetadataCounter
extends CatalogOperationCounter {
    public CatalogResetMetadataCounter() {
        this.counters_ = new HashMap();
        for (ResetMetadataType metadataType : ResetMetadataType.values()) {
            this.counters_.put(metadataType.toString(), new HashMap());
        }
    }

    public void incrementOperation(TResetMetadataRequest req) {
        Optional<TTableName> tTableName = req.table_name != null ? Optional.of(req.table_name) : Optional.empty();
        this.incrementCounter(CatalogResetMetadataCounter.getResetMetadataType(req, tTableName).toString(), this.getTableName(tTableName));
    }

    public void decrementOperation(TResetMetadataRequest req) {
        Optional<TTableName> tTableName = req.table_name != null ? Optional.of(req.table_name) : Optional.empty();
        this.decrementCounter(CatalogResetMetadataCounter.getResetMetadataType(req, tTableName).toString(), this.getTableName(tTableName));
    }

    public static ResetMetadataType getResetMetadataType(TResetMetadataRequest req, Optional<TTableName> tTableName) {
        if (req.is_refresh) {
            return ResetMetadataType.REFRESH;
        }
        if (tTableName.isPresent()) {
            return ResetMetadataType.INVALIDATE_METADATA;
        }
        return ResetMetadataType.INVALIDATE_METADATA_GLOBAL;
    }

    static enum ResetMetadataType {
        REFRESH,
        INVALIDATE_METADATA,
        INVALIDATE_METADATA_GLOBAL;

    }
}

