/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.impala.thrift.TOperationUsageCounter;
import org.apache.impala.thrift.TTableName;

public abstract class CatalogOperationCounter {
    protected Map<String, HashMap<String, MutableLong>> counters_;

    protected synchronized void incrementCounter(String operation, String tTableName) {
        this.counters_.get(operation).putIfAbsent(tTableName, new MutableLong(0L));
        this.counters_.get(operation).get(tTableName).increment();
    }

    protected synchronized void decrementCounter(String operation, String tTableName) {
        this.counters_.get(operation).get(tTableName).decrement();
        if (this.counters_.get(operation).get(tTableName).longValue() == 0L) {
            this.counters_.get(operation).remove(tTableName);
        }
    }

    public synchronized List<TOperationUsageCounter> getOperationUsage() {
        ArrayList<TOperationUsageCounter> tOperationUsageCounters = new ArrayList<TOperationUsageCounter>();
        this.counters_.forEach((operation, tableCounterMap) -> {
            if (tableCounterMap.size() > 0) {
                List<TOperationUsageCounter> tOperationUsageCounter = this.createTOperationUsageCounter((String)operation, (HashMap<String, MutableLong>)tableCounterMap);
                tOperationUsageCounters.addAll(tOperationUsageCounter);
            }
        });
        return tOperationUsageCounters;
    }

    protected List<TOperationUsageCounter> createTOperationUsageCounter(String operation, HashMap<String, MutableLong> tableCounterMap) {
        ArrayList<TOperationUsageCounter> tOperationUsageCounters = new ArrayList<TOperationUsageCounter>();
        tableCounterMap.forEach((table, counter) -> {
            TOperationUsageCounter tOperationUsageCounter = new TOperationUsageCounter();
            tOperationUsageCounter.setCatalog_op_name(operation);
            tOperationUsageCounter.setTable_name((String)table);
            tOperationUsageCounter.setOp_counter(counter.longValue());
            tOperationUsageCounters.add(tOperationUsageCounter);
        });
        return tOperationUsageCounters;
    }

    protected String getTableName(Optional<TTableName> tTableName) {
        if (tTableName.isPresent()) {
            if (tTableName.get().table_name.isEmpty()) {
                return tTableName.get().db_name;
            }
            return tTableName.get().db_name + "." + tTableName.get().table_name;
        }
        return "Not available";
    }
}

