/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import com.facebook.fb303.fb_status;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.AbstractThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.DefaultPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddCheckConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDefaultConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddNotNullConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddUniqueConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterCatalogRequest;
import org.apache.hadoop.hive.metastore.api.AlterISchemaRequest;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.AlterTableRequest;
import org.apache.hadoop.hive.metastore.api.AlterTableResponse;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsResult;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.ExtendedTableInfo;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogsResponse;
import org.apache.hadoop.hive.metastore.api.GetDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetRuntimeStatsRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaResponse;
import org.apache.hadoop.hive.metastore.api.GetSerdeRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.GetTablesExtRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesResult;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MapSchemaVersionToSerdeRequest;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdRequest;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsResult;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.RenamePartitionRequest;
import org.apache.hadoop.hive.metastore.api.RenamePartitionResponse;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.SeedTxnIdRequest;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsResponse;
import org.apache.hadoop.hive.metastore.api.SetSchemaVersionStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.TruncateTableRequest;
import org.apache.hadoop.hive.metastore.api.TruncateTableResponse;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolRequest;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMDropMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMDropMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMDropPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMDropPoolResponse;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchResponse;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.impala.catalog.CatalogHmsAPIHelper;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.events.EventFactory;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.metastore.HmsApiNameEnum;
import org.apache.impala.common.Metrics;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.AcidUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetastoreServiceHandler
extends AbstractThriftHiveMetastore {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreServiceHandler.class);
    protected static final String NOT_IMPLEMENTED_UNSUPPORTED = "%s method not supported by Catalog metastore service.";
    protected static final String METAEXCEPTION_MSG_FORMAT = "Unexpected error occurred while executing %s. Cause: %s. See catalog logs for details.";
    protected static final String HMS_FALLBACK_MSG_FORMAT = "Forwarding the request %s for table %s to the backing HiveMetastore service";
    protected final CatalogOpExecutor catalogOpExecutor_;
    protected final CatalogServiceCatalog catalog_;
    protected final boolean fallBackToHMSOnErrors_;
    protected Configuration serverConf_;
    protected PartitionExpressionProxy expressionProxy_;
    protected final String defaultCatalogName_;
    protected final Metrics metastoreEventsMetrics_ = new Metrics();
    protected EventFactory metastoreEventFactory_;

    public MetastoreServiceHandler(CatalogOpExecutor catalogOpExecutor, boolean fallBackToHMSOnErrors) {
        this.catalogOpExecutor_ = (CatalogOpExecutor)Preconditions.checkNotNull((Object)catalogOpExecutor);
        this.catalog_ = (CatalogServiceCatalog)Preconditions.checkNotNull((Object)catalogOpExecutor.getCatalog());
        this.fallBackToHMSOnErrors_ = fallBackToHMSOnErrors;
        LOG.info("Fallback to hive metastore service on errors is {}", (Object)this.fallBackToHMSOnErrors_);
        this.serverConf_ = (Configuration)Preconditions.checkNotNull((Object)MetastoreConf.newMetastoreConf());
        String className = MetastoreConf.get((Configuration)this.serverConf_, (String)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname());
        try {
            Preconditions.checkNotNull((Object)className);
            LOG.info("Instantiating {}", (Object)className);
            this.expressionProxy_ = PartFilterExprUtil.createExpressionProxy((Configuration)this.serverConf_);
            if (this.expressionProxy_ instanceof DefaultPartitionExpressionProxy) {
                LOG.error("PartFilterExprUtil.createExpressionProxy returned DefaultPartitionExpressionProxy. Check if hive-exec jar is available in the classpath.");
                this.expressionProxy_ = null;
            }
        }
        catch (Exception ex) {
            LOG.error("Could not instantiate {}", (Object)className, (Object)ex);
        }
        this.defaultCatalogName_ = MetaStoreUtils.getDefaultCatalog((Configuration)this.serverConf_);
        boolean invalidateCacheOnDdlFlag = BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs();
        boolean syncToLatestEventIdFlag = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        Preconditions.checkArgument((!invalidateCacheOnDdlFlag || !syncToLatestEventIdFlag ? 1 : 0) != 0, (Object)"Configurations invalidate_hms_cache_on_ddls and enable_sync_to_latest_event_on_ddls can not be set to true at the same time");
        if (BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs()) {
            LOG.debug("Invalidate catalogd cache for DDLs on non transactional tables is set to true");
        }
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            LOG.debug("catalogd cache sync to latest event id is set to true");
        }
        Preconditions.checkNotNull((Object)this.catalogOpExecutor_.getMetastoreDdlLock());
        this.initMetrics();
        this.metastoreEventFactory_ = this.catalog_.getEventFactoryForSyncToLatestEvent();
    }

    public String get_hms_api_version() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            String string = client.getHiveClient().getThriftClient().get_hms_api_version();
            return string;
        }
    }

    public String getMetaConf(String configKey) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            String string = client.getHiveClient().getThriftClient().getMetaConf(configKey);
            return string;
        }
    }

    public void setMetaConf(String configKey, String configValue) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().setMetaConf(configKey, configValue);
        }
    }

    public void create_catalog(CreateCatalogRequest createCatalogRequest) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_catalog(createCatalogRequest);
        }
    }

    public void alter_catalog(AlterCatalogRequest alterCatalogRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_catalog(alterCatalogRequest);
        }
    }

    public GetCatalogResponse get_catalog(GetCatalogRequest getCatalogRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetCatalogResponse getCatalogResponse = client.getHiveClient().getThriftClient().get_catalog(getCatalogRequest);
            return getCatalogResponse;
        }
    }

    public GetCatalogsResponse get_catalogs() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetCatalogsResponse getCatalogsResponse = client.getHiveClient().getThriftClient().get_catalogs();
            return getCatalogsResponse;
        }
    }

    public void drop_catalog(DropCatalogRequest dropCatalogRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_catalog(dropCatalogRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_database(Database database) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_database(database);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    public Database get_database(String databaseName) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Database database = client.getHiveClient().getThriftClient().get_database(databaseName);
            return database;
        }
    }

    public Database get_database_req(GetDatabaseRequest getDatabaseRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Database database = client.getHiveClient().getThriftClient().get_database_req(getDatabaseRequest);
            return database;
        }
    }

    public void drop_database(String databaseName, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        String[] parsedCatDbName = MetaStoreUtils.parseDbName((String)databaseName, (Configuration)this.serverConf_);
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setName(parsedCatDbName[1]);
        req.setCatalogName(parsedCatDbName[0]);
        req.setIgnoreUnknownDb(false);
        req.setDeleteData(deleteData);
        req.setCascade(cascade);
        this.drop_database_req(req);
    }

    public void drop_database_req(DropDatabaseRequest dropDatabaseRequest) throws NoSuchObjectException, InvalidOperationException, MetaException {
        long currentEventId = -1L;
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            currentEventId = this.getCurrentEventId(client);
            client.getHiveClient().getThriftClient().drop_database_req(dropDatabaseRequest);
        }
        catch (InvalidOperationException | MetaException | NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
        if (!BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs() || !BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
            return;
        }
        this.dropDbIfExists(dropDatabaseRequest.getName(), dropDatabaseRequest.isIgnoreUnknownDb(), currentEventId, "drop_database");
    }

    public List<String> get_databases(String pattern) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_databases(pattern);
            return list;
        }
    }

    public List<String> get_all_databases() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_all_databases();
            return list;
        }
    }

    public void alter_database(String dbname, Database database) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_database(dbname, database);
        }
    }

    public Type get_type(String name) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Type type = client.getHiveClient().getThriftClient().get_type(name);
            return type;
        }
    }

    public boolean create_type(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().create_type(type);
            return bl;
        }
    }

    public boolean drop_type(String type) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().drop_type(type);
            return bl;
        }
    }

    public Map<String, Type> get_type_all(String s) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Map map = client.getHiveClient().getThriftClient().get_type_all(s);
            return map;
        }
    }

    public List<FieldSchema> get_fields(String dbname, String tblname) throws MetaException, UnknownTableException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_fields(dbname, tblname);
            return list;
        }
    }

    public List<FieldSchema> get_fields_with_environment_context(String dbName, String tblName, EnvironmentContext environmentContext) throws MetaException, UnknownTableException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_fields_with_environment_context(dbName, tblName, environmentContext);
            return list;
        }
    }

    public List<FieldSchema> get_schema(String dbname, String tblname) throws MetaException, UnknownTableException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_schema(dbname, tblname);
            return list;
        }
    }

    public List<FieldSchema> get_schema_with_environment_context(String dbname, String tblname, EnvironmentContext environmentContext) throws MetaException, UnknownTableException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_schema_with_environment_context(dbname, tblname, environmentContext);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_table(org.apache.hadoop.hive.metastore.api.Table table) throws TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_table(table);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_table_with_environment_context(org.apache.hadoop.hive.metastore.api.Table table, EnvironmentContext environmentContext) throws TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_table_with_environment_context(table, environmentContext);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_table_with_constraints(org.apache.hadoop.hive.metastore.api.Table table, List<SQLPrimaryKey> sqlPrimaryKeys, List<SQLForeignKey> sqlForeignKeys, List<SQLUniqueConstraint> sqlUniqueConstraints, List<SQLNotNullConstraint> sqlNotNullConstraints, List<SQLDefaultConstraint> sqlDefaultConstraints, List<SQLCheckConstraint> sqlCheckConstraints) throws TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_table_with_constraints(table, sqlPrimaryKeys, sqlForeignKeys, sqlUniqueConstraints, sqlNotNullConstraints, sqlDefaultConstraints, sqlCheckConstraints);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_table_req(CreateTableRequest createTableRequest) throws TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_table_req(createTableRequest);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    public void drop_constraint(DropConstraintRequest dropConstraintRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_constraint(dropConstraintRequest);
        }
    }

    public void add_primary_key(AddPrimaryKeyRequest addPrimaryKeyRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_primary_key(addPrimaryKeyRequest);
        }
    }

    public void add_foreign_key(AddForeignKeyRequest addForeignKeyRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_foreign_key(addForeignKeyRequest);
        }
    }

    public void add_unique_constraint(AddUniqueConstraintRequest addUniqueConstraintRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_unique_constraint(addUniqueConstraintRequest);
        }
    }

    public void add_not_null_constraint(AddNotNullConstraintRequest addNotNullConstraintRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_not_null_constraint(addNotNullConstraintRequest);
        }
    }

    public void add_default_constraint(AddDefaultConstraintRequest addDefaultConstraintRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_default_constraint(addDefaultConstraintRequest);
        }
    }

    public void add_check_constraint(AddCheckConstraintRequest addCheckConstraintRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_check_constraint(addCheckConstraintRequest);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Table translate_table_dryrun(CreateTableRequest createTableRequest) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table table = client.getHiveClient().getThriftClient().translate_table_dryrun(createTableRequest);
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop_table(String dbname, String tblname, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        long eventId = -1L;
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            eventId = this.getCurrentEventId(client);
            client.getHiveClient().getThriftClient().drop_table(dbname, tblname, deleteData);
            if (!BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs() || !BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
                return;
            }
            this.dropTableIfExists(eventId, dbname, tblname, "drop_table");
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop_table_with_environment_context(String dbname, String tblname, boolean deleteData, EnvironmentContext environmentContext) throws NoSuchObjectException, MetaException, TException {
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        long eventId = -1L;
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            eventId = this.getCurrentEventId(client);
            client.getHiveClient().getThriftClient().drop_table_with_environment_context(dbname, tblname, deleteData, environmentContext);
            if (!BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs() || !BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
                return;
            }
            this.dropTableIfExists(eventId, dbname, tblname, "drop_table_with_environment_context");
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    public void truncate_table(String dbName, String tblName, List<String> partNames) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().truncate_table(dbName, tblName, partNames);
            this.invalidateNonTransactionalTableIfExists(dbName, tblName, "truncate_table");
        }
    }

    public TruncateTableResponse truncate_table_req(TruncateTableRequest req) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            TruncateTableResponse resp = client.getHiveClient().getThriftClient().truncate_table_req(req);
            this.invalidateNonTransactionalTableIfExists(req.getDbName(), req.getTableName(), "truncate_table_req");
            TruncateTableResponse truncateTableResponse = resp;
            return truncateTableResponse;
        }
    }

    public List<String> get_tables(String dbname, String tblName) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_tables(dbname, tblName);
            return list;
        }
    }

    public List<String> get_tables_by_type(String dbname, String tablePattern, String tableType) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_tables_by_type(dbname, tablePattern, tableType);
            return list;
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Table> get_all_materialized_view_objects_for_rewriting() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_all_materialized_view_objects_for_rewriting();
            return list;
        }
    }

    public List<String> get_materialized_views_for_rewriting(String dbName) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_materialized_views_for_rewriting(dbName);
            return list;
        }
    }

    public List<TableMeta> get_table_meta(String dbnamePattern, String tblNamePattern, List<String> tableTypes) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_table_meta(dbnamePattern, tblNamePattern, tableTypes);
            return list;
        }
    }

    public List<String> get_all_tables(String dbname) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_all_tables(dbname);
            return list;
        }
    }

    public org.apache.hadoop.hive.metastore.api.Table get_table(String dbname, String tblname) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            org.apache.hadoop.hive.metastore.api.Table table = client.getHiveClient().getThriftClient().get_table(dbname, tblname);
            return table;
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Table> get_table_objects_by_name(String dbname, List<String> list) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list2 = client.getHiveClient().getThriftClient().get_table_objects_by_name(dbname, list);
            return list2;
        }
    }

    public List<ExtendedTableInfo> get_tables_ext(GetTablesExtRequest getTablesExtRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_tables_ext(getTablesExtRequest);
            return list;
        }
    }

    public GetTableResult get_table_req(GetTableRequest getTableRequest) throws MetaException, NoSuchObjectException, TException {
        GetTableResult result;
        String tblName = getTableRequest.getDbName() + "." + getTableRequest.getTblName();
        LOG.debug(String.format(HMS_FALLBACK_MSG_FORMAT, "get_table_req", tblName));
        ValidTxnList txnList = null;
        ValidWriteIdList writeIdList = null;
        String requestWriteIdList = getTableRequest.getValidWriteIdList();
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean isTransactional;
            result = client.getHiveClient().getThriftClient().get_table_req(getTableRequest);
            org.apache.hadoop.hive.metastore.api.Table tbl = result.getTable();
            if (!getTableRequest.isGetFileMetadata()) {
                LOG.trace("File metadata is not requested. Returning table {}", (Object)tbl.getTableName());
                GetTableResult getTableResult = result;
                return getTableResult;
            }
            boolean bl = isTransactional = tbl.getParameters() != null && AcidUtils.isTransactionalTable(tbl.getParameters());
            if (isTransactional && requestWriteIdList != null) {
                txnList = MetastoreShim.getValidTxns(client.getHiveClient());
                writeIdList = MetastoreShim.getValidWriteIdListFromString(requestWriteIdList);
            }
        }
        CatalogHmsAPIHelper.loadAndSetFileMetadataFromFs(txnList, writeIdList, result);
        return result;
    }

    public GetTablesResult get_table_objects_by_name_req(GetTablesRequest getTablesRequest) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetTablesResult getTablesResult = client.getHiveClient().getThriftClient().get_table_objects_by_name_req(getTablesRequest);
            return getTablesResult;
        }
    }

    public Materialization get_materialization_invalidation_info(CreationMetadata creationMetadata, String validTxnList) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Materialization materialization = client.getHiveClient().getThriftClient().get_materialization_invalidation_info(creationMetadata, validTxnList);
            return materialization;
        }
    }

    public void update_creation_metadata(String catName, String dbName, String tblName, CreationMetadata creationMetadata) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().update_creation_metadata(catName, dbName, tblName, creationMetadata);
        }
    }

    public List<String> get_table_names_by_filter(String dbname, String tblname, short maxParts) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_table_names_by_filter(dbname, tblname, maxParts);
            return list;
        }
    }

    public void alter_table(String dbname, String tblName, org.apache.hadoop.hive.metastore.api.Table newTable) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_table(dbname, tblName, newTable);
            this.renameNonTransactionalTableIfExists(dbname, tblName, newTable.getDbName(), newTable.getTableName(), "alter_table");
        }
    }

    public void alter_table_with_environment_context(String dbname, String tblName, org.apache.hadoop.hive.metastore.api.Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_table_with_environment_context(dbname, tblName, table, environmentContext);
            this.renameNonTransactionalTableIfExists(dbname, tblName, table.getDbName(), table.getTableName(), "alter_table_with_environment_context");
        }
    }

    public void alter_table_with_cascade(String dbname, String tblName, org.apache.hadoop.hive.metastore.api.Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_table_with_cascade(dbname, tblName, table, cascade);
            this.renameNonTransactionalTableIfExists(dbname, tblName, table.getDbName(), table.getTableName(), "alter_table_with_cascade");
        }
    }

    public AlterTableResponse alter_table_req(AlterTableRequest alterTableRequest) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            AlterTableResponse response = client.getHiveClient().getThriftClient().alter_table_req(alterTableRequest);
            this.renameNonTransactionalTableIfExists(alterTableRequest.getDbName(), alterTableRequest.getTableName(), alterTableRequest.getTable().getDbName(), alterTableRequest.getTable().getTableName(), "alter_table_req");
            AlterTableResponse alterTableResponse = response;
            return alterTableResponse;
        }
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition addedPartition = client.getHiveClient().getThriftClient().add_partition(partition);
            this.invalidateNonTransactionalTableIfExists(partition.getDbName(), partition.getTableName(), "add_partition");
            Partition partition2 = addedPartition;
            return partition2;
        }
    }

    public Partition add_partition_with_environment_context(Partition partition, EnvironmentContext environmentContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition addedPartition = client.getHiveClient().getThriftClient().add_partition_with_environment_context(partition, environmentContext);
            this.invalidateNonTransactionalTableIfExists(partition.getDbName(), partition.getTableName(), "add_partition_with_environment_context");
            Partition partition2 = addedPartition;
            return partition2;
        }
    }

    public int add_partitions(List<Partition> partitionList) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            int numPartitionsAdded = client.getHiveClient().getThriftClient().add_partitions(partitionList);
            if (numPartitionsAdded > 0) {
                Partition partition = partitionList.get(0);
                this.invalidateNonTransactionalTableIfExists(partition.getDbName(), partition.getTableName(), "add_partitions");
            }
            int n = numPartitionsAdded;
            return n;
        }
    }

    public int add_partitions_pspec(List<PartitionSpec> list) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            int numPartitionsAdded = client.getHiveClient().getThriftClient().add_partitions_pspec(list);
            if (numPartitionsAdded > 0) {
                PartitionSpec partitionSpec = list.get(0);
                this.invalidateNonTransactionalTableIfExists(partitionSpec.getDbName(), partitionSpec.getTableName(), "add_partitions_pspec");
            }
            int n = numPartitionsAdded;
            return n;
        }
    }

    public Partition append_partition(String dbname, String tblName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().append_partition(dbname, tblName, partVals);
            this.invalidateNonTransactionalTableIfExists(dbname, tblName, "append_partition");
            Partition partition2 = partition;
            return partition2;
        }
    }

    public AddPartitionsResult add_partitions_req(AddPartitionsRequest addPartitionsRequest) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            AddPartitionsResult result = client.getHiveClient().getThriftClient().add_partitions_req(addPartitionsRequest);
            this.invalidateNonTransactionalTableIfExists(addPartitionsRequest.getDbName(), addPartitionsRequest.getTblName(), "add_partitions_req");
            AddPartitionsResult addPartitionsResult = result;
            return addPartitionsResult;
        }
    }

    public Partition append_partition_with_environment_context(String dbname, String tblname, List<String> partVals, EnvironmentContext environmentContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().append_partition_with_environment_context(dbname, tblname, partVals, environmentContext);
            this.invalidateNonTransactionalTableIfExists(dbname, tblname, "append_partition_with_environment_context");
            Partition partition2 = partition;
            return partition2;
        }
    }

    public Partition append_partition_by_name(String dbname, String tblname, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().append_partition_by_name(dbname, tblname, partName);
            this.invalidateNonTransactionalTableIfExists(dbname, tblname, "append_partition_by_name");
            Partition partition2 = partition;
            return partition2;
        }
    }

    public Partition append_partition_by_name_with_environment_context(String dbname, String tblname, String partName, EnvironmentContext environmentContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().append_partition_by_name_with_environment_context(dbname, tblname, partName, environmentContext);
            this.invalidateNonTransactionalTableIfExists(dbname, tblname, "append_partition_by_name_with_environment_context");
            Partition partition2 = partition;
            return partition2;
        }
    }

    public boolean drop_partition(String dbname, String tblname, List<String> partVals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean partitionDropped = client.getHiveClient().getThriftClient().drop_partition(dbname, tblname, partVals, deleteData);
            this.invalidateNonTransactionalTableIfExists(dbname, tblname, "drop_partition");
            boolean bl = partitionDropped;
            return bl;
        }
    }

    public boolean drop_partition_with_environment_context(String dbname, String tblname, List<String> partNames, boolean deleteData, EnvironmentContext environmentContext) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean partitionsDropped = client.getHiveClient().getThriftClient().drop_partition_with_environment_context(dbname, tblname, partNames, deleteData, environmentContext);
            this.invalidateNonTransactionalTableIfExists(dbname, tblname, "drop_partition_with_environment_context");
            boolean bl = partitionsDropped;
            return bl;
        }
    }

    public boolean drop_partition_by_name(String dbname, String tblname, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean partitionsDropped = client.getHiveClient().getThriftClient().drop_partition_by_name(dbname, tblname, partName, deleteData);
            this.invalidateNonTransactionalTableIfExists(dbname, tblname, "drop_partition_by_name");
            boolean bl = partitionsDropped;
            return bl;
        }
    }

    public boolean drop_partition_by_name_with_environment_context(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean partitionsDropped = client.getHiveClient().getThriftClient().drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
            this.invalidateNonTransactionalTableIfExists(dbName, tableName, "drop_partition_by_name_with_environment_context");
            boolean bl = partitionsDropped;
            return bl;
        }
    }

    public DropPartitionsResult drop_partitions_req(DropPartitionsRequest dropPartitionsRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            DropPartitionsResult result = client.getHiveClient().getThriftClient().drop_partitions_req(dropPartitionsRequest);
            this.invalidateNonTransactionalTableIfExists(dropPartitionsRequest.getDbName(), dropPartitionsRequest.getTblName(), "drop_partitions_req");
            DropPartitionsResult dropPartitionsResult = result;
            return dropPartitionsResult;
        }
    }

    public Partition get_partition(String dbName, String tblName, List<String> values) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().get_partition(dbName, tblName, values);
            return partition;
        }
    }

    public Partition exchange_partition(Map<String, String> partitionSpecMap, String sourcedb, String sourceTbl, String destDb, String destTbl) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().exchange_partition(partitionSpecMap, sourcedb, sourceTbl, destDb, destTbl);
            String apiName = "exchange_partition";
            this.invalidateNonTransactionalTableIfExists(sourcedb, sourceTbl, apiName);
            this.invalidateNonTransactionalTableIfExists(destDb, destTbl, apiName);
            Partition partition2 = partition;
            return partition2;
        }
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List partitions = client.getHiveClient().getThriftClient().exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
            String apiName = "exchange_partitions";
            this.invalidateNonTransactionalTableIfExists(sourceDb, sourceTable, apiName);
            this.invalidateNonTransactionalTableIfExists(destDb, destinationTableName, apiName);
            List list = partitions;
            return list;
        }
    }

    public Partition get_partition_with_auth(String dbname, String tblName, List<String> values, String user, List<String> groups) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().get_partition_with_auth(dbname, tblName, values, user, groups);
            return partition;
        }
    }

    public Partition get_partition_by_name(String dbName, String tblName, String partitionName) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition partition = client.getHiveClient().getThriftClient().get_partition_by_name(dbName, tblName, partitionName);
            return partition;
        }
    }

    public List<Partition> get_partitions(String dbName, String tblName, short maxLimit) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions(dbName, tblName, maxLimit);
            return list;
        }
    }

    public List<Partition> get_partitions_with_auth(String dbName, String tblName, short maxParts, String username, List<String> groups) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions_with_auth(dbName, tblName, maxParts, username, groups);
            return list;
        }
    }

    public List<PartitionSpec> get_partitions_pspec(String dbName, String tblName, int maxParts) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions_pspec(dbName, tblName, maxParts);
            return list;
        }
    }

    public GetPartitionsResponse get_partitions_with_specs(GetPartitionsRequest request) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetPartitionsResponse getPartitionsResponse = client.getHiveClient().getThriftClient().get_partitions_with_specs(request);
            return getPartitionsResponse;
        }
    }

    public List<String> get_partition_names(String dbName, String tblName, short maxParts) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partition_names(dbName, tblName, maxParts);
            return list;
        }
    }

    public PartitionValuesResponse get_partition_values(PartitionValuesRequest partitionValuesRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            PartitionValuesResponse partitionValuesResponse = client.getHiveClient().getThriftClient().get_partition_values(partitionValuesRequest);
            return partitionValuesResponse;
        }
    }

    public List<Partition> get_partitions_ps(String dbName, String tblName, List<String> partValues, short maxParts) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions_ps(dbName, tblName, partValues, maxParts);
            return list;
        }
    }

    public List<Partition> get_partitions_ps_with_auth(String dbName, String tblName, List<String> partVals, short maxParts, String user, List<String> groups) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions_ps_with_auth(dbName, tblName, partVals, maxParts, user, groups);
            return list;
        }
    }

    public List<String> get_partition_names_ps(String dbName, String tblName, List<String> partitionNames, short maxParts) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partition_names_ps(dbName, tblName, partitionNames, maxParts);
            return list;
        }
    }

    public List<Partition> get_partitions_by_filter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions_by_filter(dbName, tblName, filter, maxParts);
            return list;
        }
    }

    public List<PartitionSpec> get_part_specs_by_filter(String dbName, String tblName, String filter, int maxParts) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_part_specs_by_filter(dbName, tblName, filter, maxParts);
            return list;
        }
    }

    public GetFieldsResponse get_fields_req(GetFieldsRequest req) throws MetaException, UnknownTableException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List fields = client.getHiveClient().getThriftClient().get_fields_with_environment_context(MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.serverConf_), req.getTblName(), req.getEnvContext());
            GetFieldsResponse res = new GetFieldsResponse();
            res.setFields(fields);
            GetFieldsResponse getFieldsResponse = res;
            return getFieldsResponse;
        }
    }

    public GetSchemaResponse get_schema_req(GetSchemaRequest req) throws MetaException, UnknownTableException, UnknownDBException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List fields = client.getHiveClient().getThriftClient().get_schema_with_environment_context(MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.serverConf_), req.getTblName(), req.getEnvContext());
            GetSchemaResponse res = new GetSchemaResponse();
            res.setFields(fields);
            GetSchemaResponse getSchemaResponse = res;
            return getSchemaResponse;
        }
    }

    public GetPartitionResponse get_partition_req(GetPartitionRequest req) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Partition p = client.getHiveClient().getThriftClient().get_partition(MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.serverConf_), req.getTblName(), req.getPartVals());
            GetPartitionResponse res = new GetPartitionResponse();
            res.setPartition(p);
            GetPartitionResponse getPartitionResponse = res;
            return getPartitionResponse;
        }
    }

    public PartitionsResponse get_partitions_req(PartitionsRequest req) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List partitions = client.getHiveClient().getThriftClient().get_partitions(MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.serverConf_), req.getTblName(), req.getMaxParts());
            PartitionsResponse res = new PartitionsResponse();
            res.setPartitions(partitions);
            PartitionsResponse partitionsResponse = res;
            return partitionsResponse;
        }
    }

    public GetPartitionNamesPsResponse get_partition_names_ps_req(GetPartitionNamesPsRequest req) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List names = client.getHiveClient().getThriftClient().get_partition_names_ps(MetaStoreUtils.prependCatalogToDbName((String)req.getCatName(), (String)req.getDbName(), (Configuration)this.serverConf_), req.getTblName(), req.getPartValues(), req.getMaxParts());
            GetPartitionNamesPsResponse res = new GetPartitionNamesPsResponse();
            res.setNames(names);
            GetPartitionNamesPsResponse getPartitionNamesPsResponse = res;
            return getPartitionNamesPsResponse;
        }
    }

    public GetPartitionsPsWithAuthResponse get_partitions_ps_with_auth_req(GetPartitionsPsWithAuthRequest req) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetPartitionsPsWithAuthResponse getPartitionsPsWithAuthResponse = client.getHiveClient().getThriftClient().get_partitions_ps_with_auth_req(req);
            return getPartitionsPsWithAuthResponse;
        }
    }

    public PartitionsByExprResult get_partitions_by_expr(PartitionsByExprRequest partitionsByExprRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            PartitionsByExprResult partitionsByExprResult = client.getHiveClient().getThriftClient().get_partitions_by_expr(partitionsByExprRequest);
            return partitionsByExprResult;
        }
    }

    public int get_num_partitions_by_filter(String dbName, String tblName, String filter) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            int n = client.getHiveClient().getThriftClient().get_num_partitions_by_filter(dbName, tblName, filter);
            return n;
        }
    }

    public List<Partition> get_partitions_by_names(String dbName, String tblName, List<String> partitionNames) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_partitions_by_names(dbName, tblName, partitionNames);
            return list;
        }
    }

    protected void throwIfNoFallback(Exception cause, String apiName) throws TException {
        LOG.debug("Received exception while executing {}", (Object)apiName, (Object)cause);
        if (this.fallBackToHMSOnErrors_) {
            return;
        }
        this.rethrowException(cause, apiName);
    }

    protected void rethrowException(Exception cause, String apiName) throws TException {
        if (cause instanceof TException) {
            throw (TException)((Object)cause);
        }
        throw new MetaException(String.format(METAEXCEPTION_MSG_FORMAT, apiName, cause));
    }

    public GetPartitionsByNamesResult get_partitions_by_names_req(GetPartitionsByNamesRequest getPartitionsByNamesRequest) throws TException {
        GetPartitionsByNamesResult result;
        String tblName = getPartitionsByNamesRequest.getDb_name() + "." + getPartitionsByNamesRequest.getTbl_name();
        LOG.info(String.format(HMS_FALLBACK_MSG_FORMAT, HmsApiNameEnum.GET_PARTITION_BY_NAMES.apiName(), tblName));
        boolean getFileMetadata = getPartitionsByNamesRequest.isGetFileMetadata();
        ValidWriteIdList validWriteIdList = null;
        ValidTxnList validTxnList = null;
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean isTransactional;
            result = client.getHiveClient().getThriftClient().get_partitions_by_names_req(getPartitionsByNamesRequest);
            if (!getFileMetadata) {
                GetPartitionsByNamesResult getPartitionsByNamesResult = result;
                return getPartitionsByNamesResult;
            }
            String[] parsedCatDbName = MetaStoreUtils.parseDbName((String)getPartitionsByNamesRequest.getDb_name(), (Configuration)this.serverConf_);
            org.apache.hadoop.hive.metastore.api.Table tbl = client.getHiveClient().getTable(parsedCatDbName[0], parsedCatDbName[1], getPartitionsByNamesRequest.getTbl_name(), getPartitionsByNamesRequest.getValidWriteIdList());
            boolean bl = isTransactional = tbl.getParameters() != null && AcidUtils.isTransactionalTable(tbl.getParameters());
            if (isTransactional) {
                if (getPartitionsByNamesRequest.getValidWriteIdList() == null) {
                    throw new MetaException("ValidWriteIdList is not set when requesting partitions for table " + tbl.getDbName() + "." + tbl.getTableName());
                }
                validWriteIdList = MetastoreShim.getValidWriteIdListFromString(getPartitionsByNamesRequest.getValidWriteIdList());
                validTxnList = client.getHiveClient().getValidTxns();
            }
        }
        CatalogHmsAPIHelper.loadAndSetFileMetadataFromFs(validTxnList, validWriteIdList, result);
        return result;
    }

    public void alter_partition(String dbName, String tblName, Partition partition) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_partition(dbName, tblName, partition);
            this.invalidateNonTransactionalTableIfExists(dbName, tblName, "alter_partition");
        }
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_partitions(dbName, tblName, partitions);
            this.invalidateNonTransactionalTableIfExists(dbName, tblName, "alter_partitions");
        }
    }

    public void alter_partitions_with_environment_context(String dbName, String tblName, List<Partition> list, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_partitions_with_environment_context(dbName, tblName, list, environmentContext);
            this.invalidateNonTransactionalTableIfExists(dbName, tblName, "alter_partitions_with_environment_context");
        }
    }

    public AlterPartitionsResponse alter_partitions_req(AlterPartitionsRequest alterPartitionsRequest) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            AlterPartitionsResponse response = client.getHiveClient().getThriftClient().alter_partitions_req(alterPartitionsRequest);
            this.invalidateNonTransactionalTableIfExists(alterPartitionsRequest.getDbName(), alterPartitionsRequest.getTableName(), "alter_partitions_req");
            AlterPartitionsResponse alterPartitionsResponse = response;
            return alterPartitionsResponse;
        }
    }

    public void alter_partition_with_environment_context(String dbName, String tblName, Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_partition_with_environment_context(dbName, tblName, partition, environmentContext);
            this.invalidateNonTransactionalTableIfExists(dbName, tblName, "alter_partition_with_environment_context");
        }
    }

    public void rename_partition(String dbName, String tblName, List<String> list, Partition partition) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().rename_partition(dbName, tblName, list, partition);
            this.invalidateNonTransactionalTableIfExists(dbName, tblName, "rename_partition");
        }
    }

    public RenamePartitionResponse rename_partition_req(RenamePartitionRequest renamePartitionRequest) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            RenamePartitionResponse response = client.getHiveClient().getThriftClient().rename_partition_req(renamePartitionRequest);
            this.invalidateNonTransactionalTableIfExists(renamePartitionRequest.getDbName(), renamePartitionRequest.getTableName(), "rename_partition_req");
            RenamePartitionResponse renamePartitionResponse = response;
            return renamePartitionResponse;
        }
    }

    public boolean partition_name_has_valid_characters(List<String> list, boolean b) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().partition_name_has_valid_characters(list, b);
            return bl;
        }
    }

    public String get_config_value(String key, String defaultVal) throws ConfigValSecurityException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            String string = client.getHiveClient().getThriftClient().get_config_value(key, defaultVal);
            return string;
        }
    }

    public List<String> partition_name_to_vals(String name) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().partition_name_to_vals(name);
            return list;
        }
    }

    public Map<String, String> partition_name_to_spec(String name) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Map map = client.getHiveClient().getThriftClient().partition_name_to_spec(name);
            return map;
        }
    }

    public void markPartitionForEvent(String s, String s1, Map<String, String> map, PartitionEventType partitionEventType) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().markPartitionForEvent(s, s1, map, partitionEventType);
        }
    }

    public boolean isPartitionMarkedForEvent(String s, String s1, Map<String, String> map, PartitionEventType partitionEventType) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().isPartitionMarkedForEvent(s, s1, map, partitionEventType);
            return bl;
        }
    }

    public PrimaryKeysResponse get_primary_keys(PrimaryKeysRequest primaryKeysRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            PrimaryKeysResponse primaryKeysResponse = client.getHiveClient().getThriftClient().get_primary_keys(primaryKeysRequest);
            return primaryKeysResponse;
        }
    }

    public ForeignKeysResponse get_foreign_keys(ForeignKeysRequest foreignKeysRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ForeignKeysResponse foreignKeysResponse = client.getHiveClient().getThriftClient().get_foreign_keys(foreignKeysRequest);
            return foreignKeysResponse;
        }
    }

    public UniqueConstraintsResponse get_unique_constraints(UniqueConstraintsRequest uniqueConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            UniqueConstraintsResponse uniqueConstraintsResponse = client.getHiveClient().getThriftClient().get_unique_constraints(uniqueConstraintsRequest);
            return uniqueConstraintsResponse;
        }
    }

    public NotNullConstraintsResponse get_not_null_constraints(NotNullConstraintsRequest notNullConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            NotNullConstraintsResponse notNullConstraintsResponse = client.getHiveClient().getThriftClient().get_not_null_constraints(notNullConstraintsRequest);
            return notNullConstraintsResponse;
        }
    }

    public DefaultConstraintsResponse get_default_constraints(DefaultConstraintsRequest defaultConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            DefaultConstraintsResponse defaultConstraintsResponse = client.getHiveClient().getThriftClient().get_default_constraints(defaultConstraintsRequest);
            return defaultConstraintsResponse;
        }
    }

    public CheckConstraintsResponse get_check_constraints(CheckConstraintsRequest checkConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            CheckConstraintsResponse checkConstraintsResponse = client.getHiveClient().getThriftClient().get_check_constraints(checkConstraintsRequest);
            return checkConstraintsResponse;
        }
    }

    public AllTableConstraintsResponse get_all_table_constraints(AllTableConstraintsRequest request) throws TException, MetaException, NoSuchObjectException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            AllTableConstraintsResponse allTableConstraintsResponse = client.getHiveClient().getThriftClient().get_all_table_constraints(request);
            return allTableConstraintsResponse;
        }
    }

    public boolean update_table_column_statistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().update_table_column_statistics(columnStatistics);
            return bl;
        }
    }

    public boolean update_partition_column_statistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().update_partition_column_statistics(columnStatistics);
            return bl;
        }
    }

    public SetPartitionsStatsResponse update_table_column_statistics_req(SetPartitionsStatsRequest setPartitionsStatsRequest) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            SetPartitionsStatsResponse setPartitionsStatsResponse = client.getHiveClient().getThriftClient().update_table_column_statistics_req(setPartitionsStatsRequest);
            return setPartitionsStatsResponse;
        }
    }

    public SetPartitionsStatsResponse update_partition_column_statistics_req(SetPartitionsStatsRequest setPartitionsStatsRequest) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            SetPartitionsStatsResponse setPartitionsStatsResponse = client.getHiveClient().getThriftClient().update_partition_column_statistics_req(setPartitionsStatsRequest);
            return setPartitionsStatsResponse;
        }
    }

    public ColumnStatistics get_table_column_statistics(String s, String s1, String s2) throws NoSuchObjectException, MetaException, InvalidInputException, InvalidObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ColumnStatistics columnStatistics = client.getHiveClient().getThriftClient().get_table_column_statistics(s, s1, s2);
            return columnStatistics;
        }
    }

    public ColumnStatistics get_partition_column_statistics(String s, String s1, String s2, String s3) throws NoSuchObjectException, MetaException, InvalidInputException, InvalidObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ColumnStatistics columnStatistics = client.getHiveClient().getThriftClient().get_partition_column_statistics(s, s1, s2, s3);
            return columnStatistics;
        }
    }

    public TableStatsResult get_table_statistics_req(TableStatsRequest tableStatsRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            TableStatsResult tableStatsResult = client.getHiveClient().getThriftClient().get_table_statistics_req(tableStatsRequest);
            return tableStatsResult;
        }
    }

    public PartitionsStatsResult get_partitions_statistics_req(PartitionsStatsRequest partitionsStatsRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            PartitionsStatsResult partitionsStatsResult = client.getHiveClient().getThriftClient().get_partitions_statistics_req(partitionsStatsRequest);
            return partitionsStatsResult;
        }
    }

    public AggrStats get_aggr_stats_for(PartitionsStatsRequest partitionsStatsRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            AggrStats aggrStats = client.getHiveClient().getThriftClient().get_aggr_stats_for(partitionsStatsRequest);
            return aggrStats;
        }
    }

    public boolean set_aggr_stats_for(SetPartitionsStatsRequest setPartitionsStatsRequest) throws NoSuchObjectException, InvalidObjectException, MetaException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().set_aggr_stats_for(setPartitionsStatsRequest);
            return bl;
        }
    }

    public boolean delete_partition_column_statistics(String dbName, String tblName, String partName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().delete_partition_column_statistics(dbName, tblName, partName, colName, engine);
            return bl;
        }
    }

    public boolean delete_table_column_statistics(String dbName, String tblName, String columnName, String engien) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().delete_table_column_statistics(dbName, tblName, columnName, engien);
            return bl;
        }
    }

    public void create_function(Function function) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_function(function);
        }
    }

    public void drop_function(String dbName, String funcName) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_function(dbName, funcName);
        }
    }

    public void alter_function(String s, String s1, Function function) throws InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_function(s, s1, function);
        }
    }

    public List<String> get_functions(String s, String s1) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_functions(s, s1);
            return list;
        }
    }

    public Function get_function(String s, String s1) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Function function = client.getHiveClient().getThriftClient().get_function(s, s1);
            return function;
        }
    }

    public GetAllFunctionsResponse get_all_functions() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetAllFunctionsResponse getAllFunctionsResponse = client.getHiveClient().getThriftClient().get_all_functions();
            return getAllFunctionsResponse;
        }
    }

    public boolean create_role(Role role) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().create_role(role);
            return bl;
        }
    }

    public boolean drop_role(String s) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().drop_role(s);
            return bl;
        }
    }

    public List<String> get_role_names() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_role_names();
            return list;
        }
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
            return bl;
        }
    }

    public boolean revoke_role(String s, String s1, PrincipalType principalType) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().revoke_role(s, s1, principalType);
            return bl;
        }
    }

    public List<Role> list_roles(String s, PrincipalType principalType) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().list_roles(s, principalType);
            return list;
        }
    }

    public GrantRevokeRoleResponse grant_revoke_role(GrantRevokeRoleRequest grantRevokeRoleRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GrantRevokeRoleResponse grantRevokeRoleResponse = client.getHiveClient().getThriftClient().grant_revoke_role(grantRevokeRoleRequest);
            return grantRevokeRoleResponse;
        }
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest getPrincipalsInRoleRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetPrincipalsInRoleResponse getPrincipalsInRoleResponse = client.getHiveClient().getThriftClient().get_principals_in_role(getPrincipalsInRoleRequest);
            return getPrincipalsInRoleResponse;
        }
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRoleGrantsForPrincipalRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetRoleGrantsForPrincipalResponse getRoleGrantsForPrincipalResponse = client.getHiveClient().getThriftClient().get_role_grants_for_principal(getRoleGrantsForPrincipalRequest);
            return getRoleGrantsForPrincipalResponse;
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObjectRef, String s, List<String> list) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            PrincipalPrivilegeSet principalPrivilegeSet = client.getHiveClient().getThriftClient().get_privilege_set(hiveObjectRef, s, list);
            return principalPrivilegeSet;
        }
    }

    public List<HiveObjectPrivilege> list_privileges(String s, PrincipalType principalType, HiveObjectRef hiveObjectRef) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().list_privileges(s, principalType, hiveObjectRef);
            return list;
        }
    }

    public boolean grant_privileges(PrivilegeBag privilegeBag) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().grant_privileges(privilegeBag);
            return bl;
        }
    }

    public boolean revoke_privileges(PrivilegeBag privilegeBag) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().revoke_privileges(privilegeBag);
            return bl;
        }
    }

    public GrantRevokePrivilegeResponse grant_revoke_privileges(GrantRevokePrivilegeRequest grantRevokePrivilegeRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GrantRevokePrivilegeResponse grantRevokePrivilegeResponse = client.getHiveClient().getThriftClient().grant_revoke_privileges(grantRevokePrivilegeRequest);
            return grantRevokePrivilegeResponse;
        }
    }

    public GrantRevokePrivilegeResponse refresh_privileges(HiveObjectRef hiveObjectRef, String s, GrantRevokePrivilegeRequest grantRevokePrivilegeRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GrantRevokePrivilegeResponse grantRevokePrivilegeResponse = client.getHiveClient().getThriftClient().refresh_privileges(hiveObjectRef, s, grantRevokePrivilegeRequest);
            return grantRevokePrivilegeResponse;
        }
    }

    public List<String> set_ugi(String s, List<String> list) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list2 = client.getHiveClient().getThriftClient().set_ugi(s, list);
            return list2;
        }
    }

    public String get_delegation_token(String s, String s1) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            String string = client.getHiveClient().getThriftClient().get_delegation_token(s, s1);
            return string;
        }
    }

    public long renew_delegation_token(String s) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            long l = client.getHiveClient().getThriftClient().renew_delegation_token(s);
            return l;
        }
    }

    public void cancel_delegation_token(String s) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().cancel_delegation_token(s);
        }
    }

    public boolean add_token(String tokenIdentifier, String delegationToken) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().add_token(tokenIdentifier, delegationToken);
            return bl;
        }
    }

    public boolean remove_token(String tokenIdentifier) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().remove_token(tokenIdentifier);
            return bl;
        }
    }

    public String get_token(String s) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            String string = client.getHiveClient().getThriftClient().get_token(s);
            return string;
        }
    }

    public List<String> get_all_token_identifiers() throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_all_token_identifiers();
            return list;
        }
    }

    public int add_master_key(String s) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            int n = client.getHiveClient().getThriftClient().add_master_key(s);
            return n;
        }
    }

    public void update_master_key(int i, String s) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().update_master_key(i, s);
        }
    }

    public boolean remove_master_key(int i) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().remove_master_key(i);
            return bl;
        }
    }

    public List<String> get_master_keys() throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_master_keys();
            return list;
        }
    }

    public GetOpenTxnsResponse get_open_txns() throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetOpenTxnsResponse getOpenTxnsResponse = client.getHiveClient().getThriftClient().get_open_txns();
            return getOpenTxnsResponse;
        }
    }

    public GetOpenTxnsResponse get_open_txns_req(GetOpenTxnsRequest getOpenTxnsRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetOpenTxnsResponse getOpenTxnsResponse = client.getHiveClient().getThriftClient().get_open_txns_req(getOpenTxnsRequest);
            return getOpenTxnsResponse;
        }
    }

    public void create_stored_procedure(StoredProcedure proc) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_stored_procedure(proc);
        }
    }

    public StoredProcedure get_stored_procedure(StoredProcedureRequest request) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            StoredProcedure storedProcedure = client.getHiveClient().getThriftClient().get_stored_procedure(request);
            return storedProcedure;
        }
    }

    public void drop_stored_procedure(StoredProcedureRequest request) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_stored_procedure(request);
        }
    }

    public Package find_package(GetPackageRequest request) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            Package package_ = client.getHiveClient().getThriftClient().find_package(request);
            return package_;
        }
    }

    public void add_package(AddPackageRequest request) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_package(request);
        }
    }

    public List<String> get_all_packages(ListPackageRequest request) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_all_packages(request);
            return list;
        }
    }

    public void drop_package(DropPackageRequest request) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_package(request);
        }
    }

    public GetOpenTxnsInfoResponse get_open_txns_info() throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetOpenTxnsInfoResponse getOpenTxnsInfoResponse = client.getHiveClient().getThriftClient().get_open_txns_info();
            return getOpenTxnsInfoResponse;
        }
    }

    public OpenTxnsResponse open_txns(OpenTxnRequest openTxnRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            OpenTxnsResponse openTxnsResponse = client.getHiveClient().getThriftClient().open_txns(openTxnRequest);
            return openTxnsResponse;
        }
    }

    public void abort_txn(AbortTxnRequest abortTxnRequest) throws NoSuchTxnException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().abort_txn(abortTxnRequest);
        }
    }

    public void abort_txns(AbortTxnsRequest abortTxnsRequest) throws NoSuchTxnException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().abort_txns(abortTxnsRequest);
        }
    }

    public void commit_txn(CommitTxnRequest commitTxnRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().commit_txn(commitTxnRequest);
        }
    }

    public void repl_tbl_writeid_state(ReplTblWriteIdStateRequest replTblWriteIdStateRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().repl_tbl_writeid_state(replTblWriteIdStateRequest);
        }
    }

    public GetValidWriteIdsResponse get_valid_write_ids(GetValidWriteIdsRequest getValidWriteIdsRequest) throws NoSuchTxnException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetValidWriteIdsResponse getValidWriteIdsResponse = client.getHiveClient().getThriftClient().get_valid_write_ids(getValidWriteIdsRequest);
            return getValidWriteIdsResponse;
        }
    }

    public AllocateTableWriteIdsResponse allocate_table_write_ids(AllocateTableWriteIdsRequest allocateTableWriteIdsRequest) throws NoSuchTxnException, TxnAbortedException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            AllocateTableWriteIdsResponse allocateTableWriteIdsResponse = client.getHiveClient().getThriftClient().allocate_table_write_ids(allocateTableWriteIdsRequest);
            return allocateTableWriteIdsResponse;
        }
    }

    public LockResponse lock(LockRequest lockRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            LockResponse lockResponse = client.getHiveClient().getThriftClient().lock(lockRequest);
            return lockResponse;
        }
    }

    public LockResponse check_lock(CheckLockRequest checkLockRequest) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            LockResponse lockResponse = client.getHiveClient().getThriftClient().check_lock(checkLockRequest);
            return lockResponse;
        }
    }

    public void unlock(UnlockRequest unlockRequest) throws NoSuchLockException, TxnOpenException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().unlock(unlockRequest);
        }
    }

    public ShowLocksResponse show_locks(ShowLocksRequest showLocksRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ShowLocksResponse showLocksResponse = client.getHiveClient().getThriftClient().show_locks(showLocksRequest);
            return showLocksResponse;
        }
    }

    public void heartbeat(HeartbeatRequest heartbeatRequest) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().heartbeat(heartbeatRequest);
        }
    }

    public HeartbeatTxnRangeResponse heartbeat_txn_range(HeartbeatTxnRangeRequest heartbeatTxnRangeRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            HeartbeatTxnRangeResponse heartbeatTxnRangeResponse = client.getHiveClient().getThriftClient().heartbeat_txn_range(heartbeatTxnRangeRequest);
            return heartbeatTxnRangeResponse;
        }
    }

    public void compact(CompactionRequest compactionRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().compact(compactionRequest);
        }
    }

    public CompactionResponse compact2(CompactionRequest compactionRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            CompactionResponse compactionResponse = client.getHiveClient().getThriftClient().compact2(compactionRequest);
            return compactionResponse;
        }
    }

    public ShowCompactResponse show_compact(ShowCompactRequest showCompactRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ShowCompactResponse showCompactResponse = client.getHiveClient().getThriftClient().show_compact(showCompactRequest);
            return showCompactResponse;
        }
    }

    public GetLatestCommittedCompactionInfoResponse get_latest_committed_compaction_info(GetLatestCommittedCompactionInfoRequest request) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfoResponse = client.getHiveClient().getThriftClient().get_latest_committed_compaction_info(request);
            return getLatestCommittedCompactionInfoResponse;
        }
    }

    public void add_dynamic_partitions(AddDynamicPartitions addDynamicPartitions) throws NoSuchTxnException, TxnAbortedException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_dynamic_partitions(addDynamicPartitions);
        }
    }

    public OptionalCompactionInfoStruct find_next_compact(String s) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            OptionalCompactionInfoStruct optionalCompactionInfoStruct = client.getHiveClient().getThriftClient().find_next_compact(s);
            return optionalCompactionInfoStruct;
        }
    }

    public OptionalCompactionInfoStruct find_next_compact2(FindNextCompactRequest rqst) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            OptionalCompactionInfoStruct optionalCompactionInfoStruct = client.getHiveClient().getThriftClient().find_next_compact2(rqst);
            return optionalCompactionInfoStruct;
        }
    }

    public WriteNotificationLogBatchResponse add_write_notification_log_in_batch(WriteNotificationLogBatchRequest batchRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WriteNotificationLogBatchResponse writeNotificationLogBatchResponse = client.getHiveClient().getThriftClient().add_write_notification_log_in_batch(batchRequest);
            return writeNotificationLogBatchResponse;
        }
    }

    public void update_compactor_state(CompactionInfoStruct compactionInfoStruct, long l) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().update_compactor_state(compactionInfoStruct, l);
        }
    }

    public List<String> find_columns_with_stats(CompactionInfoStruct compactionInfoStruct) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().find_columns_with_stats(compactionInfoStruct);
            return list;
        }
    }

    public void mark_cleaned(CompactionInfoStruct compactionInfoStruct) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().mark_cleaned(compactionInfoStruct);
        }
    }

    public void mark_compacted(CompactionInfoStruct compactionInfoStruct) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().markCompacted(compactionInfoStruct);
        }
    }

    public void mark_failed(CompactionInfoStruct compactionInfoStruct) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().mark_failed(compactionInfoStruct);
        }
    }

    public MaxAllocatedTableWriteIdResponse get_max_allocated_table_write_id(MaxAllocatedTableWriteIdRequest rqst) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            MaxAllocatedTableWriteIdResponse maxAllocatedTableWriteIdResponse = client.getHiveClient().getThriftClient().get_max_allocated_table_write_id(rqst);
            return maxAllocatedTableWriteIdResponse;
        }
    }

    public void seed_write_id(SeedTableWriteIdsRequest rqst) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().seed_write_id(rqst);
        }
    }

    public void seed_txn_id(SeedTxnIdRequest rqst) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().seed_txn_id(rqst);
        }
    }

    public void set_hadoop_jobid(String s, long l) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().set_hadoop_jobid(s, l);
        }
    }

    public NotificationEventResponse get_next_notification(NotificationEventRequest notificationEventRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            NotificationEventResponse notificationEventResponse = client.getHiveClient().getThriftClient().get_next_notification(notificationEventRequest);
            return notificationEventResponse;
        }
    }

    public CurrentNotificationEventId get_current_notificationEventId() throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            CurrentNotificationEventId currentNotificationEventId = client.getHiveClient().getThriftClient().get_current_notificationEventId();
            return currentNotificationEventId;
        }
    }

    public NotificationEventsCountResponse get_notification_events_count(NotificationEventsCountRequest notificationEventsCountRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            NotificationEventsCountResponse notificationEventsCountResponse = client.getHiveClient().getThriftClient().get_notification_events_count(notificationEventsCountRequest);
            return notificationEventsCountResponse;
        }
    }

    public FireEventResponse fire_listener_event(FireEventRequest fireEventRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            FireEventResponse fireEventResponse = client.getHiveClient().getThriftClient().fire_listener_event(fireEventRequest);
            return fireEventResponse;
        }
    }

    public void flushCache() throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().flushCache();
        }
    }

    public WriteNotificationLogResponse add_write_notification_log(WriteNotificationLogRequest writeNotificationLogRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WriteNotificationLogResponse writeNotificationLogResponse = client.getHiveClient().getThriftClient().add_write_notification_log(writeNotificationLogRequest);
            return writeNotificationLogResponse;
        }
    }

    public void update_transaction_statistics(UpdateTransactionalStatsRequest req) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().update_transaction_statistics(req);
        }
    }

    public CmRecycleResponse cm_recycle(CmRecycleRequest cmRecycleRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            CmRecycleResponse cmRecycleResponse = client.getHiveClient().getThriftClient().cm_recycle(cmRecycleRequest);
            return cmRecycleResponse;
        }
    }

    public GetFileMetadataByExprResult get_file_metadata_by_expr(GetFileMetadataByExprRequest getFileMetadataByExprRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetFileMetadataByExprResult getFileMetadataByExprResult = client.getHiveClient().getThriftClient().get_file_metadata_by_expr(getFileMetadataByExprRequest);
            return getFileMetadataByExprResult;
        }
    }

    public GetFileMetadataResult get_file_metadata(GetFileMetadataRequest getFileMetadataRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            GetFileMetadataResult getFileMetadataResult = client.getHiveClient().getThriftClient().get_file_metadata(getFileMetadataRequest);
            return getFileMetadataResult;
        }
    }

    public PutFileMetadataResult put_file_metadata(PutFileMetadataRequest putFileMetadataRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            PutFileMetadataResult putFileMetadataResult = client.getHiveClient().getThriftClient().put_file_metadata(putFileMetadataRequest);
            return putFileMetadataResult;
        }
    }

    public ClearFileMetadataResult clear_file_metadata(ClearFileMetadataRequest clearFileMetadataRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ClearFileMetadataResult clearFileMetadataResult = client.getHiveClient().getThriftClient().clear_file_metadata(clearFileMetadataRequest);
            return clearFileMetadataResult;
        }
    }

    public CacheFileMetadataResult cache_file_metadata(CacheFileMetadataRequest cacheFileMetadataRequest) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            CacheFileMetadataResult cacheFileMetadataResult = client.getHiveClient().getThriftClient().cache_file_metadata(cacheFileMetadataRequest);
            return cacheFileMetadataResult;
        }
    }

    public String get_metastore_db_uuid() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            String string = client.getHiveClient().getThriftClient().get_metastore_db_uuid();
            return string;
        }
    }

    public WMCreateResourcePlanResponse create_resource_plan(WMCreateResourcePlanRequest wmCreateResourcePlanRequest) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMCreateResourcePlanResponse wMCreateResourcePlanResponse = client.getHiveClient().getThriftClient().create_resource_plan(wmCreateResourcePlanRequest);
            return wMCreateResourcePlanResponse;
        }
    }

    public WMGetResourcePlanResponse get_resource_plan(WMGetResourcePlanRequest wmGetResourcePlanRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMGetResourcePlanResponse wMGetResourcePlanResponse = client.getHiveClient().getThriftClient().get_resource_plan(wmGetResourcePlanRequest);
            return wMGetResourcePlanResponse;
        }
    }

    public WMGetActiveResourcePlanResponse get_active_resource_plan(WMGetActiveResourcePlanRequest wmGetActiveResourcePlanRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMGetActiveResourcePlanResponse wMGetActiveResourcePlanResponse = client.getHiveClient().getThriftClient().get_active_resource_plan(wmGetActiveResourcePlanRequest);
            return wMGetActiveResourcePlanResponse;
        }
    }

    public WMGetAllResourcePlanResponse get_all_resource_plans(WMGetAllResourcePlanRequest wmGetAllResourcePlanRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMGetAllResourcePlanResponse wMGetAllResourcePlanResponse = client.getHiveClient().getThriftClient().get_all_resource_plans(wmGetAllResourcePlanRequest);
            return wMGetAllResourcePlanResponse;
        }
    }

    public WMAlterResourcePlanResponse alter_resource_plan(WMAlterResourcePlanRequest wmAlterResourcePlanRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMAlterResourcePlanResponse wMAlterResourcePlanResponse = client.getHiveClient().getThriftClient().alter_resource_plan(wmAlterResourcePlanRequest);
            return wMAlterResourcePlanResponse;
        }
    }

    public WMValidateResourcePlanResponse validate_resource_plan(WMValidateResourcePlanRequest wmValidateResourcePlanRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMValidateResourcePlanResponse wMValidateResourcePlanResponse = client.getHiveClient().getThriftClient().validate_resource_plan(wmValidateResourcePlanRequest);
            return wMValidateResourcePlanResponse;
        }
    }

    public WMDropResourcePlanResponse drop_resource_plan(WMDropResourcePlanRequest wmDropResourcePlanRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMDropResourcePlanResponse wMDropResourcePlanResponse = client.getHiveClient().getThriftClient().drop_resource_plan(wmDropResourcePlanRequest);
            return wMDropResourcePlanResponse;
        }
    }

    public WMCreateTriggerResponse create_wm_trigger(WMCreateTriggerRequest wmCreateTriggerRequest) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMCreateTriggerResponse wMCreateTriggerResponse = client.getHiveClient().getThriftClient().create_wm_trigger(wmCreateTriggerRequest);
            return wMCreateTriggerResponse;
        }
    }

    public WMAlterTriggerResponse alter_wm_trigger(WMAlterTriggerRequest wmAlterTriggerRequest) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMAlterTriggerResponse wMAlterTriggerResponse = client.getHiveClient().getThriftClient().alter_wm_trigger(wmAlterTriggerRequest);
            return wMAlterTriggerResponse;
        }
    }

    public WMDropTriggerResponse drop_wm_trigger(WMDropTriggerRequest wmDropTriggerRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMDropTriggerResponse wMDropTriggerResponse = client.getHiveClient().getThriftClient().drop_wm_trigger(wmDropTriggerRequest);
            return wMDropTriggerResponse;
        }
    }

    public WMGetTriggersForResourePlanResponse get_triggers_for_resourceplan(WMGetTriggersForResourePlanRequest wmGetTriggersForResourePlanRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMGetTriggersForResourePlanResponse wMGetTriggersForResourePlanResponse = client.getHiveClient().getThriftClient().get_triggers_for_resourceplan(wmGetTriggersForResourePlanRequest);
            return wMGetTriggersForResourePlanResponse;
        }
    }

    public WMCreatePoolResponse create_wm_pool(WMCreatePoolRequest wmCreatePoolRequest) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMCreatePoolResponse wMCreatePoolResponse = client.getHiveClient().getThriftClient().create_wm_pool(wmCreatePoolRequest);
            return wMCreatePoolResponse;
        }
    }

    public WMAlterPoolResponse alter_wm_pool(WMAlterPoolRequest wmAlterPoolRequest) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMAlterPoolResponse wMAlterPoolResponse = client.getHiveClient().getThriftClient().alter_wm_pool(wmAlterPoolRequest);
            return wMAlterPoolResponse;
        }
    }

    public WMDropPoolResponse drop_wm_pool(WMDropPoolRequest wmDropPoolRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMDropPoolResponse wMDropPoolResponse = client.getHiveClient().getThriftClient().drop_wm_pool(wmDropPoolRequest);
            return wMDropPoolResponse;
        }
    }

    public WMCreateOrUpdateMappingResponse create_or_update_wm_mapping(WMCreateOrUpdateMappingRequest wmCreateOrUpdateMappingRequest) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMCreateOrUpdateMappingResponse wMCreateOrUpdateMappingResponse = client.getHiveClient().getThriftClient().create_or_update_wm_mapping(wmCreateOrUpdateMappingRequest);
            return wMCreateOrUpdateMappingResponse;
        }
    }

    public WMDropMappingResponse drop_wm_mapping(WMDropMappingRequest wmDropMappingRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMDropMappingResponse wMDropMappingResponse = client.getHiveClient().getThriftClient().drop_wm_mapping(wmDropMappingRequest);
            return wMDropMappingResponse;
        }
    }

    public WMCreateOrDropTriggerToPoolMappingResponse create_or_drop_wm_trigger_to_pool_mapping(WMCreateOrDropTriggerToPoolMappingRequest wmCreateOrDropTriggerToPoolMappingRequest) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            WMCreateOrDropTriggerToPoolMappingResponse wMCreateOrDropTriggerToPoolMappingResponse = client.getHiveClient().getThriftClient().create_or_drop_wm_trigger_to_pool_mapping(wmCreateOrDropTriggerToPoolMappingRequest);
            return wMCreateOrDropTriggerToPoolMappingResponse;
        }
    }

    public void create_ischema(ISchema iSchema) throws AlreadyExistsException, NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().create_ischema(iSchema);
        }
    }

    public void alter_ischema(AlterISchemaRequest alterISchemaRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().alter_ischema(alterISchemaRequest);
        }
    }

    public ISchema get_ischema(ISchemaName iSchemaName) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ISchema iSchema = client.getHiveClient().getThriftClient().get_ischema(iSchemaName);
            return iSchema;
        }
    }

    public void drop_ischema(ISchemaName iSchemaName) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_ischema(iSchemaName);
        }
    }

    public void add_schema_version(SchemaVersion schemaVersion) throws AlreadyExistsException, NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_schema_version(schemaVersion);
        }
    }

    public SchemaVersion get_schema_version(SchemaVersionDescriptor schemaVersionDescriptor) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            SchemaVersion schemaVersion = client.getHiveClient().getThriftClient().get_schema_version(schemaVersionDescriptor);
            return schemaVersion;
        }
    }

    public SchemaVersion get_schema_latest_version(ISchemaName iSchemaName) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            SchemaVersion schemaVersion = client.getHiveClient().getThriftClient().get_schema_latest_version(iSchemaName);
            return schemaVersion;
        }
    }

    public List<SchemaVersion> get_schema_all_versions(ISchemaName iSchemaName) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_schema_all_versions(iSchemaName);
            return list;
        }
    }

    public void drop_schema_version(SchemaVersionDescriptor schemaVersionDescriptor) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().drop_schema_version(schemaVersionDescriptor);
        }
    }

    public FindSchemasByColsResp get_schemas_by_cols(FindSchemasByColsRqst findSchemasByColsRqst) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            FindSchemasByColsResp findSchemasByColsResp = client.getHiveClient().getThriftClient().get_schemas_by_cols(findSchemasByColsRqst);
            return findSchemasByColsResp;
        }
    }

    public void map_schema_version_to_serde(MapSchemaVersionToSerdeRequest mapSchemaVersionToSerdeRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().map_schema_version_to_serde(mapSchemaVersionToSerdeRequest);
        }
    }

    public void set_schema_version_state(SetSchemaVersionStateRequest setSchemaVersionStateRequest) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().set_schema_version_state(setSchemaVersionStateRequest);
        }
    }

    public void add_serde(SerDeInfo serDeInfo) throws AlreadyExistsException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_serde(serDeInfo);
        }
    }

    public SerDeInfo get_serde(GetSerdeRequest getSerdeRequest) throws NoSuchObjectException, MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            SerDeInfo serDeInfo = client.getHiveClient().getThriftClient().get_serde(getSerdeRequest);
            return serDeInfo;
        }
    }

    public LockResponse get_lock_materialization_rebuild(String s, String s1, long l) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            LockResponse lockResponse = client.getHiveClient().getThriftClient().get_lock_materialization_rebuild(s, s1, l);
            return lockResponse;
        }
    }

    public boolean heartbeat_lock_materialization_rebuild(String s, String s1, long l) throws TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            boolean bl = client.getHiveClient().getThriftClient().heartbeat_lock_materialization_rebuild(s, s1, l);
            return bl;
        }
    }

    public void add_runtime_stats(RuntimeStat runtimeStat) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_runtime_stats(runtimeStat);
        }
    }

    public List<RuntimeStat> get_runtime_stats(GetRuntimeStatsRequest getRuntimeStatsRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_runtime_stats(getRuntimeStatsRequest);
            return list;
        }
    }

    public ScheduledQueryPollResponse scheduled_query_poll(ScheduledQueryPollRequest scheduledQueryPollRequest) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ScheduledQueryPollResponse scheduledQueryPollResponse = client.getHiveClient().getThriftClient().scheduled_query_poll(scheduledQueryPollRequest);
            return scheduledQueryPollResponse;
        }
    }

    public void scheduled_query_maintenance(ScheduledQueryMaintenanceRequest scheduledQueryMaintenanceRequest) throws MetaException, NoSuchObjectException, AlreadyExistsException, InvalidInputException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().scheduled_query_maintenance(scheduledQueryMaintenanceRequest);
        }
    }

    public void scheduled_query_progress(ScheduledQueryProgressInfo scheduledQueryProgressInfo) throws MetaException, InvalidOperationException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().scheduled_query_progress(scheduledQueryProgressInfo);
        }
    }

    public ScheduledQuery get_scheduled_query(ScheduledQueryKey scheduledQueryKey) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ScheduledQuery scheduledQuery = client.getHiveClient().getThriftClient().get_scheduled_query(scheduledQueryKey);
            return scheduledQuery;
        }
    }

    public void add_replication_metrics(ReplicationMetricList replicationMetricList) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            client.getHiveClient().getThriftClient().add_replication_metrics(replicationMetricList);
        }
    }

    public ReplicationMetricList get_replication_metrics(GetReplicationMetricsRequest getReplicationMetricsRequest) throws MetaException, NoSuchObjectException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ReplicationMetricList replicationMetricList = client.getHiveClient().getThriftClient().get_replication_metrics(getReplicationMetricsRequest);
            return replicationMetricList;
        }
    }

    public long get_latest_txnid_in_conflict(long txnId) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            long l = client.getHiveClient().getThriftClient().get_latest_txnid_in_conflict(txnId);
            return l;
        }
    }

    public String getName() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getName"));
    }

    public String getVersion() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getVersion"));
    }

    public fb_status getStatus() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getStatus"));
    }

    public String getStatusDetails() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getStatusDetails"));
    }

    public Map<String, Long> getCounters() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getCounters"));
    }

    public long getCounter(String s) throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getCounter"));
    }

    public void setOption(String s, String s1) throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "setOption"));
    }

    public String getOption(String s) throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getOption"));
    }

    public Map<String, String> getOptions() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getOptions"));
    }

    public String getCpuProfile(int i) throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "getCpuProfile"));
    }

    public long aliveSince() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "aliveSince"));
    }

    public void reinitialize() throws TException {
        throw new UnsupportedOperationException(String.format(NOT_IMPLEMENTED_UNSUPPORTED, "reinitialize"));
    }

    public void shutdown() throws TException {
    }

    public List<WriteEventInfo> get_all_write_event_info(GetAllWriteEventInfoRequest request) throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            List list = client.getHiveClient().getThriftClient().get_all_write_event_info(request);
            return list;
        }
    }

    private long getCurrentEventId(MetaStoreClientPool.MetaStoreClient msClient) throws TException {
        return msClient.getHiveClient().getCurrentNotificationEventId().getEventId();
    }

    private void invalidateNonTransactionalTableIfExists(String dbNameWithCatalog, String tableName, String apiName) throws MetaException {
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            LOG.debug("Skipping invalidation of table {}.{} due to metastore api {} because sync to latest event id is set to true", new Object[]{dbNameWithCatalog, tableName, apiName});
            return;
        }
        if (!BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs() || !BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
            LOG.debug("Skipping invalidation of table {}.{} due to metastore api {} because invalidate hms cache of ddl flag is set to false ", new Object[]{dbNameWithCatalog, tableName, apiName});
            return;
        }
        String dbName = dbNameWithCatalog;
        try {
            dbName = MetaStoreUtils.parseDbName((String)dbNameWithCatalog, (Configuration)this.serverConf_)[1];
        }
        catch (MetaException ex) {
            LOG.error("Successfully executed HMS api: {} but encountered error when trying to invalidate table {}.{} from cache with error message: {}", new Object[]{apiName, dbNameWithCatalog, tableName, ex.getMessage()});
            throw ex;
        }
        Table catalogTbl = null;
        try {
            catalogTbl = this.catalog_.getTable(dbName, tableName);
        }
        catch (DatabaseNotFoundException ex) {
            LOG.debug(ex.getMessage());
            return;
        }
        if (catalogTbl == null) {
            LOG.debug("{}.{} does not exist", (Object)dbName, (Object)tableName);
            return;
        }
        if (catalogTbl instanceof IncompleteTable) {
            LOG.debug("table {} is already incomplete, not invalidating it due to hms api: {}", (Object)catalogTbl.getFullName(), (Object)apiName);
            return;
        }
        Map tblProperties = catalogTbl.getMetaStoreTable().getParameters();
        if (tblProperties == null || AcidUtils.isTransactionalTable(tblProperties)) {
            LOG.debug("Table {} is transactional. Not removing it from catalogd cache", (Object)catalogTbl.getFullName());
            return;
        }
        LOG.debug("Invalidating non transactional table {} due to metastore api {}", (Object)catalogTbl.getFullName(), (Object)apiName);
        Table invalidatedCatalogTbl = this.catalog_.invalidateTableIfExists(dbName, tableName);
        if (invalidatedCatalogTbl != null) {
            LOG.info("Invalidated non transactional table {} from catalogd cache due to HMS api: {}", (Object)catalogTbl.getFullName(), (Object)apiName);
        }
    }

    protected void dropTableIfExists(long beforeDropEventId, String dbNameWithCatalog, String tableName, String apiName) throws MetaException {
        String[] catAndDbName = MetaStoreUtils.parseDbName((String)dbNameWithCatalog, (Configuration)this.serverConf_);
        String catName = catAndDbName[0];
        String dbName = catAndDbName[1];
        try {
            List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForTable(this.catalog_, beforeDropEventId, catName, dbName, tableName, "DROP_TABLE");
            if (events.isEmpty()) {
                throw new MetaException("Drop table event not received. Check if notification events are configured in hive metastore");
            }
            Preconditions.checkState((events.size() == 1 ? 1 : 0) != 0, (String)"Expected drop_table event count to be 1 for table %s", (Object)tableName);
            long dropEventId = events.get(0).getEventId();
            Reference<Boolean> tblAddedLater = new Reference<Boolean>();
            boolean removedTbl = this.catalogOpExecutor_.removeTableIfNotAddedLater(dropEventId, dbName, tableName, tblAddedLater);
            if (removedTbl) {
                LOG.info("Removed non transactional table {}.{} from catalogd cache due to metastore api: {}", new Object[]{dbName, tableName, apiName});
                this.catalogOpExecutor_.addToDeleteEventLog(events);
            }
        }
        catch (Exception e) {
            String msg = "Unable to process the DROP table event for table " + dbName + "." + tableName;
            LOG.error(msg, (Throwable)e);
            throw new MetaException(msg);
        }
    }

    private void renameNonTransactionalTableIfExists(String oldDbNameWithCatalog, String oldTableName, String newDbNameWithCatalog, String newTableName, String apiName) throws MetaException {
        String newDbName;
        String oldDbName;
        if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            LOG.debug("Skipping rename of table {}.{} due to metastore api {} because sync to latest event id is set to true", new Object[]{oldDbNameWithCatalog, oldTableName, apiName});
            return;
        }
        if (!BackendConfig.INSTANCE.invalidateCatalogdHMSCacheOnDDLs() || !BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
            LOG.debug("Skipping rename of table {}.{} due to metastore api {} because invalidate hms cache of ddl flag is set to false ", new Object[]{oldDbNameWithCatalog, oldTableName, apiName});
            return;
        }
        String toParse = null;
        try {
            toParse = oldDbNameWithCatalog;
            oldDbName = MetaStoreUtils.parseDbName((String)toParse, (Configuration)this.serverConf_)[1];
            toParse = newDbNameWithCatalog;
            newDbName = MetaStoreUtils.parseDbName((String)toParse, (Configuration)this.serverConf_)[1];
        }
        catch (MetaException ex) {
            LOG.error("Successfully executed metastore api: {} but encountered error when parsing dbName {}with error message: {}", new Object[]{apiName, toParse, ex.getMessage()});
            throw ex;
        }
        TTableName oldTable = new TTableName(oldDbName, oldTableName);
        TTableName newTable = new TTableName(newDbName, newTableName);
        String tableInfo = "old table " + oldDbName + "." + oldTableName + " to new table " + newDbName + "." + newTableName;
        LOG.debug("Renaming " + tableInfo);
        Pair<Table, Table> result = this.catalog_.renameTable(oldTable, newTable, -1L);
        if (result == null || result.first == null || result.second == null) {
            LOG.debug("Couldn't rename " + tableInfo);
        } else {
            LOG.info("Successfully renamed " + tableInfo);
        }
    }

    protected void dropDbIfExists(String databaseName, boolean ignoreUnknownDb, long beforeDropEventId, String apiName) throws MetaException {
        String[] catAndDbName = MetaStoreUtils.parseDbName((String)databaseName, (Configuration)this.serverConf_);
        String catName = catAndDbName[0];
        String dbName = catAndDbName[1];
        try {
            List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForDb(this.catalog_, beforeDropEventId, catName, dbName, "DROP_DATABASE");
            if (events.size() == 0) {
                if (ignoreUnknownDb) {
                    LOG.debug("db {} does not exist in metastore. Removing it from catalog if exists ", (Object)dbName);
                    if (this.catalog_.removeDb(dbName) != null) {
                        LOG.info("Db {} not known to metastore, removed it from catalog", (Object)dbName);
                    }
                    return;
                }
                throw new MetaException(String.format("Drop database event not received for db: %s from event id: %s. Check if notification events are configured in hive metastore", dbName, beforeDropEventId));
            }
            Preconditions.checkState((events.size() == 1 ? 1 : 0) != 0, (String)"Expected drop_database count to be 1 for db %s from event id %s", (Object)databaseName, (long)beforeDropEventId);
            long dropEventId = events.get(0).getEventId();
            boolean isRemoved = this.catalogOpExecutor_.removeDbIfNotAddedLater(dropEventId, dbName);
            if (isRemoved) {
                LOG.info("Removed database: " + databaseName + " from cache due to metastore api: {}", (Object)apiName);
                this.catalogOpExecutor_.addToDeleteEventLog(events);
            }
        }
        catch (Exception e) {
            String errorMsg = "Unable to process drop database event for db: " + databaseName + " for metastore api: " + apiName;
            LOG.error(errorMsg, (Throwable)e);
            throw new MetaException(errorMsg);
        }
    }

    private void initMetrics() {
        this.metastoreEventsMetrics_.addTimer("events-fetch-duration");
        this.metastoreEventsMetrics_.addTimer("events-apply-duration");
        this.metastoreEventsMetrics_.addMeter("events-received");
        this.metastoreEventsMetrics_.addCounter("events-skipped");
        this.metastoreEventsMetrics_.addCounter("tables-refreshed");
        this.metastoreEventsMetrics_.addCounter("partitions-refreshed");
        this.metastoreEventsMetrics_.addCounter("tables-added");
        this.metastoreEventsMetrics_.addCounter("tables-removed");
        this.metastoreEventsMetrics_.addCounter("databases-added");
        this.metastoreEventsMetrics_.addCounter("databases-removed");
        this.metastoreEventsMetrics_.addCounter("partitions-added");
        this.metastoreEventsMetrics_.addCounter("partitions-removed");
    }
}

