/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.AlterTableRequest;
import org.apache.hadoop.hive.metastore.api.AlterTableResponse;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsResult;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.RenamePartitionRequest;
import org.apache.hadoop.hive.metastore.api.RenamePartitionResponse;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.TruncateTableRequest;
import org.apache.hadoop.hive.metastore.api.TruncateTableResponse;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogHmsAPIHelper;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.events.DeleteEventLog;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.metastore.HmsApiNameEnum;
import org.apache.impala.catalog.metastore.MetastoreServiceHandler;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogMetastoreServiceHandler
extends MetastoreServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogMetastoreServiceHandler.class);
    private final String SYNC_TABLE_LATEST_EVENT_ID_ERR_MSG = "Failed to sync table %s to latest event id while executing %s";
    private final String SYNC_DB_LATEST_EVENT_ID_ERR_MSG = "Failed to sync db %s to latest event id while executing %s";

    public CatalogMetastoreServiceHandler(CatalogOpExecutor catalogOpExecutor, boolean fallBackToHMSOnErrors) {
        super(catalogOpExecutor, fallBackToHMSOnErrors);
    }

    @Override
    public GetTableResult get_table_req(GetTableRequest getTableRequest) throws MetaException, NoSuchObjectException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
            return super.get_table_req(getTableRequest);
        }
        try {
            LOG.trace("Received get_Table_req for {}. File metadata is {}", (Object)getTableRequest.getTblName(), (Object)getTableRequest.isGetFileMetadata());
            return CatalogHmsAPIHelper.getTableReq(this.catalog_, this.defaultCatalogName_, getTableRequest);
        }
        catch (Exception e) {
            this.throwIfNoFallback(e, "get_table_req");
            return super.get_table_req(getTableRequest);
        }
    }

    @Override
    public PartitionsByExprResult get_partitions_by_expr(PartitionsByExprRequest partitionsByExprRequest) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
            return super.get_partitions_by_expr(partitionsByExprRequest);
        }
        try {
            if (this.expressionProxy_ != null) {
                return CatalogHmsAPIHelper.getPartitionsByExpr(this.catalog_, this.defaultCatalogName_, partitionsByExprRequest, this.expressionProxy_);
            }
            throw new CatalogException("PartitionExpressionProxy could not be initialized");
        }
        catch (Exception e) {
            this.throwIfNoFallback(e, HmsApiNameEnum.GET_PARTITION_BY_EXPR.apiName());
            String tblName = partitionsByExprRequest.getDbName() + "." + partitionsByExprRequest.getTblName();
            LOG.info(String.format("Forwarding the request %s for table %s to the backing HiveMetastore service", HmsApiNameEnum.GET_PARTITION_BY_EXPR.apiName(), tblName));
            return super.get_partitions_by_expr(partitionsByExprRequest);
        }
    }

    @Override
    public GetPartitionsByNamesResult get_partitions_by_names_req(GetPartitionsByNamesRequest getPartitionsByNamesRequest) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache()) {
            return super.get_partitions_by_names_req(getPartitionsByNamesRequest);
        }
        try {
            return CatalogHmsAPIHelper.getPartitionsByNames(this.catalog_, this.serverConf_, getPartitionsByNamesRequest);
        }
        catch (Exception ex) {
            this.throwIfNoFallback(ex, HmsApiNameEnum.GET_PARTITION_BY_NAMES.apiName());
            String tblName = getPartitionsByNamesRequest.getDb_name() + "." + getPartitionsByNamesRequest.getTbl_name();
            LOG.info(String.format("Forwarding the request %s for table %s to the backing HiveMetastore service", new Object[]{HmsApiNameEnum.GET_PARTITION_BY_NAMES, tblName}));
            return super.get_partitions_by_names_req(getPartitionsByNamesRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create_database(Database msDb) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.create_database(msDb);
            return;
        }
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        String dbName = msDb.getName();
        String apiName = HmsApiNameEnum.CREATE_DATABASE.apiName();
        Db db = null;
        long fromEventId = -1L;
        try {
            block10: {
                try {
                    fromEventId = super.get_current_notificationEventId().getEventId();
                    super.create_database(msDb);
                }
                catch (Exception e) {
                    LOG.error("Caught exception when creating database {} in hms", (Object)dbName);
                    if (!(e instanceof AlreadyExistsException)) {
                        throw e;
                    }
                    if (this.catalog_.getDb(dbName) == null) break block10;
                    LOG.error("can not create database {} as it already exists in metastore and catalog", (Object)dbName);
                    throw e;
                }
            }
            List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForDb(this.catalog_, fromEventId, dbName, "CREATE_DATABASE");
            Preconditions.checkArgument((events.size() == 1 ? 1 : 0) != 0, (String)"Db %s was recreated in metastore while the current db creation was in progress", (Object)dbName);
            long createEventId = events.get(0).getEventId();
            this.catalog_.addDb(dbName, msDb, createEventId);
            LOG.info("Created database {} with create event id: {}", (Object)dbName, (Object)createEventId);
            db = this.getDbAndAcquireLock(dbName, apiName);
            this.syncToLatestEventId(db, apiName);
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
            if (db != null && db.isLockHeldByCurrentThread()) {
                db.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop_database(String databaseName, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.drop_database(databaseName, deleteData, cascade);
            return;
        }
        String apiName = HmsApiNameEnum.DROP_DATABASE.apiName();
        String dbName = MetaStoreUtils.parseDbName((String)databaseName, (Configuration)this.serverConf_)[1];
        long currentEventId = -1L;
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try {
            try {
                currentEventId = super.get_current_notificationEventId().getEventId();
                super.drop_database(databaseName, deleteData, cascade);
            }
            catch (NoSuchObjectException e) {
                if (this.catalog_.removeDb(dbName) != null) {
                    LOG.info("Db {} not known to metastore, removed it from catalog for metastore api {}", (Object)dbName, (Object)apiName);
                }
                throw e;
            }
            this.dropDbIfExists(databaseName, false, currentEventId, apiName);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop_database_req(DropDatabaseRequest dropDatabaseRequest) throws NoSuchObjectException, InvalidOperationException, MetaException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.drop_database_req(dropDatabaseRequest);
            return;
        }
        String apiName = HmsApiNameEnum.DROP_DATABASE_REQ.apiName();
        String dbName = MetaStoreUtils.parseDbName((String)dropDatabaseRequest.getName(), (Configuration)this.serverConf_)[1];
        long currentEventId = -1L;
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try {
            try {
                currentEventId = super.get_current_notificationEventId().getEventId();
                super.drop_database_req(dropDatabaseRequest);
            }
            catch (NoSuchObjectException e) {
                if (this.catalog_.removeDb(dbName) != null) {
                    LOG.info("Db {} not known to metastore, removed it from catalog for metastore api {}", (Object)dbName, (Object)apiName);
                }
                throw e;
            }
            catch (InvalidOperationException | MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
            this.dropDbIfExists(dropDatabaseRequest.getName(), dropDatabaseRequest.isIgnoreUnknownDb(), currentEventId, apiName);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_database(String databaseName, Database database) throws MetaException, NoSuchObjectException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_database(databaseName, database);
            return;
        }
        String dbname = MetaStoreUtils.parseDbName((String)databaseName, (Configuration)this.serverConf_)[1];
        String apiName = HmsApiNameEnum.ALTER_DATABASE.apiName();
        Db db = this.getDbAndAcquireLock(dbname, apiName);
        this.catalog_.getLock().writeLock().unlock();
        try {
            super.alter_database(dbname, database);
            this.syncToLatestEventId(db, apiName);
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            if (db != null && db.isLockHeldByCurrentThread()) {
                db.getLock().unlock();
            }
        }
    }

    @Override
    public void create_table(final org.apache.hadoop.hive.metastore.api.Table table) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.create_table(table);
            return;
        }
        CreateTableTask<Void> task = new CreateTableTask<Void>(){

            @Override
            public Void execute() throws TException {
                CatalogMetastoreServiceHandler.super.create_table(table);
                return null;
            }
        };
        String apiName = HmsApiNameEnum.CREATE_TABLE.apiName();
        this.createTableCore(apiName, table.getDbName(), table.getTableName(), MetadataOp.getImpalaTableType(table.getTableType()), task);
    }

    @Override
    public void create_table_req(final CreateTableRequest req) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.create_table_req(req);
            return;
        }
        CreateTableTask<Void> task = new CreateTableTask<Void>(){

            @Override
            public Void execute() throws TException {
                CatalogMetastoreServiceHandler.super.create_table_req(req);
                return null;
            }
        };
        String apiName = HmsApiNameEnum.CREATE_TABLE_REQ.apiName();
        org.apache.hadoop.hive.metastore.api.Table table = req.getTable();
        this.createTableCore(apiName, table.getDbName(), table.getTableName(), MetadataOp.getImpalaTableType(table.getTableType()), task);
    }

    @Override
    public void create_table_with_constraints(final org.apache.hadoop.hive.metastore.api.Table table, final List<SQLPrimaryKey> sqlPrimaryKeys, final List<SQLForeignKey> sqlForeignKeys, final List<SQLUniqueConstraint> sqlUniqueConstraints, final List<SQLNotNullConstraint> sqlNotNullConstraints, final List<SQLDefaultConstraint> sqlDefaultConstraints, final List<SQLCheckConstraint> sqlCheckConstraints) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.create_table_with_constraints(table, sqlPrimaryKeys, sqlForeignKeys, sqlUniqueConstraints, sqlNotNullConstraints, sqlDefaultConstraints, sqlCheckConstraints);
            return;
        }
        CreateTableTask<Void> task = new CreateTableTask<Void>(){

            @Override
            public Void execute() throws TException {
                CatalogMetastoreServiceHandler.super.create_table_with_constraints(table, sqlPrimaryKeys, sqlForeignKeys, sqlUniqueConstraints, sqlNotNullConstraints, sqlDefaultConstraints, sqlCheckConstraints);
                return null;
            }
        };
        String apiName = HmsApiNameEnum.CREATE_TABLE_WITH_CONSTRAINTS.apiName();
        this.createTableCore(apiName, table.getDbName(), table.getTableName(), MetadataOp.getImpalaTableType(table.getTableType()), task);
    }

    @Override
    public void create_table_with_environment_context(final org.apache.hadoop.hive.metastore.api.Table table, final EnvironmentContext environmentContext) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.create_table_with_environment_context(table, environmentContext);
            return;
        }
        CreateTableTask<Void> task = new CreateTableTask<Void>(){

            @Override
            public Void execute() throws TException {
                CatalogMetastoreServiceHandler.super.create_table_with_environment_context(table, environmentContext);
                return null;
            }
        };
        String apiName = HmsApiNameEnum.CREATE_TABLE_WITH_ENVIRONMENT_CONTEXT.apiName();
        this.createTableCore(apiName, table.getDbName(), table.getTableName(), MetadataOp.getImpalaTableType(table.getTableType()), task);
    }

    @Override
    public void alter_table(final String dbname, final String tblName, final org.apache.hadoop.hive.metastore.api.Table newTable) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_table(dbname, tblName, newTable);
            return;
        }
        AlterTableTask<Void> task = new AlterTableTask<Void>(){

            @Override
            public Void execute() throws InvalidOperationException, MetaException, TException {
                CatalogMetastoreServiceHandler.super.alter_table(dbname, tblName, newTable);
                return null;
            }
        };
        String apiName = HmsApiNameEnum.ALTER_TABLE.apiName();
        this.alterTableCore(dbname, tblName, newTable, apiName, task);
    }

    @Override
    public void alter_table_with_environment_context(final String dbname, final String tblName, final org.apache.hadoop.hive.metastore.api.Table table, final EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_table_with_environment_context(dbname, tblName, table, envContext);
            return;
        }
        String apiName = HmsApiNameEnum.ALTER_PARTITION_WITH_ENVIRONMENT_CONTEXT.apiName();
        AlterTableTask<Void> task = new AlterTableTask<Void>(){

            @Override
            public Void execute() throws InvalidOperationException, MetaException, TException {
                CatalogMetastoreServiceHandler.super.alter_table_with_environment_context(dbname, tblName, table, envContext);
                return null;
            }
        };
        this.alterTableCore(dbname, tblName, table, apiName, task);
    }

    @Override
    public void alter_table_with_cascade(final String dbname, final String tblName, final org.apache.hadoop.hive.metastore.api.Table table, final boolean cascade) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_table_with_cascade(dbname, tblName, table, cascade);
            return;
        }
        String apiName = HmsApiNameEnum.ALTER_TABLE_WITH_CASCADE.apiName();
        AlterTableTask<Void> task = new AlterTableTask<Void>(){

            @Override
            public Void execute() throws InvalidOperationException, MetaException, TException {
                CatalogMetastoreServiceHandler.super.alter_table_with_cascade(dbname, tblName, table, cascade);
                return null;
            }
        };
        this.alterTableCore(dbname, tblName, table, apiName, task);
    }

    @Override
    public AlterTableResponse alter_table_req(final AlterTableRequest alterTableRequest) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.alter_table_req(alterTableRequest);
        }
        String apiName = HmsApiNameEnum.ALTER_TABLE_REQ.apiName();
        String dbname = alterTableRequest.getDbName();
        String tblName = alterTableRequest.getTableName();
        org.apache.hadoop.hive.metastore.api.Table newTable = alterTableRequest.getTable();
        AlterTableTask<AlterTableResponse> task = new AlterTableTask<AlterTableResponse>(){

            @Override
            public AlterTableResponse execute() throws InvalidOperationException, MetaException, TException {
                AlterTableResponse resp = CatalogMetastoreServiceHandler.super.alter_table_req(alterTableRequest);
                return resp;
            }
        };
        return this.alterTableCore(dbname, tblName, newTable, apiName, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.add_partition(partition);
        }
        String apiName = HmsApiNameEnum.ADD_PARTITION.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(partition.getDbName(), partition.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        Partition addedPartition = super.add_partition(partition);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return addedPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition add_partition_with_environment_context(Partition partition, EnvironmentContext environmentContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.add_partition_with_environment_context(partition, environmentContext);
        }
        String apiName = HmsApiNameEnum.ADD_PARTITION_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(partition.getDbName(), partition.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        Partition addedPartition = super.add_partition_with_environment_context(partition, environmentContext);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return addedPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add_partitions(List<Partition> partitionList) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls() || partitionList.isEmpty()) {
            return super.add_partitions(partitionList);
        }
        String apiName = HmsApiNameEnum.ADD_PARTITIONS.apiName();
        Partition partition = partitionList.get(0);
        Table tbl = this.getTableAndAcquireWriteLock(partition.getDbName(), partition.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        int numPartitionsAdded = super.add_partitions(partitionList);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return numPartitionsAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add_partitions_pspec(List<PartitionSpec> list) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls() || list.isEmpty()) {
            return super.add_partitions_pspec(list);
        }
        String apiName = HmsApiNameEnum.ADD_PARTITIONS_PSPEC.apiName();
        PartitionSpec spec = list.get(0);
        Table tbl = this.getTableAndAcquireWriteLock(spec.getDbName(), spec.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        int numPartitionsAdded = super.add_partitions_pspec(list);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return numPartitionsAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddPartitionsResult add_partitions_req(AddPartitionsRequest request) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.add_partitions_req(request);
        }
        String apiName = HmsApiNameEnum.ADD_PARTITIONS_REQ.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(request.getDbName(), request.getTblName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        AddPartitionsResult result = super.add_partitions_req(request);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition append_partition(String dbname, String tblName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.append_partition(dbname, tblName, partVals);
        }
        String apiName = HmsApiNameEnum.APPEND_PARTITION.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbname, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        Partition partition = super.append_partition(dbname, tblName, partVals);
        LOG.debug("Successfully executed HMS API: append_partition");
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition append_partition_with_environment_context(String dbName, String tblName, List<String> partVals, EnvironmentContext environmentContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.append_partition_with_environment_context(dbName, tblName, partVals, environmentContext);
        }
        String apiName = HmsApiNameEnum.APPEND_PARTITION_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        Partition partition = super.append_partition_with_environment_context(dbName, tblName, partVals, environmentContext);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition append_partition_by_name(String dbName, String tblName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.append_partition_by_name(dbName, tblName, partName);
        }
        String apiName = HmsApiNameEnum.APPEND_PARTITION_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        Partition partition = super.append_partition_by_name(dbName, tblName, partName);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition append_partition_by_name_with_environment_context(String dbName, String tblName, String partName, EnvironmentContext context) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.append_partition_by_name_with_environment_context(dbName, tblName, partName, context);
        }
        String apiName = HmsApiNameEnum.APPEND_PARTITION_BY_NAME_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        Partition partition = super.append_partition_by_name_with_environment_context(dbName, tblName, partName, context);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop_partition(String dbname, String tblname, List<String> partVals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.drop_partition(dbname, tblname, partVals, deleteData);
        }
        String apiName = HmsApiNameEnum.DROP_PARTITION.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbname, tblname, apiName);
        this.catalog_.getLock().writeLock().unlock();
        boolean resp = super.drop_partition(dbname, tblname, partVals, deleteData);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop_partition_by_name(String dbname, String tblname, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.drop_partition_by_name(dbname, tblname, partName, deleteData);
        }
        String apiName = HmsApiNameEnum.DROP_PARTITION_BY_NAME.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbname, tblname, apiName);
        this.catalog_.getLock().writeLock().unlock();
        boolean response = super.drop_partition_by_name(dbname, tblname, partName, deleteData);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop_partition_with_environment_context(String dbname, String tblname, List<String> partNames, boolean deleteData, EnvironmentContext environmentContext) throws NoSuchObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.drop_partition_with_environment_context(dbname, tblname, partNames, deleteData, environmentContext);
        }
        String apiName = HmsApiNameEnum.DROP_PARTITION_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbname, tblname, apiName);
        this.catalog_.getLock().writeLock().unlock();
        boolean resp = super.drop_partition_with_environment_context(dbname, tblname, partNames, deleteData, environmentContext);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop_partition_by_name_with_environment_context(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
        }
        String apiName = HmsApiNameEnum.DROP_PARTITION_BY_NAME_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tableName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        boolean resp = super.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DropPartitionsResult drop_partitions_req(DropPartitionsRequest request) throws NoSuchObjectException, MetaException, TException {
        String dbName = request.getDbName();
        String tableName = request.getTblName();
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.drop_partitions_req(request);
        }
        String apiName = HmsApiNameEnum.DROP_PARTITIONS_REQ.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tableName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        DropPartitionsResult result = super.drop_partitions_req(request);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition exchange_partition(Map<String, String> partitionSpecMap, String sourceDbWithCatalog, String sourceTbl, String destDbWithCatalog, String destTbl) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.exchange_partition(partitionSpecMap, sourceDbWithCatalog, sourceTbl, destDbWithCatalog, destTbl);
        }
        String apiName = HmsApiNameEnum.EXCHANGE_PARTITION.apiName();
        Table srcTbl = null;
        Table destinationTbl = null;
        Partition exchangedPartition = null;
        try {
            String sourceDb = MetaStoreUtils.parseDbName((String)sourceDbWithCatalog, (Configuration)this.serverConf_)[1];
            String destDb = MetaStoreUtils.parseDbName((String)destDbWithCatalog, (Configuration)this.serverConf_)[1];
            NoOpEventSequence catalogTimeline = NoOpEventSequence.INSTANCE;
            srcTbl = this.catalogOpExecutor_.getExistingTable(sourceDb, sourceTbl, apiName, catalogTimeline);
            destinationTbl = this.catalogOpExecutor_.getExistingTable(destDb, destTbl, apiName, catalogTimeline);
            if (!this.catalog_.tryWriteLock(new Table[]{srcTbl, destinationTbl})) {
                throw new CatalogException("Couldn't acquire lock on tables: " + srcTbl.getFullName() + ", " + destinationTbl.getFullName());
            }
            exchangedPartition = super.exchange_partition(partitionSpecMap, sourceDbWithCatalog, sourceTbl, destDbWithCatalog, destTbl);
            this.syncToLatestEventId(srcTbl, apiName);
            this.syncToLatestEventId(destinationTbl, apiName);
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            if (srcTbl != null && srcTbl.isWriteLockedByCurrentThread()) {
                srcTbl.releaseWriteLock();
            }
            if (destinationTbl != null && destinationTbl.isWriteLockedByCurrentThread()) {
                destinationTbl.releaseWriteLock();
            }
        }
        return exchangedPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDbWithCatalog, String sourceTbl, String destDbWithCatalog, String destTbl) throws TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.exchange_partitions(partitionSpecs, sourceDbWithCatalog, sourceTbl, destDbWithCatalog, destTbl);
        }
        String apiName = HmsApiNameEnum.EXCHANGE_PARTITIONS.apiName();
        Table srcTbl = null;
        Table destinationTbl = null;
        List<Partition> exchangedPartitions = null;
        try {
            String sourceDb = MetaStoreUtils.parseDbName((String)sourceDbWithCatalog, (Configuration)this.serverConf_)[1];
            String destDb = MetaStoreUtils.parseDbName((String)destDbWithCatalog, (Configuration)this.serverConf_)[1];
            NoOpEventSequence catalogTimeline = NoOpEventSequence.INSTANCE;
            srcTbl = this.catalogOpExecutor_.getExistingTable(sourceDb, sourceTbl, apiName, catalogTimeline);
            destinationTbl = this.catalogOpExecutor_.getExistingTable(destDb, destTbl, apiName, catalogTimeline);
            if (!this.catalog_.tryWriteLock(new Table[]{srcTbl, destinationTbl})) {
                throw new CatalogException("Couldn't acquire lock on tables: " + srcTbl.getFullName() + ", " + destinationTbl.getFullName());
            }
            exchangedPartitions = super.exchange_partitions(partitionSpecs, sourceDbWithCatalog, sourceTbl, destDbWithCatalog, destTbl);
            this.syncToLatestEventId(srcTbl, apiName);
            this.syncToLatestEventId(destinationTbl, apiName);
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            if (srcTbl != null && srcTbl.isWriteLockedByCurrentThread()) {
                srcTbl.releaseWriteLock();
            }
            if (destinationTbl != null && destinationTbl.isWriteLockedByCurrentThread()) {
                destinationTbl.releaseWriteLock();
            }
        }
        return exchangedPartitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_partition(String dbName, String tblName, Partition partition) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_partition(dbName, tblName, partition);
            return;
        }
        String apiName = HmsApiNameEnum.ALTER_PARTITION.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        super.alter_partition(dbName, tblName, partition);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_partitions(String dbName, String tblName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_partitions(dbName, tblName, partitions);
            return;
        }
        String apiName = HmsApiNameEnum.ALTER_PARTITIONS.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        super.alter_partitions(dbName, tblName, partitions);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_partitions_with_environment_context(String dbName, String tblName, List<Partition> list, EnvironmentContext context) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_partitions_with_environment_context(dbName, tblName, list, context);
            return;
        }
        String apiName = HmsApiNameEnum.ALTER_PARTITIONS_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        super.alter_partitions_with_environment_context(dbName, tblName, list, context);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlterPartitionsResponse alter_partitions_req(AlterPartitionsRequest alterPartitionsRequest) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.alter_partitions_req(alterPartitionsRequest);
        }
        String apiName = HmsApiNameEnum.ALTER_PARTITIONS_REQ.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(alterPartitionsRequest.getDbName(), alterPartitionsRequest.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        AlterPartitionsResponse response = super.alter_partitions_req(alterPartitionsRequest);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_partition_with_environment_context(String dbName, String tblName, Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.alter_partition_with_environment_context(dbName, tblName, partition, environmentContext);
            return;
        }
        String apiName = HmsApiNameEnum.ALTER_PARTITION_WITH_ENVIRONMENT_CONTEXT.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        super.alter_partition_with_environment_context(dbName, tblName, partition, environmentContext);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename_partition(String dbName, String tblName, List<String> list, Partition partition) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.rename_partition(dbName, tblName, list, partition);
            return;
        }
        String apiName = HmsApiNameEnum.RENAME_PARTITION.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        super.rename_partition(dbName, tblName, list, partition);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenamePartitionResponse rename_partition_req(RenamePartitionRequest request) throws InvalidOperationException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.rename_partition_req(request);
        }
        String apiName = HmsApiNameEnum.RENAME_PARTITION_REQ.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(request.getDbName(), request.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        RenamePartitionResponse response = super.rename_partition_req(request);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop_table(String dbname, String tblname, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.drop_table(dbname, tblname, deleteData);
            return;
        }
        Object tbl = null;
        String apiName = HmsApiNameEnum.DROP_TABLE.apiName();
        long currentEventId = -1L;
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try {
            try {
                currentEventId = super.get_current_notificationEventId().getEventId();
                super.drop_table(dbname, tblname, deleteData);
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Table {}.{} does not exist in metastore, removing it from catalog if exists", (Object)dbname, (Object)tblname);
                if (this.catalog_.removeTable(dbname, tblname) != null) {
                    LOG.info("Table {}.{} does not exist in metastore, removed from catalog as well", (Object)dbname, (Object)tblname);
                }
                throw e;
            }
            this.dropTableIfExists(currentEventId, dbname, tblname, apiName);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop_table_with_environment_context(String dbname, String tblname, boolean deleteData, EnvironmentContext environmentContext) throws NoSuchObjectException, MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.drop_table_with_environment_context(dbname, tblname, deleteData, environmentContext);
            return;
        }
        Object tbl = null;
        String apiName = HmsApiNameEnum.DROP_TABLE_WITH_ENVIRONMENT_CONTEXT.apiName();
        long currentEventId = -1L;
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        try {
            try {
                currentEventId = super.get_current_notificationEventId().getEventId();
                super.drop_table_with_environment_context(dbname, tblname, deleteData, environmentContext);
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Table {}.{} does not exist in metastore, removing it from catalog if exists", (Object)dbname, (Object)tblname);
                if (this.catalog_.removeTable(dbname, tblname) != null) {
                    LOG.info("Table {}.{} does not exist in metastore, removed from catalog as well", (Object)dbname, (Object)tblname);
                }
                throw e;
            }
            this.dropTableIfExists(currentEventId, dbname, tblname, apiName);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate_table(String dbName, String tblName, List<String> partNames) throws MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            super.truncate_table(dbName, tblName, partNames);
            return;
        }
        String apiName = HmsApiNameEnum.TRUNCATE_TABLE.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
        this.catalog_.getLock().writeLock().unlock();
        super.truncate_table(dbName, tblName, partNames);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TruncateTableResponse truncate_table_req(TruncateTableRequest req) throws MetaException, TException {
        if (!BackendConfig.INSTANCE.enableCatalogdHMSCache() || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
            return super.truncate_table_req(req);
        }
        String apiName = HmsApiNameEnum.TRUNCATE_TABLE_REQ.apiName();
        Table tbl = this.getTableAndAcquireWriteLock(req.getDbName(), req.getTableName(), apiName);
        this.catalog_.getLock().writeLock().unlock();
        TruncateTableResponse response = super.truncate_table_req(req);
        try {
            this.syncToLatestEventId(tbl, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            tbl.releaseWriteLock();
        }
        return response;
    }

    private Table getTableAndAcquireWriteLock(String dbNameWithCatalog, String tblName, String apiName) throws TException {
        Table tbl = null;
        try {
            String dbName = MetaStoreUtils.parseDbName((String)dbNameWithCatalog, (Configuration)this.serverConf_)[1];
            tbl = this.catalogOpExecutor_.getExistingTable(dbName, tblName, apiName, NoOpEventSequence.INSTANCE);
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        if (!this.catalog_.tryWriteLock(tbl)) {
            CatalogException e = new CatalogException("Could not acquire lock on table: " + tbl.getFullName());
            this.rethrowException(e, apiName);
        }
        return tbl;
    }

    private Db getDbAndAcquireLock(String dbName, String apiName) throws TException {
        Db db = this.catalog_.getDb(dbName);
        if (db == null) {
            this.rethrowException(new CatalogException("Database: " + dbName + " does not exist in cache"), apiName);
        }
        if (!this.catalog_.tryLockDb(db)) {
            this.rethrowException(new CatalogException("Couldn't acquire write lock on db: " + db.getName()), apiName);
        }
        return db;
    }

    private void syncToLatestEventId(Table tbl, String apiName) throws TException {
        Preconditions.checkState((boolean)BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls(), (Object)"sync to latest event flag should be set to true");
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread(), (String)"Thread does not have write lock on table %s", (Object)tbl.getFullName());
        try {
            MetastoreEventsProcessor.syncToLatestEventId(this.catalog_, tbl, this.metastoreEventFactory_, this.metastoreEventsMetrics_);
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to sync table %s to latest event id while executing %s", tbl.getFullName(), apiName);
            LOG.error("{}. Exception stacktrace: {} ", (Object)errMsg, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            this.rethrowException(e, apiName);
        }
    }

    private void syncToLatestEventId(Db db, String apiName) throws TException {
        Preconditions.checkState((boolean)BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls(), (Object)"sync to latest event flag should be set to true");
        Preconditions.checkState((boolean)db.isLockHeldByCurrentThread(), (String)"Current thread does not hold lock on db: %s", (Object)db.getName());
        try {
            MetastoreEventsProcessor.syncToLatestEventId(this.catalog_, db, this.metastoreEventFactory_, this.metastoreEventsMetrics_);
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to sync db %s to latest event id while executing %s", db.getName(), apiName);
            LOG.error("{}. Exception stacktrace: {} ", (Object)errMsg, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            this.rethrowException(e, apiName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T alterTableCore(String dbname, String tblName, org.apache.hadoop.hive.metastore.api.Table newTable, String apiName, AlterTableTask<T> task) throws InvalidOperationException, MetaException, TException {
        boolean isRename = !dbname.equalsIgnoreCase(newTable.getDbName()) || !tblName.equalsIgnoreCase(newTable.getTableName());
        Table tbl = this.getTableAndAcquireWriteLock(dbname, tblName, apiName);
        Table newTbl = null;
        try {
            if (!isRename) {
                this.catalog_.getLock().writeLock().unlock();
                T resp = task.execute();
                this.syncToLatestEventId(tbl, apiName);
                T t = resp;
                return t;
            }
            long currentEventId = super.get_current_notificationEventId().getEventId();
            T resp = task.execute();
            try {
                List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForTable(this.catalog_, currentEventId, newTable.getDbName(), newTable.getTableName(), "ALTER_TABLE");
                Preconditions.checkState((events.size() == 1 ? 1 : 0) != 0, (Object)String.format("For table %s.%s, from event id: %s, expected ALTER_TABLE events size to be 1 but is %s", newTable.getDbName(), newTable.getTableName(), currentEventId, events.size()));
                MetastoreEvents.MetastoreEvent event = this.metastoreEventFactory_.get(events.get(0), this.metastoreEventsMetrics_);
                Preconditions.checkState((boolean)(event instanceof MetastoreEvents.AlterTableEvent));
                MetastoreEvents.AlterTableEvent alterEvent = (MetastoreEvents.AlterTableEvent)event;
                org.apache.hadoop.hive.metastore.api.Table oldMsTable = alterEvent.getBeforeTable();
                org.apache.hadoop.hive.metastore.api.Table newMsTable = alterEvent.getAfterTable();
                TTableName oldTTable = new TTableName(oldMsTable.getDbName(), oldMsTable.getTableName());
                TTableName newTTable = new TTableName(newMsTable.getDbName(), newMsTable.getTableName());
                this.catalogOpExecutor_.addToDeleteEventLog(alterEvent.getEventId(), DeleteEventLog.getTblKey(oldTTable.getDb_name(), oldTTable.getTable_name()));
                Pair<Table, Table> result = this.catalog_.renameTable(oldTTable, newTTable, alterEvent.getEventId());
                if (result == null || result.first == null || result.second == null) {
                    throw new CatalogException("failed to rename table " + oldTTable + " to " + newTTable + " for " + apiName);
                }
            }
            finally {
                this.catalog_.getLock().writeLock().unlock();
            }
            newTbl = this.getTableAndAcquireWriteLock(newTable.getDbName(), newTable.getTableName(), apiName);
            this.catalog_.getLock().writeLock().unlock();
            this.syncToLatestEventId(newTbl, apiName);
            T t = resp;
            return t;
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        finally {
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            if (tbl != null && tbl.isWriteLockedByCurrentThread()) {
                tbl.releaseWriteLock();
            }
            if (newTbl != null && newTbl.isWriteLockedByCurrentThread()) {
                newTbl.releaseWriteLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableCore(String apiName, String dbNameWithCatalog, String tblName, TImpalaTableType tblType, CreateTableTask task) throws TException {
        String dbName = MetaStoreUtils.parseDbName((String)dbNameWithCatalog, (Configuration)this.serverConf_)[1];
        this.catalogOpExecutor_.getMetastoreDdlLock().lock();
        Table tbl = null;
        long fromEventId = -1L;
        try {
            fromEventId = super.get_current_notificationEventId().getEventId();
            try {
                task.execute();
            }
            catch (TException e) {
                if (!(e instanceof AlreadyExistsException)) {
                    throw e;
                }
                if (this.catalog_.getTableNoThrow(dbName, tblName) != null) {
                    LOG.debug("Table {}.{} already exists in metastore as well as catalog", (Object)dbName, (Object)tblName);
                    throw e;
                }
                LOG.debug("Table {}.{} exists in metastore but not in catalog. Ignoring exception {} from metastore", new Object[]{dbName, tblName, ((Object)((Object)e)).getClass().getName()});
            }
            List<NotificationEvent> events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForTable(this.catalog_, fromEventId, dbName, tblName, "CREATE_TABLE");
            Preconditions.checkState((events.size() == 1 ? 1 : 0) != 0, (String)"Table %s.%s was recreated in metastore since event id %swhile the current table creation was in progress", (Object)dbName, (Object)tblName, (Object)fromEventId);
            long createEventId = events.get(0).getEventId();
            this.catalog_.addIncompleteTable(dbName, tblName, tblType, null, createEventId);
            LOG.info("Added incomplete table {}.{} (type={}) with create event id: {}", new Object[]{dbName, tblName, tblType, createEventId});
            tbl = this.getTableAndAcquireWriteLock(dbName, tblName, apiName);
            this.catalog_.getLock().writeLock().unlock();
            this.syncToLatestEventId(tbl, apiName);
        }
        catch (Exception e) {
            this.rethrowException(e, apiName);
        }
        finally {
            this.catalogOpExecutor_.getMetastoreDdlLock().unlock();
            this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
            if (tbl != null && tbl.isWriteLockedByCurrentThread()) {
                tbl.releaseWriteLock();
            }
        }
    }

    private abstract class CreateTableTask<T> {
        private CreateTableTask() {
        }

        public abstract T execute() throws TException;
    }

    private abstract class AlterTableTask<T> {
        private AlterTableTask() {
        }

        public abstract T execute() throws InvalidOperationException, MetaException, TException;
    }
}

