/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.metastore.CatalogMetastoreServiceHandler;
import org.apache.impala.catalog.metastore.HmsApiNameEnum;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.catalog.monitor.CatalogMonitor;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.thrift.TCatalogHmsCacheApiMetrics;
import org.apache.impala.thrift.TCatalogdHmsCacheMetrics;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogMetastoreServer
extends ThriftHiveMetastore
implements ICatalogMetastoreServer {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogMetastoreServer.class);
    private static final int MAX_MESSAGE_SIZE = 0x6400000;
    private static final int MIN_SERVER_THREADS = 1;
    private static final int MAX_SERVER_THREADS = 500;
    private static final String ACTIVE_CONNECTIONS_METRIC = "metastore.active.connections";
    private static final String RPC_DURATION_FORMAT_METRIC = "metastore.rpc.duration.%s";
    public static final Set<String> apiNamesSet_ = new HashSet<String>();
    private final AtomicBoolean started_ = new AtomicBoolean(false);
    private final ScheduledExecutorService metricsLoggerService_ = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MetricsLoggerService").build());
    private CompletableFuture<Void> serverHandle_;
    private final CatalogOpExecutor catalogOpExecutor_;

    public CatalogMetastoreServer(CatalogOpExecutor catalogOpExecutor) {
        this.catalogOpExecutor_ = (CatalogOpExecutor)Preconditions.checkNotNull((Object)catalogOpExecutor);
        this.initMetrics();
    }

    private void initMetrics() {
        CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().addCounter("catalogd-hms-cache.miss");
        CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().addCounter("catalogd-hms-cache.hit");
        CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().addMeter("catalogd-hms-cache.api-requests");
        this.metricsLoggerService_.scheduleAtFixedRate(new MetricsLogger(this), 0L, 1L, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    protected int getPort() throws CatalogException {
        return BackendConfig.INSTANCE.getHMSPort();
    }

    @Override
    public synchronized void start() throws CatalogException {
        TServerSocketKeepAlive serverSocket;
        ThriftHiveMetastore.Processor processor;
        TCompactProtocol.Factory inputProtoFactory;
        TCompactProtocol.Factory protocolFactory;
        int portNumber = this.getPort();
        Preconditions.checkState((portNumber > 0 ? 1 : 0) != 0);
        Preconditions.checkState((!this.started_.get() ? 1 : 0) != 0, (Object)"Metastore server is already started");
        LOG.info("Starting the Metastore server at port number {}", (Object)portNumber);
        CatalogMetastoreServiceHandler handler = new CatalogMetastoreServiceHandler(this.catalogOpExecutor_, BackendConfig.INSTANCE.fallbackToHMSOnErrors());
        ThriftHiveMetastore.Iface proxyCatalogHMSIFace = (ThriftHiveMetastore.Iface)Proxy.newProxyInstance(ThriftHiveMetastore.Iface.class.getClassLoader(), new Class[]{ThriftHiveMetastore.Iface.class, ICatalogMetastoreServer.class}, (InvocationHandler)new TimingInvocationHandler(handler));
        boolean useCompactProtocol = false;
        if (useCompactProtocol) {
            protocolFactory = new TCompactProtocol.Factory();
            inputProtoFactory = new TCompactProtocol.Factory(0x6400000L, 0x6400000L);
        } else {
            protocolFactory = new TBinaryProtocol.Factory();
            inputProtoFactory = new TBinaryProtocol.Factory(true, true, 0x6400000L, 0x6400000L);
        }
        try {
            processor = new ThriftHiveMetastore.Processor(proxyCatalogHMSIFace);
        }
        catch (Exception e) {
            throw new CatalogException("Unable to create processor for catalog metastore server", e);
        }
        boolean useSSL = false;
        try {
            serverSocket = new TServerSocketKeepAlive(new TServerSocket(new InetSocketAddress(portNumber)));
        }
        catch (TTransportException e) {
            throw new CatalogException("Unable to create server socket at port number " + portNumber, e);
        }
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processor((TProcessor)processor)).transportFactory(new TTransportFactory())).protocolFactory((TProtocolFactory)protocolFactory)).inputProtocolFactory((TProtocolFactory)inputProtoFactory)).minWorkerThreads(1).maxWorkerThreads(500);
        TThreadPoolServer tServer = new TThreadPoolServer(args);
        RpcMetricsEventHandler rpcMetricsEventHandler = new RpcMetricsEventHandler();
        tServer.setServerEventHandler((TServerEventHandler)rpcMetricsEventHandler);
        LOG.info("Started the new metaserver on port [" + portNumber + "]...");
        LOG.info("minWorkerThreads = 1");
        LOG.info("maxWorkerThreads = 500");
        LOG.info("Enable SSL = " + useSSL);
        this.serverHandle_ = CompletableFuture.runAsync(() -> CatalogMetastoreServer.lambda$start$0((TServer)tServer));
        this.started_.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCatalogdHmsCacheMetrics getCatalogdHmsCacheMetrics() {
        HashSet<String> apiNames;
        long apiRequests = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getMeter("catalogd-hms-cache.api-requests").getCount();
        double cacheHitRatio = this.getHitRatio("catalogd-hms-cache.hit", "catalogd-hms-cache.miss");
        double apiRequestsOneMinute = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getMeter("catalogd-hms-cache.api-requests").getOneMinuteRate();
        double apiRequestsFiveMinutes = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getMeter("catalogd-hms-cache.api-requests").getFiveMinuteRate();
        double apiRequestsFifteenMinutes = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getMeter("catalogd-hms-cache.api-requests").getFifteenMinuteRate();
        TCatalogdHmsCacheMetrics catalogdHmsCacheMetrics = new TCatalogdHmsCacheMetrics();
        ArrayList<TCatalogHmsCacheApiMetrics> apiMetricsList = new ArrayList<TCatalogHmsCacheApiMetrics>();
        catalogdHmsCacheMetrics.setApi_metrics(apiMetricsList);
        catalogdHmsCacheMetrics.setCache_hit_ratio(cacheHitRatio);
        catalogdHmsCacheMetrics.setApi_requests(apiRequests);
        catalogdHmsCacheMetrics.setApi_requests_1min_rate(apiRequestsOneMinute);
        catalogdHmsCacheMetrics.setApi_requests_5min_rate(apiRequestsFiveMinutes);
        catalogdHmsCacheMetrics.setApi_requests_15min_rate(apiRequestsFifteenMinutes);
        Set<String> set = apiNamesSet_;
        synchronized (set) {
            apiNames = new HashSet<String>(apiNamesSet_);
        }
        for (String apiName : apiNames) {
            TCatalogHmsCacheApiMetrics apiMetrics = new TCatalogHmsCacheApiMetrics();
            apiMetricsList.add(apiMetrics);
            double specificApiP95ResponseTime = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getSnapshot().get95thPercentile();
            double specificApiP99ResponseTime = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getSnapshot().get99thPercentile();
            long specificApiRequests = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getCount();
            if (HmsApiNameEnum.contains(apiName)) {
                double specificApiCacheHitRatio = this.getHitRatio(String.format("catalogd-hms-cache.cache-hit.api.%s", apiName), String.format("catalogd-hms-cache.cache-miss.api.%s", apiName));
                apiMetrics.setCache_hit_ratio(specificApiCacheHitRatio);
            }
            double specificApiRequestsOneMinute = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getOneMinuteRate();
            double specificApiRequestsFiveMinutes = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getFiveMinuteRate();
            double specificApiRequestsFifteenMinutes = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getFifteenMinuteRate();
            long max = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getSnapshot().getMax();
            long min = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getSnapshot().getMin();
            double mean = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(RPC_DURATION_FORMAT_METRIC, apiName)).getSnapshot().getMean();
            apiMetrics.setApi_name(apiName);
            apiMetrics.setApi_requests(specificApiRequests);
            apiMetrics.setP99_response_time_ms(specificApiP99ResponseTime);
            apiMetrics.setP95_response_time_ms(specificApiP95ResponseTime);
            apiMetrics.setResponse_time_mean_ms(mean);
            apiMetrics.setResponse_time_max_ms(max);
            apiMetrics.setResponse_time_min_ms(min);
            apiMetrics.setApi_requests_1min_rate(specificApiRequestsOneMinute);
            apiMetrics.setApi_requests_5min_rate(specificApiRequestsFiveMinutes);
            apiMetrics.setApi_requests_15min_rate(specificApiRequestsFifteenMinutes);
        }
        return catalogdHmsCacheMetrics;
    }

    private double getHitRatio(String hitMetric, String missMetric) {
        long hitCount = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(hitMetric).getCount();
        long missCount = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(missMetric).getCount();
        return (double)hitCount / (double)(hitCount + missCount);
    }

    @Override
    public void stop() throws CatalogException {
        this.serverHandle_.cancel(true);
    }

    private static /* synthetic */ void lambda$start$0(TServer tServer) {
        tServer.serve();
    }

    private static class MetricsLogger
    implements Runnable {
        private final CatalogMetastoreServer server_;

        public MetricsLogger(CatalogMetastoreServer server) {
            this.server_ = server;
        }

        @Override
        public void run() {
            TCatalogdHmsCacheMetrics metrics = this.server_.getCatalogdHmsCacheMetrics();
            LOG.debug("CatalogdHMSCacheMetrics : {}", (Object)metrics.toString());
        }
    }

    private class TimingInvocationHandler
    implements InvocationHandler {
        private final CatalogMetastoreServiceHandler handler_;

        TimingInvocationHandler(CatalogMetastoreServiceHandler handler) {
            Preconditions.checkNotNull((Object)((Object)handler));
            this.handler_ = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long elapsedTime;
            Object object;
            Set<String> set = apiNamesSet_;
            synchronized (set) {
                apiNamesSet_.add(method.getName());
            }
            CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getMeter("catalogd-hms-cache.api-requests").mark();
            Timer.Context context = CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(CatalogMetastoreServer.RPC_DURATION_FORMAT_METRIC, method.getName()) + Thread.currentThread().getId()).time();
            if (CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(String.format("catalogd-hms-cache.cache-miss.api.%s", method.getName())) == null) {
                CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().addCounter(String.format("catalogd-hms-cache.cache-miss.api.%s", method.getName()));
                CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().addCounter(String.format("catalogd-hms-cache.cache-hit.api.%s", method.getName()));
            }
            try {
                LOG.debug("Invoking HMS API: {}", (Object)method.getName());
                object = method.invoke((Object)this.handler_, args);
                elapsedTime = TimeUnit.NANOSECONDS.toMillis(context.stop());
            }
            catch (Exception ex) {
                try {
                    Throwable unwrapped = this.unwrap(ex);
                    LOG.error("Received exception while executing " + method.getName() + " : ", unwrapped);
                    throw unwrapped;
                }
                catch (Throwable throwable) {
                    long elapsedTime2 = TimeUnit.NANOSECONDS.toMillis(context.stop());
                    CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(CatalogMetastoreServer.RPC_DURATION_FORMAT_METRIC, method.getName())).update(elapsedTime2, TimeUnit.MILLISECONDS);
                    throw throwable;
                }
            }
            CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getTimer(String.format(CatalogMetastoreServer.RPC_DURATION_FORMAT_METRIC, method.getName())).update(elapsedTime, TimeUnit.MILLISECONDS);
            return object;
        }

        private Throwable unwrap(Exception ex) {
            if (ex instanceof InvocationTargetException) {
                return ((InvocationTargetException)ex).getTargetException();
            }
            return ex;
        }
    }

    private class RpcMetricsEventHandler
    implements TServerEventHandler {
        private RpcMetricsEventHandler() {
        }

        public void preServe() {
        }

        public ServerContext createContext(TProtocol tProtocol, TProtocol tProtocol1) {
            CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(CatalogMetastoreServer.ACTIVE_CONNECTIONS_METRIC).inc();
            return null;
        }

        public void deleteContext(ServerContext serverContext, TProtocol tProtocol, TProtocol tProtocol1) {
            CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(CatalogMetastoreServer.ACTIVE_CONNECTIONS_METRIC).dec();
        }

        public void processContext(ServerContext serverContext, TTransport tTransport, TTransport tTransport1) {
        }
    }
}

