/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.metastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FileMetadata;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.ObjectDictionary;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class CatalogHmsClientUtils {
    public static Map<Partition, List<FileDescriptor>> extractFileDescriptors(GetPartitionsByNamesResult getPartitionsResult, ListMap<TNetworkAddress> hostIndex) throws CatalogException {
        if (getPartitionsResult.getPartitionsSize() == 0) {
            return new HashMap<Partition, List<FileDescriptor>>(0);
        }
        Preconditions.checkArgument((boolean)getPartitionsResult.isSetDictionary(), (Object)"Host info is unavailable");
        List<TNetworkAddress> hostInfo = CatalogHmsClientUtils.deserializeNetworkAddresses(getPartitionsResult.getDictionary());
        HashMap fds = Maps.newHashMapWithExpectedSize((int)getPartitionsResult.getPartitionsSize());
        for (Partition part : getPartitionsResult.getPartitions()) {
            Preconditions.checkArgument((boolean)part.isSetFileMetadata(), (Object)("Filemetadata is not set for partition with values " + part.getValues()));
            FileMetadata fileMetadata = part.getFileMetadata();
            ArrayList partitionFds = Lists.newArrayListWithCapacity((int)fileMetadata.getDataSize());
            if (fileMetadata.getData() != null) {
                for (ByteBuffer data : fileMetadata.getData()) {
                    FileDescriptor fd = FileDescriptor.fromThrift(new THdfsFileDesc(data));
                    fd.cloneWithNewHostIndex(hostInfo, hostIndex);
                    partitionFds.add(fd);
                }
            }
            fds.put(part, partitionFds);
        }
        return fds;
    }

    public static List<FileDescriptor> extractFileDescriptors(Table tbl, ListMap<TNetworkAddress> hostIndex) throws CatalogException {
        String fullTblName = tbl.getDbName() + "." + tbl.getTableName();
        Preconditions.checkArgument((boolean)tbl.isSetDictionary(), (Object)("Host info is not available in the table " + fullTblName));
        List<TNetworkAddress> hostInfo = CatalogHmsClientUtils.deserializeNetworkAddresses(tbl.getDictionary());
        Preconditions.checkArgument((boolean)tbl.isSetFileMetadata(), (Object)("Filemetadata is not set for table " + fullTblName));
        FileMetadata fileMetadata = tbl.getFileMetadata();
        if (fileMetadata.getData() == null) {
            return Collections.emptyList();
        }
        ArrayList tableFds = Lists.newArrayListWithCapacity((int)fileMetadata.getDataSize());
        for (ByteBuffer data : fileMetadata.getData()) {
            FileDescriptor fd = FileDescriptor.fromThrift(new THdfsFileDesc(data));
            fd.cloneWithNewHostIndex(hostInfo, hostIndex);
            tableFds.add(fd);
        }
        return tableFds;
    }

    private static List<TNetworkAddress> deserializeNetworkAddresses(ObjectDictionary dictionary) throws CatalogException {
        if (dictionary == null) {
            return null;
        }
        if (dictionary.getValuesSize() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (!dictionary.getValues().containsKey("impala:TNetworkAddress")) {
            throw new CatalogException("Key impala:TNetworkAddress not found");
        }
        List serializedNetAddresses = (List)dictionary.getValues().get("impala:TNetworkAddress");
        ArrayList networkAddresses = Lists.newArrayListWithCapacity((int)serializedNetAddresses.size());
        int index = 0;
        TDeserializer deserializer = null;
        try {
            deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
        }
        catch (TException e) {
            throw new CatalogException("Could not create deserializer. " + e.getMessage());
        }
        for (ByteBuffer serializedData : serializedNetAddresses) {
            TNetworkAddress networkAddress = new TNetworkAddress();
            try {
                deserializer.deserialize((TBase)networkAddress, serializedData.array());
                networkAddresses.add(networkAddress);
                ++index;
            }
            catch (TException tException) {
                throw new CatalogException("Could not deserialize network address at position " + index);
            }
        }
        return networkAddresses;
    }
}

