/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.iceberg.Table;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TException;

public class MultiMetaProvider
implements MetaProvider {
    private final MetaProvider primaryProvider_;
    private final List<MetaProvider> secondaryProviders_;

    public MultiMetaProvider(MetaProvider primaryProvider, List<MetaProvider> secondaryProviders) {
        this.primaryProvider_ = primaryProvider;
        this.secondaryProviders_ = secondaryProviders;
    }

    public MetaProvider getPrimaryProvider() {
        return this.primaryProvider_;
    }

    @Override
    public String getURI() {
        StringJoiner joiner = new StringJoiner(", ");
        joiner.add(this.primaryProvider_.getURI());
        for (MetaProvider provider : this.secondaryProviders_) {
            joiner.add(provider.getURI());
        }
        return joiner.toString();
    }

    @Override
    public AuthorizationPolicy getAuthPolicy() {
        return this.primaryProvider_.getAuthPolicy();
    }

    @Override
    public boolean isReady() {
        return this.primaryProvider_.isReady();
    }

    @Override
    public void waitForIsReady(long timeoutMs) {
        this.primaryProvider_.waitForIsReady(timeoutMs);
    }

    @Override
    public ImmutableList<String> loadDbList() throws TException {
        return (ImmutableList)this.collectFromAllProviders(MultiMetaProvider.unchecked(MetaProvider::loadDbList)).stream().flatMap(Collection::stream).distinct().collect(ImmutableList.toImmutableList());
    }

    @Override
    public Database loadDb(String dbName) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadDb(dbName)));
    }

    @Override
    public ImmutableCollection<TBriefTableMeta> loadTableList(String dbName) throws TException {
        ImmutableList combinedTableList = (ImmutableList)this.collectFromAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadTableList(dbName))).stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        Optional<Map.Entry> firstDuplicate = combinedTableList.stream().map(tableMeta -> tableMeta.name).collect(Collectors.toMap(s -> s, s -> 1, Integer::sum)).entrySet().stream().filter(stringIntegerEntry -> (Integer)stringIntegerEntry.getValue() > 1).findFirst();
        if (firstDuplicate.isPresent()) {
            throw new TException("Ambiguous table name: " + (String)firstDuplicate.get().getKey());
        }
        return combinedTableList;
    }

    @Override
    public Pair<org.apache.hadoop.hive.metastore.api.Table, MetaProvider.TableMetaRef> loadTable(String dbName, String tableName) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadTable(dbName, tableName)));
    }

    @Override
    public Pair<org.apache.hadoop.hive.metastore.api.Table, MetaProvider.TableMetaRef> getTableIfPresent(String dbName, String tableName) {
        try {
            return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.getTableIfPresent(dbName, tableName)));
        }
        catch (TException e) {
            return null;
        }
    }

    @Override
    public String loadNullPartitionKeyValue() throws TException {
        return this.primaryProvider_.loadNullPartitionKeyValue();
    }

    @Override
    public List<MetaProvider.PartitionRef> loadPartitionList(MetaProvider.TableMetaRef table) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadPartitionList(table)));
    }

    @Override
    public SqlConstraints loadConstraints(MetaProvider.TableMetaRef table, org.apache.hadoop.hive.metastore.api.Table msTbl) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadConstraints(table, msTbl)));
    }

    @Override
    public List<String> loadFunctionNames(String dbName) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadFunctionNames(dbName)));
    }

    @Override
    public ImmutableList<Function> loadFunction(String dbName, String functionName) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadFunction(dbName, functionName)));
    }

    @Override
    public ImmutableList<DataSource> loadDataSources() throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(MetaProvider::loadDataSources));
    }

    @Override
    public DataSource loadDataSource(String dsName) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadDataSource(dsName)));
    }

    @Override
    public Map<String, MetaProvider.PartitionMetadata> loadPartitionsByRefs(MetaProvider.TableMetaRef table, List<String> partitionColumnNames, ListMap<TNetworkAddress> hostIndex, List<MetaProvider.PartitionRef> partitionRefs) throws TException, CatalogException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadPartitionsByRefs(table, partitionColumnNames, hostIndex, partitionRefs)));
    }

    @Override
    public List<ColumnStatisticsObj> loadTableColumnStatistics(MetaProvider.TableMetaRef table, List<String> colNames) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadTableColumnStatistics(table, colNames)));
    }

    @Override
    public TPartialTableInfo loadIcebergTable(MetaProvider.TableMetaRef table) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadIcebergTable(table)));
    }

    @Override
    public Table loadIcebergApiTable(MetaProvider.TableMetaRef table, LocalIcebergTable.TableParams param, org.apache.hadoop.hive.metastore.api.Table msTable) throws TException {
        return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.loadIcebergApiTable(table, param, msTable)));
    }

    @Override
    public TValidWriteIdList getValidWriteIdList(MetaProvider.TableMetaRef ref) {
        try {
            return this.tryAllProviders(MultiMetaProvider.unchecked(provider -> provider.getValidWriteIdList(ref)));
        }
        catch (TException e) {
            return null;
        }
    }

    @Override
    public Iterable<HdfsCachePool> getHdfsCachePools() {
        try {
            return this.tryAllProviders(MultiMetaProvider.unchecked(MetaProvider::getHdfsCachePools));
        }
        catch (TException e) {
            return null;
        }
    }

    private ImmutableList<MetaProvider> getAllProviders() {
        return ImmutableList.builder().add((Object)this.primaryProvider_).addAll(this.secondaryProviders_).build();
    }

    private <R> R tryAllProviders(java.util.function.Function<MetaProvider, R> function) throws TException {
        HashMap<String, Exception> exceptions = new HashMap<String, Exception>();
        ImmutableList<MetaProvider> providers = this.getAllProviders();
        for (MetaProvider provider : providers) {
            try {
                return function.apply(provider);
            }
            catch (MetaProviderException e) {
                exceptions.put(provider.getURI(), e);
            }
        }
        this.handleExceptions(exceptions);
        return null;
    }

    private <R> Collection<R> collectFromAllProviders(java.util.function.Function<MetaProvider, R> function) throws TException {
        HashMap<String, Exception> exceptions = new HashMap<String, Exception>();
        ImmutableList<MetaProvider> providers = this.getAllProviders();
        ArrayList<R> results = new ArrayList<R>();
        for (MetaProvider provider : providers) {
            try {
                results.add(function.apply(provider));
            }
            catch (MetaProviderException e) {
                exceptions.put(provider.getURI(), e);
            }
        }
        if (!results.isEmpty()) {
            return results;
        }
        this.handleExceptions(exceptions);
        return Collections.emptyList();
    }

    private void handleExceptions(Map<String, Exception> exceptions) throws TException {
        if (!exceptions.isEmpty()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (Map.Entry<String, Exception> e : exceptions.entrySet()) {
                printWriter.print(String.format("%s: ", e.getKey()));
                e.getValue().printStackTrace(printWriter);
            }
            String message = String.format("Every MetaProvider failed with the following exceptions: %s", stringWriter);
            throw new TException(message);
        }
    }

    private static <T, R> java.util.function.Function<T, R> unchecked(ThrowingFunction<T, R> tf) {
        return t -> {
            try {
                return tf.apply(t);
            }
            catch (Exception e) {
                throw new MetaProviderException(e);
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    public static class MetaProviderException
    extends RuntimeException {
        MetaProviderException(Throwable cause) {
            super(cause);
        }
    }
}

