/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HBaseTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.SideloadTableStats;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.SystemTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalDataSourceTable;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.catalog.local.LocalHbaseTable;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.catalog.local.LocalKuduTable;
import org.apache.impala.catalog.local.LocalPaimonTable;
import org.apache.impala.catalog.local.LocalSystemTable;
import org.apache.impala.catalog.local.LocalView;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.AcidUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LocalTable
implements FeTable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTable.class);
    protected final LocalDb db_;
    protected final String name_;
    protected final TImpalaTableType tableType_;
    protected final String tableComment_;
    private final ColumnMap cols_;
    protected final Table msTable_;
    private final TTableStats tableStats_;
    protected final ArrayList<VirtualColumn> virtualCols_ = new ArrayList();
    protected SideloadTableStats testStats_ = null;
    protected double testMetadataScale_ = 1.0;
    @Nullable
    @VisibleForTesting
    protected final MetaProvider.TableMetaRef ref_;

    public static LocalTable load(LocalDb db, String tblName) throws TableLoadingException {
        Pair<Table, MetaProvider.TableMetaRef> tableMeta = LocalTable.loadTableMetadata(db, tblName);
        return LocalTable.load(db, tableMeta);
    }

    public static LocalTable load(LocalDb db, Pair<Table, MetaProvider.TableMetaRef> tableMeta) throws TableLoadingException {
        LocalTable t = null;
        Table msTbl = (Table)tableMeta.first;
        MetaProvider.TableMetaRef ref = (MetaProvider.TableMetaRef)tableMeta.second;
        if (TableType.valueOf((String)msTbl.getTableType()) == TableType.VIRTUAL_VIEW) {
            t = new LocalView(db, msTbl, ref);
        } else if (HBaseTable.isHBaseTable(msTbl)) {
            t = LocalHbaseTable.loadFromHbase(db, msTbl, ref);
        } else if (KuduTable.isKuduTable(msTbl)) {
            t = LocalKuduTable.loadFromKudu(db, msTbl, ref);
        } else if (IcebergTable.isIcebergTable(msTbl)) {
            t = LocalIcebergTable.loadIcebergTableViaMetaProvider(db, msTbl, ref);
        } else if (PaimonUtil.isPaimonTable(msTbl)) {
            t = LocalPaimonTable.load(db, msTbl, ref);
        } else if (DataSourceTable.isDataSourceTable(msTbl)) {
            t = LocalDataSourceTable.load(db, msTbl, ref);
        } else if (SystemTable.isSystemTable(msTbl)) {
            t = LocalSystemTable.load(db, msTbl, ref);
        } else if (HdfsFileFormat.isHdfsInputFormatClass(msTbl.getSd().getInputFormat())) {
            t = LocalFsTable.load(db, msTbl, ref);
        }
        if (t == null) {
            throw new LocalCatalogException("Unknown table type for table " + db.getName() + "." + msTbl.getTableName());
        }
        t.loadColumnStats();
        return t;
    }

    private static Pair<Table, MetaProvider.TableMetaRef> loadTableMetadata(LocalDb db, String tblName) throws TableLoadingException {
        Preconditions.checkArgument((boolean)tblName.toLowerCase().equals(tblName));
        try {
            return db.getCatalog().getMetaProvider().loadTable(db.getName(), tblName);
        }
        catch (TException e) {
            throw new TableLoadingException(String.format("Could not load table %s.%s from catalog", db.getName(), tblName), e);
        }
    }

    public LocalTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref, ColumnMap cols) {
        this.db_ = (LocalDb)Preconditions.checkNotNull((Object)db);
        this.name_ = msTbl.getTableName();
        this.tableType_ = MetastoreShim.mapToInternalTableType(msTbl.getTableType());
        this.tableComment_ = MetadataOp.getTableComment(msTbl);
        this.cols_ = cols;
        this.ref_ = ref;
        this.msTable_ = msTbl;
        if (RuntimeEnv.INSTANCE.hasSideloadStats(db.getName(), this.name_)) {
            this.testStats_ = RuntimeEnv.INSTANCE.getSideloadStats(db.getName(), this.name_);
        }
        this.tableStats_ = new TTableStats(-1L);
        long rowCount = FeCatalogUtils.getRowCount(this.msTable_.getParameters());
        if (this.testStats_ != null) {
            this.tableStats_.setTotal_file_bytes(this.testStats_.getTotalSize());
            this.testMetadataScale_ = (double)this.testStats_.getNumRows() / (double)rowCount;
            rowCount = this.testStats_.getNumRows();
        } else {
            this.tableStats_.setTotal_file_bytes(FeCatalogUtils.getTotalSize(this.msTable_.getParameters()));
        }
        this.tableStats_.setNum_rows(rowCount);
    }

    public LocalTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) {
        this(db, msTbl, ref, ColumnMap.fromMsTable(msTbl));
    }

    protected LocalTable(LocalDb db, String tblName) {
        this.db_ = (LocalDb)Preconditions.checkNotNull((Object)db);
        this.name_ = tblName;
        this.tableType_ = TImpalaTableType.TABLE;
        this.tableComment_ = null;
        this.ref_ = null;
        this.msTable_ = null;
        this.cols_ = null;
        this.tableStats_ = null;
    }

    protected void addVirtualColumns(List<VirtualColumn> virtualColumns) {
        for (VirtualColumn virtCol : virtualColumns) {
            this.addVirtualColumn(virtCol);
        }
    }

    protected void addVirtualColumn(VirtualColumn col) {
        this.virtualCols_.add(col);
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public Table getMetaStoreTable() {
        return this.msTable_;
    }

    @Override
    public String getOwnerUser() {
        if (this.msTable_ == null) {
            LOG.warn("Owner of {} is unknown due to msTable is unloaded", (Object)this.getFullName());
            return null;
        }
        return this.msTable_.getOwnerType() == PrincipalType.USER ? this.msTable_.getOwner() : null;
    }

    @Override
    public String getStorageHandlerClassName() {
        return null;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getFullName() {
        return this.db_.getName() + "." + this.name_;
    }

    @Override
    public TableName getTableName() {
        return new TableName(this.db_.getName(), this.name_);
    }

    @Override
    public TImpalaTableType getTableType() {
        return this.tableType_;
    }

    @Override
    public String getTableComment() {
        return this.tableComment_;
    }

    @Override
    public List<Column> getColumns() {
        return this.cols_ == null ? Collections.emptyList() : this.cols_.colsByPos_;
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        List<Object> columns = Lists.newArrayList(this.getNonClusteringColumns());
        columns = this.filterColumnsNotStoredInHms((List<Column>)columns);
        columns.addAll(this.getClusteringColumns());
        return Collections.unmodifiableList(columns);
    }

    @Override
    public List<String> getColumnNames() {
        return this.cols_ == null ? Collections.emptyList() : this.cols_.getColumnNames();
    }

    @Override
    public List<Column> getClusteringColumns() {
        return this.cols_ == null ? Collections.emptyList() : this.cols_.getClusteringColumns();
    }

    @Override
    public List<Column> getNonClusteringColumns() {
        return this.cols_ == null ? Collections.emptyList() : this.cols_.getNonClusteringColumns();
    }

    @Override
    public List<VirtualColumn> getVirtualColumns() {
        return this.virtualCols_;
    }

    @Override
    public int getNumClusteringCols() {
        return this.cols_ == null ? 0 : this.cols_.getNumClusteringCols();
    }

    @Override
    public boolean isClusteringColumn(Column c) {
        return this.cols_ != null && this.cols_.isClusteringColumn(c);
    }

    @Override
    public Column getColumn(String name) {
        return this.cols_ == null ? null : this.cols_.getByName(name);
    }

    @Override
    public ArrayType getType() {
        return this.cols_ == null ? null : this.cols_.getType();
    }

    @Override
    public FeDb getDb() {
        return this.db_;
    }

    @Override
    public long getNumRows() {
        return this.tableStats_.num_rows;
    }

    @Override
    public TTableStats getTTableStats() {
        return this.tableStats_;
    }

    @Override
    public long getWriteId() {
        return -1L;
    }

    @Override
    public ValidWriteIdList getValidWriteIds() {
        return null;
    }

    @Override
    public long getCatalogVersion() {
        if (this.ref_ == null) {
            return 0L;
        }
        return this.ref_.getCatalogVersion();
    }

    @Override
    public long getLastLoadedTimeMs() {
        if (this.ref_ == null) {
            return 0L;
        }
        return this.ref_.getLoadedTimeMs();
    }

    protected void loadColumnStats() {
        try {
            List<ColumnStatisticsObj> stats = this.db_.getCatalog().getMetaProvider().loadTableColumnStatistics(this.ref_, this.getColumnNames());
            FeCatalogUtils.injectColumnStats(stats, this, this.testStats_);
        }
        catch (TException e) {
            LOG.warn("Could not load column statistics for: " + this.getFullName(), (Throwable)e);
        }
    }

    protected double getDebugMetadataScale() {
        return this.testMetadataScale_;
    }

    protected static class ColumnMap {
        private final ArrayType type_;
        private final ImmutableList<Column> colsByPos_;
        private final ImmutableMap<String, Column> colsByName_;
        private final int numClusteringCols_;
        private final boolean hasRowIdCol_;

        public static ColumnMap fromMsTable(Table msTbl) {
            String fullName = msTbl.getDbName() + "." + msTbl.getTableName();
            int numClusteringCols = msTbl.getPartitionKeys().size();
            try {
                ImmutableList<Column> cols = FeCatalogUtils.fieldSchemasToColumns(msTbl);
                boolean isFullAcidTable = AcidUtils.isFullAcidTable(msTbl.getParameters());
                return new ColumnMap((List<Column>)cols, numClusteringCols, fullName, isFullAcidTable);
            }
            catch (TableLoadingException e) {
                throw new LocalCatalogException(e);
            }
        }

        public ColumnMap(List<Column> cols, int numClusteringCols, String fullTableName, boolean isFullAcidSchema) {
            this.hasRowIdCol_ = isFullAcidSchema;
            this.colsByPos_ = ImmutableList.copyOf(cols);
            this.numClusteringCols_ = numClusteringCols;
            this.colsByName_ = ColumnMap.indexColumnNames(this.colsByPos_);
            this.type_ = new ArrayType(ColumnMap.columnsToStructType(this.colsByPos_));
            try {
                FeCatalogUtils.validateClusteringColumns((Iterable<Column>)this.colsByPos_.subList(0, this.numClusteringCols_), fullTableName);
            }
            catch (TableLoadingException e) {
                throw new LocalCatalogException(e);
            }
        }

        public ArrayType getType() {
            return this.type_;
        }

        public Column getByName(String name) {
            return (Column)this.colsByName_.get((Object)name.toLowerCase());
        }

        public int getNumClusteringCols() {
            return this.numClusteringCols_;
        }

        public List<Column> getNonClusteringColumns() {
            return this.colsByPos_.subList(this.numClusteringCols_ + (this.hasRowIdCol_ ? 1 : 0), this.colsByPos_.size());
        }

        public List<Column> getClusteringColumns() {
            return this.colsByPos_.subList(0, this.numClusteringCols_);
        }

        public List<String> getColumnNames() {
            return Column.toColumnNames(this.colsByPos_);
        }

        private static StructType columnsToStructType(List<Column> cols) {
            ArrayList fields = Lists.newArrayListWithCapacity((int)cols.size());
            for (Column col : cols) {
                if (col instanceof IcebergColumn) {
                    IcebergColumn iCol = (IcebergColumn)col;
                    fields.add(new IcebergStructField(iCol.getName(), iCol.getType(), iCol.getComment(), iCol.getFieldId()));
                    continue;
                }
                fields.add(new StructField(col.getName(), col.getType(), col.getComment()));
            }
            return new StructType(fields);
        }

        private static ImmutableMap<String, Column> indexColumnNames(List<Column> cols) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Column col : cols) {
                builder.put((Object)col.getName().toLowerCase(), (Object)col);
            }
            return builder.build();
        }

        boolean isClusteringColumn(Column c) {
            Preconditions.checkArgument((this.colsByPos_.get(c.getPosition()) == c ? 1 : 0) != 0);
            return c.getPosition() < this.numClusteringCols_;
        }
    }
}

