/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.util.MetaStoreUtil;

@Immutable
class LocalPartitionSpec
implements PrunablePartition {
    static final long UNPARTITIONED_ID = 0L;
    private final long id_;
    @Nullable
    private final MetaProvider.PartitionRef ref_;
    private final ImmutableList<LiteralExpr> partitionValues_;

    LocalPartitionSpec(LocalFsTable table, MetaProvider.PartitionRef ref, long id) {
        this.id_ = id;
        this.ref_ = (MetaProvider.PartitionRef)Preconditions.checkNotNull((Object)ref);
        if (ref.getName().isEmpty()) {
            this.partitionValues_ = ImmutableList.of();
            return;
        }
        try {
            List<String> partValues = MetaStoreUtil.getPartValsFromName(table.getMetaStoreTable(), this.ref_.getName());
            this.partitionValues_ = ImmutableList.copyOf(FeCatalogUtils.parsePartitionKeyValues(table, partValues));
        }
        catch (MetaException | CatalogException e) {
            throw new LocalCatalogException(String.format("Failed to parse partition name '%s' for table %s", ref.getName(), table.getFullName()), e);
        }
    }

    LocalPartitionSpec(long id) {
        Preconditions.checkArgument((id == -1L || id == 0L ? 1 : 0) != 0);
        this.id_ = id;
        this.ref_ = null;
        this.partitionValues_ = ImmutableList.of();
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public List<LiteralExpr> getPartitionValues() {
        return this.partitionValues_;
    }

    MetaProvider.PartitionRef getRef() {
        return this.ref_;
    }

    public String toString() {
        if (this.ref_ != null) {
            return this.ref_.getName();
        }
        if (this.id_ == -1L) {
            return "<prototype>";
        }
        return "<default>";
    }
}

