/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.catalog.paimon.FePaimonTable;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.log4j.Logger;

public class LocalPaimonTable
extends LocalTable
implements FePaimonTable {
    private static final Logger LOG = Logger.getLogger(LocalPaimonTable.class);
    private org.apache.paimon.table.Table table_;

    public static LocalPaimonTable load(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) throws TableLoadingException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)msTbl);
        Preconditions.checkNotNull((Object)ref);
        try {
            LocalPaimonTable localPaimonTable = new LocalPaimonTable(db, msTbl, ref);
            return localPaimonTable;
        }
        catch (MetaException ex) {
            throw new TableLoadingException("Failed to load table" + msTbl.getTableName(), ex);
        }
    }

    protected LocalPaimonTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) throws MetaException {
        super(db, msTbl, ref);
        this.table_ = PaimonUtil.createFileStoreTable(msTbl);
        this.applyPaimonTableStatsIfPresent();
    }

    @Override
    public org.apache.paimon.table.Table getPaimonApiTable() {
        return this.table_;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDescriptor = new TTableDescriptor(tableId, TTableType.PAIMON_TABLE, this.getTColumnDescriptors(), 0, this.name_, this.db_.getName());
        try {
            tableDescriptor.setPaimonTable(PaimonUtil.getTPaimonTable(this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tableDescriptor;
    }
}

