/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TKuduPartitionParam;
import org.apache.impala.thrift.TKuduTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTable;

public class LocalKuduTable
extends LocalTable
implements FeKuduTable {
    private final TableParams tableParams_;
    private final boolean isPrimaryKeyUnique_;
    private final boolean hasAutoIncrementingColumn_;
    private final ImmutableList<String> primaryKeyColumnNames_;
    private final List<KuduPartitionParam> partitionBy_;
    private final KuduTable kuduTable_;

    static LocalTable loadFromKudu(LocalDb db, Table msTable, MetaProvider.TableMetaRef ref) throws TableLoadingException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)msTable);
        String fullTableName = msTable.getDbName() + "." + msTable.getTableName();
        TableParams params = new TableParams(msTable);
        KuduTable kuduTable = params.openTable();
        ArrayList<Column> cols = new ArrayList<Column>();
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        LocalKuduTable.convertColsFromKudu(kuduTable.getSchema(), cols, fieldSchemas);
        msTable.getSd().setCols(fieldSchemas);
        boolean isPrimaryKeyUnique = kuduTable.getSchema().isPrimaryKeyUnique();
        boolean hasAutoIncrementingColumn = kuduTable.getSchema().hasAutoIncrementingColumn();
        ArrayList<String> pkNames = new ArrayList<String>();
        for (ColumnSchema c : kuduTable.getSchema().getPrimaryKeyColumns()) {
            pkNames.add(c.getName().toLowerCase());
        }
        List<KuduPartitionParam> partitionBy = FeKuduTable.Utils.loadPartitionByParams(kuduTable);
        LocalTable.ColumnMap cmap = new LocalTable.ColumnMap(cols, 0, fullTableName, false);
        return new LocalKuduTable(db, msTable, ref, cmap, kuduTable, isPrimaryKeyUnique, pkNames, hasAutoIncrementingColumn, partitionBy);
    }

    public static FeKuduTable createCtasTarget(LocalDb db, Table msTable, List<ColumnDef> columnDefs, boolean isPrimaryKeyUnique, List<ColumnDef> primaryKeyColumnDefs, List<KuduPartitionParam> kuduPartitionParams) throws ImpalaRuntimeException {
        String fullTableName = msTable.getDbName() + "." + msTable.getTableName();
        boolean hasAutoIncrementingColumn = false;
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<String> pkNames = new ArrayList<String>();
        int pos = 0;
        for (ColumnDef colDef : columnDefs) {
            columns.add(KuduColumn.fromThrift(colDef.toThrift(), pos++));
            if (isPrimaryKeyUnique || pos != primaryKeyColumnDefs.size()) continue;
            columns.add(KuduColumn.createAutoIncrementingColumn(pos++));
            hasAutoIncrementingColumn = true;
        }
        for (ColumnDef pkColDef : primaryKeyColumnDefs) {
            pkNames.add(pkColDef.getColName());
        }
        if (!isPrimaryKeyUnique) {
            pkNames.add(Schema.getAutoIncrementingColumnName());
        }
        LocalTable.ColumnMap cmap = new LocalTable.ColumnMap(columns, 0, fullTableName, false);
        return new LocalKuduTable(db, msTable, null, cmap, null, isPrimaryKeyUnique, pkNames, hasAutoIncrementingColumn, kuduPartitionParams);
    }

    private static void convertColsFromKudu(Schema schema, List<Column> cols, List<FieldSchema> fieldSchemas) {
        Preconditions.checkArgument((boolean)cols.isEmpty());
        Preconditions.checkArgument((boolean)fieldSchemas.isEmpty());
        int pos = 0;
        for (ColumnSchema colSchema : schema.getColumns()) {
            KuduColumn kuduCol;
            try {
                kuduCol = KuduColumn.fromColumnSchema(colSchema, pos++);
            }
            catch (ImpalaRuntimeException e) {
                throw new LocalCatalogException(e);
            }
            Preconditions.checkNotNull((Object)kuduCol);
            fieldSchemas.add(new FieldSchema(kuduCol.getName(), kuduCol.getType().toSql().toLowerCase(), null));
            cols.add(kuduCol);
        }
    }

    private LocalKuduTable(LocalDb db, Table msTable, MetaProvider.TableMetaRef ref, LocalTable.ColumnMap cmap, KuduTable kuduTable, boolean isPrimaryKeyUnique, List<String> primaryKeyColumnNames, boolean hasAutoIncrementingColumn, List<KuduPartitionParam> partitionBy) {
        super(db, msTable, ref, cmap);
        this.kuduTable_ = kuduTable;
        this.tableParams_ = new TableParams(msTable);
        this.partitionBy_ = ImmutableList.copyOf(partitionBy);
        this.isPrimaryKeyUnique_ = isPrimaryKeyUnique;
        this.primaryKeyColumnNames_ = ImmutableList.copyOf(primaryKeyColumnNames);
        this.hasAutoIncrementingColumn_ = hasAutoIncrementingColumn;
    }

    @Override
    public String getKuduMasterHosts() {
        return this.tableParams_.masters_;
    }

    @Override
    public String getKuduTableName() {
        return this.tableParams_.kuduTableName_;
    }

    public KuduTable getKuduTable() {
        return this.kuduTable_;
    }

    @Override
    public boolean isPrimaryKeyUnique() {
        return this.isPrimaryKeyUnique_;
    }

    @Override
    public boolean hasAutoIncrementingColumn() {
        return this.hasAutoIncrementingColumn_;
    }

    @Override
    public List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames_;
    }

    @Override
    public List<KuduPartitionParam> getPartitionBy() {
        return this.partitionBy_;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.KUDU_TABLE, this.getTColumnDescriptors(), this.getNumClusteringCols(), this.name_, this.db_.getName());
        desc.setKuduTable(this.toTKuduTable());
        return desc;
    }

    public TKuduTable toTKuduTable() {
        TKuduTable tbl = new TKuduTable();
        tbl.setIs_primary_key_unique(this.isPrimaryKeyUnique_);
        tbl.setHas_auto_incrementing(this.hasAutoIncrementingColumn_);
        tbl.setKey_columns((List)Preconditions.checkNotNull(this.primaryKeyColumnNames_));
        tbl.setMaster_addresses(this.tableParams_.getMastersAsList());
        tbl.setTable_name(this.tableParams_.kuduTableName_);
        Preconditions.checkNotNull(this.partitionBy_);
        tbl.partition_by = new ArrayList<TKuduPartitionParam>();
        for (KuduPartitionParam partitionParam : this.partitionBy_) {
            tbl.addToPartition_by(partitionParam.toThrift());
        }
        return tbl;
    }

    @Immutable
    private static class TableParams {
        private final String kuduTableName_;
        private final String masters_;

        TableParams(Table msTable) {
            String fullTableName = msTable.getDbName() + "." + msTable.getTableName();
            Map params = msTable.getParameters();
            this.kuduTableName_ = (String)params.get("kudu.table_name");
            if (this.kuduTableName_ == null) {
                throw new LocalCatalogException("No kudu.table_name property found for table " + fullTableName);
            }
            this.masters_ = (String)params.get("kudu.master_addresses");
            if (this.masters_ == null) {
                throw new LocalCatalogException("No kudu.master_addresses property found for table " + fullTableName);
            }
        }

        public List<String> getMastersAsList() {
            return Lists.newArrayList((Object[])this.masters_.split(","));
        }

        public KuduTable openTable() throws TableLoadingException {
            KuduTable kuduTable;
            KuduClient kuduClient = KuduUtil.getKuduClient(this.masters_);
            try {
                kuduTable = kuduClient.openTable(this.kuduTableName_);
            }
            catch (KuduException e) {
                throw new TableLoadingException(String.format("Error opening Kudu table '%s', Kudu error: %s", this.kuduTableName_, e.getMessage()));
            }
            return kuduTable;
        }
    }
}

