/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;

public class LocalHbaseTable
extends LocalTable
implements FeHBaseTable {
    private String hbaseTableName_;
    private HColumnDescriptor[] columnFamilies_ = null;

    private LocalHbaseTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref, LocalTable.ColumnMap cols) {
        super(db, msTbl, ref, cols);
        this.hbaseTableName_ = FeHBaseTable.Util.getHBaseTableName(msTbl);
    }

    static LocalHbaseTable loadFromHbase(LocalDb db, Table msTable, MetaProvider.TableMetaRef ref) {
        try {
            FeHBaseTable.Util.getHBaseTable(FeHBaseTable.Util.getHBaseTableName(msTable)).close();
            LocalTable.ColumnMap cmap = new LocalTable.ColumnMap(FeHBaseTable.Util.loadColumns(msTable), 1, msTable.getDbName() + "." + msTable.getTableName(), false);
            return new LocalHbaseTable(db, msTable, ref, cmap);
        }
        catch (IOException | MetaException | SerDeException e) {
            throw new LocalCatalogException(e);
        }
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDescriptor = new TTableDescriptor(tableId, TTableType.HBASE_TABLE, this.getTColumnDescriptors(), 1, this.getHBaseTableName(), this.db_.getName());
        tableDescriptor.setHbaseTable(FeHBaseTable.Util.getTHBaseTable(this));
        return tableDescriptor;
    }

    @Override
    public Pair<Long, Long> getEstimatedRowStats(byte[] startRowKey, byte[] endRowKey) {
        return FeHBaseTable.Util.getEstimatedRowStats(this, startRowKey, endRowKey);
    }

    @Override
    public String getHBaseTableName() {
        return this.hbaseTableName_;
    }

    @Override
    public TResultSet getTableStats() {
        return FeHBaseTable.Util.getTableStats(this);
    }

    @Override
    public HColumnDescriptor[] getColumnFamilies() throws IOException {
        if (this.columnFamilies_ == null) {
            try (org.apache.hadoop.hbase.client.Table hBaseTable = FeHBaseTable.Util.getHBaseTable(this.getHBaseTableName());){
                this.columnFamilies_ = hBaseTable.getTableDescriptor().getColumnFamilies();
            }
        }
        return this.columnFamilies_;
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        return this.getColumns();
    }

    @Override
    public String getStorageHandlerClassName() {
        return "org.apache.hadoop.hive.hbase.HBaseStorageHandler";
    }
}

