/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalFsPartition;
import org.apache.impala.catalog.local.LocalPartitionSpec;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.AvroSchemaConverter;
import org.apache.impala.util.AvroSchemaUtils;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TException;

public class LocalFsTable
extends LocalTable
implements FeFsTable {
    ImmutableMap<Long, LocalPartitionSpec> partitionSpecs_;
    private List<TreeMap<LiteralExpr, Set<Long>>> partitionValueMap_;
    private List<Set<Long>> nullPartitionIds_;
    private final String nullColumnValue_;
    private final ListMap<TNetworkAddress> hostIndex_ = new ListMap();
    private SqlConstraints sqlConstraints_;
    private String avroSchema_;
    private final boolean isMarkedCached_;

    public static LocalFsTable load(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) {
        String fullName = msTbl.getDbName() + "." + msTbl.getTableName();
        try {
            LocalTable.ColumnMap cmap;
            String avroSchema = LocalFsTable.loadAvroSchema(msTbl);
            if (LocalFsTable.isAvroFormat(msTbl)) {
                if (avroSchema == null) {
                    Schema inferredSchema = AvroSchemaConverter.convertFieldSchemas(msTbl.getSd().getCols(), fullName);
                    avroSchema = inferredSchema.toString();
                }
                List<FieldSchema> reconciledFieldSchemas = AvroSchemaUtils.reconcileAvroSchema(msTbl, avroSchema);
                Table msTblWithExplicitAvroSchema = msTbl.deepCopy();
                msTblWithExplicitAvroSchema.getSd().setCols(reconciledFieldSchemas);
                cmap = LocalTable.ColumnMap.fromMsTable(msTblWithExplicitAvroSchema);
            } else {
                cmap = LocalTable.ColumnMap.fromMsTable(msTbl);
            }
            return new LocalFsTable(db, msTbl, ref, cmap, avroSchema);
        }
        catch (AnalysisException e) {
            throw new LocalCatalogException("Failed to load Avro schema for table " + fullName);
        }
    }

    private LocalFsTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref, LocalTable.ColumnMap cmap, String explicitAvroSchema) {
        super(db, msTbl, ref, cmap);
        String tableNullFormat = (String)msTbl.getParameters().get("serialization.null.format");
        this.nullColumnValue_ = tableNullFormat != null ? tableNullFormat : "\\N";
        this.avroSchema_ = explicitAvroSchema;
        boolean bl = this.isMarkedCached_ = ref != null && ref.isMarkedCached();
        if (ref != null) {
            this.addVirtualColumns(ref.getVirtualColumns());
        }
    }

    private static String loadAvroSchema(Table msTbl) throws AnalysisException {
        ImmutableList schemaSearchLocations = ImmutableList.of((Object)msTbl.getSd().getSerdeInfo().getParameters(), (Object)msTbl.getParameters());
        return AvroSchemaUtils.getAvroSchema((List<Map<String, String>>)schemaSearchLocations);
    }

    public static LocalFsTable createCtasTarget(LocalDb db, Table msTbl) throws CatalogException {
        return new LocalFsTable(db, msTbl, null, LocalTable.ColumnMap.fromMsTable(msTbl), null);
    }

    @Override
    public boolean isCacheable() {
        if (!this.isLocationCacheable()) {
            return false;
        }
        if (!this.isMarkedCached() && this.getNumClusteringCols() > 0) {
            this.loadPartitionSpecs();
            for (FeFsPartition feFsPartition : this.loadPartitions((Collection<Long>)this.partitionSpecs_.keySet())) {
                if (feFsPartition.isCacheable()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isLocationCacheable() {
        return FileSystemUtil.isPathCacheable(new Path(this.getLocation()));
    }

    @Override
    public boolean isMarkedCached() {
        return this.isMarkedCached_;
    }

    @Override
    public String getLocation() {
        return this.getMetaStoreTable().getSd().getLocation();
    }

    @Override
    public String getNullPartitionKeyValue() {
        return this.db_.getCatalog().getNullPartitionKeyValue();
    }

    @Override
    public String getHdfsBaseDir() {
        return this.getLocation();
    }

    @Override
    public long getTotalHdfsBytes() {
        long size = 0L;
        for (FeFsPartition feFsPartition : this.loadPartitions(this.getPartitionIds())) {
            size += feFsPartition.getSize();
        }
        return size;
    }

    @Override
    public boolean usesAvroSchemaOverride() {
        return LocalFsTable.isAvroFormat(this.msTable_);
    }

    @Override
    public Set<HdfsFileFormat> getFileFormats() {
        Collection<Object> parts = this.ref_ != null ? this.loadAllPartitions() : Collections.emptyList();
        Iterable partitionsToConsider = Iterables.concat(parts, Collections.singleton(this.createPrototypePartition()));
        return FeCatalogUtils.getFileFormats(partitionsToConsider);
    }

    @Override
    public boolean hasWriteAccessToBaseDir() {
        return true;
    }

    @Override
    public String getFirstLocationWithoutWriteAccess() {
        return null;
    }

    @Override
    public boolean isHiveAcid() {
        return AcidUtils.isTransactionalTable(this.getMetaStoreTable().getParameters());
    }

    @Override
    public FileSystemUtil.FsType getFsType() {
        Preconditions.checkNotNull((Object)this.getHdfsBaseDir(), (Object)"LocalTable base dir is null");
        Path hdfsBaseDirPath = new Path(this.getHdfsBaseDir());
        Preconditions.checkNotNull((Object)hdfsBaseDirPath.toUri().getScheme(), (Object)("Cannot get scheme from path " + this.getHdfsBaseDir()));
        return FileSystemUtil.FsType.getFsType(hdfsBaseDirPath.toUri().getScheme());
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDesc = new TTableDescriptor(tableId, TTableType.HDFS_TABLE, this.getTColumnDescriptors(), this.getNumClusteringCols(), this.name_, this.db_.getName());
        tableDesc.setHdfsTable(this.toTHdfsTable(referencedPartitions, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return tableDesc;
    }

    public THdfsTable toTHdfsTable(CatalogObject.ThriftObjectType type) {
        return this.toTHdfsTable(null, type);
    }

    private THdfsTable toTHdfsTable(Set<Long> referencedPartitions, CatalogObject.ThriftObjectType type) {
        if (referencedPartitions == null) {
            referencedPartitions = this.getPartitionIds();
        }
        HashMap<Long, THdfsPartition> idToPartition = new HashMap<Long, THdfsPartition>();
        List<? extends FeFsPartition> partitions = this.loadPartitions(referencedPartitions);
        for (FeFsPartition feFsPartition : partitions) {
            idToPartition.put(feFsPartition.getId(), FeCatalogUtils.fsPartitionToThrift(feFsPartition, type));
        }
        THdfsPartition tPrototypePartition = FeCatalogUtils.fsPartitionToThrift(this.createPrototypePartition(), CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY);
        THdfsTable tHdfsTable = new THdfsTable(this.getHdfsBaseDir(), this.getColumnNames(), this.getNullPartitionKeyValue(), this.nullColumnValue_, idToPartition, tPrototypePartition);
        tHdfsTable.setHas_full_partitions(true);
        if (this.avroSchema_ != null) {
            tHdfsTable.setAvroSchema(this.avroSchema_);
        } else if (LocalFsTable.hasAnyAvroPartition(partitions)) {
            tHdfsTable.setAvroSchema(AvroSchemaConverter.convertFieldSchemas(this.getMetaStoreTable().getSd().getCols(), this.getFullName()).toString());
        }
        if (AcidUtils.isFullAcidTable(this.getMetaStoreTable().getParameters())) {
            tHdfsTable.setIs_full_acid(true);
        }
        if (this.ref_ != null) {
            TValidWriteIdList validWriteIdList = this.db_.getCatalog().getMetaProvider().getValidWriteIdList(this.ref_);
            if (validWriteIdList != null) {
                tHdfsTable.setValid_write_ids(validWriteIdList);
            }
            tHdfsTable.setPartition_prefixes(this.ref_.getPartitionPrefixes());
        }
        if (type == CatalogObject.ThriftObjectType.FULL) {
            tHdfsTable.setNetwork_addresses(this.hostIndex_.getList());
            tHdfsTable.setSql_constraints(this.getSqlConstraints().toThrift());
        }
        return tHdfsTable;
    }

    private static boolean isAvroFormat(Table msTbl) {
        String serDeLib;
        String inputFormat = msTbl.getSd().getInputFormat();
        return HdfsFileFormat.fromJavaClassName(inputFormat, serDeLib = msTbl.getSd().getSerdeInfo().getSerializationLib()) == HdfsFileFormat.AVRO;
    }

    private static boolean hasAnyAvroPartition(List<? extends FeFsPartition> partitions) {
        for (FeFsPartition feFsPartition : partitions) {
            if (feFsPartition.getFileFormat() != HdfsFileFormat.AVRO) continue;
            return true;
        }
        return false;
    }

    protected void setAvroSchema(Table msTbl) {
        if (this.avroSchema_ == null) {
            Schema inferredSchema = AvroSchemaConverter.convertFieldSchemas(msTbl.getSd().getCols(), msTbl.getDbName() + "." + msTbl.getTableName());
            this.avroSchema_ = inferredSchema.toString();
        }
    }

    protected String getAvroSchema() {
        return this.avroSchema_;
    }

    public LocalFsPartition createPrototypePartition() {
        StorageDescriptor sd = this.getMetaStoreTable().getSd().deepCopy();
        sd.unsetLocation();
        HdfsStorageDescriptor hdfsStorageDescriptor = null;
        try {
            hdfsStorageDescriptor = HdfsStorageDescriptor.fromStorageDescriptor(this.name_, sd);
        }
        catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
            Preconditions.checkState((boolean)false, (Object)"Failed to create prototype partition HdfsStorageDescriptor using sd of table");
        }
        LocalPartitionSpec spec = new LocalPartitionSpec(-1L);
        return new LocalFsPartition(this, spec, Collections.emptyMap(), -1L, hdfsStorageDescriptor, null, null, null, null, false, false, null);
    }

    @Override
    public Collection<? extends PrunablePartition> getPartitions() {
        this.loadPartitionSpecs();
        return this.partitionSpecs_.values();
    }

    @Override
    public Set<Long> getPartitionIds() {
        this.loadPartitionSpecs();
        return this.partitionSpecs_.keySet();
    }

    @Override
    public Map<Long, ? extends PrunablePartition> getPartitionMap() {
        this.loadPartitionSpecs();
        return this.partitionSpecs_;
    }

    @Override
    public TreeMap<LiteralExpr, Set<Long>> getPartitionValueMap(int col) {
        this.loadPartitionValueMap();
        return this.partitionValueMap_.get(col);
    }

    @Override
    public Set<Long> getNullPartitionIds(int colIdx) {
        this.loadPartitionValueMap();
        return this.nullPartitionIds_.get(colIdx);
    }

    @Override
    public List<? extends FeFsPartition> loadPartitions(Collection<Long> ids) {
        Map<String, MetaProvider.PartitionMetadata> partsByName;
        Preconditions.checkState((this.partitionSpecs_ != null ? 1 : 0) != 0, (Object)"Cannot load partitions without having fetched partition IDs from the same LocalFsTable instance");
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaProvider.PartitionRef> refs = new ArrayList<MetaProvider.PartitionRef>();
        for (Long id : ids) {
            LocalPartitionSpec spec = (LocalPartitionSpec)this.partitionSpecs_.get((Object)id);
            Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (String)"Invalid partition ID for table %s: %s", (Object)this.getFullName(), (Object)id);
            refs.add((MetaProvider.PartitionRef)Preconditions.checkNotNull((Object)spec.getRef()));
        }
        try {
            partsByName = this.db_.getCatalog().getMetaProvider().loadPartitionsByRefs(this.ref_, this.getClusteringColumnNames(), this.hostIndex_, refs);
        }
        catch (CatalogException | TException e) {
            throw new LocalCatalogException("Could not load partitions for table " + this.getFullName(), e);
        }
        ArrayList ret = Lists.newArrayListWithCapacity((int)ids.size());
        for (Long id : ids) {
            LocalPartitionSpec spec = (LocalPartitionSpec)this.partitionSpecs_.get((Object)id);
            MetaProvider.PartitionMetadata p = partsByName.get(spec.getRef().getName());
            if (p == null) {
                throw new LocalCatalogException("Could not load expected partitions for table " + this.getFullName() + ": missing expected partition with name '" + spec.getRef().getName() + "' (perhaps it was concurrently dropped by another process)");
            }
            ImmutableList<FileDescriptor> fds = p.getInsertFileDescriptors().isEmpty() ? p.getFileDescriptors() : ImmutableList.of();
            LocalFsPartition part = new LocalFsPartition(this, spec, p.getHmsParameters(), p.getWriteId(), p.getInputFormatDescriptor(), fds, p.getInsertFileDescriptors(), p.getDeleteFileDescriptors(), p.getPartitionStats(), p.hasIncrementalStats(), p.isMarkedCached(), p.getLocation());
            ret.add(part);
        }
        return ret;
    }

    private List<String> getClusteringColumnNames() {
        ArrayList names = Lists.newArrayListWithCapacity((int)this.getNumClusteringCols());
        for (Column c : this.getClusteringColumns()) {
            names.add(c.getName());
        }
        return names;
    }

    private void loadPartitionValueMap() {
        if (this.partitionValueMap_ != null) {
            return;
        }
        this.loadPartitionSpecs();
        ArrayList<TreeMap<LiteralExpr, Set<Long>>> valMapByCol = new ArrayList<TreeMap<LiteralExpr, Set<Long>>>();
        ArrayList<Set<Long>> nullParts = new ArrayList<Set<Long>>();
        for (int i = 0; i < this.getNumClusteringCols(); ++i) {
            valMapByCol.add(new TreeMap());
            nullParts.add(new HashSet());
        }
        for (LocalPartitionSpec partition : this.partitionSpecs_.values()) {
            List<LiteralExpr> vals = partition.getPartitionValues();
            for (int i = 0; i < this.getNumClusteringCols(); ++i) {
                LiteralExpr val = vals.get(i);
                if (Expr.IS_NULL_LITERAL.apply((Object)val)) {
                    ((Set)nullParts.get(i)).add(partition.getId());
                    continue;
                }
                HashSet<Long> ids = (HashSet<Long>)((TreeMap)valMapByCol.get(i)).get(val);
                if (ids == null) {
                    ids = new HashSet<Long>();
                    ((TreeMap)valMapByCol.get(i)).put(val, ids);
                }
                ids.add(partition.getId());
            }
        }
        this.partitionValueMap_ = valMapByCol;
        this.nullPartitionIds_ = nullParts;
    }

    private void loadPartitionSpecs() {
        List<MetaProvider.PartitionRef> partList;
        if (this.partitionSpecs_ != null) {
            return;
        }
        if (this.ref_ == null) {
            this.partitionSpecs_ = ImmutableMap.of();
            return;
        }
        try {
            partList = this.db_.getCatalog().getMetaProvider().loadPartitionList(this.ref_);
        }
        catch (TException e) {
            throw new LocalCatalogException("Could not load partition names for table " + this.getFullName(), e);
        }
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        long id = 0L;
        for (MetaProvider.PartitionRef part : partList) {
            b.put((Object)id, (Object)new LocalPartitionSpec(this, part, id));
            ++id;
        }
        this.partitionSpecs_ = b.build();
    }

    private void loadConstraints() throws TException {
        if (this.sqlConstraints_ != null) {
            return;
        }
        this.sqlConstraints_ = this.db_.getCatalog().getMetaProvider().loadConstraints(this.ref_, this.msTable_);
    }

    @Override
    protected void loadColumnStats() {
        super.loadColumnStats();
        this.loadPartitionValueMap();
        for (int i = 0; i < this.getNumClusteringCols(); ++i) {
            ColumnStats stats = ((Column)this.getColumns().get(i)).getStats();
            int nonNullParts = this.partitionValueMap_.get(i).size();
            int nullParts = this.nullPartitionIds_.get(i).size();
            stats.setNumDistinctValues(nonNullParts + (nullParts > 0 ? 1 : 0));
            stats.setNumNulls(nullParts);
        }
    }

    @Override
    public ListMap<TNetworkAddress> getHostIndex() {
        return this.hostIndex_;
    }

    @Override
    public SqlConstraints getSqlConstraints() {
        try {
            this.loadConstraints();
        }
        catch (TException e) {
            throw new LocalCatalogException("Failed to load primary keys/foreign keys for table " + this.getFullName(), e);
        }
        return this.sqlConstraints_;
    }

    public List<String> getPartitionPrefixes() {
        return this.ref_ == null ? Collections.emptyList() : this.ref_.getPartitionPrefixes();
    }
}

