/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.local.FailedLoadLocalTable;
import org.apache.impala.catalog.local.LocalCatalog;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.catalog.local.LocalIncompleteTable;
import org.apache.impala.catalog.local.LocalKuduTable;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.util.FunctionUtils;
import org.apache.impala.util.PatternMatcher;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDb
implements FeDb {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDb.class);
    private final LocalCatalog catalog_;
    private final String name_;
    private Database msDb_;
    private Map<String, FeTable> tables_;
    private Map<String, List<Function>> functions_;

    public LocalDb(LocalCatalog catalog, String dbName) {
        Preconditions.checkNotNull((Object)catalog);
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkArgument((boolean)dbName.toLowerCase().equals(dbName));
        this.catalog_ = catalog;
        this.name_ = dbName;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public Database getMetaStoreDb() {
        if (this.msDb_ == null) {
            try {
                this.msDb_ = this.catalog_.getMetaProvider().loadDb(this.name_);
            }
            catch (TException e) {
                throw new LocalCatalogException(String.format("Could not load database '%s' from HMS", this.name_), e);
            }
        }
        return this.msDb_;
    }

    @Override
    public boolean containsTable(String tableName) {
        this.loadTableNames();
        return this.tables_.containsKey(tableName.toLowerCase());
    }

    @Override
    public FeTable getTableIfCached(String tblName) {
        Pair<Table, MetaProvider.TableMetaRef> tblMeta;
        Preconditions.checkNotNull((Object)tblName);
        tblName = tblName.toLowerCase();
        this.loadTableNames();
        if (!this.tables_.containsKey(tblName)) {
            return null;
        }
        FeTable tbl = this.tables_.get(tblName);
        if (tbl instanceof LocalIncompleteTable && tbl.getMetaStoreTable() == null && (tblMeta = this.catalog_.getMetaProvider().getTableIfPresent(this.name_, tblName)) != null) {
            tbl = new LocalIncompleteTable(this, (Table)tblMeta.first, (MetaProvider.TableMetaRef)tblMeta.second, tbl.getTableType(), tbl.getTableComment());
            this.tables_.put(tblName, tbl);
        }
        return tbl;
    }

    @Override
    public FeTable getTable(String tableName) {
        String tblName = ((String)Preconditions.checkNotNull((Object)tableName, (Object)"Received a null table name")).toLowerCase();
        FeTable tbl = this.getTableIfCached(tblName);
        if (tbl instanceof LocalIncompleteTable) {
            try {
                tbl = LocalTable.load(this, tblName);
            }
            catch (TableLoadingException tle) {
                tbl = new FailedLoadLocalTable(this, tblName, tbl.getTableType(), tbl.getTableComment(), tle);
            }
            this.tables_.put(tblName, tbl);
        }
        return tbl;
    }

    @Override
    public FeKuduTable createKuduCtasTarget(Table msTbl, List<ColumnDef> columnDefs, List<ColumnDef> primaryKeyColumnDefs, boolean isPrimaryKeyUnique, List<KuduPartitionParam> kuduPartitionParams) throws ImpalaRuntimeException {
        return LocalKuduTable.createCtasTarget(this, msTbl, columnDefs, isPrimaryKeyUnique, primaryKeyColumnDefs, kuduPartitionParams);
    }

    @Override
    public FeFsTable createFsCtasTarget(Table msTbl) throws CatalogException {
        return LocalFsTable.createCtasTarget(this, msTbl);
    }

    @Override
    public List<String> getAllTableNames() {
        return this.getAllTableNames(Collections.emptySet());
    }

    @Override
    public List<String> getAllTableNames(Set<TImpalaTableType> tableTypes) {
        this.loadTableNames();
        if (!tableTypes.isEmpty()) {
            return this.tables_.values().stream().filter(table -> tableTypes.stream().anyMatch(type -> type.equals((Object)table.getTableType()))).map(table -> table.getName()).collect(Collectors.toList());
        }
        return ImmutableList.copyOf(this.tables_.keySet());
    }

    private void loadTableNames() {
        if (this.tables_ != null) {
            return;
        }
        HashMap<String, FeTable> newMap = new HashMap<String, FeTable>();
        try {
            MetaProvider metaProvider = this.catalog_.getMetaProvider();
            for (TBriefTableMeta meta : metaProvider.loadTableList(this.name_)) {
                newMap.put(meta.getName(), new LocalIncompleteTable(this, meta));
            }
        }
        catch (TException e) {
            throw new LocalCatalogException(String.format("Could not load table names for database '%s' from HMS", this.name_), e);
        }
        this.tables_ = newMap;
    }

    @Override
    public boolean isSystemDb() {
        return false;
    }

    @Override
    public Function getFunction(Function desc, Function.CompareMode mode) {
        this.loadFunction(desc.functionName());
        List<Function> funcs = this.functions_.get(desc.functionName());
        if (funcs == null) {
            return null;
        }
        return FunctionUtils.resolveFunction(funcs, desc, mode);
    }

    private void loadFunctionNames() {
        List<String> funcNames;
        if (this.functions_ != null) {
            return;
        }
        try {
            funcNames = this.catalog_.getMetaProvider().loadFunctionNames(this.name_);
        }
        catch (TException e) {
            throw new LocalCatalogException(String.format("Could not load function names for database '%s'", this.name_), e);
        }
        this.functions_ = Maps.newHashMapWithExpectedSize((int)funcNames.size());
        for (String fn : funcNames) {
            this.functions_.put(fn, null);
        }
    }

    private void loadFunction(String functionName) {
        this.loadFunctionNames();
        if (!this.functions_.containsKey(functionName)) {
            return;
        }
        List<Function> overloads = this.functions_.get(functionName);
        if (overloads != null) {
            return;
        }
        try {
            overloads = this.catalog_.getMetaProvider().loadFunction(this.name_, functionName);
        }
        catch (TException e) {
            throw new LocalCatalogException(String.format("Could not load function '%s.%s'", this.name_, functionName), e);
        }
        this.functions_.put(functionName, overloads);
    }

    @Override
    public List<Function> getFunctions(String functionName) {
        this.loadFunction(functionName);
        List<Function> funcs = this.functions_.get(functionName);
        if (funcs == null) {
            return Collections.emptyList();
        }
        return FunctionUtils.getVisibleFunctions(funcs);
    }

    @Override
    public List<Function> getFunctions(TFunctionCategory category, String functionName) {
        this.loadFunction(functionName);
        List<Function> funcs = this.functions_.get(functionName);
        if (funcs == null) {
            return Collections.emptyList();
        }
        return FunctionUtils.getVisibleFunctionsInCategory(funcs, category);
    }

    @Override
    public List<Function> getFunctions(TFunctionCategory category, PatternMatcher matcher) {
        this.loadFunctionNames();
        ArrayList<Function> result = new ArrayList<Function>();
        Iterable fnNames = Iterables.filter(this.functions_.keySet(), (Predicate)matcher);
        for (String fnName : fnNames) {
            result.addAll(this.getFunctions(category, fnName));
        }
        return result;
    }

    @Override
    public int numFunctions() {
        this.loadFunctionNames();
        return this.functions_.size();
    }

    @Override
    public boolean containsFunction(String function) {
        this.loadFunctionNames();
        return this.functions_.containsKey(function);
    }

    @Override
    public TDatabase toThrift() {
        TDatabase tdb = new TDatabase(this.name_);
        tdb.setMetastore_db(this.getMetaStoreDb());
        return tdb;
    }

    LocalCatalog getCatalog() {
        return this.catalog_;
    }

    @Override
    public String getOwnerUser() {
        Database db = this.getMetaStoreDb();
        return db == null ? null : (db.getOwnerType() == PrincipalType.USER ? db.getOwnerName() : null);
    }
}

