/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.BuiltinsDb;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDataSource;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.PartitionNotFoundException;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.local.CatalogdMetaProvider;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TDataSource;
import org.apache.impala.thrift.TGetPartitionStatsResponse;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.PatternMatcher;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCatalog
implements FeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCatalog.class);
    private final MetaProvider metaProvider_;
    private Map<String, FeDb> dbs_ = new HashMap<String, FeDb>();
    private Map<String, HdfsCachePool> hdfsCachePools_ = null;
    private String nullPartitionKeyValue_;
    private TUniqueId catalogServiceId_ = Catalog.INITIAL_CATALOG_SERVICE_ID;

    public LocalCatalog(MetaProvider metaProvider) {
        this.metaProvider_ = (MetaProvider)Preconditions.checkNotNull((Object)metaProvider);
        if (metaProvider instanceof CatalogdMetaProvider) {
            this.catalogServiceId_ = ((CatalogdMetaProvider)metaProvider).getCatalogServiceId();
        }
    }

    public String getProviderURI() {
        return this.metaProvider_.getURI();
    }

    @Override
    public List<? extends FeDb> getDbs(PatternMatcher matcher) {
        this.loadDbs();
        return Catalog.filterCatalogObjectsByPattern(this.dbs_.values(), matcher);
    }

    private void loadDbs() {
        ImmutableList<String> names;
        if (!this.dbs_.isEmpty()) {
            return;
        }
        HashMap<String, FeDb> dbs = new HashMap<String, FeDb>();
        try {
            names = this.metaProvider_.loadDbList();
        }
        catch (TException e) {
            throw new LocalCatalogException("Unable to load database names", e);
        }
        for (String dbName : names) {
            if (this.dbs_.containsKey(dbName = dbName.toLowerCase())) {
                dbs.put(dbName, this.dbs_.get(dbName));
                continue;
            }
            dbs.put(dbName, new LocalDb(this, dbName));
        }
        Db bdb = BuiltinsDb.getInstance();
        dbs.put(bdb.getName(), bdb);
        this.dbs_ = dbs;
    }

    @Override
    public List<String> getTableNames(String dbName, PatternMatcher matcher) throws DatabaseNotFoundException {
        return this.getTableNames(dbName, matcher, Collections.emptySet());
    }

    @Override
    public List<String> getTableNames(String dbName, PatternMatcher matcher, Set<TImpalaTableType> tableTypes) throws DatabaseNotFoundException {
        FeDb db = this.getDbOrThrow(dbName);
        return Catalog.filterStringsByPattern(db.getAllTableNames(tableTypes), matcher);
    }

    @Override
    public FeTable getTable(String dbName, String tableName) throws DatabaseNotFoundException {
        return this.getDbOrThrow(dbName).getTable(tableName);
    }

    @Override
    public FeTable getTableNoThrow(String dbName, String tableName) {
        try {
            return this.getTable(dbName, tableName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public FeTable getTableIfCached(String dbName, String tableName) throws DatabaseNotFoundException {
        return this.getDbOrThrow(dbName).getTableIfCached(tableName);
    }

    @Override
    public FeTable getTableIfCachedNoThrow(String dbName, String tableName) {
        try {
            return this.getTableIfCached(dbName, tableName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public TCatalogObject getTCatalogObject(TCatalogObject objectDesc) throws CatalogException {
        Preconditions.checkNotNull((Object)objectDesc, (Object)"invalid objectDesc");
        if (objectDesc.type == TCatalogObjectType.DATA_SOURCE) {
            TDataSource dsDesc = (TDataSource)Preconditions.checkNotNull((Object)objectDesc.data_source);
            String dsName = dsDesc.getName();
            if (dsName != null && !dsName.isEmpty()) {
                try {
                    DataSource ds = this.metaProvider_.loadDataSource(dsName);
                    if (ds != null) {
                        TCatalogObject resultObj = new TCatalogObject();
                        resultObj.setType(TCatalogObjectType.DATA_SOURCE);
                        resultObj.setData_source(ds.toThrift());
                        return resultObj;
                    }
                }
                catch (Exception e) {
                    LOG.info("Data source not found: " + dsName + ", " + e.getMessage());
                }
            }
            throw new CatalogException("Data source not found: " + dsName);
        }
        throw new UnsupportedOperationException("LocalCatalog.getTCatalogObject");
    }

    @Override
    public FeDb getDb(String db) {
        this.loadDbs();
        return this.dbs_.get(db.toLowerCase());
    }

    private FeDb getDbOrThrow(String dbName) throws DatabaseNotFoundException {
        Preconditions.checkNotNull((Object)dbName);
        FeDb db = this.getDb(dbName);
        if (db == null) {
            throw new DatabaseNotFoundException("Database '" + dbName + "' not found");
        }
        return db;
    }

    private void throwPartitionNotFound(List<TPartitionKeyValue> partitionSpec) throws PartitionNotFoundException {
        throw new PartitionNotFoundException("Partition not found: " + Joiner.on((String)", ").join(partitionSpec));
    }

    @Override
    public FeFsPartition getHdfsPartition(String db, String tbl, List<TPartitionKeyValue> partitionSpec) throws CatalogException {
        PrunablePartition partition;
        FeTable table = this.getTable(db, tbl);
        if (!(table instanceof FeFsTable)) {
            this.throwPartitionNotFound(partitionSpec);
        }
        if ((partition = FeFsTable.Utils.getPartitionFromThriftPartitionSpec((FeFsTable)table, partitionSpec)) == null) {
            this.throwPartitionNotFound(partitionSpec);
        }
        return ((FeFsTable)table).loadPartition(partition.getId());
    }

    @Override
    public List<? extends FeDataSource> getDataSources(PatternMatcher matcher) {
        try {
            ImmutableList<DataSource> dataSrcs = this.metaProvider_.loadDataSources();
            return Catalog.filterCatalogObjectsByPattern(dataSrcs, matcher);
        }
        catch (TException e) {
            LOG.error("Unable to load DataSource objects. Returning empty list. ", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public FeDataSource getDataSource(String dsName) {
        Preconditions.checkNotNull((Object)dsName);
        try {
            return this.metaProvider_.loadDataSource(dsName);
        }
        catch (Exception e) {
            LOG.info("DataSource not found: " + dsName, (Throwable)e);
            return null;
        }
    }

    @Override
    public Function getFunction(Function desc, Function.CompareMode mode) {
        FeDb db = this.getDb(desc.dbName());
        if (db == null) {
            return null;
        }
        return db.getFunction(desc, mode);
    }

    @Override
    public HdfsCachePool getHdfsCachePool(String poolName) {
        this.loadHdfsCachePools();
        return this.hdfsCachePools_.get(poolName);
    }

    private void loadHdfsCachePools() {
        if (this.hdfsCachePools_ != null) {
            return;
        }
        this.hdfsCachePools_ = new HashMap<String, HdfsCachePool>();
        for (HdfsCachePool pool : this.metaProvider_.getHdfsCachePools()) {
            this.hdfsCachePools_.put(pool.getName(), pool);
        }
    }

    @Override
    public void prioritizeLoad(Set<TableName> tableNames, TUniqueId queryId) {
    }

    @Override
    public TGetPartitionStatsResponse getPartitionStats(TableName table) throws InternalException {
        throw new UnsupportedOperationException("Stats are eagerly fetched in LocalCatalog");
    }

    @Override
    public void waitForCatalogUpdate(long timeoutMs) {
        this.metaProvider_.waitForIsReady(timeoutMs);
    }

    @Override
    public TUniqueId getCatalogServiceId() {
        return this.catalogServiceId_;
    }

    @Override
    public AuthorizationPolicy getAuthPolicy() {
        return this.metaProvider_.getAuthPolicy();
    }

    public String getNullPartitionKeyValue() {
        if (this.nullPartitionKeyValue_ == null) {
            try {
                this.nullPartitionKeyValue_ = this.metaProvider_.loadNullPartitionKeyValue();
            }
            catch (TException e) {
                throw new LocalCatalogException("Could not load null partition key value", e);
            }
        }
        return this.nullPartitionKeyValue_;
    }

    @Override
    public boolean isReady() {
        return this.metaProvider_.isReady();
    }

    @Override
    public void setIsReady(boolean isReady) {
        this.metaProvider_.setIsReady(isReady);
    }

    public MetaProvider getMetaProvider() {
        return this.metaProvider_;
    }
}

