/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergFileMetadataLoader;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.PuffinStatsLoader;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.catalog.iceberg.IcebergRESTCatalog;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Pair;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TIcebergContentFileStore;
import org.apache.impala.thrift.TIcebergPartition;
import org.apache.impala.thrift.TIcebergTable;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMetaProvider
implements MetaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergMetaProvider.class);
    private AtomicReference<? extends AuthorizationChecker> authzChecker_;
    private final AuthorizationPolicy authPolicy_ = new AuthorizationPolicy();
    private IcebergRESTCatalog iceCatalog_;
    Properties properties_;

    public IcebergMetaProvider(Properties properties) {
        this.properties_ = properties;
        this.iceCatalog_ = new IcebergRESTCatalog(properties);
    }

    @Override
    public String getURI() {
        return "Iceberg REST (" + this.iceCatalog_.getUri() + ")";
    }

    public void setAuthzChecker(AtomicReference<? extends AuthorizationChecker> authzChecker) {
        this.authzChecker_ = authzChecker;
    }

    @Override
    public Iterable<HdfsCachePool> getHdfsCachePools() {
        throw new UnsupportedOperationException("HDFSCachePools are not supported in IcebergMetaProvider");
    }

    @Override
    public AuthorizationPolicy getAuthPolicy() {
        return this.authPolicy_;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void waitForIsReady(long timeoutMs) {
    }

    @Override
    public ImmutableList<String> loadDbList() throws TException {
        return this.iceCatalog_.listNamespaces();
    }

    @Override
    public Database loadDb(String dbName) throws TException {
        Database db = new Database();
        db.setName(dbName);
        return db;
    }

    @Override
    public ImmutableCollection<TBriefTableMeta> loadTableList(String dbName) throws TException {
        ImmutableList.Builder ret = ImmutableList.builder();
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        for (TableIdentifier tid : this.iceCatalog_.listTables(ns.toString())) {
            TBriefTableMeta briefMeta = new TBriefTableMeta(tid.name());
            briefMeta.setMsType("TABLE");
            ret.add((Object)briefMeta);
        }
        return ret.build();
    }

    String getIcebergTableName(org.apache.iceberg.Table tbl) {
        return tbl.name().substring(tbl.name().lastIndexOf(46) + 1);
    }

    @Override
    public Pair<Table, MetaProvider.TableMetaRef> getTableIfPresent(String dbName, String tblName) {
        try {
            return this.loadTable(dbName, tblName);
        }
        catch (TException e) {
            LOG.error("Failed to load table", (Throwable)e);
            return null;
        }
    }

    @Override
    public Pair<Table, MetaProvider.TableMetaRef> loadTable(String dbName, String tableName) throws TException {
        try {
            Table msTable = new Table();
            msTable.setDbName(dbName);
            Namespace ns = Namespace.of((String[])new String[]{dbName});
            org.apache.iceberg.Table tbl = this.iceCatalog_.loadTable(TableIdentifier.of((Namespace)ns, (String)tableName), null, null);
            msTable.setTableName(this.getIcebergTableName(tbl));
            msTable.setSd(this.createStorageDescriptor(tbl));
            msTable.setPartitionKeys(Collections.emptyList());
            msTable.setParameters(this.createTableProps(tbl));
            msTable.setTableType(TableType.EXTERNAL_TABLE.toString());
            MetastoreShim.setTableAccessType(msTable, (byte)2);
            long loadingTime = System.currentTimeMillis();
            TableMetaRefImpl ref = new TableMetaRefImpl(dbName, tableName, msTable, tbl, loadingTime);
            return Pair.create(msTable, ref);
        }
        catch (IcebergTableLoadingException | ImpalaRuntimeException e) {
            throw new IllegalStateException(String.format("Error loading Iceberg table %s.%s", dbName, tableName), e);
        }
    }

    private StorageDescriptor createStorageDescriptor(org.apache.iceberg.Table tbl) throws ImpalaRuntimeException {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setInputFormat(HdfsFileFormat.ICEBERG.inputFormat());
        sd.setOutputFormat(HdfsFileFormat.ICEBERG.outputFormat());
        sd.setSortCols(Collections.emptyList());
        SerDeInfo serde = new SerDeInfo();
        serde.setSerializationLib(HdfsFileFormat.ICEBERG.serializationLib());
        serde.setParameters(Collections.emptyMap());
        sd.setSerdeInfo(serde);
        sd.setCols(IcebergSchemaConverter.convertToHiveSchema(tbl.schema()));
        Path p = new Path(tbl.location());
        sd.setLocation(FileSystemUtil.createFullyQualifiedPath(p).toString());
        return sd;
    }

    private Map<String, String> createTableProps(org.apache.iceberg.Table tbl) {
        HashMap<String, String> props = new HashMap<String, String>(tbl.properties());
        Snapshot currentSnapshot = tbl.currentSnapshot();
        if (currentSnapshot != null) {
            if (props.get("numRows") == null) {
                props.put("numRows", String.valueOf(currentSnapshot.summary().get("total-records")));
            }
            if (props.get("totalSize") == null) {
                props.put("totalSize", String.valueOf(currentSnapshot.summary().get("total-files-size")));
            }
        }
        return props;
    }

    @Override
    public String loadNullPartitionKeyValue() throws MetaException, TException {
        return "__HIVE_DEFAULT_PARTITION__";
    }

    @Override
    public List<MetaProvider.PartitionRef> loadPartitionList(MetaProvider.TableMetaRef table) throws MetaException, TException {
        TableMetaRefImpl ref = (TableMetaRefImpl)table;
        Preconditions.checkState((!ref.isPartitioned() ? 1 : 0) != 0);
        return ImmutableList.of((Object)new PartitionRefImpl(""));
    }

    @Override
    public SqlConstraints loadConstraints(MetaProvider.TableMetaRef table, Table msTbl) throws TException {
        return null;
    }

    @Override
    public Map<String, MetaProvider.PartitionMetadata> loadPartitionsByRefs(MetaProvider.TableMetaRef table, List<String> partitionColumnNames, ListMap<TNetworkAddress> hostIndex, List<MetaProvider.PartitionRef> partitionRefs) throws CatalogException, TException {
        HashMap<String, MetaProvider.PartitionMetadata> ret = new HashMap<String, MetaProvider.PartitionMetadata>();
        ret.put("", new PartitionMetadataImpl(((TableMetaRefImpl)table).msTable_));
        return ret;
    }

    private Map<String, MetaProvider.PartitionMetadata> loadUnpartitionedPartition(TableMetaRefImpl table, List<MetaProvider.PartitionRef> partitionRefs, ListMap<TNetworkAddress> hostIndex) throws CatalogException {
        HashMap<String, MetaProvider.PartitionMetadata> ret = new HashMap<String, MetaProvider.PartitionMetadata>();
        ret.put("", new PartitionMetadataImpl(table.msTable_));
        return ret;
    }

    @Override
    public List<String> loadFunctionNames(String dbName) throws TException {
        throw new UnsupportedOperationException("Functions not supported by IcebergMetaProvider");
    }

    @Override
    public ImmutableList<Function> loadFunction(String dbName, String functionName) throws TException {
        throw new UnsupportedOperationException("Functions not supported by IcebergMetaProvider");
    }

    @Override
    public ImmutableList<DataSource> loadDataSources() throws TException {
        throw new UnsupportedOperationException("DataSource not supported by IcebergMetaProvider");
    }

    @Override
    public DataSource loadDataSource(String dsName) throws TException {
        throw new UnsupportedOperationException("DataSource not supported by IcebergMetaProvider");
    }

    @Override
    public List<ColumnStatisticsObj> loadTableColumnStatistics(MetaProvider.TableMetaRef table, List<String> colNames) throws TException {
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        TableMetaRefImpl tblImpl = (TableMetaRefImpl)table;
        org.apache.iceberg.Table iceTbl = tblImpl.iceApiTbl_;
        Map<Integer, PuffinStatsLoader.PuffinStatsRecord> puffinStats = PuffinStatsLoader.loadPuffinStats(iceTbl, tblImpl.fullName(), Collections.emptyMap());
        ArrayList<ColumnStatisticsObj> res = new ArrayList<ColumnStatisticsObj>();
        for (String colName : colNames) {
            Types.NestedField field = iceTbl.schema().findField(colName);
            int fieldId = field.fieldId();
            PuffinStatsLoader.PuffinStatsRecord stats = puffinStats.get(fieldId);
            if (stats == null) continue;
            long ndv = stats.ndv;
            LongColumnStatsData ndvData = new LongColumnStatsData();
            ndvData.setNumDVs(ndv);
            ColumnStatisticsData ndvColStatsData = this.createNdvColStatsData(field.type(), ndv);
            ColumnStatisticsObj statsObj = new ColumnStatisticsObj(colName, "", ndvColStatsData);
            res.add(statsObj);
        }
        return res;
    }

    private ColumnStatisticsData createNdvColStatsData(Type type, long ndv) {
        if (type instanceof Types.BooleanType) {
            BooleanColumnStatsData ndvData = new BooleanColumnStatsData();
            return ColumnStatisticsData.booleanStats((BooleanColumnStatsData)ndvData);
        }
        if (type instanceof Types.IntegerType || type instanceof Types.LongType || type instanceof Types.TimestampType) {
            LongColumnStatsData ndvData = new LongColumnStatsData();
            ndvData.setNumDVs(ndv);
            return ColumnStatisticsData.longStats((LongColumnStatsData)ndvData);
        }
        if (type instanceof Types.DateType) {
            DateColumnStatsData ndvData = new DateColumnStatsData();
            ndvData.setNumDVs(ndv);
            return ColumnStatisticsData.dateStats((DateColumnStatsData)ndvData);
        }
        if (type instanceof Types.FloatType || type instanceof Types.DoubleType) {
            DoubleColumnStatsData ndvData = new DoubleColumnStatsData();
            ndvData.setNumDVs(ndv);
            return ColumnStatisticsData.doubleStats((DoubleColumnStatsData)ndvData);
        }
        if (type instanceof Types.StringType) {
            StringColumnStatsData ndvData = new StringColumnStatsData();
            ndvData.setNumDVs(ndv);
            return ColumnStatisticsData.stringStats((StringColumnStatsData)ndvData);
        }
        if (type instanceof Types.BinaryType) {
            BinaryColumnStatsData ndvData = new BinaryColumnStatsData();
            return ColumnStatisticsData.binaryStats((BinaryColumnStatsData)ndvData);
        }
        if (type instanceof Types.DecimalType) {
            DecimalColumnStatsData ndvData = new DecimalColumnStatsData();
            ndvData.setNumDVs(ndv);
            return ColumnStatisticsData.decimalStats((DecimalColumnStatsData)ndvData);
        }
        return new ColumnStatisticsData();
    }

    @Override
    public TValidWriteIdList getValidWriteIdList(MetaProvider.TableMetaRef ref) {
        return null;
    }

    public List<MetaProvider.PartitionRef> checkLatestCompaction(String dbName, String tableName, MetaProvider.TableMetaRef table, Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> metas) throws TException {
        return Collections.emptyList();
    }

    @Override
    public TPartialTableInfo loadIcebergTable(MetaProvider.TableMetaRef table) throws TException {
        TableMetaRefImpl tableRefImpl = (TableMetaRefImpl)table;
        LocalIcebergTable.TableParams tableParams = new LocalIcebergTable.TableParams(tableRefImpl.msTable_);
        org.apache.iceberg.Table apiTable = this.loadIcebergApiTable(table, tableParams, tableRefImpl.msTable_);
        TPartialTableInfo ret = new TPartialTableInfo();
        TIcebergTable iceTable = new TIcebergTable();
        if (apiTable.currentSnapshot() != null) {
            iceTable.setCatalog_snapshot_id(apiTable.currentSnapshot().snapshotId());
        }
        iceTable.setDefault_partition_spec_id(apiTable.spec().specId());
        ListMap<TNetworkAddress> hostIndex = new ListMap<TNetworkAddress>();
        iceTable.setContent_files(this.getTContentFileStore(table, apiTable, hostIndex));
        iceTable.setPartition_stats(Collections.emptyMap());
        ret.setIceberg_table(iceTable);
        ret.setNetwork_addresses(hostIndex.getList());
        return ret;
    }

    @Override
    public org.apache.iceberg.Table loadIcebergApiTable(MetaProvider.TableMetaRef table, LocalIcebergTable.TableParams params, Table msTable) throws TException {
        return ((TableMetaRefImpl)table).iceApiTbl_;
    }

    public String getLocation(MetaProvider.TableMetaRef table) {
        return ((TableMetaRefImpl)table).msTable_.getSd().getLocation();
    }

    private TIcebergContentFileStore getTContentFileStore(MetaProvider.TableMetaRef table, org.apache.iceberg.Table apiTable, ListMap<TNetworkAddress> hostIndex) {
        try {
            TableScan scan = apiTable.newScan();
            GroupedContentFiles groupedFiles = new GroupedContentFiles((CloseableIterable<FileScanTask>)scan.planFiles());
            IcebergFileMetadataLoader iceFml = new IcebergFileMetadataLoader(apiTable, Collections.emptyList(), hostIndex, groupedFiles, new ArrayList<TIcebergPartition>(), false);
            iceFml.load();
            IcebergContentFileStore contentFileStore = new IcebergContentFileStore(apiTable, iceFml.getLoadedIcebergFds(), groupedFiles, iceFml.getIcebergPartitions());
            return contentFileStore.toThrift();
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception occurred during loading Iceberg file metadata", e);
        }
    }

    private class TableMetaRefImpl
    implements MetaProvider.TableMetaRef {
        private final String dbName_;
        private final String tableName_;
        private final Table msTable_;
        private final long loadingTimeMs_;
        private final HdfsPartitionLocationCompressor partitionLocationCompressor_;
        private final org.apache.iceberg.Table iceApiTbl_;

        public TableMetaRefImpl(String dbName, String tableName, Table msTable, org.apache.iceberg.Table iceApiTbl, long loadingTimeMs) {
            this.dbName_ = dbName;
            this.tableName_ = tableName;
            this.msTable_ = msTable;
            this.iceApiTbl_ = iceApiTbl;
            this.loadingTimeMs_ = loadingTimeMs;
            this.partitionLocationCompressor_ = new HdfsPartitionLocationCompressor(msTable.getPartitionKeysSize(), Lists.newArrayList((Object[])new String[]{msTable.getSd().getLocation()}));
        }

        @Override
        public boolean isPartitioned() {
            return this.msTable_.getPartitionKeysSize() != 0;
        }

        @Override
        public boolean isMarkedCached() {
            return false;
        }

        @Override
        public List<String> getPartitionPrefixes() {
            return this.partitionLocationCompressor_.getPrefixes();
        }

        @Override
        public boolean isTransactional() {
            return AcidUtils.isTransactionalTable(this.msTable_.getParameters());
        }

        public String fullName() {
            return this.dbName_ + "." + this.tableName_;
        }

        @Override
        public List<VirtualColumn> getVirtualColumns() {
            ArrayList<VirtualColumn> ret = new ArrayList<VirtualColumn>();
            ret.add(VirtualColumn.INPUT_FILE_NAME);
            ret.add(VirtualColumn.FILE_POSITION);
            ret.add(VirtualColumn.PARTITION_SPEC_ID);
            ret.add(VirtualColumn.ICEBERG_PARTITION_SERIALIZED);
            ret.add(VirtualColumn.ICEBERG_DATA_SEQUENCE_NUMBER);
            return ret;
        }

        @Override
        public long getCatalogVersion() {
            return 0L;
        }

        @Override
        public long getLoadedTimeMs() {
            return this.loadingTimeMs_;
        }
    }

    private static class PartitionMetadataImpl
    implements MetaProvider.PartitionMetadata {
        private final Table msTable_;

        public PartitionMetadataImpl(Table msTable) {
            this.msTable_ = msTable;
        }

        @Override
        public Map<String, String> getHmsParameters() {
            return Collections.emptyMap();
        }

        @Override
        public long getWriteId() {
            return -1L;
        }

        @Override
        public HdfsStorageDescriptor getInputFormatDescriptor() {
            String tblName = this.msTable_.getDbName() + "." + this.msTable_.getTableName();
            try {
                return HdfsStorageDescriptor.fromStorageDescriptor(tblName, this.msTable_.getSd());
            }
            catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
                throw new LocalCatalogException(String.format("Invalid input format descriptor for table %s", tblName), e);
            }
        }

        @Override
        public HdfsPartitionLocationCompressor.Location getLocation() {
            HdfsPartitionLocationCompressor hdfsPartitionLocationCompressor = new HdfsPartitionLocationCompressor(0);
            hdfsPartitionLocationCompressor.getClass();
            return new HdfsPartitionLocationCompressor.Location(hdfsPartitionLocationCompressor, this.msTable_.getSd().getLocation());
        }

        @Override
        public ImmutableList<FileDescriptor> getFileDescriptors() {
            return ImmutableList.of();
        }

        @Override
        public ImmutableList<FileDescriptor> getInsertFileDescriptors() {
            return ImmutableList.of();
        }

        @Override
        public ImmutableList<FileDescriptor> getDeleteFileDescriptors() {
            return ImmutableList.of();
        }

        @Override
        public boolean hasIncrementalStats() {
            return false;
        }

        @Override
        public byte[] getPartitionStats() {
            return null;
        }

        @Override
        public boolean isMarkedCached() {
            return false;
        }

        @Override
        public long getLastCompactionId() {
            throw new UnsupportedOperationException("Compaction id is not provided with IcebergMetaProvider implementation");
        }
    }

    @Immutable
    private static class PartitionRefImpl
    implements MetaProvider.PartitionRef {
        private static final String UNPARTITIONED_NAME = "";
        private final String name_;

        public PartitionRefImpl(String name) {
            this.name_ = name;
        }

        @Override
        public String getName() {
            return this.name_;
        }
    }
}

