/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.AuthzCacheInvalidation;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogDeltaLog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObjectCache;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.ImpaladCatalog;
import org.apache.impala.catalog.Principal;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.local.InconsistentMetadataFetchException;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TCatalogInfoSelector;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TDataSource;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TDbInfoSelector;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionName;
import org.apache.impala.thrift.TGetLatestCompactionsRequest;
import org.apache.impala.thrift.TGetLatestCompactionsResponse;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableInfoSelector;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUnit;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.TByteBuffer;
import org.apache.impala.util.TUniqueIdUtil;
import org.apache.thrift.TBase;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;
import org.github.jamm.CannotAccessFieldException;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogdMetaProvider
implements MetaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogdMetaProvider.class);
    private static final ColumnStatisticsObj NEGATIVE_COLUMN_STATS_SENTINEL = new ColumnStatisticsObj();
    private static final Object NULL_PARTITION_KEY_VALUE_CACHE_KEY = new Object();
    private static final Object DB_LIST_CACHE_KEY = new Object();
    private static final String CATALOG_FETCH_PREFIX = "CatalogFetch";
    private static final String DB_LIST_STATS_CATEGORY = "DatabaseList";
    private static final String DB_METADATA_STATS_CATEGORY = "Databases";
    private static final String TABLE_LIST_STATS_CATEGORY = "TableList";
    private static final String TABLE_METADATA_CACHE_CATEGORY = "Tables";
    private static final String PARTITION_LIST_STATS_CATEGORY = "PartitionLists";
    private static final String PARTITIONS_STATS_CATEGORY = "Partitions";
    private static final String COLUMN_STATS_STATS_CATEGORY = "ColumnStats";
    private static final String GLOBAL_CONFIGURATION_STATS_CATEGORY = "Config";
    private static final String FUNCTION_LIST_STATS_CATEGORY = "FunctionLists";
    private static final String FUNCTIONS_STATS_CATEGORY = "Functions";
    private static final String RPC_STATS_CATEGORY = "RPCs";
    private static final String STORAGE_METADATA_LOAD_CATEGORY = "StorageLoad";
    private static final String DATA_SOURCE_LIST_STATS_CATEGORY = "DataSourceLists";
    private static final Object DS_OBJ_LIST_CACHE_KEY = new Object();
    private static final String RPC_REQUESTS = "CatalogFetch.RPCs.Requests";
    private static final String RPC_BYTES = "CatalogFetch.RPCs.Bytes";
    private static final String RPC_TIME = "CatalogFetch.RPCs.Time";
    private final ListMap<TNetworkAddress> cacheHostIndex_ = new ListMap();
    @VisibleForTesting
    final AtomicInteger piggybackSuccessCountForTests = new AtomicInteger();
    @VisibleForTesting
    final AtomicInteger piggybackExceptionCountForTests = new AtomicInteger();
    final Cache<Object, Object> cache_;
    private final Histogram cacheEntrySize_ = new Histogram((Reservoir)new UniformReservoir());
    private final AtomicLong lastSeenCatalogVersion_ = new AtomicLong(0L);
    private final AtomicLong lastResetCatalogVersion_ = new AtomicLong(-1L);
    CatalogDeltaLog deletedObjectsLog_ = new CatalogDeltaLog();
    @GuardedBy(value="catalogServiceIdLock_")
    private TUniqueId catalogServiceId_ = Catalog.INITIAL_CATALOG_SERVICE_ID;
    private final ReentrantReadWriteLock catalogServiceIdLock_ = new ReentrantReadWriteLock(true);
    private final Object catalogReadyNotifier_ = new Object();
    private final AuthorizationPolicy authPolicy_ = new AuthorizationPolicy();
    private final CatalogObjectCache<AuthzCacheInvalidation> authzCacheInvalidation_ = new CatalogObjectCache();
    private AtomicReference<? extends AuthorizationChecker> authzChecker_;
    private final CatalogObjectCache<HdfsCachePool> hdfsCachePools_ = new CatalogObjectCache(false);

    public CatalogdMetaProvider(TBackendGflags flags) {
        long cacheSizeBytes;
        Preconditions.checkArgument((boolean)flags.isSetLocal_catalog_cache_expiration_s());
        Preconditions.checkArgument((boolean)flags.isSetLocal_catalog_cache_mb());
        if (flags.local_catalog_cache_mb < 0) {
            long maxHeapBytes = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
            cacheSizeBytes = (long)((double)maxHeapBytes * 0.6);
        } else {
            cacheSizeBytes = flags.local_catalog_cache_mb * 1024 * 1024;
        }
        int expirationSecs = flags.local_catalog_cache_expiration_s;
        int concurrencyLevel = flags.local_catalog_cache_concurrency_level;
        if (concurrencyLevel <= 0) {
            concurrencyLevel = 4;
        }
        LOG.info("Metadata cache configuration: capacity={} MB, expiration={} sec, concurrencyLevel={}", new Object[]{cacheSizeBytes / 1024L / 1024L, expirationSecs, concurrencyLevel});
        this.cache_ = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).maximumWeight(cacheSizeBytes).expireAfterAccess((long)expirationSecs, TimeUnit.SECONDS).weigher((Weigher)new SizeOfWeigher(BackendConfig.INSTANCE.useJammWeigher(), this.cacheEntrySize_)).recordStats().build();
    }

    @Override
    public String getURI() {
        return "Catalogd (URI TODO)";
    }

    public TUniqueId getCatalogServiceId() {
        this.catalogServiceIdLock_.readLock().lock();
        try {
            TUniqueId tUniqueId = this.catalogServiceId_;
            return tUniqueId;
        }
        finally {
            this.catalogServiceIdLock_.readLock().unlock();
        }
    }

    public CacheStats getCacheStats() {
        return this.cache_.stats();
    }

    public Snapshot getCacheEntrySize() {
        return this.cacheEntrySize_.getSnapshot();
    }

    @Override
    public Iterable<HdfsCachePool> getHdfsCachePools() {
        return this.hdfsCachePools_;
    }

    @Override
    public AuthorizationPolicy getAuthPolicy() {
        return this.authPolicy_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForIsReady(long timeoutMs) {
        if (this.isReady()) {
            return;
        }
        Object object = this.catalogReadyNotifier_;
        synchronized (object) {
            try {
                this.catalogReadyNotifier_.wait(timeoutMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isReady() {
        return this.lastSeenCatalogVersion_.get() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsReady(boolean isReady) {
        this.lastSeenCatalogVersion_.incrementAndGet();
        Object object = this.catalogReadyNotifier_;
        synchronized (object) {
            this.catalogReadyNotifier_.notifyAll();
        }
    }

    public void setAuthzChecker(AtomicReference<? extends AuthorizationChecker> authzChecker) {
        this.authzChecker_ = authzChecker;
    }

    private TGetPartialCatalogObjectResponse sendRequest(TGetPartialCatalogObjectRequest req) throws TException {
        byte[] ret = null;
        Stopwatch sw = Stopwatch.createStarted();
        try {
            ret = FeSupport.GetPartialCatalogObject(new TSerializer().serialize((TBase)req));
        }
        catch (InternalException e) {
            try {
                throw new TException((Throwable)e);
            }
            catch (Throwable throwable) {
                sw.stop();
                FrontendProfile profile = FrontendProfile.getCurrentOrNull();
                if (profile != null) {
                    profile.addToCounter(RPC_REQUESTS, TUnit.NONE, 1L);
                    profile.addToCounter(RPC_BYTES, TUnit.BYTES, ret == null ? 0L : (long)ret.length);
                    profile.addToCounter(RPC_TIME, TUnit.TIME_MS, sw.elapsed(TimeUnit.MILLISECONDS));
                }
                throw throwable;
            }
        }
        sw.stop();
        FrontendProfile profile = FrontendProfile.getCurrentOrNull();
        if (profile != null) {
            profile.addToCounter(RPC_REQUESTS, TUnit.NONE, 1L);
            profile.addToCounter(RPC_BYTES, TUnit.BYTES, ret == null ? 0L : (long)ret.length);
            profile.addToCounter(RPC_TIME, TUnit.TIME_MS, sw.elapsed(TimeUnit.MILLISECONDS));
        }
        TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
        new TDeserializer().deserialize((TBase)resp, ret);
        if (resp.isSetStatus() && resp.status.status_code != TErrorCode.OK) {
            throw new TException(String.join((CharSequence)"\n", resp.status.error_msgs));
        }
        if (resp.isSetCatalog_service_id() && this.witnessCatalogServiceId(resp.getCatalog_service_id())) {
            throw new InconsistentMetadataFetchException(CatalogLookupStatus.CATALOG_SERVICE_CHANGED, String.format("Catalog service ID changed to %s", TUniqueIdUtil.PrintId(resp.getCatalog_service_id())));
        }
        switch (resp.lookup_status) {
            case DB_NOT_FOUND: 
            case FUNCTION_NOT_FOUND: 
            case TABLE_NOT_FOUND: 
            case TABLE_NOT_LOADED: 
            case PARTITION_NOT_FOUND: 
            case DATA_SOURCE_NOT_FOUND: {
                this.invalidateCacheForObject(req.object_desc);
                throw new InconsistentMetadataFetchException(resp.lookup_status, String.format("Fetching %s failed: %s for %s", new Object[]{req.object_desc.type, resp.lookup_status, req.object_desc}));
            }
        }
        Preconditions.checkState((resp.lookup_status == CatalogLookupStatus.OK ? 1 : 0) != 0);
        if (req.object_desc.isSetCatalog_version() && resp.isSetObject_version_number() && req.object_desc.catalog_version != resp.object_version_number) {
            this.invalidateCacheForObject(req.object_desc);
            LOG.warn("Catalog object {} changed version from {} to {} while fetching metadata", new Object[]{req.object_desc.toString(), req.object_desc.catalog_version, resp.object_version_number});
            throw new InconsistentMetadataFetchException(CatalogLookupStatus.VERSION_MISMATCH, String.format("Catalog object %s changed version between accesses.", req.object_desc.toString()));
        }
        return resp;
    }

    /*
     * Exception decompiling
     */
    private <CacheKeyType, ValueType> ValueType loadWithCaching(String itemString, String statsCategory, CacheKeyType key, Callable<ValueType> loadCallable) throws TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addStatsToProfile(String statsCategory, int numHits, int numMisses, Stopwatch stopwatch) {
        FrontendProfile profile = FrontendProfile.getCurrentOrNull();
        if (profile == null) {
            return;
        }
        String prefix = "CatalogFetch." + (String)Preconditions.checkNotNull((Object)statsCategory) + ".";
        profile.addToCounter(prefix + "Requests", TUnit.NONE, numHits + numMisses);
        profile.addToCounter(prefix + "Time", TUnit.TIME_MS, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        profile.addToCounter(prefix + "Hits", TUnit.NONE, numHits);
        profile.addToCounter(prefix + "Misses", TUnit.NONE, numMisses);
    }

    private void addTableMetadatStorageLoadTimeToProfile(long storageLoadTimeNano) {
        FrontendProfile profile = FrontendProfile.getCurrentOrNull();
        if (profile == null) {
            return;
        }
        String storageAccessTimeCounter = "CatalogFetch.StorageLoad.Time";
        profile.addToCounter("CatalogFetch.StorageLoad.Time", TUnit.TIME_MS, TimeUnit.MILLISECONDS.convert(storageLoadTimeNano, TimeUnit.NANOSECONDS));
    }

    @Override
    public ImmutableList<String> loadDbList() throws TException {
        return this.loadWithCaching("database list", DB_LIST_STATS_CATEGORY, DB_LIST_CACHE_KEY, new Callable<ImmutableList<String>>(){

            @Override
            public ImmutableList<String> call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForCatalog();
                req.catalog_info_selector.want_db_names = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.catalog_info != null && resp.catalog_info.db_names != null, req, "missing database names", new Object[0]);
                return ImmutableList.copyOf(resp.catalog_info.db_names);
            }
        });
    }

    private TGetPartialCatalogObjectRequest newReqForCatalog() {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.CATALOG);
        req.catalog_info_selector = new TCatalogInfoSelector();
        return req;
    }

    private TGetPartialCatalogObjectRequest newReqForDb(String dbName) {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.DATABASE);
        req.object_desc.db = new TDatabase(dbName);
        req.db_info_selector = new TDbInfoSelector();
        return req;
    }

    private TGetPartialCatalogObjectRequest newReqForFunction(String dbName, String funcName) {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.FUNCTION);
        req.object_desc.fn = new TFunction();
        req.object_desc.fn.name = new TFunctionName();
        req.object_desc.fn.name.db_name = dbName;
        req.object_desc.fn.name.function_name = funcName;
        return req;
    }

    private TGetPartialCatalogObjectRequest newReqForDataSource(String dsName) {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.DATA_SOURCE);
        if (dsName == null) {
            dsName = "";
        }
        req.object_desc.setData_source(new TDataSource(dsName, "", "", ""));
        return req;
    }

    @Override
    public Database loadDb(final String dbName) throws TException {
        return this.loadWithCaching("database metadata for " + dbName, DB_METADATA_STATS_CATEGORY, new DbCacheKey(dbName.toLowerCase(), DbCacheKey.DbInfoType.HMS_METADATA), new Callable<Database>(){

            @Override
            public Database call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForDb(dbName);
                req.db_info_selector.want_hms_database = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.db_info != null && resp.db_info.hms_database != null, req, "missing expected HMS database", new Object[0]);
                return resp.db_info.hms_database;
            }
        });
    }

    @Override
    public ImmutableCollection<TBriefTableMeta> loadTableList(final String dbName) throws MetaException, UnknownDBException, TException {
        ImmutableMap<String, TBriefTableMeta> res = this.loadWithCaching("table list of database " + dbName, TABLE_LIST_STATS_CATEGORY, new DbCacheKey(dbName.toLowerCase(), DbCacheKey.DbInfoType.TABLE_LIST), new Callable<ImmutableMap<String, TBriefTableMeta>>(){

            @Override
            public ImmutableMap<String, TBriefTableMeta> call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForDb(dbName);
                req.db_info_selector.want_brief_meta_of_tables = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.db_info != null && resp.db_info.brief_meta_of_tables != null, req, "missing expected table names", new Object[0]);
                ImmutableMap.Builder map = ImmutableMap.builder();
                for (TBriefTableMeta meta : resp.db_info.brief_meta_of_tables) {
                    map.put((Object)meta.getName(), (Object)meta);
                }
                return map.build();
            }
        });
        return res.values();
    }

    private static TGetPartialCatalogObjectRequest newReqForTable(String dbName, String tableName) {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable(dbName, tableName);
        req.table_info_selector = new TTableInfoSelector();
        return req;
    }

    private static TGetPartialCatalogObjectRequest newReqForTable(MetaProvider.TableMetaRef table) {
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl), (String)"table ref %s was not created by CatalogdMetaProvider", (Object)table);
        TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForTable(((TableMetaRefImpl)table).dbName_, ((TableMetaRefImpl)table).tableName_);
        req.object_desc.setCatalog_version(((TableMetaRefImpl)table).catalogVersion_);
        return req;
    }

    private static TGetPartialCatalogObjectRequest newReqForPartitions(TableMetaRefImpl table, List<Long> partIds) {
        TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForTable(table);
        req.table_info_selector.partition_ids = partIds;
        req.table_info_selector.want_partition_metadata = true;
        req.table_info_selector.want_partition_files = true;
        if (BackendConfig.INSTANCE.isAutoCheckCompaction()) {
            req.table_info_selector.valid_write_ids = table.validWriteIds_;
        }
        req.table_info_selector.want_partition_stats = true;
        return req;
    }

    @Override
    public Pair<Table, MetaProvider.TableMetaRef> getTableIfPresent(String dbName, String tblName) {
        TableCacheKey cacheKey = new TableCacheKey(dbName.toLowerCase(), tblName.toLowerCase());
        try {
            Object value = this.getIfPresent(cacheKey);
            if (value == null) {
                return null;
            }
            TableMetaRefImpl ref = (TableMetaRefImpl)value;
            return Pair.create(ref.msTable_, ref);
        }
        catch (TException e) {
            return null;
        }
    }

    @Override
    public Pair<Table, MetaProvider.TableMetaRef> loadTable(final String dbName, final String tableName) throws NoSuchObjectException, MetaException, TException {
        TableCacheKey cacheKey = new TableCacheKey(dbName.toLowerCase(), tableName.toLowerCase());
        TableMetaRefImpl ref = this.loadWithCaching("table metadata for " + dbName + "." + tableName, TABLE_METADATA_CACHE_CATEGORY, cacheKey, new Callable<TableMetaRefImpl>(){

            @Override
            public TableMetaRefImpl call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForTable(dbName, tableName);
                req.table_info_selector.want_hms_table = true;
                req.table_info_selector.want_table_constraints = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.table_info != null && resp.table_info.hms_table != null, req, "missing expected HMS table", new Object[0]);
                CatalogdMetaProvider.this.addTableMetadatStorageLoadTimeToProfile(resp.table_info.storage_metadata_load_time_ns);
                ArrayList<SQLPrimaryKey> primaryKeys = resp.table_info.sql_constraints == null ? new ArrayList() : resp.table_info.sql_constraints.getPrimary_keys();
                ArrayList<SQLForeignKey> foreignKeys = resp.table_info.sql_constraints == null ? new ArrayList() : resp.table_info.sql_constraints.getForeign_keys();
                return new TableMetaRefImpl(dbName, tableName, resp.table_info.hms_table, resp.object_version_number, resp.object_loaded_time_ms, new SqlConstraints(primaryKeys, foreignKeys), resp.table_info.valid_write_ids, resp.table_info.is_marked_cached, resp.table_info.partition_prefixes, resp.table_info.virtual_columns);
            }
        });
        this.invalidateStaleTableList(dbName.toLowerCase(), ref);
        return Pair.create(ref.msTable_, ref);
    }

    private void invalidateStaleTableList(String dbName, TableMetaRefImpl latestMeta) {
        Preconditions.checkNotNull((Object)latestMeta.msTable_, (Object)"loaded table should have a msTable");
        DbCacheKey dbKey = new DbCacheKey(dbName, DbCacheKey.DbInfoType.TABLE_LIST);
        Object dbValue = this.cache_.getIfPresent((Object)dbKey);
        if (dbValue instanceof ImmutableMap) {
            boolean hasStaleType;
            TBriefTableMeta cachedMeta = (TBriefTableMeta)((ImmutableMap)dbValue).get((Object)latestMeta.tableName_);
            String latestComment = MetadataOp.getTableComment(latestMeta.msTable_);
            boolean hasStaleComment = !StringUtils.equals((CharSequence)latestComment, (CharSequence)cachedMeta.comment);
            boolean bl = hasStaleType = MetadataOp.getImpalaTableType(cachedMeta.msType) != MetadataOp.getImpalaTableType(latestMeta.msTable_.getTableType());
            if (hasStaleType || hasStaleComment) {
                ArrayList<String> invalidated = new ArrayList<String>();
                this.invalidateCacheForDb(dbName, (Iterable<DbCacheKey.DbInfoType>)ImmutableList.of((Object)((Object)DbCacheKey.DbInfoType.TABLE_LIST)), invalidated);
                if (!invalidated.isEmpty()) {
                    Preconditions.checkState((invalidated.size() == 1 ? 1 : 0) != 0);
                    LOG.debug("Invalidated stale {} after loading table {}: hasStaleType={}, hasStaleComment={}", new Object[]{invalidated.get(0), latestMeta.tableName_, hasStaleType, hasStaleComment});
                }
            }
        }
    }

    @Override
    public List<ColumnStatisticsObj> loadTableColumnStatistics(MetaProvider.TableMetaRef table, List<String> colNames) throws TException {
        Stopwatch sw = Stopwatch.createStarted();
        ArrayList ret = Lists.newArrayListWithCapacity((int)colNames.size());
        int negativeHitCount = 0;
        ArrayList missingCols = Lists.newArrayListWithCapacity((int)colNames.size());
        for (String colName : colNames) {
            ColStatsCacheKey cacheKey = new ColStatsCacheKey((TableMetaRefImpl)table, colName);
            ColumnStatisticsObj val = (ColumnStatisticsObj)this.getIfPresent(cacheKey);
            if (val == null) {
                missingCols.add(colName);
                continue;
            }
            if (val == NEGATIVE_COLUMN_STATS_SENTINEL) {
                ++negativeHitCount;
                continue;
            }
            ret.add(val);
        }
        int hitCount = ret.size();
        if (!missingCols.isEmpty()) {
            TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForTable(table);
            req.table_info_selector.want_stats_for_column_names = missingCols;
            TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
            CatalogdMetaProvider.checkResponse(resp.table_info != null && resp.table_info.column_stats != null, req, "missing column stats", new Object[0]);
            HashSet colsWithoutStats = new HashSet(missingCols);
            for (ColumnStatisticsObj stats : resp.table_info.column_stats) {
                this.cache_.put((Object)new ColStatsCacheKey((TableMetaRefImpl)table, stats.getColName()), (Object)stats);
                ret.add(stats);
                colsWithoutStats.remove(stats.getColName());
            }
            for (String missingColName : colsWithoutStats) {
                this.cache_.put((Object)new ColStatsCacheKey((TableMetaRefImpl)table, missingColName), (Object)NEGATIVE_COLUMN_STATS_SENTINEL);
            }
        }
        sw.stop();
        this.addStatsToProfile(COLUMN_STATS_STATS_CATEGORY, hitCount + negativeHitCount, missingCols.size(), sw);
        LOG.trace("Request for column stats of {}: hit {}/ neg hit {} / miss {}", new Object[]{table, hitCount, negativeHitCount, missingCols.size()});
        return ret;
    }

    private Object getIfPresent(Object cacheKey) throws TException {
        Object existing = this.cache_.getIfPresent(cacheKey);
        if (existing == null) {
            return null;
        }
        if (!(existing instanceof Future)) {
            return existing;
        }
        try {
            return Uninterruptibles.getUninterruptibly((Future)((Future)existing));
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), TException.class);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<MetaProvider.PartitionRef> loadPartitionList(final MetaProvider.TableMetaRef table) throws TException {
        PartitionListCacheKey key = new PartitionListCacheKey((TableMetaRefImpl)table);
        return this.loadWithCaching("partition list for " + table, PARTITION_LIST_STATS_CATEGORY, key, new Callable<List<MetaProvider.PartitionRef>>(){

            @Override
            public List<MetaProvider.PartitionRef> call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForTable(table);
                req.table_info_selector.want_partition_names = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.table_info != null && resp.table_info.partitions != null, req, "missing partition list result", new Object[0]);
                ArrayList partitionRefs = Lists.newArrayListWithCapacity((int)resp.table_info.partitions.size());
                for (TPartialPartitionInfo p : resp.table_info.partitions) {
                    CatalogdMetaProvider.checkResponse(p.isSetId(), req, "response missing partition IDs for partition %s", new Object[]{p});
                    partitionRefs.add(new PartitionRefImpl(p));
                }
                return partitionRefs;
            }
        });
    }

    @Override
    public SqlConstraints loadConstraints(MetaProvider.TableMetaRef table, Table msTbl) {
        return ((TableMetaRefImpl)table).sqlConstraints_;
    }

    @Override
    public Map<String, MetaProvider.PartitionMetadata> loadPartitionsByRefs(MetaProvider.TableMetaRef table, List<String> partitionColumnNames, ListMap<TNetworkAddress> hostIndex, List<MetaProvider.PartitionRef> partitionRefs) throws CatalogException, TException {
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        TableMetaRefImpl refImpl = (TableMetaRefImpl)table;
        Stopwatch sw = Stopwatch.createStarted();
        Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> refToMeta = this.loadPartitionsFromCache(refImpl, hostIndex, partitionRefs);
        if (BackendConfig.INSTANCE.isAutoCheckCompaction()) {
            List<MetaProvider.PartitionRef> stalePartitions = this.checkLatestCompaction(refImpl.dbName_, refImpl.tableName_, refImpl, refToMeta);
            this.cache_.invalidateAll((Iterable)stalePartitions.stream().map(PartitionRefImpl.class::cast).map(rec$ -> ((PartitionRefImpl)rec$).getId()).map(PartitionCacheKey::new).collect(Collectors.toList()));
            LOG.debug("Checked the latest compaction id for {}.{}", (Object)refImpl.dbName_, (Object)refImpl.tableName_);
        }
        int numHits = refToMeta.size();
        int numMisses = partitionRefs.size() - numHits;
        ArrayList<MetaProvider.PartitionRef> missingRefs = new ArrayList<MetaProvider.PartitionRef>();
        for (MetaProvider.PartitionRef ref : partitionRefs) {
            if (refToMeta.containsKey(ref)) continue;
            missingRefs.add(ref);
        }
        if (!missingRefs.isEmpty()) {
            Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> fromCatalogd = this.loadPartitionsFromCatalogd(refImpl, hostIndex, missingRefs);
            refToMeta.putAll(fromCatalogd);
            this.storePartitionsInCache(hostIndex, fromCatalogd);
        }
        sw.stop();
        this.addStatsToProfile(PARTITIONS_STATS_CATEGORY, numHits, numMisses, sw);
        LOG.trace("Request for partitions of {}: hit {}/{}", new Object[]{table, numHits, partitionRefs.size()});
        HashMap nameToMeta = Maps.newHashMapWithExpectedSize((int)refToMeta.size());
        for (Map.Entry<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> e : refToMeta.entrySet()) {
            nameToMeta.put(e.getKey().getName(), e.getValue());
        }
        return nameToMeta;
    }

    private List<MetaProvider.PartitionRef> checkLatestCompaction(String dbName, String tableName, MetaProvider.TableMetaRef table, Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> metas) throws TException {
        Preconditions.checkNotNull((Object)table, (Object)"TableMetaRef must be non-null");
        Preconditions.checkNotNull(metas, (Object)"Partition map must be non-null");
        if (!table.isTransactional() || metas.isEmpty()) {
            return Collections.emptyList();
        }
        Stopwatch sw = Stopwatch.createStarted();
        TGetLatestCompactionsRequest req = new TGetLatestCompactionsRequest();
        req.db_name = dbName;
        req.table_name = tableName;
        req.non_parition_name = "";
        if (table.isPartitioned()) {
            req.partition_names = metas.keySet().stream().map(MetaProvider.PartitionRef::getName).collect(Collectors.toList());
        }
        req.last_compaction_id = metas.values().stream().mapToLong(MetaProvider.PartitionMetadata::getLastCompactionId).max().orElse(-1L);
        byte[] ret = FeSupport.GetLatestCompactions(new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory()).serialize((TBase)req));
        TGetLatestCompactionsResponse resp = new TGetLatestCompactionsResponse();
        new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory()).deserialize((TBase)resp, ret);
        if (resp.status.status_code != TErrorCode.OK) {
            throw new TException(Joiner.on((String)"\n").join(resp.status.getError_msgs()));
        }
        Map<String, Long> partNameToCompactionId = resp.partition_to_compaction_id;
        Preconditions.checkNotNull(partNameToCompactionId, (Object)"Partition name to compaction id map must be non-null");
        ArrayList<MetaProvider.PartitionRef> stalePartitions = new ArrayList<MetaProvider.PartitionRef>();
        Iterator<Map.Entry<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata>> iter = metas.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> entry = iter.next();
            if (!partNameToCompactionId.containsKey(entry.getKey().getName())) continue;
            stalePartitions.add(entry.getKey());
            iter.remove();
        }
        LOG.info("Checked the latest compaction info for {}.{}. Time taken: {}", new Object[]{dbName, tableName, PrintUtils.printTimeMs(sw.stop().elapsed(TimeUnit.MILLISECONDS))});
        return stalePartitions;
    }

    private Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> loadPartitionsFromCatalogd(TableMetaRefImpl table, ListMap<TNetworkAddress> hostIndex, List<MetaProvider.PartitionRef> partRefs) throws CatalogException, TException {
        ArrayList ids = Lists.newArrayListWithCapacity((int)partRefs.size());
        for (MetaProvider.PartitionRef partRef : partRefs) {
            ids.add(((PartitionRefImpl)partRef).getId());
        }
        TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForPartitions(table, ids);
        TGetPartialCatalogObjectResponse resp = this.sendRequest(req);
        CatalogdMetaProvider.checkResponse(resp.table_info != null && resp.table_info.partitions != null, req, "missing partition list result", new Object[0]);
        CatalogdMetaProvider.checkResponse(resp.table_info.network_addresses != null, req, "missing network addresses", new Object[0]);
        this.addTableMetadatStorageLoadTimeToProfile(resp.table_info.storage_metadata_load_time_ns);
        boolean logProgress = false;
        while (resp.table_info.partitions.size() < ids.size()) {
            logProgress = true;
            int numFetchedParts = resp.table_info.partitions.size();
            LOG.info("Fetched {}/{} partitions for {}. Sending new requests.", new Object[]{numFetchedParts, ids.size(), table});
            ArrayList remainingIds = Lists.newArrayListWithCapacity((int)(ids.size() - numFetchedParts));
            for (int i = numFetchedParts; i < ids.size(); ++i) {
                remainingIds.add(ids.get(i));
            }
            TGetPartialCatalogObjectRequest nextReq = CatalogdMetaProvider.newReqForPartitions(table, remainingIds);
            TGetPartialCatalogObjectResponse nextResp = this.sendRequest(nextReq);
            resp.table_info.partitions.addAll(nextResp.table_info.partitions);
        }
        if (logProgress) {
            LOG.info("Fetched {} partitions for {}", (Object)ids.size(), (Object)table);
        }
        HashMap<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> ret = new HashMap<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata>();
        for (int i = 0; i < ids.size(); ++i) {
            HdfsPartitionLocationCompressor.Location location;
            MetaProvider.PartitionRef partRef = partRefs.get(i);
            TPartialPartitionInfo part = resp.table_info.partitions.get(i);
            HdfsStorageDescriptor hdfsStorageDescriptor = null;
            if (part.isSetHdfs_storage_descriptor()) {
                Preconditions.checkNotNull((Object)part.location, (Object)"location should not be null");
                hdfsStorageDescriptor = HdfsStorageDescriptor.fromThrift(part.hdfs_storage_descriptor, table.tableName_);
                HdfsPartitionLocationCompressor hdfsPartitionLocationCompressor = table.getPartitionLocationCompressor();
                hdfsPartitionLocationCompressor.getClass();
                location = new HdfsPartitionLocationCompressor.Location(hdfsPartitionLocationCompressor, part.location);
            } else {
                CatalogdMetaProvider.checkResponse(table.msTable_.getPartitionKeysSize() == 0, req, "Should not return a partition with missing partition meta unless the table is unpartitioned: %s", part);
                try {
                    hdfsStorageDescriptor = HdfsStorageDescriptor.fromStorageDescriptor(table.tableName_, table.msTable_.getSd());
                }
                catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
                    Preconditions.checkState((boolean)false, (Object)"Failed to create HdfsStorageDescriptor using sd of table");
                }
                HdfsPartitionLocationCompressor hdfsPartitionLocationCompressor = table.getPartitionLocationCompressor();
                hdfsPartitionLocationCompressor.getClass();
                location = new HdfsPartitionLocationCompressor.Location(hdfsPartitionLocationCompressor, table.msTable_.getSd().getLocation());
                part.setHms_parameters(table.msTable_.getParameters());
            }
            CatalogdMetaProvider.checkResponse(part.file_descriptors != null, req, "missing file descriptors", new Object[0]);
            ImmutableList<FileDescriptor> fds = this.convertThriftFdList(part.file_descriptors, resp.table_info.network_addresses, hostIndex);
            ImmutableList<FileDescriptor> insertFds = this.convertThriftFdList(part.insert_file_descriptors, resp.table_info.network_addresses, hostIndex);
            ImmutableList<FileDescriptor> deleteFds = this.convertThriftFdList(part.delete_file_descriptors, resp.table_info.network_addresses, hostIndex);
            PartitionMetadataImpl metaImpl = new PartitionMetadataImpl(part.getHms_parameters(), part.write_id, hdfsStorageDescriptor, fds, insertFds, deleteFds, part.getPartition_stats(), part.has_incremental_stats, part.is_marked_cached, location, part.last_compaction_id);
            CatalogdMetaProvider.checkResponse(partRef != null, req, "returned unexpected partition id %s", part.id);
            MetaProvider.PartitionMetadata oldVal = ret.put(partRef, metaImpl);
            if (oldVal == null) continue;
            throw new CatalogException("catalogd returned partition " + part.id + " multiple times");
        }
        return ret;
    }

    @Override
    public TPartialTableInfo loadIcebergTable(final MetaProvider.TableMetaRef table) throws TException {
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        TableMetaRefImpl tableRef = (TableMetaRefImpl)table;
        String itemStr = "iceberg metadata for " + tableRef.dbName_ + "." + tableRef.tableName_;
        IcebergMetaCacheKey cacheKey = new IcebergMetaCacheKey(tableRef);
        return this.loadWithCaching(itemStr, TABLE_METADATA_CACHE_CATEGORY, cacheKey, new Callable<TPartialTableInfo>(){

            @Override
            public TPartialTableInfo call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.newReqForTable(table);
                req.table_info_selector.want_iceberg_table = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.table_info != null && resp.table_info.iceberg_table != null, req, "missing Iceberg table metadata", new Object[0]);
                return resp.getTable_info();
            }
        });
    }

    @Override
    public org.apache.iceberg.Table loadIcebergApiTable(MetaProvider.TableMetaRef table, final LocalIcebergTable.TableParams params, final Table msTable) throws TException {
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        TableMetaRefImpl tableRef = (TableMetaRefImpl)table;
        String itemStr = "iceberg api table for " + tableRef.dbName_ + "." + tableRef.tableName_;
        IcebergApiTableCacheKey cacheKey = new IcebergApiTableCacheKey(tableRef);
        return this.loadWithCaching(itemStr, TABLE_METADATA_CACHE_CATEGORY, cacheKey, new Callable<org.apache.iceberg.Table>(){

            @Override
            public org.apache.iceberg.Table call() throws Exception {
                return IcebergUtil.loadTable(params.getIcebergCatalog(), IcebergUtil.getIcebergTableIdentifier(msTable), params.getIcebergCatalogLocation(), msTable.getParameters());
            }
        });
    }

    private ImmutableList<FileDescriptor> convertThriftFdList(List<THdfsFileDesc> thriftFds, List<TNetworkAddress> networkAddresses, ListMap<TNetworkAddress> hostIndex) {
        ArrayList fds = Lists.newArrayListWithCapacity((int)thriftFds.size());
        for (THdfsFileDesc thriftFd : thriftFds) {
            FileDescriptor fd = FileDescriptor.fromThrift(thriftFd);
            fds.add(fd.cloneWithNewHostIndex(networkAddresses, hostIndex));
        }
        return ImmutableList.copyOf((Collection)fds);
    }

    private Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> loadPartitionsFromCache(TableMetaRefImpl table, ListMap<TNetworkAddress> hostIndex, List<MetaProvider.PartitionRef> partitionRefs) throws TException {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)partitionRefs.size());
        for (MetaProvider.PartitionRef ref : partitionRefs) {
            PartitionRefImpl prefImpl = (PartitionRefImpl)ref;
            PartitionCacheKey cacheKey = new PartitionCacheKey(prefImpl.getId());
            PartitionMetadataImpl val = (PartitionMetadataImpl)this.getIfPresent(cacheKey);
            if (val == null) continue;
            ret.put(ref, val.cloneRelativeToHostIndex(this.cacheHostIndex_, hostIndex));
        }
        return ret;
    }

    private void storePartitionsInCache(ListMap<TNetworkAddress> hostIndex, Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> metas) {
        for (Map.Entry<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> e : metas.entrySet()) {
            PartitionRefImpl prefImpl = (PartitionRefImpl)e.getKey();
            PartitionMetadataImpl metaImpl = (PartitionMetadataImpl)e.getValue();
            PartitionCacheKey cacheKey = new PartitionCacheKey(prefImpl.getId());
            PartitionMetadataImpl cacheVal = metaImpl.cloneRelativeToHostIndex(hostIndex, this.cacheHostIndex_);
            this.cache_.put((Object)cacheKey, (Object)cacheVal);
        }
    }

    private static void checkResponse(boolean condition, TGetPartialCatalogObjectRequest req, String msg, Object ... args) throws TException {
        if (condition) {
            return;
        }
        throw new TException(String.format("Invalid response from catalogd for request " + StringUtils.abbreviate((String)req.toString(), (int)1000) + ": " + msg, args));
    }

    @Override
    public String loadNullPartitionKeyValue() throws MetaException, TException {
        return this.loadWithCaching("null partition key value", GLOBAL_CONFIGURATION_STATS_CATEGORY, NULL_PARTITION_KEY_VALUE_CACHE_KEY, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return FeSupport.GetNullPartitionName();
            }
        });
    }

    @Override
    public List<String> loadFunctionNames(final String dbName) throws TException {
        return (List)this.loadWithCaching("function names for database " + dbName, FUNCTION_LIST_STATS_CATEGORY, new DbCacheKey(dbName, DbCacheKey.DbInfoType.FUNCTION_NAMES), new Callable<ImmutableList<String>>(){

            @Override
            public ImmutableList<String> call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForDb(dbName);
                req.db_info_selector.want_function_names = true;
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.db_info != null && resp.db_info.function_names != null, req, "missing expected function names", new Object[0]);
                return ImmutableList.copyOf(resp.db_info.function_names);
            }
        });
    }

    @Override
    public ImmutableList<Function> loadFunction(final String dbName, final String functionName) throws TException {
        ImmutableList<TFunction> thriftFuncs = this.loadWithCaching("function " + dbName + "." + functionName, FUNCTIONS_STATS_CATEGORY, new FunctionsCacheKey(dbName, functionName), new Callable<ImmutableList<TFunction>>(){

            @Override
            public ImmutableList<TFunction> call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForFunction(dbName, functionName);
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.functions != null, req, "missing expected function", new Object[0]);
                return ImmutableList.copyOf(resp.functions);
            }
        });
        ImmutableList.Builder funcs = ImmutableList.builder();
        for (TFunction thriftFunc : thriftFuncs) {
            funcs.add((Object)Function.fromThrift(thriftFunc));
        }
        return funcs.build();
    }

    @Override
    public ImmutableList<DataSource> loadDataSources() throws TException {
        ImmutableList<TDataSource> thriftDataSrcs = this.loadWithCaching("DataSource object list", DATA_SOURCE_LIST_STATS_CATEGORY, DS_OBJ_LIST_CACHE_KEY, new Callable<ImmutableList<TDataSource>>(){

            @Override
            public ImmutableList<TDataSource> call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForDataSource(null);
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.data_srcs != null, req, "no existing DataSource", new Object[0]);
                return ImmutableList.copyOf(resp.data_srcs);
            }
        });
        ImmutableList.Builder dataSrcBld = ImmutableList.builder();
        for (TDataSource thriftDataSrc : thriftDataSrcs) {
            dataSrcBld.add((Object)DataSource.fromThrift(thriftDataSrc));
        }
        return dataSrcBld.build();
    }

    @Override
    public DataSource loadDataSource(final String dsName) throws TException {
        Preconditions.checkState((dsName != null && !dsName.isEmpty() ? 1 : 0) != 0);
        return this.loadWithCaching("DataSource object for " + dsName, DATA_SOURCE_LIST_STATS_CATEGORY, new DataSourceCacheKey(dsName.toLowerCase()), new Callable<DataSource>(){

            @Override
            public DataSource call() throws Exception {
                TGetPartialCatalogObjectRequest req = CatalogdMetaProvider.this.newReqForDataSource(dsName);
                TGetPartialCatalogObjectResponse resp = CatalogdMetaProvider.this.sendRequest(req);
                CatalogdMetaProvider.checkResponse(resp.data_srcs != null, req, "missing expected DataSource", new Object[0]);
                if (resp.data_srcs.size() == 1) {
                    return DataSource.fromThrift(resp.data_srcs.get(0));
                }
                Preconditions.checkState((resp.data_srcs.size() == 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) {
        Object object;
        Pair<Boolean, ByteBuffer> update;
        if (req.isSetCatalog_service_id()) {
            this.witnessCatalogServiceId(req.catalog_service_id);
        }
        Long nextCatalogVersion = null;
        ImpaladCatalog.ObjectUpdateSequencer authObjectSequencer = new ImpaladCatalog.ObjectUpdateSequencer();
        ImpaladCatalog.ObjectUpdateSequencer hdfsCachePoolSequencer = new ImpaladCatalog.ObjectUpdateSequencer();
        int maxMessageSize = BackendConfig.INSTANCE.getThriftRpcMaxMessageSize();
        TConfiguration config = new TConfiguration(maxMessageSize, 0xFA0000, 64);
        while ((update = FeSupport.NativeGetNextCatalogObjectUpdate(req.native_iterator_ptr)) != null) {
            boolean isDelete = (Boolean)update.first;
            TCatalogObject obj = new TCatalogObject();
            try {
                obj.read((TProtocol)new TBinaryProtocol((TTransport)new TByteBuffer(config, (ByteBuffer)update.second)));
            }
            catch (TException e) {
                LOG.warn("Unable to deserialize updated catalog info. Skipping cache invalidation which may result in stale metadata being used at this coordinator.", (Throwable)e);
                continue;
            }
            if (isDelete) {
                this.deletedObjectsLog_.addRemovedObject(obj);
            } else if (this.deletedObjectsLog_.wasObjectRemovedAfter(obj)) {
                LOG.trace("Skipping update because a matching object was removed in a later catalog version: {}", (Object)obj);
                continue;
            }
            if (!isDelete && obj.type == TCatalogObjectType.HDFS_PARTITION) {
                if (!obj.hdfs_partition.isSetPrev_id()) continue;
                obj.hdfs_partition.setId(obj.hdfs_partition.prev_id);
                obj.hdfs_partition.unsetPrev_id();
            }
            this.invalidateCacheForObject(obj);
            if (obj.type == TCatalogObjectType.HDFS_CACHE_POOL) {
                hdfsCachePoolSequencer.add(obj, isDelete);
                continue;
            }
            if (obj.type == TCatalogObjectType.PRINCIPAL || obj.type == TCatalogObjectType.PRIVILEGE || obj.type == TCatalogObjectType.AUTHZ_CACHE_INVALIDATION) {
                authObjectSequencer.add(obj, isDelete);
                continue;
            }
            if (obj.type != TCatalogObjectType.CATALOG) continue;
            nextCatalogVersion = obj.catalog_version;
            this.witnessCatalogServiceId(obj.catalog.catalog_service_id);
            long resetStartVersion = obj.catalog.last_reset_catalog_version;
            if (this.lastResetCatalogVersion_.getAndSet(resetStartVersion) == resetStartVersion) continue;
            this.cache_.invalidateAll();
        }
        for (TCatalogObject obj : hdfsCachePoolSequencer.getUpdatedObjects()) {
            this.updateHdfsCachePools(obj, false);
        }
        for (TCatalogObject obj : hdfsCachePoolSequencer.getDeletedObjects()) {
            this.updateHdfsCachePools(obj, true);
        }
        for (TCatalogObject obj : authObjectSequencer.getUpdatedObjects()) {
            this.updateAuthPolicy(obj, false);
        }
        for (TCatalogObject obj : authObjectSequencer.getDeletedObjects()) {
            this.updateAuthPolicy(obj, true);
        }
        this.deletedObjectsLog_.garbageCollect(this.lastSeenCatalogVersion_.get());
        if (nextCatalogVersion != null) {
            this.lastSeenCatalogVersion_.set(nextCatalogVersion);
            object = this.catalogReadyNotifier_;
            synchronized (object) {
                this.catalogReadyNotifier_.notifyAll();
            }
        }
        this.catalogServiceIdLock_.readLock().lock();
        try {
            object = new TUpdateCatalogCacheResponse(this.catalogServiceId_, this.lastResetCatalogVersion_.get() + 1L, this.lastSeenCatalogVersion_.get());
            return object;
        }
        finally {
            this.catalogServiceIdLock_.readLock().unlock();
        }
    }

    private void updateHdfsCachePools(TCatalogObject obj, boolean isDelete) {
        Preconditions.checkState((obj.type == TCatalogObjectType.HDFS_CACHE_POOL ? 1 : 0) != 0);
        String poolName = obj.getCache_pool().getPool_name();
        if (isDelete) {
            HdfsCachePool existingItem = this.hdfsCachePools_.get(poolName);
            if (existingItem != null && existingItem.getCatalogVersion() <= obj.getCatalog_version()) {
                this.hdfsCachePools_.remove(poolName);
                LOG.trace("Removed HdfsCachePool {}", (Object)poolName);
            }
            return;
        }
        HdfsCachePool cachePool = new HdfsCachePool(obj.getCache_pool());
        cachePool.setCatalogVersion(obj.getCatalog_version());
        if (this.hdfsCachePools_.add(cachePool)) {
            LOG.trace("Added HdfsCachePool name={}, version={}", (Object)poolName, (Object)obj.getCatalog_version());
            return;
        }
        LOG.warn("Ignored stale HdfsCachePool update: name={}, version={}", (Object)poolName, (Object)obj.getCatalog_version());
    }

    private void updateAuthPolicy(TCatalogObject obj, boolean isDelete) {
        LOG.trace("Updating authorization policy: {} isDelete={}", (Object)obj, (Object)isDelete);
        switch (obj.type) {
            case PRINCIPAL: {
                if (!isDelete) {
                    Principal principal = Principal.fromThrift(obj.getPrincipal());
                    principal.setCatalogVersion(obj.getCatalog_version());
                    this.authPolicy_.addPrincipal(principal);
                    break;
                }
                this.authPolicy_.removePrincipalIfLowerVersion(obj.getPrincipal(), obj.getCatalog_version());
                break;
            }
            case PRIVILEGE: {
                if (!isDelete) {
                    PrincipalPrivilege privilege = PrincipalPrivilege.fromThrift(obj.getPrivilege());
                    privilege.setCatalogVersion(obj.getCatalog_version());
                    try {
                        this.authPolicy_.addPrivilege(privilege);
                    }
                    catch (CatalogException e) {
                        LOG.error("Error adding privilege: ", (Throwable)e);
                    }
                    break;
                }
                this.authPolicy_.removePrivilegeIfLowerVersion(obj.getPrivilege(), obj.getCatalog_version());
                break;
            }
            case AUTHZ_CACHE_INVALIDATION: {
                if (!isDelete) {
                    AuthzCacheInvalidation authzCacheInvalidation = new AuthzCacheInvalidation(obj.getAuthz_cache_invalidation());
                    authzCacheInvalidation.setCatalogVersion(obj.getCatalog_version());
                    this.authzCacheInvalidation_.add(authzCacheInvalidation);
                    Preconditions.checkState((this.authzChecker_ != null ? 1 : 0) != 0);
                    this.authzChecker_.get().invalidateAuthorizationCache();
                    break;
                }
                this.authzCacheInvalidation_.remove(obj.getAuthz_cache_invalidation().getMarker_name());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type: " + (Object)((Object)obj.type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean witnessCatalogServiceId(TUniqueId serviceId) {
        this.catalogServiceIdLock_.readLock().lock();
        try {
            if (this.catalogServiceId_.equals(serviceId)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.catalogServiceIdLock_.readLock().unlock();
        }
        this.catalogServiceIdLock_.writeLock().lock();
        try {
            if (this.catalogServiceId_.equals(serviceId)) {
                boolean bl = false;
                return bl;
            }
            boolean needsReplan = true;
            if (!this.catalogServiceId_.equals(Catalog.INITIAL_CATALOG_SERVICE_ID)) {
                LOG.warn("Detected catalog service restart: service ID changed from {} to {}. Invalidating all cached metadata on this coordinator.", (Object)TUniqueIdUtil.PrintId(this.catalogServiceId_), (Object)TUniqueIdUtil.PrintId(serviceId));
                this.cache_.invalidateAll();
            } else {
                needsReplan = false;
            }
            this.catalogServiceId_ = serviceId;
            this.hdfsCachePools_.clear();
            boolean bl = needsReplan;
            return bl;
        }
        finally {
            this.catalogServiceIdLock_.writeLock().unlock();
        }
    }

    @VisibleForTesting
    void invalidateCacheForObject(TCatalogObject obj) {
        ArrayList<String> invalidated = new ArrayList<String>();
        switch (obj.type) {
            case TABLE: 
            case VIEW: {
                this.invalidateCacheForTable(obj.table.db_name, obj.table.tbl_name, invalidated);
                this.invalidateCacheForDb(obj.table.db_name, (Iterable<DbCacheKey.DbInfoType>)ImmutableList.of((Object)((Object)DbCacheKey.DbInfoType.TABLE_LIST)), invalidated);
                break;
            }
            case HDFS_PARTITION: {
                this.invalidateCacheForPartition(obj.hdfs_partition.db_name, obj.hdfs_partition.tbl_name, obj.hdfs_partition.partition_name, obj.hdfs_partition.id, invalidated);
                break;
            }
            case FUNCTION: {
                this.invalidateCacheForDb(obj.fn.name.db_name, (Iterable<DbCacheKey.DbInfoType>)ImmutableList.of((Object)((Object)DbCacheKey.DbInfoType.FUNCTION_NAMES)), invalidated);
                this.invalidateCacheForFunction(obj.fn.name.db_name, obj.fn.name.function_name, invalidated);
                if (obj.fn.hdfs_location == null) break;
                FeSupport.NativeLibCacheSetNeedsRefresh(obj.fn.hdfs_location);
                break;
            }
            case DATABASE: {
                if (this.cache_.asMap().remove(DB_LIST_CACHE_KEY) != null) {
                    invalidated.add("list of database names");
                }
                this.invalidateCacheForDb(obj.db.db_name, (Iterable<DbCacheKey.DbInfoType>)ImmutableList.of((Object)((Object)DbCacheKey.DbInfoType.TABLE_LIST), (Object)((Object)DbCacheKey.DbInfoType.HMS_METADATA), (Object)((Object)DbCacheKey.DbInfoType.FUNCTION_NAMES)), invalidated);
                break;
            }
            case DATA_SOURCE: {
                if (this.cache_.asMap().remove(DS_OBJ_LIST_CACHE_KEY) != null) {
                    invalidated.add("list of DataSource objects");
                }
                this.invalidateCacheForDataSource(obj.data_source.name, invalidated);
                break;
            }
        }
        if (!invalidated.isEmpty()) {
            LOG.debug("Invalidated objects in cache: {}", invalidated);
        }
    }

    private void invalidateCacheForDb(String dbName, Iterable<DbCacheKey.DbInfoType> types, List<String> invalidated) {
        for (DbCacheKey.DbInfoType type : types) {
            DbCacheKey key = new DbCacheKey(dbName.toLowerCase(), type);
            if (this.cache_.asMap().remove(key) == null) continue;
            invalidated.add((Object)((Object)type) + " for DB " + dbName);
        }
    }

    private void invalidateCacheForTable(String dbName, String tblName, List<String> invalidated) {
        TableCacheKey key = new TableCacheKey(dbName.toLowerCase(), tblName.toLowerCase());
        if (this.cache_.asMap().remove(key) != null) {
            invalidated.add("table " + dbName + "." + tblName);
        }
    }

    private void invalidateCacheForPartition(String dbName, String tblName, String partName, long partitionId, List<String> invalidated) {
        PartitionCacheKey key = new PartitionCacheKey(partitionId);
        if (this.cache_.asMap().remove(key) != null) {
            invalidated.add(String.format("partition %s.%s:%s (id=%d)", dbName, tblName, partName, partitionId));
        }
    }

    private void invalidateCacheForFunction(String dbName, String functionName, List<String> invalidated) {
        FunctionsCacheKey key = new FunctionsCacheKey(dbName, functionName);
        if (this.cache_.asMap().remove(key) != null) {
            invalidated.add("function " + dbName + "." + functionName);
        }
    }

    private void invalidateCacheForDataSource(String dsName, List<String> invalidated) {
        DataSourceCacheKey key = new DataSourceCacheKey(dsName.toLowerCase());
        if (this.cache_.asMap().remove(key) != null) {
            invalidated.add("DataSource " + dsName);
        }
    }

    @Override
    public TValidWriteIdList getValidWriteIdList(MetaProvider.TableMetaRef ref) {
        Preconditions.checkArgument((boolean)(ref instanceof TableMetaRefImpl), (String)"table ref %s was not created by CatalogdMetaProvider", (Object)ref);
        return ((TableMetaRefImpl)ref).validWriteIds_;
    }

    private static /* synthetic */ Object lambda$loadWithCaching$0(CompletableFuture f) throws Exception {
        return f;
    }

    @VisibleForTesting
    static class SizeOfWeigher
    implements Weigher<Object, Object> {
        private static final boolean BYPASS_FLYWEIGHT = true;
        private static final boolean CACHE_SIZES = true;
        private static final int BYTES_PER_WORD = 8;
        private static final int OVERHEAD_PER_ENTRY = 128;
        private final SizeOf SIZEOF;
        private final MemoryMeter METER;
        private final boolean useJamm_;
        private final Histogram entrySize_;

        public SizeOfWeigher(boolean useJamm, Histogram entrySize) {
            if (useJamm) {
                this.METER = MemoryMeter.builder().build();
                this.SIZEOF = null;
            } else {
                this.SIZEOF = SizeOf.newInstance((boolean)true, (boolean)true, (SizeOfFilter[])new SizeOfFilter[0]);
                this.METER = null;
            }
            this.useJamm_ = useJamm;
            this.entrySize_ = entrySize;
        }

        public SizeOfWeigher() {
            this(true, null);
        }

        public int weigh(Object key, Object value) {
            long size = 128L;
            try {
                if (this.useJamm_) {
                    size += this.METER.measureDeep(key);
                    size += this.METER.measureDeep(value);
                } else {
                    size += this.SIZEOF.deepSizeOf(new Object[]{key, value});
                }
            }
            catch (CannotAccessFieldException e) {
                LOG.warn("Unable to weigh cache entry, additional add-opens needed", (Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to weigh cache entry", (Throwable)e);
            }
            if (this.entrySize_ != null) {
                this.entrySize_.update(size);
            }
            if (size > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)size;
        }
    }

    @Immutable
    private static class DataSourceCacheKey {
        private final String dsName_;

        DataSourceCacheKey(String dsName) {
            this.dsName_ = dsName;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.dsName_, this.getClass()});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataSourceCacheKey)) {
                return false;
            }
            DataSourceCacheKey other = (DataSourceCacheKey)obj;
            return this.dsName_.equals(other.dsName_);
        }
    }

    private static class IcebergApiTableCacheKey
    extends VersionedTableCacheKey {
        public IcebergApiTableCacheKey(TableMetaRefImpl table) {
            super(table);
        }
    }

    private static class IcebergMetaCacheKey
    extends VersionedTableCacheKey {
        public IcebergMetaCacheKey(TableMetaRefImpl table) {
            super(table);
        }
    }

    private static class DbCacheKey {
        private final String dbName_;
        private final DbInfoType type_;

        DbCacheKey(String dbName, DbInfoType type) {
            this.dbName_ = (String)Preconditions.checkNotNull((Object)dbName);
            this.type_ = (DbInfoType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.dbName_, this.type_});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DbCacheKey other = (DbCacheKey)obj;
            return this.dbName_.equals(other.dbName_) && this.type_ == other.type_;
        }

        static enum DbInfoType {
            HMS_METADATA,
            TABLE_LIST,
            FUNCTION_NAMES;

        }
    }

    @Immutable
    private static class PartitionCacheKey {
        private final long partId_;

        PartitionCacheKey(long partId) {
            this.partId_ = partId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.partId_, this.getClass()});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionCacheKey)) {
                return false;
            }
            PartitionCacheKey other = (PartitionCacheKey)obj;
            return this.partId_ == other.partId_;
        }
    }

    private static class PartitionListCacheKey
    extends VersionedTableCacheKey {
        PartitionListCacheKey(TableMetaRefImpl table) {
            super(table);
        }
    }

    private static class ColStatsCacheKey
    extends VersionedTableCacheKey {
        private final String colName_;

        public ColStatsCacheKey(TableMetaRefImpl table, String colName) {
            super(table);
            this.colName_ = colName;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.colName_});
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ColStatsCacheKey)) {
                return false;
            }
            ColStatsCacheKey other = (ColStatsCacheKey)obj;
            return super.equals(obj) && this.colName_.equals(other.colName_);
        }
    }

    private static class VersionedTableCacheKey
    extends TableCacheKey {
        final long version_;

        VersionedTableCacheKey(TableMetaRefImpl table) {
            super(table.dbName_, table.tableName_);
            this.version_ = table.catalogVersion_;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.version_});
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            VersionedTableCacheKey other = (VersionedTableCacheKey)obj;
            return super.equals(obj) && this.version_ == other.version_;
        }
    }

    private static class FunctionsCacheKey
    extends DbChildCacheKey {
        FunctionsCacheKey(String dbName, String funcName) {
            super(dbName, funcName);
        }
    }

    private static class TableCacheKey
    extends DbChildCacheKey {
        TableCacheKey(String dbName, String tableName) {
            super(dbName, tableName);
        }
    }

    private static class DbChildCacheKey {
        final String dbName_;
        final String childName_;

        protected DbChildCacheKey(String dbName, String childName) {
            this.dbName_ = dbName;
            this.childName_ = childName;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.dbName_, this.childName_, this.getClass()});
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            DbChildCacheKey other = (DbChildCacheKey)obj;
            return this.childName_.equals(other.childName_) && this.dbName_.equals(other.dbName_);
        }
    }

    private static class TableMetaRefImpl
    implements MetaProvider.TableMetaRef {
        private final String dbName_;
        private final String tableName_;
        private final SqlConstraints sqlConstraints_;
        private final Table msTable_;
        List<VirtualColumn> virtualColumns_ = new ArrayList<VirtualColumn>();
        private final long catalogVersion_;
        private final long loadedTimeMs_;
        private final TValidWriteIdList validWriteIds_;
        private final boolean isMarkedCached_;
        private final HdfsPartitionLocationCompressor partitionLocationCompressor_;

        public TableMetaRefImpl(String dbName, String tableName, Table msTable, long catalogVersion, long loadedTimeMs, SqlConstraints sqlConstraints, TValidWriteIdList validWriteIds, boolean isMarkedCached, List<String> locationPrefixes, List<TColumn> tvirtCols) {
            this.dbName_ = dbName;
            this.tableName_ = tableName;
            this.msTable_ = msTable;
            this.catalogVersion_ = catalogVersion;
            this.loadedTimeMs_ = loadedTimeMs;
            this.sqlConstraints_ = sqlConstraints;
            this.validWriteIds_ = validWriteIds;
            this.isMarkedCached_ = isMarkedCached;
            this.partitionLocationCompressor_ = locationPrefixes == null ? null : new HdfsPartitionLocationCompressor(msTable.getPartitionKeysSize(), locationPrefixes);
            for (TColumn tvCol : tvirtCols) {
                this.virtualColumns_.add(VirtualColumn.fromThrift(tvCol));
            }
        }

        public String toString() {
            return String.format("TableMetaRef %s.%s@%d", this.dbName_, this.tableName_, this.catalogVersion_);
        }

        @Override
        public boolean isPartitioned() {
            return this.msTable_.getPartitionKeysSize() != 0;
        }

        @Override
        public boolean isMarkedCached() {
            return this.isMarkedCached_;
        }

        public HdfsPartitionLocationCompressor getPartitionLocationCompressor() {
            return this.partitionLocationCompressor_;
        }

        @Override
        public List<String> getPartitionPrefixes() {
            return this.partitionLocationCompressor_.getPrefixes();
        }

        @Override
        public boolean isTransactional() {
            return AcidUtils.isTransactionalTable(this.msTable_.getParameters());
        }

        @Override
        public List<VirtualColumn> getVirtualColumns() {
            return this.virtualColumns_;
        }

        @Override
        public long getCatalogVersion() {
            return this.catalogVersion_;
        }

        @Override
        public long getLoadedTimeMs() {
            return this.loadedTimeMs_;
        }
    }

    public static class PartitionMetadataImpl
    implements MetaProvider.PartitionMetadata {
        private final Map<String, String> hmsParameters_;
        private final long writeId_;
        private final HdfsStorageDescriptor hdfsStorageDescriptor_;
        private final HdfsPartitionLocationCompressor.Location location_;
        private final ImmutableList<FileDescriptor> fds_;
        private final ImmutableList<FileDescriptor> insertFds_;
        private final ImmutableList<FileDescriptor> deleteFds_;
        private final byte[] partitionStats_;
        private final boolean hasIncrementalStats_;
        private final boolean isMarkedCached_;
        private final long lastCompactionId_;

        public PartitionMetadataImpl(Map<String, String> hmsParameters, long writeId, HdfsStorageDescriptor hdfsStorageDescriptor, ImmutableList<FileDescriptor> fds, ImmutableList<FileDescriptor> insertFds, ImmutableList<FileDescriptor> deleteFds, byte[] partitionStats, boolean hasIncrementalStats, boolean isMarkedCached, HdfsPartitionLocationCompressor.Location location, long lastCompactionId) {
            this.hmsParameters_ = hmsParameters;
            this.writeId_ = writeId;
            this.hdfsStorageDescriptor_ = hdfsStorageDescriptor;
            this.location_ = location;
            this.fds_ = fds;
            this.insertFds_ = insertFds;
            this.deleteFds_ = deleteFds;
            this.partitionStats_ = partitionStats;
            this.hasIncrementalStats_ = hasIncrementalStats;
            this.isMarkedCached_ = isMarkedCached;
            this.lastCompactionId_ = lastCompactionId;
        }

        public PartitionMetadataImpl cloneRelativeToHostIndex(ListMap<TNetworkAddress> origIndex, ListMap<TNetworkAddress> dstIndex) {
            ImmutableList<FileDescriptor> fds = PartitionMetadataImpl.cloneFdsRelativeToHostIndex(this.fds_, origIndex, dstIndex);
            ImmutableList<FileDescriptor> insertFds = PartitionMetadataImpl.cloneFdsRelativeToHostIndex(this.insertFds_, origIndex, dstIndex);
            ImmutableList<FileDescriptor> deleteFds = PartitionMetadataImpl.cloneFdsRelativeToHostIndex(this.deleteFds_, origIndex, dstIndex);
            return new PartitionMetadataImpl(this.hmsParameters_, this.writeId_, this.hdfsStorageDescriptor_, fds, insertFds, deleteFds, this.partitionStats_, this.hasIncrementalStats_, this.isMarkedCached_, this.location_, this.lastCompactionId_);
        }

        private static ImmutableList<FileDescriptor> cloneFdsRelativeToHostIndex(ImmutableList<FileDescriptor> fds, ListMap<TNetworkAddress> origIndex, ListMap<TNetworkAddress> dstIndex) {
            ArrayList ret = Lists.newArrayListWithCapacity((int)fds.size());
            for (FileDescriptor fd : fds) {
                ret.add(fd.cloneWithNewHostIndex(origIndex.getList(), dstIndex));
            }
            return ImmutableList.copyOf((Collection)ret);
        }

        @Override
        public Map<String, String> getHmsParameters() {
            return this.hmsParameters_;
        }

        @Override
        public long getWriteId() {
            return this.writeId_;
        }

        @Override
        public HdfsStorageDescriptor getInputFormatDescriptor() {
            return this.hdfsStorageDescriptor_;
        }

        @Override
        public HdfsPartitionLocationCompressor.Location getLocation() {
            return this.location_;
        }

        @Override
        public ImmutableList<FileDescriptor> getFileDescriptors() {
            if (this.insertFds_.isEmpty()) {
                return this.fds_;
            }
            ArrayList ret = Lists.newArrayListWithCapacity((int)(this.insertFds_.size() + this.deleteFds_.size()));
            ret.addAll(this.insertFds_);
            ret.addAll(this.deleteFds_);
            return ImmutableList.copyOf((Collection)ret);
        }

        @Override
        public ImmutableList<FileDescriptor> getInsertFileDescriptors() {
            return this.insertFds_;
        }

        @Override
        public ImmutableList<FileDescriptor> getDeleteFileDescriptors() {
            return this.deleteFds_;
        }

        @Override
        public byte[] getPartitionStats() {
            return this.partitionStats_;
        }

        @Override
        public boolean hasIncrementalStats() {
            return this.hasIncrementalStats_;
        }

        @Override
        public boolean isMarkedCached() {
            return this.isMarkedCached_;
        }

        @Override
        public long getLastCompactionId() {
            return this.lastCompactionId_;
        }
    }

    @Immutable
    private static class PartitionRefImpl
    implements MetaProvider.PartitionRef {
        private final TPartialPartitionInfo info_;

        public PartitionRefImpl(TPartialPartitionInfo p) {
            this.info_ = (TPartialPartitionInfo)Preconditions.checkNotNull((Object)p);
        }

        @Override
        public String getName() {
            return this.info_.getName();
        }

        private long getId() {
            return this.info_.id;
        }
    }
}

