/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RESTCatalogProperties {
    private static final String NAME = "iceberg.rest-catalog.name";
    private static final ImmutableList<Config> CATALOG_CONFIGS = ImmutableList.of((Object)new RequiredConfig("uri", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.uri")), (Object)new Config("prefix", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.prefix")), (Object)new Config("warehouse", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.warehouse")), (Object)new Config("auth.session-timeout-ms", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.session-timeout")), (Object)new VerifiedConfig("iceberg.rest-catalog.session", "NONE"), (Object)new VerifiedConfig("iceberg.rest-catalog.vended-credentials-enabled", "false"), (Object)new VerifiedConfig("iceberg.rest-catalog.nested-namespace-enabled", "false"), (Object)new VerifiedConfig("iceberg.rest-catalog.case-insensitive-name-matching", "true"), (Object)new IgnoredConfig("iceberg.rest-catalog.case-insensitive-name-matching.cache-ttl"), (Object)new IgnoredConfig("iceberg.catalog.type"), (Object)new IgnoredConfig("connector.name"), (Object)new IgnoredConfig("iceberg.rest-catalog.name"), (Object[])new Config[0]);
    private static final ImmutableList<Config> OAUTH2_CONFIGS = ImmutableList.of((Object)new VerifiedConfig("iceberg.rest-catalog.security", "OAUTH2"), (Object)new Config("oauth2-server-uri", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.oauth2.server-uri")), (Object)new Config("credential", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.oauth2.credential")), (Object)new Config("token", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.oauth2.token")), (Object)new Config("token-refresh-enabled", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.oauth2.token-refresh-enabled")), (Object)new Config("scope", (ImmutableList<String>)ImmutableList.of((Object)"iceberg.rest-catalog.oauth2.scope")));
    private Map<String, String> sourceMap_ = new HashMap<String, String>();
    private Map<String, String> finalMap_;
    private String uri_;
    private String name_ = "";

    public RESTCatalogProperties(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            this.sourceMap_.put(string, properties.getProperty(string));
        }
        if (this.sourceMap_.containsKey(NAME)) {
            this.name_ = this.sourceMap_.get(NAME);
        }
        this.finalMap_ = new HashMap<String, String>();
        this.applyConfigs(CATALOG_CONFIGS, this.sourceMap_, this.finalMap_);
        this.applyConfigs(OAUTH2_CONFIGS, this.sourceMap_, this.finalMap_);
        for (Map.Entry entry : this.sourceMap_.entrySet()) {
            Preconditions.checkState((!this.finalMap_.containsKey(entry.getKey()) ? 1 : 0) != 0);
            this.finalMap_.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.uri_ = this.finalMap_.get("uri");
        Preconditions.checkState((this.uri_ != null ? 1 : 0) != 0);
    }

    private void applyConfigs(ImmutableList<Config> configs, Map<String, String> sourceMap, Map<String, String> outputMap) {
        for (Config config : configs) {
            config.applyConfig(sourceMap, outputMap);
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getUri() {
        return this.uri_;
    }

    public Map<String, String> getCatalogProperties() {
        return this.finalMap_;
    }

    private static class VerifiedConfig
    extends Config {
        private String expectedValue;

        public VerifiedConfig(String key, String expectedValue) {
            super(key, (ImmutableList<String>)ImmutableList.of());
            Preconditions.checkState((expectedValue != null ? 1 : 0) != 0);
            this.expectedValue = expectedValue;
        }

        @Override
        public boolean applyConfig(Map<String, String> sourceMap, Map<String, String> outputMap) {
            String value = sourceMap.get(this.catalogKey);
            if (value != null) {
                if (!this.expectedValue.equalsIgnoreCase(value)) {
                    throw new IllegalStateException(String.format("The only allowed value for REST Catalog property '%s' is '%s'.\nValue in configuration is '%s'", this.catalogKey, this.expectedValue, value));
                }
                return true;
            }
            return false;
        }
    }

    private static class IgnoredConfig
    extends Config {
        public IgnoredConfig(String key) {
            super(key, (ImmutableList<String>)ImmutableList.of());
        }

        @Override
        public boolean applyConfig(Map<String, String> sourceMap, Map<String, String> outputMap) {
            if (sourceMap.containsKey(this.catalogKey)) {
                sourceMap.remove(this.catalogKey);
                return true;
            }
            return false;
        }
    }

    private static class RequiredConfig
    extends Config {
        public RequiredConfig(String key) {
            super(key, (ImmutableList<String>)ImmutableList.of());
        }

        public RequiredConfig(String key, ImmutableList<String> alternativeKeys) {
            super(key, alternativeKeys);
        }

        @Override
        public boolean applyConfig(Map<String, String> sourceMap, Map<String, String> outputMap) {
            boolean success = super.applyConfig(sourceMap, outputMap);
            if (success) {
                return true;
            }
            throw new IllegalStateException(String.format("Missing property of IcebergRESTCatalog: %s", this.catalogKey));
        }
    }

    private static class Config {
        protected String catalogKey;
        protected ImmutableList<String> alternativeKeys;

        public Config(String key) {
            this(key, (ImmutableList<String>)ImmutableList.of());
        }

        public Config(String key, ImmutableList<String> alternativeKeys) {
            this.catalogKey = key;
            this.alternativeKeys = alternativeKeys;
        }

        public boolean applyConfig(Map<String, String> sourceMap, Map<String, String> outputMap) {
            this.verifyOutputMap(outputMap);
            boolean applied = false;
            String value = sourceMap.get(this.catalogKey);
            if (value != null) {
                applied = true;
                sourceMap.remove(this.catalogKey);
                outputMap.put(this.catalogKey, value);
            }
            for (String alternativeKey : this.alternativeKeys) {
                value = sourceMap.get(alternativeKey);
                if (value == null) continue;
                if (applied) {
                    throw new IllegalStateException(String.format("Alternative key '%s' sets the same configuration as '%s' which is already defined with value '%s'", alternativeKey, this.catalogKey, value));
                }
                applied = true;
                sourceMap.remove(alternativeKey);
                outputMap.put(this.catalogKey, value);
            }
            return applied;
        }

        protected void verifyOutputMap(Map<String, String> outputMap) {
            String value = outputMap.get(this.catalogKey);
            if (value != null) {
                throw new IllegalStateException(String.format("REST Catalog property is defined multiple times: %s\nCurrent value: %s", this.catalogKey, value));
            }
        }
    }
}

