/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaIcebergDeleteOrphanFiles
implements DeleteOrphanFiles {
    public static final String METADATA_FOLDER_NAME = "metadata";
    public static final String DATA_FOLDER_NAME = "data";
    private static final Logger LOG = LoggerFactory.getLogger(ImpalaIcebergDeleteOrphanFiles.class);
    private String tableLocation;
    private long olderThanTimestamp = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(3L);
    private Consumer<String> deleteFunc;
    private ExecutorService deleteExecutorService = MoreExecutors.newDirectExecutorService();
    private final Configuration conf;
    private final Table table;

    public ImpalaIcebergDeleteOrphanFiles(Configuration conf, Table table) {
        this.conf = conf;
        this.table = table;
        this.deleteFunc = file -> table.io().deleteFile(file);
        this.tableLocation = table.location();
    }

    public ImpalaIcebergDeleteOrphanFiles location(String location) {
        this.tableLocation = location;
        return this;
    }

    public ImpalaIcebergDeleteOrphanFiles olderThan(long newOlderThanTimestamp) {
        this.olderThanTimestamp = newOlderThanTimestamp;
        return this;
    }

    public ImpalaIcebergDeleteOrphanFiles deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    public ImpalaIcebergDeleteOrphanFiles executeDeleteWith(ExecutorService executorService) {
        this.deleteExecutorService = executorService;
        return this;
    }

    public DeleteOrphanFiles.Result execute() {
        LOG.info("Cleaning orphan files for {}", (Object)this.table.name());
        ImpalaIcebergDeleteOrphanFilesResult result = new ImpalaIcebergDeleteOrphanFilesResult();
        result.addDeletedFiles(this.cleanContentFiles(this.olderThanTimestamp));
        result.addDeletedFiles(this.cleanMetadata(this.olderThanTimestamp));
        LOG.debug("Deleting {} files while cleaning orphan files for {}", (Object)result.deletedFiles.size(), (Object)this.table.name());
        Tasks.foreach((Iterable)result.deletedFiles).executeWith(this.deleteExecutorService).retry(3).stopRetryOn(new Class[]{FileNotFoundException.class}).suppressFailureWhenFinished().onFailure((file, thrown) -> LOG.warn("Delete failed for file: {}", file, (Object)thrown)).run(this.deleteFunc::accept);
        return result;
    }

    private Set<String> cleanContentFiles(long lastTime) {
        Sets.SetView validFiles = Sets.union(this.getAllContentFilePath(), ImpalaIcebergDeleteOrphanFiles.getAllStatisticsFilePath(this.table));
        LOG.debug("Valid content file for {} are {}", (Object)this.table.name(), (Object)validFiles.size());
        try {
            Path dataPath = new Path(this.tableLocation, DATA_FOLDER_NAME);
            return this.getFilesToBeDeleted(lastTime, (Set<String>)validFiles, dataPath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Set<String> getAllContentFilePath() {
        HashSet validFilesPath = Sets.newHashSet();
        Table metadataTable = this.getMetadataTable();
        TableScan tableScan = metadataTable.newScan();
        CloseableIterable manifestFileScanTasks = ((TableScan)tableScan.planWith(this.deleteExecutorService)).planFiles();
        CloseableIterable entries = CloseableIterable.concat(this.entriesOfManifest((CloseableIterable<FileScanTask>)manifestFileScanTasks));
        for (StructLike entry : entries) {
            StructLike fileRecord = (StructLike)entry.get(4, StructLike.class);
            String filePath = (String)fileRecord.get(1, String.class);
            validFilesPath.add(ImpalaIcebergDeleteOrphanFiles.getUriPath(filePath));
        }
        return validFilesPath;
    }

    private Iterable<CloseableIterable<StructLike>> entriesOfManifest(CloseableIterable<FileScanTask> fileScanTasks) {
        return Iterables.transform(fileScanTasks, task -> {
            assert (task != null);
            return ((DataTask)task).rows();
        });
    }

    private static Set<String> getAllStatisticsFilePath(Table table) {
        return ReachableFileUtil.statisticsFilesLocations((Table)table).stream().map(ImpalaIcebergDeleteOrphanFiles::getUriPath).collect(Collectors.toSet());
    }

    protected Set<String> cleanMetadata(long lastTime) {
        LOG.info("{} start clean metadata files", (Object)this.table.name());
        try {
            Set<String> validFiles = ImpalaIcebergDeleteOrphanFiles.getValidMetadataFiles(this.table);
            LOG.debug("Valid metadata files for {} are {}", (Object)this.table.name(), validFiles);
            Path metadataLocation = new Path(this.tableLocation, METADATA_FOLDER_NAME);
            return this.getFilesToBeDeleted(lastTime, validFiles, metadataLocation);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private Set<String> getFilesToBeDeleted(long lastTime, Set<String> validFiles, Path location) throws IOException {
        HashSet filesToDelete = Sets.newHashSet();
        FileSystem fs = location.getFileSystem(this.conf);
        RemoteIterator metadataLocations = fs.listFiles(location, true);
        while (metadataLocations.hasNext()) {
            LocatedFileStatus metadataFile = (LocatedFileStatus)metadataLocations.next();
            if (metadataFile.getModificationTime() >= lastTime || validFiles.contains(ImpalaIcebergDeleteOrphanFiles.getUriPath(metadataFile.getPath().toString()))) continue;
            filesToDelete.add(metadataFile.getPath().toString());
        }
        return filesToDelete;
    }

    private Table getMetadataTable() {
        return MetadataTableUtils.createMetadataTableInstance((TableOperations)((HasTableOperations)this.table).operations(), (String)this.table.name(), (String)(this.table.name() + "#" + MetadataTableType.ALL_ENTRIES.name()), (MetadataTableType)MetadataTableType.ALL_ENTRIES);
    }

    private static Set<String> getValidMetadataFiles(Table icebergTable) {
        HashSet validFiles = Sets.newHashSet();
        Iterable snapshots = icebergTable.snapshots();
        for (Snapshot snapshot : snapshots) {
            String manifestListLocation = snapshot.manifestListLocation();
            validFiles.add(ImpalaIcebergDeleteOrphanFiles.getUriPath(manifestListLocation));
            List manifestFiles = snapshot.allManifests(icebergTable.io());
            for (ManifestFile manifestFile : manifestFiles) {
                validFiles.add(ImpalaIcebergDeleteOrphanFiles.getUriPath(manifestFile.path()));
            }
        }
        Stream.of(ReachableFileUtil.metadataFileLocations((Table)icebergTable, (boolean)false).stream(), ReachableFileUtil.statisticsFilesLocations((Table)icebergTable).stream(), Stream.of(ReachableFileUtil.versionHintLocation((Table)icebergTable))).reduce(Stream::concat).orElse(Stream.empty()).map(ImpalaIcebergDeleteOrphanFiles::getUriPath).forEach(validFiles::add);
        return validFiles;
    }

    private static String getUriPath(String path) {
        return URI.create(path).getPath();
    }

    public static class ImpalaIcebergDeleteOrphanFilesResult
    implements DeleteOrphanFiles.Result {
        private final Set<String> deletedFiles = Sets.newHashSet();

        public Iterable<String> orphanFileLocations() {
            return this.deletedFiles;
        }

        public void addDeletedFiles(Set<String> files) {
            this.deletedFiles.addAll(files);
        }
    }
}

