/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergCatalog;
import org.apache.impala.catalog.iceberg.RESTCatalogProperties;
import org.apache.impala.util.IcebergUtil;

public class IcebergRESTCatalog
implements IcebergCatalog {
    private final String REST_URI;
    private final RESTCatalog restCatalog_;

    public IcebergRESTCatalog(Properties properties) {
        this.setContextClassLoader();
        RESTCatalogProperties restConfig = new RESTCatalogProperties(properties);
        this.REST_URI = restConfig.getUri();
        this.restCatalog_ = new RESTCatalog();
        HiveConf conf = new HiveConf(IcebergRESTCatalog.class);
        this.restCatalog_.setConf((Object)conf);
        this.restCatalog_.initialize(restConfig.getName(), restConfig.getCatalogProperties());
    }

    public String getUri() {
        return this.REST_URI;
    }

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        throw new UnsupportedOperationException("CREATE TABLE is not implemented for REST catalog");
    }

    public ImmutableList<String> listNamespaces() {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Namespace ns : this.restCatalog_.listNamespaces()) {
            ret.add((Object)ns.toString());
        }
        return ret.build();
    }

    public List<TableIdentifier> listTables(String namespace) {
        return this.restCatalog_.listTables(Namespace.of((String[])new String[]{namespace}));
    }

    @Override
    public Table loadTable(FeIcebergTable feTable) throws TableLoadingException {
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        return this.loadTable(tableId, null, null);
    }

    @Override
    public Table loadTable(TableIdentifier tableId, String tableLocation, Map<String, String> properties) throws IcebergTableLoadingException {
        return this.restCatalog_.loadTable(tableId);
    }

    @Override
    public boolean dropTable(FeIcebergTable feTable, boolean purge) {
        throw new UnsupportedOperationException("DROP TABLE is not implemented for REST catalog");
    }

    @Override
    public boolean dropTable(String dbName, String tblName, boolean purge) {
        throw new UnsupportedOperationException("DROP TABLE is not implemented for REST catalog");
    }

    @Override
    public void renameTable(FeIcebergTable feTable, TableIdentifier newTableId) {
        throw new UnsupportedOperationException("RENAME TABLE is not implemented for REST catalog");
    }
}

