/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.VirtualTable;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.IcebergSchemaConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMetadataTable
extends VirtualTable {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergMetadataTable.class);
    private FeIcebergTable baseTable_;
    private String metadataTableName_;

    public IcebergMetadataTable(FeIcebergTable baseTable, String metadataTableTypeStr) throws ImpalaRuntimeException {
        super(null, baseTable.getDb(), baseTable.getName(), baseTable.getOwnerUser());
        this.baseTable_ = baseTable;
        this.metadataTableName_ = metadataTableTypeStr.toUpperCase();
        MetadataTableType type = MetadataTableType.from((String)metadataTableTypeStr.toUpperCase());
        Preconditions.checkNotNull((Object)type);
        Table metadataTable = MetadataTableUtils.createMetadataTableInstance((Table)this.baseTable_.getIcebergApiTable(), (MetadataTableType)type);
        Schema metadataTableSchema = metadataTable.schema();
        for (Column col : IcebergSchemaConverter.convertToImpalaSchema(metadataTableSchema)) {
            LOG.trace("Adding column: \"{}\" with type: \"{}\" to metadata table.", (Object)col.getName(), (Object)col.getType());
            this.addColumn(IcebergColumn.cloneWithNullability((IcebergColumn)col, true));
        }
    }

    @Override
    public long getNumRows() {
        return -1L;
    }

    public FeIcebergTable getBaseTable() {
        return this.baseTable_;
    }

    @Override
    public String getFullName() {
        return super.getFullName() + "." + this.metadataTableName_;
    }

    public String getMetadataTableName() {
        return this.metadataTableName_;
    }

    @Override
    public TableName getTableName() {
        return new TableName(this.db_.getName(), this.name_, this.metadataTableName_);
    }

    @Override
    public TTableStats getTTableStats() {
        long totalBytes = 0L;
        TTableStats ret = new TTableStats(this.getNumRows());
        ret.setTotal_file_bytes(totalBytes);
        return ret;
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getMetaStoreTable() {
        return this.baseTable_.getMetaStoreTable();
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.ICEBERG_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        desc.setIcebergTable(FeIcebergTable.Utils.getTIcebergTable(this.baseTable_, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return desc;
    }

    public static boolean isIcebergMetadataTable(List<String> tblRefPath, Analyzer analyzer) {
        if (!IcebergMetadataTable.canBeIcebergMetadataTable(tblRefPath)) {
            return false;
        }
        TableName virtualTableName = new TableName(tblRefPath.get(0), tblRefPath.get(1), tblRefPath.get(2));
        FeTable catalogTable = analyzer.getStmtTableCache().tables.get(virtualTableName);
        return catalogTable instanceof FeIcebergTable || catalogTable instanceof IcebergMetadataTable;
    }

    public static boolean canBeIcebergMetadataTable(List<String> tblRefPath) {
        if (tblRefPath == null) {
            return false;
        }
        if (tblRefPath.size() < 3) {
            return false;
        }
        String vTableName = tblRefPath.get(2).toUpperCase();
        return EnumUtils.isValidEnum(MetadataTableType.class, (String)vTableName);
    }
}

