/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergCatalog;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TIcebergCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHadoopTables
implements IcebergCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergHadoopTables.class);
    private static IcebergHadoopTables instance_;
    private HadoopTables hadoopTables = new HadoopTables(FileSystemUtil.getConfiguration());

    public static synchronized IcebergHadoopTables getInstance() {
        if (instance_ == null) {
            instance_ = new IcebergHadoopTables();
        }
        return instance_;
    }

    private IcebergHadoopTables() {
    }

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.hadoopTables.create(schema, spec, properties, location);
    }

    @Override
    public Table loadTable(FeIcebergTable feTable) throws TableLoadingException {
        Preconditions.checkState((feTable.getIcebergCatalog() == TIcebergCatalog.HADOOP_TABLES ? 1 : 0) != 0);
        return this.loadTable(null, feTable.getLocation(), null);
    }

    @Override
    public Table loadTable(TableIdentifier tableId, String tableLocation, Map<String, String> properties) throws IcebergTableLoadingException {
        Preconditions.checkState((tableLocation != null ? 1 : 0) != 0);
        int MAX_ATTEMPTS = 5;
        int SLEEP_MS = 500;
        int attempt = 0;
        while (attempt < 5) {
            try {
                return this.hadoopTables.load(tableLocation);
            }
            catch (NoSuchTableException e) {
                throw new IcebergTableLoadingException(e.getMessage());
            }
            catch (UncheckedIOException | NullPointerException e) {
                if (attempt == 4) {
                    throw new IcebergTableLoadingException(String.format("Could not load Iceberg table at location: %s", tableLocation), e);
                }
                LOG.warn("Caught Exception during Iceberg table loading at location: {}: {}", (Object)tableLocation, (Object)e);
                ++attempt;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new IcebergTableLoadingException(String.format("Could not load Iceberg table at location: %s", tableLocation));
    }

    @Override
    public boolean dropTable(FeIcebergTable feTable, boolean purge) {
        Preconditions.checkState((feTable.getIcebergCatalog() == TIcebergCatalog.HADOOP_TABLES ? 1 : 0) != 0);
        if (purge) {
            // empty if block
        }
        return true;
    }

    @Override
    public boolean dropTable(String dbName, String tblName, boolean purge) {
        throw new UnsupportedOperationException("Hadoop Tables doesn't support dropping table by name");
    }

    @Override
    public void renameTable(FeIcebergTable feTable, TableIdentifier newTableId) {
        throw new UnsupportedOperationException("Cannot rename Iceberg tables that use 'hadoop.tables' as catalog.");
    }
}

