/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergCatalog;
import org.apache.impala.catalog.iceberg.IcebergHadoopTables;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.util.IcebergUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHadoopCatalog
implements IcebergCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergHadoopTables.class);
    private HadoopCatalog hadoopCatalog;

    public IcebergHadoopCatalog(String catalogLocation) {
        this.setContextClassLoader();
        this.hadoopCatalog = new HadoopCatalog();
        Map<String, String> props = IcebergUtil.composeCatalogProperties();
        props.put("warehouse", catalogLocation);
        this.hadoopCatalog.setConf(FileSystemUtil.getConfiguration());
        this.hadoopCatalog.initialize("", props);
    }

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.hadoopCatalog.createTable(identifier, schema, spec, null, properties);
    }

    @Override
    public Table loadTable(FeIcebergTable feTable) throws TableLoadingException {
        Preconditions.checkState((feTable.getIcebergCatalog() == TIcebergCatalog.HADOOP_CATALOG ? 1 : 0) != 0);
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        return this.loadTable(tableId, null, null);
    }

    @Override
    public Table loadTable(TableIdentifier tableId, String tableLocation, Map<String, String> properties) throws IcebergTableLoadingException {
        Preconditions.checkState((tableId != null ? 1 : 0) != 0);
        int MAX_ATTEMPTS = 5;
        int SLEEP_MS = 500;
        int attempt = 0;
        while (attempt < 5) {
            try {
                return this.hadoopCatalog.loadTable(tableId);
            }
            catch (NoSuchTableException e) {
                throw new IcebergTableLoadingException(e.getMessage());
            }
            catch (UncheckedIOException | NullPointerException e) {
                if (attempt == 4) {
                    throw new IcebergTableLoadingException(String.format("Could not load Iceberg table %s", tableId), e);
                }
                LOG.warn("Caught Exception during Iceberg table loading: {}: {}", (Object)tableId, (Object)e);
                ++attempt;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new IcebergTableLoadingException(String.format("Failed to load Iceberg table with id: %s", tableId));
    }

    @Override
    public boolean dropTable(FeIcebergTable feTable, boolean purge) {
        Preconditions.checkState((feTable.getIcebergCatalog() == TIcebergCatalog.HADOOP_CATALOG ? 1 : 0) != 0);
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        return this.hadoopCatalog.dropTable(tableId, purge);
    }

    @Override
    public boolean dropTable(String dbName, String tblName, boolean purge) {
        return this.hadoopCatalog.dropTable(TableIdentifier.of((String[])new String[]{dbName, tblName}), purge);
    }

    @Override
    public void renameTable(FeIcebergTable feTable, TableIdentifier newTableId) {
        TableIdentifier oldTableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        try {
            this.hadoopCatalog.renameTable(oldTableId, newTableId);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Cannot rename Iceberg tables that use 'hadoop.catalog' as catalog.");
        }
    }
}

