/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.io.CloseableIterable;

public class GroupedContentFiles {
    public List<DataFile> dataFilesWithoutDeletes = new ArrayList<DataFile>();
    public List<DataFile> dataFilesWithDeletes = new ArrayList<DataFile>();
    public Set<DeleteFile> positionDeleteFiles = new HashSet<DeleteFile>();
    public Set<DeleteFile> equalityDeleteFiles = new HashSet<DeleteFile>();

    public GroupedContentFiles() {
    }

    public GroupedContentFiles(CloseableIterable<FileScanTask> fileScanTasks) {
        for (FileScanTask scanTask : fileScanTasks) {
            if (scanTask.deletes().isEmpty()) {
                this.dataFilesWithoutDeletes.add((DataFile)scanTask.file());
                continue;
            }
            this.dataFilesWithDeletes.add((DataFile)scanTask.file());
            for (DeleteFile delFile : scanTask.deletes()) {
                if (delFile.content() == FileContent.POSITION_DELETES) {
                    this.positionDeleteFiles.add(delFile);
                    continue;
                }
                Preconditions.checkState((delFile.content() == FileContent.EQUALITY_DELETES ? 1 : 0) != 0);
                this.equalityDeleteFiles.add(delFile);
            }
        }
    }

    public Iterable<ContentFile<?>> getAllContentFiles() {
        return Iterables.concat(this.dataFilesWithoutDeletes, this.dataFilesWithDeletes, this.positionDeleteFiles, this.equalityDeleteFiles);
    }

    public int size() {
        return this.dataFilesWithDeletes.size() + this.dataFilesWithoutDeletes.size() + this.positionDeleteFiles.size() + this.equalityDeleteFiles.size();
    }

    public boolean isEmpty() {
        return Iterables.isEmpty(this.getAllContentFiles());
    }
}

