/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.SelfEventContext;
import org.apache.impala.common.Reference;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.util.DebugUtils;

public class RenameTableBarrierEvent
extends MetastoreEvents.DerivedMetastoreTableEvent {
    private final MetastoreEvents.MetastoreTableEvent pseudoEvent_;
    private final RenameEventState state_;

    RenameTableBarrierEvent(MetastoreEvents.DerivedMetastoreEventContext context, MetastoreEvents.MetastoreTableEvent pseudoEvent, RenameEventState state) {
        super(context, pseudoEvent.event_);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0);
        Preconditions.checkArgument((pseudoEvent.getEventType() == MetastoreEvents.MetastoreEventType.DROP_TABLE || pseudoEvent.getEventType() == MetastoreEvents.MetastoreEventType.CREATE_TABLE ? 1 : 0) != 0);
        this.pseudoEvent_ = pseudoEvent;
        this.state_ = state;
    }

    boolean canProcess() {
        if (this.getEventType() == MetastoreEvents.MetastoreEventType.DROP_TABLE) {
            return !this.state_.isDropProcessed();
        }
        return this.state_.isDropProcessed() && !this.state_.isCreateProcessed();
    }

    private void updateStatus(boolean skip) {
        this.state_.setProcessed(this.getEventType(), skip);
        if (this.state_.isSkipped()) {
            this.metrics_.getCounter("events-skipped").inc();
            this.getActualEvent().debugLog("Incremented skipped metric to {}", this.metrics_.getCounter("events-skipped").getCount());
        }
        if (this.state_.isProcessed()) {
            this.catalog_.getMetastoreEventProcessor().getDeleteEventLog().removeEvent(this.getEventId());
        }
    }

    @VisibleForTesting
    RenameEventState getState() {
        return this.state_;
    }

    @Override
    public void processIfEnabled() throws CatalogException {
        Preconditions.checkState((boolean)this.canProcess());
        if (this.getActualEvent().isEventProcessingDisabled()) {
            this.updateStatus(true);
            return;
        }
        if (!this.state_.isDropProcessed()) {
            DebugUtils.executeDebugAction(BackendConfig.INSTANCE.debugActions(), "catalogd_event_processing_delay");
        }
        this.process();
        if (this.state_.isProcessed()) {
            this.getActualEvent().injectErrorIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() throws CatalogException {
        Timer.Context context = null;
        Db db = this.catalog_.getDb(this.getDbName());
        Table table = null;
        if (db != null) {
            table = db.getTable(this.getTableName());
        }
        if (table != null) {
            context = table.getMetrics().getTimer("events-process-duration").time();
        }
        String fqTableName = this.getFullyQualifiedTblName();
        boolean skipped = true;
        try {
            if (this.getEventType() == MetastoreEvents.MetastoreEventType.DROP_TABLE) {
                if (table != null && this.catalogOpExecutor_.removeTableIfNotAddedLater(this.getEventId(), this.getDbName(), this.getTableName(), new Reference<Boolean>())) {
                    skipped = false;
                    this.getActualEvent().infoLog("Successfully removed table {}", fqTableName);
                    this.metrics_.getCounter("tables-removed").inc();
                }
            } else {
                Preconditions.checkState((this.getEventType() == MetastoreEvents.MetastoreEventType.CREATE_TABLE ? 1 : 0) != 0);
                if (db != null && this.catalogOpExecutor_.addTableIfNotRemovedLater(this.getEventId(), this.pseudoEvent_.getTable())) {
                    skipped = false;
                    this.getActualEvent().infoLog("Successfully added table {}", fqTableName);
                    this.metrics_.getCounter("tables-added").inc();
                }
            }
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
        this.updateStatus(skipped);
    }

    @Override
    protected boolean onFailure(Exception e) {
        return false;
    }

    @Override
    protected boolean shouldSkipWhenSyncingToLatestEventId() {
        throw new UnsupportedOperationException("Not supported for rename table barrier event");
    }

    @Override
    protected boolean isEventProcessingDisabled() {
        throw new UnsupportedOperationException("Not supported for rename table barrier event");
    }

    @Override
    protected void processTableEvent() {
        throw new UnsupportedOperationException("Not supported for rename table barrier event");
    }

    @Override
    protected SelfEventContext getSelfEventContext() {
        throw new UnsupportedOperationException("Not supported for rename table barrier event");
    }

    @Override
    public String getEventDesc() {
        return this.getActualEvent().getEventDesc() + " pseudo-event " + (Object)((Object)this.getEventType());
    }

    static class RenameEventState {
        private boolean dropSkipped_ = false;
        private boolean dropProcessed_ = false;
        private boolean createSkipped_ = false;
        private boolean createProcessed_ = false;

        RenameEventState() {
        }

        synchronized boolean isDropProcessed() {
            return this.dropProcessed_;
        }

        synchronized boolean isCreateProcessed() {
            return this.createProcessed_;
        }

        synchronized void setProcessed(MetastoreEvents.MetastoreEventType eventType, boolean skipped) {
            if (eventType == MetastoreEvents.MetastoreEventType.DROP_TABLE) {
                Preconditions.checkState((!this.dropProcessed_ ? 1 : 0) != 0);
                this.dropSkipped_ = skipped;
                this.dropProcessed_ = true;
            } else {
                Preconditions.checkState((eventType == MetastoreEvents.MetastoreEventType.CREATE_TABLE ? 1 : 0) != 0);
                Preconditions.checkState((!this.createProcessed_ ? 1 : 0) != 0);
                this.createSkipped_ = skipped;
                this.createProcessed_ = true;
            }
        }

        private synchronized boolean isSkipped() {
            return this.dropSkipped_ && this.createSkipped_;
        }

        private synchronized boolean isProcessed() {
            return this.dropProcessed_ && this.createProcessed_;
        }
    }
}

