/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import org.apache.impala.catalog.events.ConfigValidator;
import org.apache.impala.catalog.events.DefaultConfigValidator;
import org.apache.impala.compat.MetastoreShim;

public enum MetastoreEventProcessorConfig {
    FIRE_EVENTS_FOR_DML("hive.metastore.dml.events", "true"),
    METASTORE_DEFAULT_CATALOG_NAME("metastore.catalog.default", MetastoreShim.getDefaultCatalogName());

    private final ConfigValidator validator_;

    private MetastoreEventProcessorConfig(String configKey, String expectedValue) {
        Preconditions.checkNotNull((Object)configKey);
        this.validator_ = new DefaultConfigValidator(configKey, expectedValue);
    }

    private MetastoreEventProcessorConfig(ConfigValidator validator) {
        this.validator_ = (ConfigValidator)Preconditions.checkNotNull((Object)validator);
    }

    public ConfigValidator getValidator() {
        return this.validator_;
    }

    public String toString() {
        return this.validator_.toString();
    }

    public ConfigValidator.ValidationResult validate(String value) {
        return this.validator_.validate(value);
    }
}

