/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InFlightEvents {
    private static final int DEFAULT_MAX_NUMBER_OF_INFLIGHT_EVENTS = 100;
    private static final int DEFAULT_MAX_NUMBER_OF_INFLIGHT_INSERT_EVENTS = 100;
    private static final Logger LOG = LoggerFactory.getLogger(InFlightEvents.class);
    private final LinkedList<Long> versionsForInflightEvents_ = new LinkedList();
    private final LinkedList<Long> idsForInflightDmlEvents_ = new LinkedList();
    private final int capacity_for_versions_;
    private final int capacity_for_eventIds_;

    public InFlightEvents() {
        this.capacity_for_versions_ = 100;
        this.capacity_for_eventIds_ = 100;
    }

    public List<Long> getAll(boolean isInsertEvent) {
        if (isInsertEvent) {
            return ImmutableList.copyOf(this.idsForInflightDmlEvents_);
        }
        return ImmutableList.copyOf(this.versionsForInflightEvents_);
    }

    public boolean remove(boolean isInsertEvent, long versionNumber) {
        if (isInsertEvent) {
            return this.idsForInflightDmlEvents_.remove(versionNumber);
        }
        return this.versionsForInflightEvents_.remove(versionNumber);
    }

    public boolean add(boolean isInsertEvent, long versionNumber) {
        if (isInsertEvent) {
            if (this.idsForInflightDmlEvents_.size() == this.capacity_for_eventIds_) {
                LOG.warn(String.format("Number of Insert events to be stored is at  its max capacity %d. Ignoring add request for eventId %d.", 100, versionNumber));
                return false;
            }
            this.idsForInflightDmlEvents_.add(versionNumber);
        } else {
            if (this.versionsForInflightEvents_.size() == this.capacity_for_versions_) {
                LOG.warn(String.format("Number of DDL events to be stored is at its max capacity %d. Ignoring add request for version %d.", 100, versionNumber));
                return false;
            }
            this.versionsForInflightEvents_.add(versionNumber);
        }
        return true;
    }

    public int size(boolean isInsertEvent) {
        if (isInsertEvent) {
            return this.idsForInflightDmlEvents_.size();
        }
        return this.versionsForInflightEvents_.size();
    }

    public String print() {
        return Joiner.on((char)',').join(this.versionsForInflightEvents_);
    }
}

