/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.HdfsTable;

public class DeleteEventLog {
    private SortedMap<Long, Object> eventLog_ = new TreeMap<Long, Object>();
    private static final String DB_KEY_FORMAT_STR = "DB:%s";
    private static final String TBL_KEY_FORMAT_STR = "TBL:%s.%s";
    private static final String PART_KEY_FORMAT_STR = "PART:%s.%s";

    public synchronized void addRemovedObject(long eventId, Object value) {
        Preconditions.checkNotNull((Object)value);
        this.eventLog_.put(eventId, value);
    }

    public synchronized boolean wasRemovedAfter(long eventId, Object value) {
        Preconditions.checkNotNull((Object)value);
        return this.keyExistsAfterEventId(eventId, value);
    }

    private boolean keyExistsAfterEventId(long eventId, Object key) {
        for (Object objectName : this.eventLog_.tailMap(eventId + 1L).values()) {
            if (!key.equals(objectName)) continue;
            return true;
        }
        return false;
    }

    public synchronized void garbageCollect(long eventId) {
        if (!this.eventLog_.isEmpty() && this.eventLog_.firstKey() <= eventId) {
            this.eventLog_ = new TreeMap<Long, Object>(this.eventLog_.tailMap(eventId + 1L));
        }
    }

    public synchronized void removeEvent(long eventId) {
        this.eventLog_.remove(eventId);
    }

    public synchronized int size() {
        return this.eventLog_.size();
    }

    public static String getDbKey(String dbName) {
        return String.format(DB_KEY_FORMAT_STR, dbName).toLowerCase();
    }

    public static String getTblKey(String dbName, String tblName) {
        return String.format(TBL_KEY_FORMAT_STR, dbName, tblName).toLowerCase();
    }

    public static String getPartitionKey(HdfsTable hdfsTable, List<String> partValues) {
        return String.format(PART_KEY_FORMAT_STR, hdfsTable.getFullName(), FileUtils.makePartName(hdfsTable.getClusteringColNames(), partValues));
    }

    public static String getKey(Database database) {
        return DeleteEventLog.getDbKey(database.getName());
    }

    public static String getKey(Table tbl) {
        return String.format(TBL_KEY_FORMAT_STR, tbl.getDbName(), tbl.getTableName()).toLowerCase();
    }
}

