/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.catalog.events.SelfEventContext;

public class DbBarrierEvent
extends MetastoreEvents.MetastoreDatabaseEvent
implements MetastoreEvents.DerivedMetastoreEvent {
    private volatile boolean isProcessed_;
    private final MetastoreEvents.MetastoreDatabaseEvent actualEvent_;
    private final AtomicInteger expectedProceedCount_ = new AtomicInteger();

    DbBarrierEvent(MetastoreEvents.MetastoreDatabaseEvent actualEvent) {
        super(actualEvent.catalogOpExecutor_, actualEvent.metrics_, actualEvent.event_);
        this.actualEvent_ = actualEvent;
    }

    @Override
    public void processIfEnabled() throws CatalogException, MetastoreNotificationException {
        Preconditions.checkState((this.expectedProceedCount_.get() == 0 ? 1 : 0) != 0);
        this.actualEvent_.processIfEnabled();
    }

    @Override
    protected void process() {
        throw new UnsupportedOperationException("Not supported for DB barrier event");
    }

    @Override
    protected SelfEventContext getSelfEventContext() {
        throw new UnsupportedOperationException("Not supported for DB barrier event");
    }

    void proceed() {
        this.decrExpectedProceedCount();
    }

    int getExpectedProceedCount() {
        return this.expectedProceedCount_.get();
    }

    void incrExpectedProceedCount() {
        int value = this.expectedProceedCount_.incrementAndGet();
        this.debugLog("Number of table processors expected to process the event: {}", value);
    }

    private void decrExpectedProceedCount() {
        int value = this.expectedProceedCount_.decrementAndGet();
        this.debugLog("Number of table processors expected to process the event: {}", value);
    }

    @Override
    public MetastoreEvents.MetastoreEvent getActualEvent() {
        return this.actualEvent_;
    }

    @Override
    public void markProcessed() {
        Preconditions.checkState((this.expectedProceedCount_.get() == 0 ? 1 : 0) != 0);
        this.isProcessed_ = true;
    }

    @Override
    public boolean isAllDerivedEventsProcessed() {
        return this.isProcessed_;
    }
}

