/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.CollectionStructType;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.BinaryCompatibility;
import org.apache.impala.catalog.CheckEmptyCompatibility;
import org.apache.impala.catalog.CompatibilityRule;
import org.apache.impala.catalog.DefaultCompatibility;
import org.apache.impala.catalog.DiagonalCompatibility;
import org.apache.impala.catalog.FixedUdaCompatibility;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StrictOverrideCompatibility;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.catalog.UnsafeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TPrimitiveType;
import org.apache.impala.thrift.TScalarType;
import org.apache.impala.thrift.TStructField;
import org.apache.impala.thrift.TTypeNode;

public abstract class Type {
    public static int MAX_NESTING_DEPTH = 100;
    public static final ScalarType INVALID = new ScalarType(PrimitiveType.INVALID_TYPE);
    public static final ScalarType NULL = new ScalarType(PrimitiveType.NULL_TYPE);
    public static final ScalarType BOOLEAN = new ScalarType(PrimitiveType.BOOLEAN);
    public static final ScalarType TINYINT = new ScalarType(PrimitiveType.TINYINT);
    public static final ScalarType SMALLINT = new ScalarType(PrimitiveType.SMALLINT);
    public static final ScalarType INT = new ScalarType(PrimitiveType.INT);
    public static final ScalarType BIGINT = new ScalarType(PrimitiveType.BIGINT);
    public static final ScalarType FLOAT = new ScalarType(PrimitiveType.FLOAT);
    public static final ScalarType DOUBLE = new ScalarType(PrimitiveType.DOUBLE);
    public static final ScalarType STRING = new ScalarType(PrimitiveType.STRING);
    public static final ScalarType BINARY = new ScalarType(PrimitiveType.BINARY);
    public static final ScalarType TIMESTAMP = new ScalarType(PrimitiveType.TIMESTAMP);
    public static final ScalarType DATE = new ScalarType(PrimitiveType.DATE);
    public static final ScalarType DATETIME = new ScalarType(PrimitiveType.DATETIME);
    public static final ScalarType DEFAULT_DECIMAL = ScalarType.createDecimalType(9, 0);
    public static final ScalarType DECIMAL = ScalarType.createWildCardDecimalType();
    public static final ScalarType DEFAULT_VARCHAR = ScalarType.createVarcharType(-1);
    public static final ScalarType VARCHAR = ScalarType.createVarcharType(-1);
    public static final ScalarType CHAR = ScalarType.createCharType(-1);
    public static final ScalarType FIXED_UDA_INTERMEDIATE = ScalarType.createFixedUdaIntermediateType(-1);
    private static List<ScalarType> integerTypes = new ArrayList<ScalarType>();
    private static List<ScalarType> numericTypes;
    private static List<ScalarType> supportedTypes;
    private static List<ScalarType> unsupportedTypes;
    protected static PrimitiveType[][] compatibilityMatrix;
    protected static PrimitiveType[][] strictCompatibilityMatrix;
    protected static PrimitiveType[][] unsafeCompatibilityMatrix;

    public static List<ScalarType> getIntegerTypes() {
        return integerTypes;
    }

    public static List<ScalarType> getNumericTypes() {
        return numericTypes;
    }

    public static List<ScalarType> getSupportedTypes() {
        return supportedTypes;
    }

    public static List<ScalarType> getUnsupportedTypes() {
        return unsupportedTypes;
    }

    public static ScalarType getDefaultScalarType(PrimitiveType ptype) {
        switch (ptype) {
            case INVALID_TYPE: {
                return INVALID;
            }
            case NULL_TYPE: {
                return NULL;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case STRING: {
                return STRING;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case BINARY: {
                return BINARY;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case CHAR: {
                return CHAR;
            }
            case FIXED_UDA_INTERMEDIATE: {
                return FIXED_UDA_INTERMEDIATE;
            }
        }
        return INVALID;
    }

    public final String toSql() {
        return this.toSql(0);
    }

    protected abstract String toSql(int var1);

    public String prettyPrint() {
        return this.prettyPrint(0);
    }

    protected abstract String prettyPrint(int var1);

    public boolean isInvalid() {
        return this.isScalarType(PrimitiveType.INVALID_TYPE);
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isNull() {
        return this.isScalarType(PrimitiveType.NULL_TYPE);
    }

    public boolean isBoolean() {
        return this.isScalarType(PrimitiveType.BOOLEAN);
    }

    public boolean isTimestamp() {
        return this.isScalarType(PrimitiveType.TIMESTAMP);
    }

    public boolean isDate() {
        return this.isScalarType(PrimitiveType.DATE);
    }

    public boolean isDecimal() {
        return this.isScalarType(PrimitiveType.DECIMAL);
    }

    public boolean isFullySpecifiedDecimal() {
        return false;
    }

    public boolean isChar() {
        return this.isScalarType(PrimitiveType.CHAR);
    }

    public boolean isVarchar() {
        return this.isScalarType(PrimitiveType.VARCHAR);
    }

    public boolean isString() {
        return this.isScalarType(PrimitiveType.STRING);
    }

    public boolean isBinary() {
        return this.isScalarType(PrimitiveType.BINARY);
    }

    public boolean isVarLenStringType() {
        return this.isVarchar() || this.isString() || this.isBinary();
    }

    public boolean isWildcardDecimal() {
        return false;
    }

    public boolean isWildcardVarchar() {
        return false;
    }

    public boolean isWildcardChar() {
        return false;
    }

    public boolean isStringType() {
        return this.isScalarType(PrimitiveType.STRING) || this.isScalarType(PrimitiveType.VARCHAR) || this.isScalarType(PrimitiveType.CHAR) || this.isScalarType(PrimitiveType.BINARY);
    }

    public boolean isScalarType() {
        return this instanceof ScalarType;
    }

    public boolean isScalarType(PrimitiveType t) {
        return this.isScalarType() && ((ScalarType)this).getPrimitiveType() == t;
    }

    public boolean isFixedPointType() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT) || this.isScalarType(PrimitiveType.BIGINT) || this.isScalarType(PrimitiveType.DECIMAL);
    }

    public boolean isFloatingPointType() {
        return this.isScalarType(PrimitiveType.FLOAT) || this.isScalarType(PrimitiveType.DOUBLE);
    }

    public boolean isIntegerType() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT) || this.isScalarType(PrimitiveType.BIGINT);
    }

    public boolean isFixedLengthType() {
        return false;
    }

    public boolean isNumericType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isDecimal();
    }

    public boolean isDateOrTimeType() {
        return this.isScalarType(PrimitiveType.DATE) || this.isScalarType(PrimitiveType.DATETIME) || this.isScalarType(PrimitiveType.TIMESTAMP);
    }

    public boolean isIntegerOrDateType() {
        return this.isIntegerType() || this.isDate();
    }

    public boolean isComplexType() {
        return this.isStructType() || this.isCollectionType();
    }

    public boolean isCollectionType() {
        return this.isMapType() || this.isArrayType();
    }

    public boolean isMapType() {
        return this instanceof MapType;
    }

    public boolean isArrayType() {
        return this instanceof ArrayType;
    }

    public boolean isStructType() {
        return this instanceof StructType;
    }

    public boolean isCollectionStructType() {
        return this instanceof CollectionStructType;
    }

    public boolean containsStruct() {
        if (this.isStructType()) {
            return true;
        }
        if (this.isArrayType()) {
            ArrayType arrayType = (ArrayType)this;
            return arrayType.getItemType().containsStruct();
        }
        if (this.isMapType()) {
            MapType mapType = (MapType)this;
            return mapType.getKeyType().containsStruct() || mapType.getValueType().containsStruct();
        }
        return false;
    }

    public boolean containsCollection() {
        if (this.isCollectionType()) {
            return true;
        }
        if (this.isStructType()) {
            for (StructField field : ((StructType)this).getFields()) {
                Type fieldType = field.getType();
                if (!fieldType.containsCollection()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean supportsTablePartitioning() {
        return false;
    }

    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.INVALID_TYPE;
    }

    public int getSlotSize() {
        if (this.isCollectionType()) {
            return 12;
        }
        throw new IllegalStateException("getSlotSize() not implemented for type " + this.toSql());
    }

    public TColumnType toThrift() {
        TColumnType container = new TColumnType();
        container.setTypes(new ArrayList<TTypeNode>());
        this.toThrift(container);
        return container;
    }

    public abstract void toThrift(TColumnType var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean matchesType(Type t) {
        return false;
    }

    public static Type parseColumnType(String typeStr) {
        CreateTableStmt createTableStmt;
        String stmt = String.format("CREATE TABLE $DUMMY ($DUMMY %s)", typeStr);
        try {
            StatementBase o = Parser.parse(stmt);
            if (!(o instanceof CreateTableStmt)) {
                throw new IllegalStateException("Couldn't parse create table stmt.");
            }
            createTableStmt = (CreateTableStmt)o;
            if (createTableStmt.getColumnDefs().isEmpty()) {
                throw new IllegalStateException("Invalid create table stmt.");
            }
        }
        catch (AnalysisException e) {
            return null;
        }
        TypeDef typeDef = createTableStmt.getColumnDefs().get(0).getTypeDef();
        return typeDef.getType();
    }

    public static boolean isImplicitlyCastable(Type t1, Type t2, TypeCompatibility compatibility) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.isImplicitlyCastable((ScalarType)t1, (ScalarType)t2, compatibility);
        }
        return false;
    }

    public static Type getAssignmentCompatibleType(Type t1, Type t2, TypeCompatibility compatibility) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.getAssignmentCompatibleType((ScalarType)t1, (ScalarType)t2, compatibility);
        }
        if (t1.isArrayType() && t2.isArrayType() ? t1.equals(t2) : t1.isMapType() && t2.isMapType() && t1.equals(t2)) {
            return t2;
        }
        return ScalarType.INVALID;
    }

    public boolean exceedsMaxNestingDepth() {
        return this.exceedsMaxNestingDepth(0);
    }

    private boolean exceedsMaxNestingDepth(int d) {
        if (d >= MAX_NESTING_DEPTH) {
            return true;
        }
        if (this.isStructType()) {
            StructType structType = (StructType)this;
            for (StructField f : structType.getFields()) {
                if (!f.getType().exceedsMaxNestingDepth(d + 1)) continue;
                return true;
            }
        } else if (this.isArrayType()) {
            ArrayType arrayType = (ArrayType)this;
            if (arrayType.getItemType().exceedsMaxNestingDepth(d + 1)) {
                return true;
            }
        } else if (this.isMapType()) {
            MapType mapType = (MapType)this;
            if (mapType.getValueType().exceedsMaxNestingDepth(d + 1)) {
                return true;
            }
        } else {
            Preconditions.checkState((boolean)this.isScalarType());
        }
        return false;
    }

    public static List<TColumnType> toThrift(Type[] types) {
        return Type.toThrift(Lists.newArrayList((Object[])types));
    }

    public static List<TColumnType> toThrift(List<Type> types) {
        ArrayList<TColumnType> result = new ArrayList<TColumnType>();
        for (Type t : types) {
            result.add(t.toThrift());
        }
        return result;
    }

    public static Type fromThrift(TColumnType thrift) {
        Preconditions.checkState((thrift.types.size() > 0 ? 1 : 0) != 0);
        Pair<Type, Integer> t = Type.fromThrift(thrift, 0);
        Preconditions.checkState((boolean)((Integer)t.second).equals(thrift.getTypesSize()));
        return (Type)t.first;
    }

    public static Type fromTScalarType(TScalarType scalarType) {
        if (scalarType.getType() == TPrimitiveType.CHAR) {
            Preconditions.checkState((boolean)scalarType.isSetLen());
            return ScalarType.createCharType(scalarType.getLen());
        }
        if (scalarType.getType() == TPrimitiveType.VARCHAR) {
            Preconditions.checkState((boolean)scalarType.isSetLen());
            return ScalarType.createVarcharType(scalarType.getLen());
        }
        if (scalarType.getType() == TPrimitiveType.DECIMAL) {
            Preconditions.checkState((scalarType.isSetPrecision() && scalarType.isSetScale() ? 1 : 0) != 0);
            return ScalarType.createDecimalType(scalarType.getPrecision(), scalarType.getScale());
        }
        return ScalarType.createType(PrimitiveType.fromThrift(scalarType.getType()));
    }

    protected static Pair<Type, Integer> fromThrift(TColumnType col, int nodeIdx) {
        TTypeNode node = col.getTypes().get(nodeIdx);
        Type type = null;
        switch (node.getType()) {
            case SCALAR: {
                Preconditions.checkState((boolean)node.isSetScalar_type());
                type = Type.fromTScalarType(node.getScalar_type());
                ++nodeIdx;
                break;
            }
            case ARRAY: {
                Preconditions.checkState((nodeIdx + 1 < col.getTypesSize() ? 1 : 0) != 0);
                Pair<Type, Integer> childType = Type.fromThrift(col, nodeIdx + 1);
                type = new ArrayType((Type)childType.first);
                nodeIdx = (Integer)childType.second;
                break;
            }
            case MAP: {
                Preconditions.checkState((nodeIdx + 2 < col.getTypesSize() ? 1 : 0) != 0);
                Pair<Type, Integer> keyType = Type.fromThrift(col, nodeIdx + 1);
                Pair<Type, Integer> valueType = Type.fromThrift(col, (Integer)keyType.second);
                type = new MapType((Type)keyType.first, (Type)valueType.first);
                nodeIdx = (Integer)valueType.second;
                break;
            }
            case STRUCT: {
                Preconditions.checkState((nodeIdx + node.getStruct_fieldsSize() < col.getTypesSize() ? 1 : 0) != 0);
                ArrayList<StructField> structFields = new ArrayList<StructField>();
                ++nodeIdx;
                for (int i = 0; i < node.getStruct_fieldsSize(); ++i) {
                    TStructField thriftField = node.getStruct_fields().get(i);
                    String name = thriftField.getName();
                    String comment = null;
                    if (thriftField.isSetComment()) {
                        comment = thriftField.getComment();
                    }
                    Pair<Type, Integer> res = Type.fromThrift(col, nodeIdx);
                    nodeIdx = (Integer)res.second;
                    if (thriftField.isSetField_id()) {
                        structFields.add(new IcebergStructField(name, (Type)res.first, comment, thriftField.getField_id()));
                        continue;
                    }
                    structFields.add(new StructField(name, (Type)res.first, comment));
                }
                type = new StructType(structFields);
                break;
            }
        }
        return new Pair<Object, Integer>(type, nodeIdx);
    }

    public Integer getColumnSize() {
        if (!this.isScalarType()) {
            return null;
        }
        if (this.isNumericType()) {
            return this.getPrecision();
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case STRING: 
            case BINARY: {
                return Integer.MAX_VALUE;
            }
            case TIMESTAMP: {
                return 29;
            }
            case DATE: {
                return 10;
            }
            case VARCHAR: 
            case CHAR: 
            case FIXED_UDA_INTERMEDIATE: {
                return t.getLength();
            }
        }
        return null;
    }

    public Integer getPrecision() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case DECIMAL: {
                return t.decimalPrecision();
            }
        }
        return null;
    }

    public Integer getDecimalDigits() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DATE: {
                return 0;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case TIMESTAMP: {
                return 9;
            }
            case DECIMAL: {
                return t.decimalScale();
            }
        }
        return null;
    }

    public Integer getNumPrecRadix() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return 10;
            }
        }
        return null;
    }

    public int getJavaSqlType() {
        if (this.isStructType()) {
            return 2002;
        }
        if (this.isCollectionType()) {
            return 2003;
        }
        Preconditions.checkState((boolean)this.isScalarType(), (Object)("Invalid non-scalar type: " + this.toSql()));
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case NULL_TYPE: {
                return 0;
            }
            case BOOLEAN: {
                return 16;
            }
            case TINYINT: {
                return -6;
            }
            case SMALLINT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case BIGINT: {
                return -5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
            case TIMESTAMP: {
                return 93;
            }
            case DATE: {
                return 91;
            }
            case STRING: {
                return 12;
            }
            case CHAR: {
                return 1;
            }
            case VARCHAR: {
                return 12;
            }
            case BINARY: {
                return -2;
            }
            case DECIMAL: {
                return 3;
            }
            case FIXED_UDA_INTERMEDIATE: {
                return -2;
            }
        }
        Preconditions.checkArgument((boolean)false, (Object)("Invalid primitive type " + t.getPrimitiveType().name()));
        return 0;
    }

    public static PrimitiveType[][] getCompatibilityMatrix(List<CompatibilityRule> rules) {
        PrimitiveType[][] compatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        for (CompatibilityRule rule : rules) {
            rule.apply(compatibilityMatrix);
        }
        return compatibilityMatrix;
    }

    static {
        integerTypes.add(TINYINT);
        integerTypes.add(SMALLINT);
        integerTypes.add(INT);
        integerTypes.add(BIGINT);
        numericTypes = new ArrayList<ScalarType>();
        numericTypes.add(TINYINT);
        numericTypes.add(SMALLINT);
        numericTypes.add(INT);
        numericTypes.add(BIGINT);
        numericTypes.add(FLOAT);
        numericTypes.add(DOUBLE);
        numericTypes.add(DECIMAL);
        supportedTypes = new ArrayList<ScalarType>();
        supportedTypes.add(NULL);
        supportedTypes.add(BOOLEAN);
        supportedTypes.add(TINYINT);
        supportedTypes.add(SMALLINT);
        supportedTypes.add(INT);
        supportedTypes.add(BIGINT);
        supportedTypes.add(FLOAT);
        supportedTypes.add(DOUBLE);
        supportedTypes.add(STRING);
        supportedTypes.add(VARCHAR);
        supportedTypes.add(CHAR);
        supportedTypes.add(TIMESTAMP);
        supportedTypes.add(DECIMAL);
        supportedTypes.add(DATE);
        supportedTypes.add(BINARY);
        unsupportedTypes = new ArrayList<ScalarType>();
        unsupportedTypes.add(DATETIME);
        ArrayList<CompatibilityRule> defaultCompatibilityRules = new ArrayList<CompatibilityRule>();
        defaultCompatibilityRules.add(new DiagonalCompatibility());
        defaultCompatibilityRules.add(new BinaryCompatibility());
        defaultCompatibilityRules.add(new FixedUdaCompatibility());
        defaultCompatibilityRules.add(new DefaultCompatibility());
        defaultCompatibilityRules.add(new CheckEmptyCompatibility());
        compatibilityMatrix = Type.getCompatibilityMatrix(defaultCompatibilityRules);
        ArrayList<CompatibilityRule> strictCompatibilityRules = new ArrayList<CompatibilityRule>();
        strictCompatibilityRules.add(new StrictOverrideCompatibility());
        strictCompatibilityMatrix = Type.getCompatibilityMatrix(strictCompatibilityRules);
        ArrayList<CompatibilityRule> unsafeCompatibilityRules = new ArrayList<CompatibilityRule>(defaultCompatibilityRules);
        unsafeCompatibilityRules.add(unsafeCompatibilityRules.size() - 1, new UnsafeCompatibility());
        unsafeCompatibilityMatrix = Type.getCompatibilityMatrix(unsafeCompatibilityRules);
    }
}

