/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.impala.common.TransactionException;
import org.apache.impala.common.TransactionKeepalive;
import org.apache.impala.compat.MetastoreShim;
import org.apache.log4j.Logger;

public class Transaction
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Transaction.class);
    private long transactionId_ = -1L;
    private IMetaStoreClient hmsClient_;
    private TransactionKeepalive keepalive_;

    public Transaction(IMetaStoreClient hmsClient, TransactionKeepalive keepalive, String user, TransactionKeepalive.HeartbeatContext ctx) throws TransactionException {
        Preconditions.checkNotNull((Object)hmsClient);
        Preconditions.checkNotNull((Object)keepalive);
        this.hmsClient_ = hmsClient;
        this.keepalive_ = keepalive;
        this.transactionId_ = MetastoreShim.openTransaction(this.hmsClient_);
        LOG.info((Object)String.format("Opened transaction %d by user '%s' ", this.transactionId_, user));
        this.keepalive_.addTransaction(this.transactionId_, ctx);
    }

    public Transaction(IMetaStoreClient hmsClient, String user, String context) throws TransactionException {
        Preconditions.checkNotNull((Object)hmsClient);
        this.hmsClient_ = hmsClient;
        this.transactionId_ = MetastoreShim.openTransaction(this.hmsClient_);
        LOG.info((Object)String.format("Opened transaction %d by user '%s' in context: %s", this.transactionId_, user, context));
    }

    public long getId() {
        return this.transactionId_;
    }

    public void commit() throws TransactionException {
        Preconditions.checkState((this.transactionId_ > 0L ? 1 : 0) != 0);
        if (this.keepalive_ != null) {
            this.keepalive_.deleteTransaction(this.transactionId_);
        }
        MetastoreShim.commitTransaction(this.hmsClient_, this.transactionId_);
        this.transactionId_ = -1L;
    }

    @Override
    public void close() {
        if (this.transactionId_ <= 0L) {
            return;
        }
        if (this.keepalive_ != null) {
            this.keepalive_.deleteTransaction(this.transactionId_);
        }
        try {
            MetastoreShim.abortTransaction(this.hmsClient_, this.transactionId_);
        }
        catch (TransactionException e) {
            LOG.error((Object)("Cannot abort transaction with id " + String.valueOf(this.transactionId_)), (Throwable)e);
        }
        this.transactionId_ = -1L;
    }
}

