/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicUpdateLog {
    private static final Logger LOG = LoggerFactory.getLogger(TopicUpdateLog.class);
    private int topicUpdateLogGcFrequency_;
    private int numTopicUpdatesToGc_;
    private long oldestTopicUpdateToGc_;
    private final Map<String, Entry> topicLogEntries_;

    public TopicUpdateLog() {
        this.numTopicUpdatesToGc_ = this.topicUpdateLogGcFrequency_ = BackendConfig.INSTANCE.getBackendCfg().topic_update_log_gc_frequency;
        this.oldestTopicUpdateToGc_ = -1L;
        this.topicLogEntries_ = new ConcurrentHashMap<String, Entry>();
    }

    public void garbageCollectUpdateLogEntries(long lastTopicUpdateVersion) {
        if (this.oldestTopicUpdateToGc_ == -1L) {
            this.oldestTopicUpdateToGc_ = lastTopicUpdateVersion;
            return;
        }
        if (this.numTopicUpdatesToGc_ == 0) {
            LOG.info("Topic update log GC started. GC-ing topics with versions <= {}", (Object)this.oldestTopicUpdateToGc_);
            Preconditions.checkState((this.oldestTopicUpdateToGc_ > 0L ? 1 : 0) != 0);
            int numEntriesRemoved = 0;
            for (Map.Entry<String, Entry> entry : this.topicLogEntries_.entrySet()) {
                if (entry.getValue().getLastSentVersion() == -1L || entry.getValue().getLastSentCatalogUpdate() > this.oldestTopicUpdateToGc_ || !this.topicLogEntries_.remove(entry.getKey(), entry.getValue())) continue;
                ++numEntriesRemoved;
            }
            this.numTopicUpdatesToGc_ = this.topicUpdateLogGcFrequency_;
            this.oldestTopicUpdateToGc_ = lastTopicUpdateVersion;
            LOG.info("Topic update log GC finished. Removed {} entries.", (Object)numEntriesRemoved);
        } else {
            --this.numTopicUpdatesToGc_;
        }
    }

    public void add(String catalogObjectKey, Entry logEntry) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)catalogObjectKey) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)logEntry);
        this.topicLogEntries_.put(catalogObjectKey, logEntry);
    }

    public Entry get(String catalogObjectKey) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)catalogObjectKey) ? 1 : 0) != 0);
        return this.topicLogEntries_.get(catalogObjectKey);
    }

    public Entry getOrCreateLogEntry(String catalogObjectKey) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)catalogObjectKey) ? 1 : 0) != 0);
        Entry entry = this.topicLogEntries_.get(catalogObjectKey);
        if (entry == null) {
            entry = new Entry();
        }
        return entry;
    }

    public long getOldestTopicUpdateToGc() {
        return this.oldestTopicUpdateToGc_;
    }

    public static class Entry {
        private final int numSkippedUpdates_;
        private final long lastSentVersion_;
        private final long lastSentTopicUpdate_;
        private final int numSkippedUpdatesLockContention_;

        Entry() {
            this.numSkippedUpdates_ = 0;
            this.lastSentVersion_ = -1L;
            this.lastSentTopicUpdate_ = -1L;
            this.numSkippedUpdatesLockContention_ = 0;
        }

        Entry(int numSkippedUpdates, long lastSentVersion, long lastSentCatalogUpdate, int numSkippedUpdatesLockContention) {
            this.numSkippedUpdates_ = numSkippedUpdates;
            this.lastSentVersion_ = lastSentVersion;
            this.lastSentTopicUpdate_ = lastSentCatalogUpdate;
            this.numSkippedUpdatesLockContention_ = numSkippedUpdatesLockContention;
        }

        public int getNumSkippedTopicUpdates() {
            return this.numSkippedUpdates_;
        }

        public long getLastSentVersion() {
            return this.lastSentVersion_;
        }

        public long getLastSentCatalogUpdate() {
            return this.lastSentTopicUpdate_;
        }

        public int getNumSkippedUpdatesLockContention() {
            return this.numSkippedUpdatesLockContention_;
        }

        public boolean equals(Object other) {
            if (this.getClass() != other.getClass()) {
                return false;
            }
            Entry entry = (Entry)other;
            return this.numSkippedUpdates_ == entry.getNumSkippedTopicUpdates() && this.lastSentVersion_ == entry.getLastSentVersion() && this.lastSentTopicUpdate_ == entry.getLastSentCatalogUpdate() && this.numSkippedUpdatesLockContention_ == entry.getNumSkippedUpdatesLockContention();
        }

        public int hashCode() {
            return Objects.hash(this.numSkippedUpdates_, this.lastSentVersion_, this.lastSentTopicUpdate_, this.numSkippedUpdatesLockContention_);
        }
    }
}

