/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.events.EventFactory;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.common.Metrics;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.ThreadNameAnnotator;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TableLoader.class);
    private final CatalogServiceCatalog catalog_;
    private static final Object metastoreAccessLock_ = new Object();
    private Metrics metrics_ = new Metrics();

    public TableLoader(CatalogServiceCatalog catalog) {
        Preconditions.checkNotNull((Object)catalog);
        this.catalog_ = catalog;
        this.initMetrics(this.metrics_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table load(Db db, String tblName, long eventId, String reason, EventSequence catalogTimeline) {
        Stopwatch sw = Stopwatch.createStarted();
        String fullTblName = db.getName() + "." + tblName;
        String annotation = "Loading metadata for: " + fullTblName + " (" + reason + ")";
        LOG.info(annotation);
        Table table = null;
        boolean syncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        List<NotificationEvent> events = null;
        try (ThreadNameAnnotator tna = new ThreadNameAnnotator(annotation);
             MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient(catalogTimeline);){
            org.apache.hadoop.hive.metastore.api.Table msTbl = null;
            Stopwatch hmsLoadSW = Stopwatch.createStarted();
            Object object = metastoreAccessLock_;
            synchronized (object) {
                msTbl = msClient.getHiveClient().getTable(db.getName(), tblName);
                catalogTimeline.markEvent("Fetched table from Metastore");
            }
            if (eventId != -1L && this.catalog_.isEventProcessingEnabled()) {
                events = MetastoreEventsProcessor.getNextMetastoreEventsInBatchesForTable(this.catalog_, eventId, db.getName(), tblName, "CREATE_TABLE");
                catalogTimeline.markEvent("Fetched event batch from Metastore");
            }
            if (events != null && !events.isEmpty()) {
                eventId = ((NotificationEvent)events.get(events.size() - 1)).getEventId();
            }
            long hmsLoadTime = hmsLoadSW.elapsed(TimeUnit.NANOSECONDS);
            TableType tableType = TableType.valueOf((String)msTbl.getTableType());
            if (!MetastoreShim.IMPALA_SUPPORTED_TABLE_TYPES.contains(tableType)) {
                throw new TableLoadingException(String.format("Unsupported table type '%s' for: %s", tableType, fullTblName));
            }
            String val = (String)msTbl.getParameters().get("storage_handler");
            if (val != null && val.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler")) {
                Map<String, String> impalaTblProps = this.setHiveJdbcProperties(msTbl);
                msTbl.unsetParameters();
                msTbl.setParameters(impalaTblProps);
            }
            if ((table = Table.fromMetastoreTable(db, msTbl)) == null) {
                throw new TableLoadingException("Unrecognized table type for table: " + fullTblName);
            }
            table.updateHMSLoadTableSchemaTime(hmsLoadTime);
            table.setCreateEventId(eventId, false);
            long latestEventId = -1L;
            if (syncToLatestEventId) {
                if (!this.catalog_.tryWriteLock(table, catalogTimeline)) {
                    throw new CatalogException("Couldn't acquire write lock on new table object created when doing a full table reload of " + table.getFullName());
                }
                this.catalog_.getLock().writeLock().unlock();
                try {
                    latestEventId = msClient.getHiveClient().getCurrentNotificationEventId().getEventId();
                }
                catch (TException e) {
                    throw new TableLoadingException("Failed to get latest event id from HMS while loading table: " + table.getFullName(), e);
                }
            }
            table.load(false, msClient.getHiveClient(), msTbl, reason, catalogTimeline);
            table.validate();
            if (syncToLatestEventId) {
                LOG.debug("After full reload, table {} is synced atleast till event id {}. Checking if there are more events generated for this table while the full reload was in progress", (Object)table.getFullName(), (Object)latestEventId);
                table.setLastSyncedEventId(latestEventId);
                MetastoreEventsProcessor.syncToLatestEventId(this.catalog_, table, (EventFactory)this.catalog_.getEventFactoryForSyncToLatestEvent(), this.metrics_);
            }
            table.setLastRefreshEventId(latestEventId);
        }
        catch (TableLoadingException e) {
            table = IncompleteTable.createFailedMetadataLoadTable(db, tblName, e);
        }
        catch (NoSuchObjectException e) {
            TableLoadingException tableDoesNotExist = new TableLoadingException("Table " + fullTblName + " no longer exists in the Hive MetaStore. Run 'invalidate metadata " + fullTblName + "' to update the Impala catalog.");
            table = IncompleteTable.createFailedMetadataLoadTable(db, tblName, tableDoesNotExist);
        }
        catch (Throwable e) {
            table = IncompleteTable.createFailedMetadataLoadTable(db, tblName, new TableLoadingException("Failed to load metadata for table: " + fullTblName + ". Running 'invalidate metadata " + fullTblName + "' may resolve this problem.", e));
        }
        finally {
            if (table != null && table.isWriteLockedByCurrentThread()) {
                table.releaseWriteLock();
            }
        }
        LOG.info("Loaded metadata for: " + fullTblName + " (" + sw.elapsed(TimeUnit.MILLISECONDS) + "ms)");
        return table;
    }

    private Map<String, String> setHiveJdbcProperties(org.apache.hadoop.hive.metastore.api.Table msTbl) throws TableLoadingException {
        HashMap<String, String> impala_tbl_props = new HashMap<String, String>();
        impala_tbl_props.put("__IMPALA_DATA_SOURCE_NAME", "impalajdbcdatasource");
        String val = (String)msTbl.getParameters().get("hive.sql.database.type");
        if (val == null) {
            throw new TableLoadingException("Required parameter: hive.sql.database.typeis missing.");
        }
        impala_tbl_props.put("database.type", val);
        val = (String)msTbl.getParameters().get("hive.sql.dbcp.password");
        if (val != null) {
            impala_tbl_props.put("dbcp.password", val);
        }
        if ((val = (String)msTbl.getParameters().get("hive.sql.dbcp.password.keystore")) != null) {
            impala_tbl_props.put("dbcp.password.keystore", val);
        }
        if ((val = (String)msTbl.getParameters().get("hive.sql.dbcp.password.key")) != null) {
            impala_tbl_props.put("dbcp.password.key", val);
        }
        if ((val = (String)msTbl.getParameters().get("hive.sql.jdbc.url")) == null) {
            throw new TableLoadingException("Required parameter: hive.sql.jdbc.urlis missing.");
        }
        impala_tbl_props.put("jdbc.url", val);
        val = (String)msTbl.getParameters().get("hive.sql.dbcp.username");
        if (val == null) {
            throw new TableLoadingException("Required parameter: hive.sql.dbcp.usernameis missing.");
        }
        impala_tbl_props.put("dbcp.username", val);
        val = (String)msTbl.getParameters().get("hive.sql.table");
        if (val == null) {
            throw new TableLoadingException("Required parameter: hive.sql.tableis missing.");
        }
        impala_tbl_props.put("table", val);
        val = (String)msTbl.getParameters().get("hive.sql.jdbc.driver");
        if (val == null) {
            throw new TableLoadingException("Required parameter: hive.sql.jdbc.driveris missing.");
        }
        impala_tbl_props.put("jdbc.driver", val);
        return impala_tbl_props;
    }

    private void initMetrics(Metrics metrics) {
        metrics.addTimer("events-fetch-duration");
        metrics.addTimer("events-apply-duration");
        metrics.addMeter("events-received");
        metrics.addCounter("events-skipped");
        metrics.addCounter("tables-refreshed");
        metrics.addCounter("partitions-refreshed");
        metrics.addCounter("tables-added");
        metrics.addCounter("tables-removed");
        metrics.addCounter("databases-added");
        metrics.addCounter("databases-removed");
        metrics.addCounter("partitions-added");
        metrics.addCounter("partitions-removed");
    }
}

