/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogInterners;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.CatalogdTableInvalidator;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HBaseTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.catalog.SideloadTableStats;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.SystemTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.View;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.events.InFlightEvents;
import org.apache.impala.catalog.monitor.CatalogMonitor;
import org.apache.impala.catalog.paimon.PaimonTable;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Metrics;
import org.apache.impala.common.Pair;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableInfoSelector;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.HdfsCachingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Table
extends CatalogObjectImpl
implements FeTable {
    private static final Logger LOG = LoggerFactory.getLogger(Table.class);
    protected org.apache.hadoop.hive.metastore.api.Table msTable_;
    protected final Db db_;
    protected final String name_;
    protected final String full_name_;
    protected final String owner_;
    protected TAccessLevel accessLevel_ = TAccessLevel.READ_WRITE;
    private final ReentrantReadWriteLock tableLock_ = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock_ = this.tableLock_.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock_ = this.tableLock_.writeLock();
    protected int numClusteringCols_;
    protected TTableStats tableStats_;
    protected AtomicLong estimatedMetadataSize_ = new AtomicLong(0L);
    protected AtomicLong metadataOpsCount_ = new AtomicLong(0L);
    protected AtomicLong numFiles_ = new AtomicLong(0L);
    protected final Metrics metrics_ = new Metrics();
    protected final ArrayList<Column> colsByPos_ = new ArrayList();
    protected final ArrayList<VirtualColumn> virtualCols_ = new ArrayList();
    protected final Map<String, Column> colsByName_ = new HashMap<String, Column>();
    protected final ArrayType type_ = new ArrayType(new StructType());
    protected boolean storedInImpaladCatalogCache_ = false;
    protected long storageMetadataLoadTime_ = 0L;
    protected long lastUsedTime_;
    protected volatile long createEventId_ = -1L;
    private final InFlightEvents inFlightEvents_ = new InFlightEvents();
    public static final String REFRESH_DURATION_METRIC = "refresh-duration";
    public static final String ALTER_DURATION_METRIC = "alter-duration";
    public static final String LOAD_DURATION_METRIC = "load-duration";
    public static final String LOAD_DURATION_STORAGE_METADATA = "load-duration.storage-metadata";
    public static final String HMS_LOAD_TBL_SCHEMA = "hms-load-tbl-schema";
    public static final String LOAD_DURATION_ALL_COLUMN_STATS = "load-duration.all-column-stats";
    public static final String NUMBER_OF_INFLIGHT_EVENTS = "num-inflight-events";
    public static final String TBL_PROP_LAST_DDL_TIME = "transient_lastDdlTime";
    public static final String TBL_PROP_LAST_COMPUTE_STATS_TIME = "impala.lastComputeStatsTime";
    public static final String TBL_PROP_EXTERNAL_TABLE = "EXTERNAL";
    public static final String TBL_PROP_EXTERNAL_TABLE_PURGE = "external.table.purge";
    public static final String TBL_PROP_EXTERNAL_TABLE_PURGE_DEFAULT = "TRUE";
    public static final AtomicInteger LOADING_TABLES = new AtomicInteger(0);
    public static final String TBL_EVENTS_PROCESS_DURATION = "events-process-duration";
    public static final String LAST_SYNC_EVENT_ID = "last-sync-event-id";
    protected volatile long lastSyncedEventId_ = -1L;
    protected volatile long lastRefreshEventId_ = -1L;
    protected SideloadTableStats testStats_ = null;
    protected double testMetadataScale_ = -1.0;

    protected Table(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        this.msTable_ = msTable;
        this.db_ = db;
        this.name_ = name.toLowerCase();
        this.full_name_ = (this.db_ != null ? this.db_.getName() + "." : "") + this.name_;
        this.owner_ = owner;
        this.tableStats_ = new TTableStats(-1L);
        this.tableStats_.setTotal_file_bytes(-1L);
        if (db != null && RuntimeEnv.INSTANCE.hasSideloadStats(db.getName(), name)) {
            this.testStats_ = RuntimeEnv.INSTANCE.getSideloadStats(db.getName(), name);
        }
        this.initMetrics();
    }

    public long getCreateEventId() {
        return this.createEventId_;
    }

    public void setCreateEventId(long eventId, boolean suppressLogging) {
        if (eventId < this.createEventId_) {
            if (!suppressLogging) {
                LOG.warn("Ignored stale createEventId: {}. Current id: {}", (Object)eventId, (Object)this.createEventId_);
            }
            return;
        }
        this.createEventId_ = eventId;
        if (!suppressLogging) {
            LOG.debug("createEventId_ for table: {} set to: {}", (Object)this.getFullName(), (Object)this.createEventId_);
        }
        if (this.lastSyncedEventId_ < eventId) {
            this.setLastSyncedEventId(eventId, suppressLogging);
        }
    }

    public long getLastSyncedEventId() {
        return this.lastSyncedEventId_;
    }

    public void setLastSyncedEventId(long eventId) {
        this.setLastSyncedEventId(eventId, false);
    }

    public void setLastSyncedEventId(long eventId, boolean suppressLogging) {
        if (!suppressLogging) {
            LOG.debug("lastSyncedEventId_ for table: {} set from {} to {}", new Object[]{this.getFullName(), this.lastSyncedEventId_, eventId});
        }
        this.lastSyncedEventId_ = eventId;
    }

    public static boolean isExternalTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return msTbl.getTableType().equalsIgnoreCase(TableType.EXTERNAL_TABLE.toString()) || TBL_PROP_EXTERNAL_TABLE_PURGE_DEFAULT.equalsIgnoreCase((String)msTbl.getParameters().get(TBL_PROP_EXTERNAL_TABLE));
    }

    public static boolean isExternalPurgeTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return Table.isExternalTable(msTbl) && Boolean.parseBoolean((String)msTbl.getParameters().get(TBL_PROP_EXTERNAL_TABLE_PURGE));
    }

    public void takeReadLock() {
        this.readLock_.lock();
    }

    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock_;
    }

    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock_;
    }

    public void releaseReadLock() {
        this.readLock_.unlock();
    }

    public boolean isReadLockedByCurrentThread() {
        return this.tableLock_.getReadHoldCount() > 0;
    }

    public boolean tryReadLock() {
        try {
            return this.readLock_.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void releaseWriteLock() {
        this.writeLock_.unlock();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.writeLock_.isHeldByCurrentThread();
    }

    public boolean isWriteLocked() {
        return this.tableLock_.isWriteLocked();
    }

    @Override
    public abstract TTableDescriptor toThriftDescriptor(int var1, Set<Long> var2);

    @Override
    public abstract TCatalogObjectType getCatalogObjectType();

    public long getMetadataOpsCount() {
        return this.metadataOpsCount_.get();
    }

    public long getEstimatedMetadataSize() {
        return this.estimatedMetadataSize_.get();
    }

    public long getNumFiles() {
        return this.numFiles_.get();
    }

    public long getMedianTableLoadingTime() {
        return (long)this.metrics_.getTimer(LOAD_DURATION_METRIC).getSnapshot().getMedian();
    }

    public long getMaxTableLoadingTime() {
        return this.metrics_.getTimer(LOAD_DURATION_METRIC).getSnapshot().getMax();
    }

    public long get75TableLoadingTime() {
        return (long)this.metrics_.getTimer(LOAD_DURATION_METRIC).getSnapshot().get75thPercentile();
    }

    public long get95TableLoadingTime() {
        return (long)this.metrics_.getTimer(LOAD_DURATION_METRIC).getSnapshot().get95thPercentile();
    }

    public long get99TableLoadingTime() {
        return (long)this.metrics_.getTimer(LOAD_DURATION_METRIC).getSnapshot().get99thPercentile();
    }

    public long getTableLoadingCounts() {
        return this.metrics_.getTimer(LOAD_DURATION_METRIC).getCount();
    }

    public void setEstimatedMetadataSize(long estimatedMetadataSize) {
        this.estimatedMetadataSize_.set(estimatedMetadataSize);
        if (!this.isStoredInImpaladCatalogCache()) {
            CatalogMonitor.INSTANCE.getCatalogTableMetrics().updateLargestTables(this);
        }
    }

    public void incrementMetadataOpsCount() {
        this.metadataOpsCount_.incrementAndGet();
        if (!this.isStoredInImpaladCatalogCache()) {
            CatalogMonitor.INSTANCE.getCatalogTableMetrics().updateFrequentlyAccessedTables(this);
        }
    }

    public void updateTableLoadingTime() {
        if (!this.isStoredInImpaladCatalogCache()) {
            CatalogMonitor.INSTANCE.getCatalogTableMetrics().updateLongMetadataLoadingTables(this);
        }
    }

    public void setNumFiles(long numFiles) {
        this.numFiles_.set(numFiles);
        if (!this.isStoredInImpaladCatalogCache()) {
            CatalogMonitor.INSTANCE.getCatalogTableMetrics().updateHighFileCountTables(this);
        }
    }

    public void initMetrics() {
        this.metrics_.addTimer(REFRESH_DURATION_METRIC);
        this.metrics_.addTimer(ALTER_DURATION_METRIC);
        this.metrics_.addTimer(LOAD_DURATION_METRIC);
        this.metrics_.addTimer(LOAD_DURATION_STORAGE_METADATA);
        this.metrics_.addTimer(HMS_LOAD_TBL_SCHEMA);
        this.metrics_.addTimer(LOAD_DURATION_ALL_COLUMN_STATS);
        this.metrics_.addCounter(NUMBER_OF_INFLIGHT_EVENTS);
        this.metrics_.addTimer(TBL_EVENTS_PROCESS_DURATION);
        this.metrics_.addGauge(LAST_SYNC_EVENT_ID, () -> this.lastSyncedEventId_);
    }

    public Metrics getMetrics() {
        return this.metrics_;
    }

    public long getStorageLoadTime() {
        return this.storageMetadataLoadTime_;
    }

    public boolean isStoredInImpaladCatalogCache() {
        return this.storedInImpaladCatalogCache_ || RuntimeEnv.INSTANCE.isTestEnv();
    }

    public long getLastUsedTime() {
        Preconditions.checkState((this.lastUsedTime_ != 0L && !this.isStoredInImpaladCatalogCache() ? 1 : 0) != 0);
        return this.lastUsedTime_;
    }

    public void updateHMSLoadTableSchemaTime(long hmsLoadTimeNS) {
        this.metrics_.getTimer(HMS_LOAD_TBL_SCHEMA).update(hmsLoadTimeNS, TimeUnit.NANOSECONDS);
    }

    public abstract void load(boolean var1, IMetaStoreClient var2, org.apache.hadoop.hive.metastore.api.Table var3, String var4, EventSequence var5) throws TableLoadingException;

    public void setTableStats(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        long rowCount = FeCatalogUtils.getRowCount(msTbl.getParameters());
        if (this.testStats_ != null) {
            this.tableStats_.setTotal_file_bytes(this.testStats_.getTotalSize());
            this.testMetadataScale_ = (double)this.testStats_.getNumRows() / (double)rowCount;
            rowCount = this.testStats_.getNumRows();
        } else {
            this.tableStats_.setTotal_file_bytes(FeCatalogUtils.getTotalSize(msTbl.getParameters()));
        }
        this.tableStats_.setNum_rows(rowCount);
    }

    public void addColumn(Column col) {
        this.colsByPos_.add(col);
        this.colsByName_.put(col.getName().toLowerCase(), col);
        ((StructType)this.type_.getItemType()).addField(new StructField(col.getName(), col.getType(), col.getComment()));
    }

    public void clearColumns() {
        this.colsByPos_.clear();
        this.colsByName_.clear();
        ((StructType)this.type_.getItemType()).clearFields();
        this.virtualCols_.clear();
    }

    protected void addVirtualColumn(VirtualColumn col) {
        this.virtualCols_.add(col);
    }

    protected List<String> getColumnNamesWithHmsStats() {
        List<Column> columns = this.filterColumnsNotStoredInHms(this.getColumns());
        return columns.stream().map(col -> col.getName().toLowerCase()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAllColumnStats(IMetaStoreClient client, EventSequence catalogTimeline) {
        Timer.Context columnStatsLdContext = this.getMetrics().getTimer(LOAD_DURATION_ALL_COLUMN_STATS).time();
        try {
            List<ColumnStatisticsObj> colStats;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading column stats for table: " + this.name_);
            }
            List<String> colNames = this.getColumnNamesWithHmsStats();
            try {
                colStats = MetastoreShim.getTableColumnStatistics(client, this.db_.getName(), this.name_, colNames);
            }
            catch (Exception e) {
                LOG.warn("Could not load column statistics for: " + this.getFullName(), (Throwable)e);
                columnStatsLdContext.stop();
                return;
            }
            FeCatalogUtils.injectColumnStats(colStats, this, this.testStats_);
            catalogTimeline.markEvent("Loaded all column stats");
        }
        finally {
            columnStatsLdContext.stop();
        }
    }

    public static Table fromMetastoreTable(Db db, org.apache.hadoop.hive.metastore.api.Table msTbl) {
        CatalogInterners.internFieldsInPlace(msTbl);
        Table table = null;
        TImpalaTableType tableType = MetastoreShim.mapToInternalTableType(msTbl.getTableType());
        if (tableType == TImpalaTableType.VIEW) {
            table = new View(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (tableType == TImpalaTableType.MATERIALIZED_VIEW) {
            table = HdfsFileFormat.isHdfsInputFormatClass(msTbl.getSd().getInputFormat()) ? new MaterializedViewHdfsTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner()) : new View(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (HBaseTable.isHBaseTable(msTbl)) {
            table = new HBaseTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (KuduTable.isKuduTable(msTbl)) {
            table = new KuduTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (IcebergTable.isIcebergTable(msTbl)) {
            table = new IcebergTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (PaimonUtil.isPaimonTable(msTbl)) {
            table = new PaimonTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (DataSourceTable.isDataSourceTable(msTbl)) {
            table = new DataSourceTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (SystemTable.isSystemTable(msTbl)) {
            table = new SystemTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        } else if (HdfsFileFormat.isHdfsInputFormatClass(msTbl.getSd().getInputFormat())) {
            table = new HdfsTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        }
        return table;
    }

    public static Table fromThrift(Db parentDb, TTable thriftTable, boolean loadedInImpalad) throws TableLoadingException {
        Table newTable;
        CatalogInterners.internFieldsInPlace(thriftTable);
        if (!thriftTable.isSetLoad_status() && thriftTable.isSetMetastore_table()) {
            newTable = Table.fromMetastoreTable(parentDb, thriftTable.getMetastore_table());
        } else {
            TImpalaTableType tblType = thriftTable.getTable_type() == TTableType.VIEW ? TImpalaTableType.VIEW : (thriftTable.getTable_type() == TTableType.MATERIALIZED_VIEW ? TImpalaTableType.MATERIALIZED_VIEW : TImpalaTableType.TABLE);
            newTable = IncompleteTable.createUninitializedTable(parentDb, thriftTable.getTbl_name(), tblType, MetadataOp.getTableComment(thriftTable.getMetastore_table()), -1L);
        }
        newTable.storedInImpaladCatalogCache_ = loadedInImpalad;
        try {
            newTable.loadFromThrift(thriftTable);
        }
        catch (IcebergTableLoadingException e) {
            LOG.warn(String.format("The table %s in database %s could not be loaded.", thriftTable.getTbl_name(), parentDb.getName()), (Throwable)e);
            newTable = IncompleteTable.createFailedMetadataLoadTable(parentDb, thriftTable.getTbl_name(), e);
        }
        newTable.validate();
        return newTable;
    }

    @Override
    public boolean isClusteringColumn(Column c) {
        return c.getPosition() < this.numClusteringCols_;
    }

    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        columns.addAll(thriftTable.getClustering_columns());
        columns.addAll(thriftTable.getColumns());
        this.colsByPos_.clear();
        this.colsByPos_.ensureCapacity(columns.size());
        try {
            for (int i = 0; i < columns.size(); ++i) {
                Column col = Column.fromThrift((TColumn)columns.get(i));
                this.colsByPos_.add(col.getPosition(), col);
                this.colsByName_.put(col.getName().toLowerCase(), col);
                ((StructType)this.type_.getItemType()).addField(this.getStructFieldFromColumn(col));
            }
            this.virtualCols_.clear();
            this.virtualCols_.ensureCapacity(thriftTable.getVirtual_columns().size());
            for (TColumn tvCol : thriftTable.getVirtual_columns()) {
                this.virtualCols_.add(VirtualColumn.fromThrift(tvCol));
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new TableLoadingException(String.format("Error loading schema for table '%s'", this.getName()), e);
        }
        this.numClusteringCols_ = thriftTable.getClustering_columns().size();
        if (thriftTable.isSetTable_stats()) {
            this.tableStats_ = thriftTable.getTable_stats();
        }
        this.accessLevel_ = thriftTable.isSetAccess_level() ? thriftTable.getAccess_level() : TAccessLevel.READ_WRITE;
        this.storageMetadataLoadTime_ = thriftTable.getStorage_metadata_load_time_ns();
    }

    private StructField getStructFieldFromColumn(Column col) {
        if (col instanceof IcebergColumn) {
            IcebergColumn iCol = (IcebergColumn)col;
            return new IcebergStructField(iCol.getName(), iCol.getType(), iCol.getComment(), iCol.getFieldId());
        }
        return new StructField(col.getName(), col.getType(), col.getComment());
    }

    public void validate() throws TableLoadingException {
        for (String colName : this.colsByName_.keySet()) {
            if (colName.equals(colName.toLowerCase())) continue;
            throw new TableLoadingException("Expected lower case column name but found: " + colName);
        }
    }

    public TTable toThrift() {
        if (!this.storedInImpaladCatalogCache_ && !this.isLockedByCurrentThread()) {
            throw new IllegalStateException("Table.toThrift() called without holding the table lock: " + this.getFullName() + " " + this.getClass().getName());
        }
        TTable table = new TTable(this.db_.getName(), this.name_);
        table.setAccess_level(this.accessLevel_);
        table.setStorage_metadata_load_time_ns(this.storageMetadataLoadTime_);
        table.setColumns(new ArrayList<TColumn>());
        table.setClustering_columns(new ArrayList<TColumn>());
        for (int i = 0; i < this.colsByPos_.size(); ++i) {
            TColumn colDesc = this.colsByPos_.get(i).toThrift();
            if (i < this.numClusteringCols_) {
                table.addToClustering_columns(colDesc);
                continue;
            }
            table.addToColumns(colDesc);
        }
        table.setVirtual_columns(new ArrayList<TColumn>());
        for (VirtualColumn vCol : this.getVirtualColumns()) {
            table.addToVirtual_columns(vCol.toThrift());
        }
        org.apache.hadoop.hive.metastore.api.Table msTable = this.getMetaStoreTable();
        if (msTable != null) {
            msTable = msTable.deepCopy();
        }
        table.setMetastore_table(msTable);
        table.setTable_stats(this.tableStats_);
        return table;
    }

    public TTable toHumanReadableThrift() {
        return this.toThrift();
    }

    private boolean isLockedByCurrentThread() {
        return this.isReadLockedByCurrentThread() || this.tableLock_.isWriteLockedByCurrentThread();
    }

    public TCatalogObject toMinimalTCatalogObject() {
        return this.toMinimalTCatalogObjectHelper();
    }

    private TCatalogObject toMinimalTCatalogObjectHelper() {
        TCatalogObject catalogObject = new TCatalogObject(this.getCatalogObjectType(), this.getCatalogVersion());
        catalogObject.setLast_modified_time_ms(this.getLastLoadedTimeMs());
        TTable table = new TTable(this.getDb().getName(), this.getName());
        table.setTbl_comment(this.getTableComment());
        catalogObject.setTable(table);
        return catalogObject;
    }

    public TCatalogObject toInvalidationObject() {
        return this.toMinimalTCatalogObjectHelper();
    }

    @Override
    public final String getUniqueName() {
        return Catalog.toCatalogObjectKey(this.toMinimalTCatalogObjectHelper());
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setTable(this.toThrift());
    }

    public TCatalogObject toTCatalogObject(CatalogObject.ThriftObjectType resultType) {
        switch (resultType) {
            case FULL: {
                return this.toTCatalogObject();
            }
            case DESCRIPTOR_ONLY: {
                return this.toMinimalTCatalogObject();
            }
            case INVALIDATION: {
                return this.toInvalidationObject();
            }
        }
        return null;
    }

    public TGetPartialCatalogObjectResponse getPartialInfo(TGetPartialCatalogObjectRequest req) throws CatalogException {
        Preconditions.checkState((boolean)this.isLoaded(), (String)"unloaded table: %s", (Object)this.getFullName());
        TTableInfoSelector selector = (TTableInfoSelector)Preconditions.checkNotNull((Object)req.table_info_selector, (Object)"no table_info_selector");
        TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
        resp.setObject_version_number(this.getCatalogVersion());
        resp.setObject_loaded_time_ms(this.getLastLoadedTimeMs());
        resp.table_info = new TPartialTableInfo();
        resp.table_info.setStorage_metadata_load_time_ns(this.storageMetadataLoadTime_);
        this.storageMetadataLoadTime_ = 0L;
        if (selector.want_hms_table) {
            resp.table_info.setHms_table(this.getMetaStoreTable().deepCopy());
            resp.table_info.setVirtual_columns(new ArrayList<TColumn>());
            for (VirtualColumn vCol : this.getVirtualColumns()) {
                resp.table_info.addToVirtual_columns(vCol.toThrift());
            }
        }
        if (selector.want_stats_for_column_names != null || selector.want_stats_for_all_columns) {
            List<String> colList = selector.want_stats_for_all_columns ? this.getColumnNames() : selector.want_stats_for_column_names;
            ArrayList statsList = Lists.newArrayListWithCapacity((int)colList.size());
            for (String colName : colList) {
                ColumnStatisticsData tstats;
                Column col = this.getColumn(colName);
                if (col == null || this instanceof FeFsTable && this.isClusteringColumn(col) || (tstats = col.getStats().toHmsCompatibleThrift(col.getType())) == null) continue;
                statsList.add(new ColumnStatisticsObj(colName, col.getType().toString(), tstats));
            }
            resp.table_info.setColumn_stats(statsList);
        }
        if (this.getMetaStoreTable() != null && AcidUtils.isTransactionalTable(this.getMetaStoreTable().getParameters())) {
            Preconditions.checkState((this.getValidWriteIds() != null ? 1 : 0) != 0);
            resp.table_info.setValid_write_ids(MetastoreShim.convertToTValidWriteIdList(this.getValidWriteIds()));
        }
        return resp;
    }

    protected Type parseColumnType(FieldSchema fs) throws TableLoadingException {
        return FeCatalogUtils.parseColumnType(fs, this.getName());
    }

    @Override
    public Db getDb() {
        return this.db_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getFullName() {
        return this.full_name_;
    }

    @Override
    public TableName getTableName() {
        return new TableName(this.db_ != null ? this.db_.getName() : null, this.name_);
    }

    @Override
    public TImpalaTableType getTableType() {
        if (this.msTable_ == null) {
            return TImpalaTableType.TABLE;
        }
        return MetastoreShim.mapToInternalTableType(this.msTable_.getTableType());
    }

    @Override
    public String getTableComment() {
        return MetadataOp.getTableComment(this.msTable_);
    }

    @Override
    public List<Column> getColumns() {
        return this.colsByPos_;
    }

    @Override
    public List<VirtualColumn> getVirtualColumns() {
        return this.virtualCols_;
    }

    @Override
    public List<String> getColumnNames() {
        return Column.toColumnNames(this.colsByPos_);
    }

    @Override
    public String getStorageHandlerClassName() {
        return null;
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        List<Object> columns = Lists.newArrayList(this.getNonClusteringColumns());
        columns = this.filterColumnsNotStoredInHms((List<Column>)columns);
        columns.addAll(this.getClusteringColumns());
        return Collections.unmodifiableList(columns);
    }

    @Override
    public List<Column> getClusteringColumns() {
        return Collections.unmodifiableList(this.colsByPos_.subList(0, this.numClusteringCols_));
    }

    @Override
    public List<Column> getNonClusteringColumns() {
        return Collections.unmodifiableList(this.colsByPos_.subList(this.numClusteringCols_, this.colsByPos_.size()));
    }

    @Override
    public Column getColumn(String name) {
        return this.colsByName_.get(name.toLowerCase());
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getMetaStoreTable() {
        return this.msTable_;
    }

    @Override
    public String getOwnerUser() {
        if (this.msTable_ == null) {
            LOG.warn("Owner of {} is unknown due to table is unloaded", (Object)this.getFullName());
            return null;
        }
        return this.msTable_.getOwnerType() == PrincipalType.USER ? this.msTable_.getOwner() : null;
    }

    public void setMetaStoreTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        this.msTable_ = msTbl;
        CatalogInterners.internFieldsInPlace(this.msTable_);
    }

    @Override
    public int getNumClusteringCols() {
        return this.numClusteringCols_;
    }

    public void setNumClusteringCols(int n) {
        Preconditions.checkState((boolean)RuntimeEnv.INSTANCE.isTestEnv());
        this.numClusteringCols_ = n;
    }

    @Override
    public long getNumRows() {
        return this.tableStats_.num_rows;
    }

    @Override
    public TTableStats getTTableStats() {
        return this.tableStats_;
    }

    @Override
    public ArrayType getType() {
        return this.type_;
    }

    public Pair<String, Short> getTableCacheInfo(List<Long> cacheDirIds) {
        String cachePoolName = null;
        Short cacheReplication = 0;
        Long cacheDirId = HdfsCachingUtil.getCacheDirectiveId(this.msTable_.getParameters());
        if (cacheDirId != null) {
            try {
                cachePoolName = HdfsCachingUtil.getCachePool(cacheDirId);
                cacheReplication = HdfsCachingUtil.getCacheReplication(cacheDirId);
                Preconditions.checkNotNull((Object)cacheReplication);
                if (this.numClusteringCols_ == 0) {
                    cacheDirIds.add(cacheDirId);
                }
            }
            catch (ImpalaRuntimeException e) {
                LOG.error(String.format("Cache directive %d was not found, uncache the table %s to remove this message.", cacheDirId, this.getFullName()));
                cacheDirId = null;
            }
        }
        return new Pair<String, Short>(cachePoolName, cacheReplication);
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        return this.getFullName().equals(((Table)obj).getFullName());
    }

    public static void updateTimestampProperty(org.apache.hadoop.hive.metastore.api.Table msTbl, String propertyKey) {
        msTbl.putToParameters(propertyKey, Long.toString(System.currentTimeMillis() / 1000L));
    }

    public void refreshLastUsedTime() {
        this.lastUsedTime_ = CatalogdTableInvalidator.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromVersionsForInflightEvents(boolean isInsertEvent, long versionNumber) {
        boolean removed = false;
        InFlightEvents inFlightEvents = this.inFlightEvents_;
        synchronized (inFlightEvents) {
            removed = this.inFlightEvents_.remove(isInsertEvent, versionNumber);
            if (removed) {
                this.metrics_.getCounter(NUMBER_OF_INFLIGHT_EVENTS).dec();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToVersionsForInflightEvents(boolean isInsertEvent, long versionNumber) {
        Preconditions.checkState((this instanceof IncompleteTable || this.isWriteLockedByCurrentThread() ? 1 : 0) != 0);
        boolean added = false;
        InFlightEvents inFlightEvents = this.inFlightEvents_;
        synchronized (inFlightEvents) {
            added = this.inFlightEvents_.add(isInsertEvent, versionNumber);
            if (!added) {
                LOG.warn(String.format("Could not add %s version to the table %s. This could cause unnecessary refresh of the table when the event is received by the Events processor.", versionNumber, this.getFullName()));
            } else {
                this.metrics_.getCounter(NUMBER_OF_INFLIGHT_EVENTS).inc();
            }
        }
        return added;
    }

    @Override
    public long getWriteId() {
        return MetastoreShim.getWriteIdFromMSTable(this.msTable_);
    }

    @Override
    public ValidWriteIdList getValidWriteIds() {
        return null;
    }

    public boolean hasInProgressModification() {
        return false;
    }

    public void resetInProgressModification() {
    }

    public long getLastRefreshEventId() {
        return this.lastRefreshEventId_;
    }

    public void setLastRefreshEventId(long eventId) {
        this.setLastRefreshEventId(eventId, true);
    }

    public void setLastRefreshEventId(long eventId, boolean isSetLastSyncEventId) {
        if (eventId > this.lastRefreshEventId_) {
            this.lastRefreshEventId_ = eventId;
        }
        LOG.info("last refreshed event id for table: {} set to: {}", (Object)this.getFullName(), (Object)this.lastRefreshEventId_);
        if (this.lastSyncedEventId_ < eventId && isSetLastSyncEventId) {
            this.setLastSyncedEventId(eventId);
        }
    }

    public double getDebugMetadataScale() {
        return this.testMetadataScale_;
    }
}

