/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeSystemTable;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TSystemTable;
import org.apache.impala.thrift.TSystemTableName;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.TResultRowBuilder;

public final class SystemTable
extends Table
implements FeSystemTable {
    protected SystemTable(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
        this.accessLevel_ = TAccessLevel.READ_ONLY;
    }

    @Override
    public TSystemTableName getSystemTableName() {
        return TSystemTableName.valueOf(this.getName().toUpperCase());
    }

    public static boolean isSystemTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        String value = (String)msTbl.getParameters().get("__IMPALA_SYSTEM_TABLE");
        return value != null && BooleanUtils.toBoolean((String)value);
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDescriptor = new TTableDescriptor(tableId, TTableType.SYSTEM_TABLE, this.getTColumnDescriptors(), this.getNumClusteringCols(), this.getName(), this.getDb().getName());
        tableDescriptor.setSystemTable(this.getTSystemTable());
        return tableDescriptor;
    }

    @Override
    public long getNumRows() {
        try {
            return FeSupport.NumLiveQueries() * (long)FeSupport.GetCoordinators().getAddressesSize();
        }
        catch (InternalException e) {
            return super.getNumRows();
        }
    }

    private TSystemTable getTSystemTable() {
        return new TSystemTable(this.getSystemTableName());
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        if (msTbl.getPartitionKeysSize() > 0) {
            throw new TableLoadingException("System table cannot contain clustering columns: " + this.name_);
        }
        Table.LOADING_TABLES.incrementAndGet();
        try {
            this.clearColumns();
            this.numClusteringCols_ = 0;
            int pos = 0;
            for (FieldSchema s : msTbl.getSd().getCols()) {
                this.addColumn(new Column(s.getName(), this.parseColumnType(s), s.getComment(), pos++));
            }
            this.setMetaStoreTable(msTbl);
            this.refreshLastUsedTime();
        }
        finally {
            Table.LOADING_TABLES.decrementAndGet();
        }
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.SYSTEM_TABLE);
        table.setSystem_table(this.getTSystemTable());
        return table;
    }

    @Override
    public TResultSet getTableStats() {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
        result.setSchema(resultSchema);
        TResultRowBuilder rowBuilder = new TResultRowBuilder();
        rowBuilder.add(this.getNumRows());
        result.addToRows(rowBuilder.get());
        return result;
    }
}

