/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;

public class SideloadTableStats {
    private final String tableName_;
    private final long numRows_;
    private final long totalSize_;
    private final Map<String, ColumnStatisticsData> columnStats_;

    public SideloadTableStats(String tableName, long numRows, long totalSize) {
        this.tableName_ = tableName;
        this.numRows_ = numRows;
        this.totalSize_ = totalSize;
        this.columnStats_ = new HashMap<String, ColumnStatisticsData>();
    }

    public void addColumnStats(String colName, ColumnStatisticsData colStats) {
        Preconditions.checkNotNull((Object)colName);
        Preconditions.checkNotNull((Object)colStats);
        Preconditions.checkArgument((!colName.isEmpty() ? 1 : 0) != 0);
        this.columnStats_.put(colName, colStats);
    }

    public long getNumRows() {
        return this.numRows_;
    }

    public long getTotalSize() {
        return this.totalSize_;
    }

    public boolean hasColumn(String colName) {
        return this.columnStats_.containsKey(colName);
    }

    @Nullable
    public ColumnStatisticsData getColumnStats(String colName) {
        return this.columnStats_.get(colName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SideloadTableStats(");
        sb.append("tableName:").append(this.tableName_);
        sb.append(", numRows:").append(this.numRows_);
        sb.append(", columns:{");
        int numCols = 0;
        for (Map.Entry<String, ColumnStatisticsData> entry : this.columnStats_.entrySet()) {
            if (numCols > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append(": ").append(entry.getValue());
            ++numCols;
        }
        sb.append("})");
        return sb.toString();
    }
}

