/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.analysis.TypesUtil;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TScalarType;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;

public class ScalarType
extends Type {
    private final PrimitiveType type_;
    private int len_;
    private int precision_;
    private int scale_;
    public static final int DEFAULT_PRECISION = 9;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAX_VARCHAR_LENGTH = 65535;
    public static final int MAX_CHAR_LENGTH = 255;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 38;
    public static final int MIN_ADJUSTED_SCALE = 6;

    protected ScalarType(PrimitiveType type) {
        this.type_ = type;
    }

    public static ScalarType createType(PrimitiveType type) {
        switch (type) {
            case INVALID_TYPE: {
                return INVALID;
            }
            case NULL_TYPE: {
                return NULL;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case TINYINT: {
                return TINYINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case VARCHAR: {
                return ScalarType.createVarcharType();
            }
            case BINARY: {
                return BINARY;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case DECIMAL: {
                return ScalarType.createDecimalType();
            }
        }
        Preconditions.checkState((boolean)false);
        return NULL;
    }

    public static ScalarType createCharType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.CHAR);
        type.len_ = len;
        return type;
    }

    public static ScalarType createFixedUdaIntermediateType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.FIXED_UDA_INTERMEDIATE);
        type.len_ = len;
        return type;
    }

    public static ScalarType createDecimalType() {
        return DEFAULT_DECIMAL;
    }

    public static ScalarType createDecimalType(int precision) {
        return ScalarType.createDecimalType(precision, 0);
    }

    public static ScalarType createDecimalType(int precision, int scale) {
        Preconditions.checkState((precision >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((scale >= 0 ? 1 : 0) != 0);
        ScalarType type = new ScalarType(PrimitiveType.DECIMAL);
        type.precision_ = precision;
        type.scale_ = scale;
        return type;
    }

    public static ScalarType createWildCardDecimalType() {
        ScalarType type = new ScalarType(PrimitiveType.DECIMAL);
        type.precision_ = -1;
        type.scale_ = -1;
        return type;
    }

    public static ScalarType createClippedDecimalType(int precision, int scale) {
        Preconditions.checkState((precision >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((scale >= 0 ? 1 : 0) != 0);
        ScalarType type = new ScalarType(PrimitiveType.DECIMAL);
        type.precision_ = Math.min(precision, 38);
        type.scale_ = Math.min(type.precision_, scale);
        return type;
    }

    public static ScalarType createAdjustedDecimalType(int precision, int scale) {
        Preconditions.checkState((precision >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((scale >= 0 ? 1 : 0) != 0);
        if (precision > 38) {
            int minScale = Math.min(scale, 6);
            int delta = precision - 38;
            precision = 38;
            scale = Math.max(scale - delta, minScale);
        }
        ScalarType type = new ScalarType(PrimitiveType.DECIMAL);
        type.precision_ = precision;
        type.scale_ = scale;
        return type;
    }

    public static ScalarType createVarcharType(int len) {
        ScalarType type = new ScalarType(PrimitiveType.VARCHAR);
        type.len_ = len;
        return type;
    }

    public static ScalarType createVarcharType() {
        return DEFAULT_VARCHAR;
    }

    public String toString() {
        if (this.type_ == PrimitiveType.CHAR) {
            if (this.isWildcardChar()) {
                return "CHAR(*)";
            }
            return "CHAR(" + this.len_ + ")";
        }
        if (this.type_ == PrimitiveType.DECIMAL) {
            if (this.isWildcardDecimal()) {
                return "DECIMAL(*,*)";
            }
            return "DECIMAL(" + this.precision_ + "," + this.scale_ + ")";
        }
        if (this.type_ == PrimitiveType.VARCHAR) {
            if (this.isWildcardVarchar()) {
                return "VARCHAR(*)";
            }
            return "VARCHAR(" + this.len_ + ")";
        }
        if (this.type_ == PrimitiveType.FIXED_UDA_INTERMEDIATE) {
            return "FIXED_UDA_INTERMEDIATE(" + this.len_ + ")";
        }
        return this.type_.toString();
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "...";
        }
        switch (this.type_) {
            case BINARY: {
                return this.type_.toString();
            }
            case VARCHAR: 
            case CHAR: 
            case FIXED_UDA_INTERMEDIATE: {
                return this.type_.toString() + "(" + this.len_ + ")";
            }
            case DECIMAL: {
                return String.format("%s(%s,%s)", this.type_.toString(), this.precision_, this.scale_);
            }
        }
        return this.type_.toString();
    }

    @Override
    protected String prettyPrint(int lpad) {
        return StringUtils.repeat((char)' ', (int)lpad) + this.toSql();
    }

    public TScalarType toTScalarType() {
        TScalarType scalarType = new TScalarType();
        switch (this.type_) {
            case VARCHAR: 
            case CHAR: 
            case FIXED_UDA_INTERMEDIATE: {
                scalarType.setType(this.type_.toThrift());
                scalarType.setLen(this.len_);
                break;
            }
            case DECIMAL: {
                scalarType.setType(this.type_.toThrift());
                scalarType.setScale(this.scale_);
                scalarType.setPrecision(this.precision_);
                break;
            }
            default: {
                scalarType.setType(this.type_.toThrift());
            }
        }
        return scalarType;
    }

    @Override
    public void toThrift(TColumnType container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        TScalarType scalarType = this.toTScalarType();
        node.setType(TTypeNodeType.SCALAR);
        node.setScalar_type(scalarType);
    }

    public int decimalPrecision() {
        Preconditions.checkState((this.type_ == PrimitiveType.DECIMAL ? 1 : 0) != 0);
        return this.precision_;
    }

    public int decimalScale() {
        Preconditions.checkState((this.type_ == PrimitiveType.DECIMAL ? 1 : 0) != 0);
        return this.scale_;
    }

    public int storageBytesForDecimal() {
        if (this.type_ != PrimitiveType.DECIMAL) {
            return -1;
        }
        if (this.precision_ <= 9) {
            return 4;
        }
        if (this.precision_ <= 18) {
            return 8;
        }
        if (this.precision_ <= 38) {
            return 16;
        }
        return -1;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return this.type_;
    }

    public int ordinal() {
        return this.type_.ordinal();
    }

    public int getLength() {
        return this.len_;
    }

    @Override
    public boolean isWildcardDecimal() {
        return this.type_ == PrimitiveType.DECIMAL && this.precision_ == -1 && this.scale_ == -1;
    }

    @Override
    public boolean isWildcardVarchar() {
        return this.type_ == PrimitiveType.VARCHAR && this.len_ == -1;
    }

    @Override
    public boolean isWildcardChar() {
        return this.type_ == PrimitiveType.CHAR && this.len_ == -1;
    }

    @Override
    public boolean isFullySpecifiedDecimal() {
        if (!this.isDecimal()) {
            return false;
        }
        if (this.isWildcardDecimal()) {
            return false;
        }
        if (this.precision_ <= 0 || this.precision_ > 38) {
            return false;
        }
        return this.scale_ >= 0 && this.scale_ <= this.precision_;
    }

    @Override
    public boolean isFixedLengthType() {
        return this.type_ == PrimitiveType.BOOLEAN || this.type_ == PrimitiveType.TINYINT || this.type_ == PrimitiveType.SMALLINT || this.type_ == PrimitiveType.INT || this.type_ == PrimitiveType.BIGINT || this.type_ == PrimitiveType.FLOAT || this.type_ == PrimitiveType.DOUBLE || this.type_ == PrimitiveType.DATE || this.type_ == PrimitiveType.DATETIME || this.type_ == PrimitiveType.TIMESTAMP || this.type_ == PrimitiveType.CHAR || this.type_ == PrimitiveType.DECIMAL || this.type_ == PrimitiveType.FIXED_UDA_INTERMEDIATE;
    }

    @Override
    public boolean isSupported() {
        return this.isValid() && !ScalarType.getUnsupportedTypes().contains(this);
    }

    public boolean isInternalType() {
        return this.type_ == PrimitiveType.FIXED_UDA_INTERMEDIATE || this.type_ == PrimitiveType.NULL_TYPE;
    }

    @Override
    public boolean supportsTablePartitioning() {
        if (!this.isSupported() || this.isComplexType()) {
            return false;
        }
        switch (this.type_) {
            case BINARY: 
            case TIMESTAMP: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getSlotSize() {
        switch (this.type_) {
            case CHAR: 
            case FIXED_UDA_INTERMEDIATE: {
                return this.len_;
            }
            case DECIMAL: {
                return TypesUtil.getDecimalSlotSize(this);
            }
        }
        return this.type_.getSlotSize();
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (!t.isScalarType()) {
            return false;
        }
        ScalarType scalarType = (ScalarType)t;
        if (this.type_ == PrimitiveType.VARCHAR && scalarType.isWildcardVarchar()) {
            Preconditions.checkState((!this.isWildcardVarchar() ? 1 : 0) != 0);
            return true;
        }
        if (this.type_ == PrimitiveType.CHAR && scalarType.isWildcardChar()) {
            Preconditions.checkState((!this.isWildcardChar() ? 1 : 0) != 0);
            return true;
        }
        if (this.isDecimal() && scalarType.isWildcardDecimal()) {
            Preconditions.checkState((!this.isWildcardDecimal() ? 1 : 0) != 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ScalarType)) {
            return false;
        }
        ScalarType other = (ScalarType)o;
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.type_ == PrimitiveType.CHAR || this.type_ == PrimitiveType.FIXED_UDA_INTERMEDIATE) {
            return this.len_ == other.len_;
        }
        if (this.type_ == PrimitiveType.VARCHAR) {
            return this.len_ == other.len_;
        }
        if (this.type_ == PrimitiveType.DECIMAL) {
            return this.precision_ == other.precision_ && this.scale_ == other.scale_;
        }
        return true;
    }

    @Override
    public int hashCode() {
        switch (this.type_) {
            case VARCHAR: 
            case CHAR: 
            case FIXED_UDA_INTERMEDIATE: {
                return Objects.hash(new Object[]{this.type_, this.len_});
            }
            case DECIMAL: {
                return Objects.hash(new Object[]{this.type_, this.precision_, this.scale_});
            }
        }
        return Objects.hash(new Object[]{this.type_});
    }

    public Type getMaxResolutionType() {
        if (this.isIntegerType() || this.type_ == PrimitiveType.DATE) {
            return BIGINT;
        }
        if (this.isFloatingPointType() || this.type_ == PrimitiveType.TIMESTAMP) {
            return DOUBLE;
        }
        if (this.isNull()) {
            return NULL;
        }
        if (this.isDecimal()) {
            Preconditions.checkState((this.scale_ <= 38 ? 1 : 0) != 0);
            return ScalarType.createDecimalType(38, this.scale_);
        }
        return INVALID;
    }

    public ScalarType getNextResolutionType() {
        Preconditions.checkState((this.isNumericType() || this.isNull() ? 1 : 0) != 0);
        if (this.type_ == PrimitiveType.DOUBLE || this.type_ == PrimitiveType.BIGINT || this.isNull()) {
            return this;
        }
        if (this.type_ == PrimitiveType.DECIMAL) {
            Preconditions.checkState((this.scale_ <= 38 ? 1 : 0) != 0);
            return ScalarType.createDecimalType(38, this.scale_);
        }
        return ScalarType.createType(PrimitiveType.values()[this.type_.ordinal() + 1]);
    }

    public ScalarType getMinResolutionDecimal() {
        switch (this.type_) {
            case NULL_TYPE: {
                return Type.NULL;
            }
            case DECIMAL: {
                return this;
            }
            case TINYINT: {
                return ScalarType.createDecimalType(3);
            }
            case SMALLINT: {
                return ScalarType.createDecimalType(5);
            }
            case INT: {
                return ScalarType.createDecimalType(10);
            }
            case BIGINT: {
                return ScalarType.createDecimalType(19);
            }
            case FLOAT: {
                return ScalarType.createDecimalType(38, 9);
            }
            case DOUBLE: {
                return ScalarType.createDecimalType(38, 17);
            }
        }
        return INVALID;
    }

    public boolean isSupertypeOf(ScalarType o) {
        Preconditions.checkState((boolean)this.isDecimal());
        Preconditions.checkState((boolean)o.isDecimal());
        if (this.isWildcardDecimal()) {
            return true;
        }
        if (o.isWildcardDecimal()) {
            return false;
        }
        return this.scale_ >= o.scale_ && this.precision_ - this.scale_ >= o.precision_ - o.scale_;
    }

    public static ScalarType getAssignmentCompatibleType(ScalarType t1, ScalarType t2, TypeCompatibility compatibility) {
        if (!t1.isValid() || !t2.isValid()) {
            return INVALID;
        }
        if (t1.equals(t2)) {
            return t1;
        }
        if (t1.isNull()) {
            return t2;
        }
        if (t2.isNull()) {
            return t1;
        }
        PrimitiveType smallerType = t1.type_.ordinal() < t2.type_.ordinal() ? t1.type_ : t2.type_;
        PrimitiveType largerType = t1.type_.ordinal() > t2.type_.ordinal() ? t1.type_ : t2.type_;
        PrimitiveType result = null;
        if (compatibility.isUnsafe()) {
            result = unsafeCompatibilityMatrix[t1.type_.ordinal()][t2.type_.ordinal()];
        } else if (compatibility.isStrict()) {
            result = strictCompatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        }
        if (result == null) {
            result = compatibilityMatrix[smallerType.ordinal()][largerType.ordinal()];
        }
        if (result == PrimitiveType.VARCHAR) {
            return ScalarType.createVarcharType(Math.max(t1.len_, t2.len_));
        }
        if (result == PrimitiveType.CHAR) {
            return ScalarType.createCharType(Math.max(t1.len_, t2.len_));
        }
        if (result == PrimitiveType.DECIMAL) {
            ScalarType t1Decimal = t1.getMinResolutionDecimal();
            ScalarType t2Decimal = t2.getMinResolutionDecimal();
            if (t1Decimal.isInvalid() || t2Decimal.isInvalid()) {
                return Type.INVALID;
            }
            Preconditions.checkState((boolean)t1Decimal.isDecimal());
            Preconditions.checkState((boolean)t2Decimal.isDecimal());
            if (t1Decimal.equals(t2Decimal)) {
                Preconditions.checkState((!t1.isDecimal() || !t2.isDecimal() ? 1 : 0) != 0);
                return t1Decimal;
            }
            if (t1Decimal.isSupertypeOf(t2Decimal)) {
                return t1;
            }
            if (t2Decimal.isSupertypeOf(t1Decimal)) {
                return t2;
            }
            return TypesUtil.getDecimalAssignmentCompatibleType(t1Decimal, t2Decimal, compatibility.isStrictDecimal());
        }
        Preconditions.checkNotNull((Object)((Object)result));
        return ScalarType.createType(result);
    }

    public static boolean isImplicitlyCastable(ScalarType t1, ScalarType t2, TypeCompatibility compatibility) {
        return ScalarType.getAssignmentCompatibleType(t1, t2, compatibility).matchesType(t2);
    }

    public static boolean isAssignable(ScalarType dest, ScalarType source) {
        return ScalarType.isImplicitlyCastable(source, dest, TypeCompatibility.DEFAULT);
    }
}

